/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                Message.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/Form.h>
# include <Xm/Frame.h>
# include <Xm/Label.h>
# include <Xm/LabelG.h>
# include <Xm/TextF.h>
# include <Xm/Text.h>
 
# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include GSB_H
# include GTB_H
# include GMX_H
# include "GMX_message.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  Widget        GraalMessageMainForm;
  Widget        GraalMessageText  [ GRAAL_MAX_MESSAGE ];
  Widget        GraalMessageLabel [ GRAAL_MAX_MESSAGE ];
  Widget        GraalMessageFrame [ GRAAL_MAX_MESSAGE ];
  Widget        GraalMessageForm  [ GRAAL_MAX_MESSAGE ];

  static char *GraalMessageLabelName [ GRAAL_MAX_MESSAGE ] =

         {
           "X :",
           "Y :",
           "Dx :",
           "Dy :",
           NULL,
           NULL,
           NULL
         };

  static char *GraalMessageTextName [ GRAAL_MAX_MESSAGE ] =

         {
           "0",
           "0",
           "0",
           "0",
           "Measure",
           "Select point",
           "Enter base point"
         };

  static char *GraalMessageFormName [ GRAAL_MAX_MESSAGE ] =

         {
           "GraalMessageFormX",
           "GraalMessageFormY",
           "GraalMessageFormDx",
           "GraalMessageFormDy",
           "GraalMessageFormMode",
           "GraalMessageFormInfo",
           "GraalMessageFormPrompt"
         };

  static char *GraalMessageFrameName [ GRAAL_MAX_MESSAGE ] =

         {
           "GraalMessageFrameX",
           "GraalMessageFrameY",
           "GraalMessageFrameDx",
           "GraalMessageFrameDy",
           "GraalMessageFrameMode",
           "GraalMessageFrameInfo",
           "GraalMessageFramePrompt"
         };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      GraalDisplayMessage                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalDisplayMessage( Where, Text )
 
       char  Where;
       char *Text;
  {
    XmString TextString;

    TextString = XmStringCreateSimple( Text ); 

    XtVaSetValues( GraalMessageText[ Where ], XmNlabelString, TextString, NULL );

    XmStringFree( TextString );
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalPromptEditMeasure                  |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptEditMeasure()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE  , "Measure" );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter base point" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO  , "Select point" );
  }  

/*------------------------------------------------------------\
|                                                             |
|                    GraalInitializeMessage                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalInitializeMessage()

  {
    int Counter;
    int Column;
    int Left;
    int Width;


    GraalMessageMainForm = 

      XtVaCreateManagedWidget( "GraalMessageMainForm",
                                xmFormWidgetClass    ,
                                GraalMainForm        ,
                                XmNtopAttachment     , XmATTACH_POSITION,
                                XmNtopPosition       , 193,
                                XmNbottomAttachment  , XmATTACH_POSITION,
                                XmNbottomPosition    , 199,
                                XmNleftAttachment    , XmATTACH_POSITION,
                                XmNleftPosition      , 0,
                                XmNrightAttachment   , XmATTACH_POSITION,
                                XmNrightPosition     , 200,
                                XmNfractionBase      , 200,
                                NULL );

    Column = 1;
    Width  = 17;

    for ( Counter = 0; Counter < GRAAL_MAX_MESSAGE; Counter++ )
    {
      if ( Counter == 4 ) Width = 22;
      if ( Counter == 5 ) Width = 68;
      if ( Counter == 6 ) Width = 40;

      GraalMessageFrame[ Counter ] =

        XtVaCreateManagedWidget( GraalMessageFrameName[ Counter ],
                                 xmFrameWidgetClass,
                                 GraalMessageMainForm,
                                 XmNshadowType            , XmSHADOW_ETCHED_IN,
                                 XmNleftAttachment        , XmATTACH_POSITION,
                                 XmNleftPosition          , Column,
                                 XmNrightAttachment       , XmATTACH_POSITION,
                                 XmNrightPosition         , Column + Width,
                                 XmNtopAttachment         , XmATTACH_FORM,
                                 XmNbottomAttachment      , XmATTACH_FORM,
                                 NULL
                               );

      GraalMessageForm[ Counter ] =

        XtVaCreateManagedWidget( GraalMessageFormName[ Counter ],
                                 xmFormWidgetClass   ,
                                 GraalMessageFrame[ Counter ],
                                 XmNleftAttachment           , XmATTACH_FORM,
                                 XmNrightAttachment          , XmATTACH_FORM,
                                 XmNtopAttachment            , XmATTACH_FORM,
                                 XmNbottomAttachment         , XmATTACH_FORM,
                                 XmNfractionBase             , 18,
                                 NULL
                               );

      if ( GraalMessageLabelName[ Counter ] != (char *)NULL )
      {
        GraalMessageLabel [ Counter ] = 

          XtVaCreateManagedWidget( GraalMessageLabelName[ Counter ], 
                                   xmLabelWidgetClass,
                                   GraalMessageForm [ Counter ],
                                   XmNleftAttachment           , XmATTACH_FORM,
                                   XmNrightAttachment          , XmATTACH_POSITION,
                                   XmNrightPosition            , 6,
                                   XmNbottomAttachment         , XmATTACH_FORM,
                                   XmNtopAttachment            , XmATTACH_FORM,
                                   XmNrecomputeSize            , False,
                                   NULL
                                 );
        Left = 6;
      }
      else
      {
        Left = 0;
      }

      GraalMessageText [ Counter ]  = 

        XtVaCreateManagedWidget( GraalMessageTextName[ Counter ], 
                                 xmLabelWidgetClass,
                                 GraalMessageForm [ Counter ],
                                 XmNtopAttachment            , XmATTACH_FORM,
                                 XmNbottomAttachment         , XmATTACH_FORM,
                                 XmNrightAttachment          , XmATTACH_FORM,
                                 XmNleftAttachment           , XmATTACH_POSITION,
                                 XmNleftPosition             , Left,
                                 XmNrecomputeSize            , False,
                                 NULL
                               );

      Column = Column + Width;
    }
  }
