/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                 Graphic.c                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/Form.h>
# include <Xm/Frame.h>
# include <Xm/DrawingA.h>
 
# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include GSB_H
# include GTB_H
# include GMX_H

# include "GMX_graphic.h"
# include "GMX_view.h"
# include "GMX_grid.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  Widget GraalGraphicFrame;
  Widget GraalGraphicWindow;

  Dimension  GraalGraphicDx    = 0;
  Dimension  GraalGraphicDy    = 0;
  Dimension  GraalOldGraphicDx = 0;
  Dimension  GraalOldGraphicDy = 0;

  Pixmap     GraalGraphicPixmap   = (Pixmap)NULL;

/*------------------------------------------------------------\
|                                                             |
|                           Functions                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                 GraalInitializeGraphicWindow                |
|                                                             |
\------------------------------------------------------------*/

  void GraalInitializeGraphicWindow()
 
  {
    XtVaGetValues( GraalGraphicWindow,
                   XmNwidth, &GraalGraphicDx,
                   XmNheight, &GraalGraphicDy,
                   NULL
                 );

    GraalOldGraphicDx = GraalGraphicDx;
    GraalOldGraphicDy = GraalGraphicDy;
  
    GraalGraphicPixmap =

       XCreatePixmap ( XtDisplay ( GraalGraphicWindow ),
                       RootWindowOfScreen( XtScreen ( GraalGraphicWindow ) ),
                       GraalGraphicDx,
                       GraalGraphicDy,
                       DefaultDepthOfScreen ( XtScreen ( GraalGraphicWindow ) )
                     );

    GraalClearGraphicWindow( 0, 0, GraalGraphicDx, GraalGraphicDy );
    GraalInitializeLambdaGrid();

    GraalSetMouseCursor( GraalGraphicWindow, GRAAL_NORMAL_CURSOR );
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalClearGraphicWindow                 |
|                                                             |
\------------------------------------------------------------*/

  void GraalClearGraphicWindow( GraphicX, GraphicY, GraphicDx, GraphicDy )

     long GraphicX;
     long GraphicY;
     long GraphicDx;
     long GraphicDy;
  {
    XFillRectangle( XtDisplay( GraalGraphicWindow ),
                    GraalGraphicPixmap,
                    GraalBackgroundGC, 
                    GraphicX, GraphicY,
                    GraphicDx,
                    GraphicDy );
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalRefreshGraphicWindow               |
|                                                             |
\------------------------------------------------------------*/

  void GraalRefreshGraphicWindow( GraphicX, GraphicY, GraphicDx, GraphicDy )

     Dimension GraphicX;
     Dimension GraphicY;
     Dimension GraphicDx;
     Dimension GraphicDy;
  {
    GraalUndisplayCursor();

    XCopyArea( XtDisplay ( GraalGraphicWindow ),
               GraalGraphicPixmap,
               XtWindow ( GraalGraphicWindow ),
               GraalBackgroundGC,
               GraphicX, GraphicY,
               GraphicDx, GraphicDy,
               GraphicX, GraphicY 
             ); 

    GraalDisplayLambdaGrid( GraphicX, GraphicY, 
                            GraphicX + GraphicDx, 
                            GraphicY + GraphicDy );
    GraalUndisplayCursor();
  }


/*------------------------------------------------------------\
|                                                             |
|                     GraalResizeGraphicWindow                |
|                                                             |
\------------------------------------------------------------*/

  void GraalResizeGraphicWindow()

  {
    Pixmap    OldPixmap;
    Dimension SourceY;
    Dimension TargetY;
    Dimension TargetDx;
    Dimension TargetDy;

    GraalOldGraphicDx = GraalGraphicDx;
    GraalOldGraphicDy = GraalGraphicDy;

    XtVaGetValues( GraalGraphicWindow,
                   XmNwidth, &GraalGraphicDx,
                   XmNheight, &GraalGraphicDy,
                   NULL
                 );   

    if ( ( GraalOldGraphicDx != GraalGraphicDx ) ||
         ( GraalOldGraphicDy != GraalGraphicDy ) )
    {
      OldPixmap = GraalGraphicPixmap;

      GraalGraphicPixmap = 

        XCreatePixmap ( XtDisplay ( GraalGraphicWindow ),
                        RootWindowOfScreen( XtScreen ( GraalGraphicWindow ) ),
                        GraalGraphicDx,
                        GraalGraphicDy,
                        DefaultDepthOfScreen ( XtScreen ( GraalGraphicWindow ) )
                      );

      GraalClearGraphicWindow( 0, 0, GraalGraphicDx, GraalGraphicDy );

      if ( GraalResizeLambdaGrid() )
      {
        if ( GraalOldGraphicDx < GraalGraphicDx )
        {
          TargetDx = GraalOldGraphicDx;

          GraalDisplayFigure( TargetDx, 0, 
                              GraalGraphicDx, GraalGraphicDy );
        }
        else
        {
          TargetDx = GraalGraphicDx;
        }
      
        if ( GraalOldGraphicDy < GraalGraphicDy )
        {
          SourceY  = 0;
          TargetDy = GraalOldGraphicDy;
          TargetY  = GraalGraphicDy - GraalOldGraphicDy;

          GraalDisplayFigure( 0, TargetDy, 
                              TargetDx, GraalGraphicDy ); 
        }
        else
        {
          TargetDy = GraalGraphicDy;
          TargetY  = 0;
          SourceY  = GraalOldGraphicDy - GraalGraphicDy;
        }

        XCopyArea( XtDisplay ( GraalGraphicWindow ),
                   OldPixmap,
                   GraalGraphicPixmap,
                   GraalBackgroundGC,
                   0, SourceY,
                   TargetDx, TargetDy, 
                   0, TargetY
                 );
      }
      else
      {
        GraalComputeLambdaGrid();

        GraalDisplayFigure( 0, 0, 
                            GraalGraphicDx, GraalGraphicDy );
      }

      XFreePixmap( XtDisplay( GraalGraphicWindow ), OldPixmap );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    GraalInitializeGraphic                   |
|                                                             |
\------------------------------------------------------------*/

  void GraalInitializeGraphic()

  {
    GraalGraphicFrame = XtVaCreateManagedWidget( "GraalGraphicFrame",
                                                 xmFrameWidgetClass,
                                                 GraalMainForm,
                                                 XmNshadowType       , XmSHADOW_ETCHED_IN,
                                                 XmNtopAttachment    , XmATTACH_POSITION,
                                                 XmNtopPosition      , 1,
                                                 XmNbottomAttachment , XmATTACH_POSITION,
                                                 XmNbottomPosition   , 191,
                                                 XmNleftAttachment   , XmATTACH_POSITION,
                                                 XmNleftPosition     , 1,
                                                 XmNrightAttachment  , XmATTACH_POSITION,
                                                 XmNrightPosition    , 199,
                                                 NULL );

    GraalGraphicWindow = XtVaCreateManagedWidget(
                                                  "GraalGraphicWindow",
                                                  xmDrawingAreaWidgetClass,
                                                  GraalGraphicFrame,
                                                  XmNtopAttachment,    XmATTACH_FORM,
                                                  XmNrightAttachment,  XmATTACH_FORM,
                                                  XmNbottomAttachment, XmATTACH_FORM,
                                                  XmNleftAttachment,   XmATTACH_FORM,
                                                  XmNbackground,       1,
                                                  XmNforeground,       0,
                                                  NULL
                                               );
  }
