/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  gmx101.h                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef GRAAL_GMX
# define GRAAL_GMX

/*------------------------------------------------------------\
|                                                             |
|                         Graphic Context                     |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Colors Define                      |
|                                                             |
\------------------------------------------------------------*/

# define GRAAL_BLACK_COLOR    "Black"
# define GRAAL_WHITE_COLOR    "White"
# define GRAAL_TEXT_COLOR     "White"
# define GRAAL_ACCEPT_COLOR   "magenta"
# define GRAAL_EQUI_COLOR     "White"
# define GRAAL_DRUC_COLOR     "Gray"

/*------------------------------------------------------------\
|                                                             |
|                       Graal Message                         |
|                                                             |
\------------------------------------------------------------*/

# define GRAAL_MAX_MESSAGE    7

# define GRAAL_MESSAGE_X      0 
# define GRAAL_MESSAGE_Y      1
# define GRAAL_MESSAGE_DX     2
# define GRAAL_MESSAGE_DY     3
# define GRAAL_MESSAGE_MODE   4
# define GRAAL_MESSAGE_INFO   5
# define GRAAL_MESSAGE_PROMPT 6

/*------------------------------------------------------------\
|                                                             |
|                       Graal Default X Y                     |
|                                                             |
\------------------------------------------------------------*/

# define GRAAL_TOPLEVEL_X                10
# define GRAAL_TOPLEVEL_Y                10
# define GRAAL_TOPLEVEL_WIDTH          1024
# define GRAAL_TOPLEVEL_HEIGHT          768
# define GRAAL_TOPLEVEL_MIN_WIDTH       300
# define GRAAL_TOPLEVEL_MIN_HEIGHT      200


/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Graal Widget                       |
|                                                             |
\------------------------------------------------------------*/

  extern XtAppContext  GraalApplication;
  extern Widget        GraalTopLevel;
  extern Widget        GraalMainWindow;
  extern Widget        GraalMainForm;

  extern Widget        GraalMenuBar;

  extern Widget        GraalGraphicFrame;
  extern Widget        GraalGraphicWindow;

  extern Widget        GraalMessageMainPaned;
  extern Widget        GraalMessageMainForm;
  extern Widget        GraalMessageForm  [ GRAAL_MAX_MESSAGE ];
  extern Widget        GraalMessageText  [ GRAAL_MAX_MESSAGE ];
  extern Widget        GraalMessageLabel [ GRAAL_MAX_MESSAGE ];
  extern Widget        GraalMessageFrame [ GRAAL_MAX_MESSAGE ];

/*------------------------------------------------------------\
|                                                             |
|                      Graal Graphic Context                  |
|                                                             |
\------------------------------------------------------------*/

  extern GC GraalLayerFillGC   [ RDS_MAX_LAYER ];  
  extern GC GraalLayerDrawGC   [ RDS_MAX_LAYER ];  
  extern GC GraalLayerAcceptGC [ RDS_MAX_LAYER ];
  extern GC GraalLayerEquiGC   [ RDS_MAX_LAYER ];
  extern GC GraalLayerDrucGC   [ RDS_MAX_LAYER ];
  extern GC GraalAcceptDrawGC;
  extern GC GraalEquiDrawGC;
  extern GC GraalDrucDrawGC;
  extern GC GraalBackgroundGC;
  extern GC GraalGridGC;
  extern GC GraalXorGC;
  extern GC GraalSmallTextGC;
  extern GC GraalMediumTextGC;
  extern GC GraalLargeTextGC;

  extern XFontStruct *GraalSmallTextFont;
  extern XFontStruct *GraalLargeTextFont;
  extern XFontStruct *GraalMediumTextFont;

/*------------------------------------------------------------\
|                                                             |
|                      Graal Graphic Pixmap                   |
|                                                             |
\------------------------------------------------------------*/

  extern Pixmap    GraalGraphicPixmap;

/*------------------------------------------------------------\
|                                                             |
|                      Graal Graphic Size                     |
|                                                             |
\------------------------------------------------------------*/

  extern Dimension GraalOldGraphicDx;
  extern Dimension GraalOldGraphicDy;
  extern Dimension GraalGraphicDx;
  extern Dimension GraalGraphicDy;

/*------------------------------------------------------------\
|                                                             |
|                       Graal Lambda Grid                     |
|                                                             |
\------------------------------------------------------------*/

  extern float GraalLambdaGridStep;
  extern long  GraalLambdaGridX;
  extern long  GraalLambdaGridY;
  extern long  GraalLambdaGridDx;
  extern long  GraalLambdaGridDy;
  extern long  GraalPixelGridX;
  extern long  GraalPixelGridY;

/*------------------------------------------------------------\
|                                                             |
|                      User Lambda Grid                       |
|                                                             |
\------------------------------------------------------------*/

  extern long GraalLambdaUserGridDx;
  extern long GraalLambdaUserGridDy;
  extern char GraalLambdaUserGrid;

/*------------------------------------------------------------\
|                                                             |
|                         Graal Cursor                        |
|                                                             |
\------------------------------------------------------------*/

  extern long GraalLambdaCursorX;
  extern long GraalLambdaCursorY;

/*------------------------------------------------------------\
|                                                             |
|                         Graal Event                         |
|                                                             |
\------------------------------------------------------------*/

  extern char GraalCountEventZoom;
  extern char GraalCountEventEdit;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                   GraalInitializeRessources                 |
|                                                             |
\------------------------------------------------------------*/

  extern void GraalInitializeRessources();

/*------------------------------------------------------------\
|                                                             |
|                     Graal Edit Mode                         |
|                                                             |
\------------------------------------------------------------*/

  extern void GraalChangeEditMode();
  extern void GraalContinueEditMode();

/*------------------------------------------------------------\
|                                                             |
|                     GraalDisplayMessage                     |
|                                                             |
\------------------------------------------------------------*/

  extern void GraalDisplayMessage();
  extern void GraalPromptEditMeasure();

/*------------------------------------------------------------\
|                                                             |
|                      Graal Graphic Window                   |
|                                                             |
\------------------------------------------------------------*/

  extern void GraalClearGraphicWindow();
  extern void GraalResizeGraphicWindow();
  extern void GraalRefreshGraphicWindow();

/*------------------------------------------------------------\
|                                                             |
|                      Graal Lambda Grid                      |
|                                                             |
\------------------------------------------------------------*/

  extern void    GraalComputeLambdaGrid();
  extern char    GraalResizeLambdaGrid();

/*------------------------------------------------------------\
|                                                             |
|                     Graal Display Figure                    |
|                                                             |
\------------------------------------------------------------*/

  extern void GraalDisplayFigure();
  extern void GraalDisplayRectangle();

/*------------------------------------------------------------\
|                                                             |
|                        Graal Cursor                         |
|                                                             |
\------------------------------------------------------------*/

  extern void GraalDisplayCursor();
  extern void GraalUndisplayCursor();

# endif 
