/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                 Dialog.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>
# include <Xm/CascadeBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include GTB_H
# include GSB_H
# include GMX_H
# include GMV_H

# include "GMV_dialog.h"
# include "GMV_view.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Dialog Box                          |
|                                                             |
\------------------------------------------------------------*/

  GraalDialogItem GraalViewZoomSetDialog =

  {
    "Zoom set",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackViewZoomSetOk,
    (XtPointer)NULL,
    (void *)CallbackViewZoomSetCancel,
    (XtPointer)NULL
  };

  GraalDialogItem GraalViewZoomGotoDialog =

  {
    "Goto X,Y",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackViewZoomGotoOk,
    (XtPointer)NULL,
    (void *)CallbackViewZoomGotoCancel,
    (XtPointer)NULL
  };

  GraalDialogItem GraalViewMoveSetDialog =
 
  {
    "Move set",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackViewMoveSetOk,
    (XtPointer)NULL,
    (void *)CallbackViewMoveSetCancel,
    (XtPointer)NULL
  };

  GraalDialogItem GraalViewGridXDialog =

  {
    "Grid X",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackViewGridXOk,
    (XtPointer)NULL,
    (void *)CallbackViewGridXCancel,
    (XtPointer)NULL
  };

  GraalDialogItem GraalViewGridYDialog =

  {
    "Grid Y",
    GRAAL_DIALOG_PROMPT,
    (Widget)NULL,
    (void *)CallbackViewGridYOk,
    (XtPointer)NULL,
    (void *)CallbackViewGridYCancel,
    (XtPointer)NULL
  };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      Build Dialog Box                       |
|                                                             |
\------------------------------------------------------------*/

  void GraalBuildViewDialog()

  {
    GraalBuildDialog( GraalMainWindow, &GraalViewZoomSetDialog  );
    GraalBuildDialog( GraalMainWindow, &GraalViewZoomGotoDialog );
    GraalBuildDialog( GraalMainWindow, &GraalViewMoveSetDialog  );
    GraalBuildDialog( GraalMainWindow, &GraalViewGridXDialog    );
    GraalBuildDialog( GraalMainWindow, &GraalViewGridYDialog    );
  }

/*------------------------------------------------------------\
|                                                             |
|                      Callback For Dialog                    |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      CallbackViewZoomSetOk                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackViewZoomSetOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *ZoomSet;
    int   ZoomPercent;

    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &ZoomSet );

    XtUnmanageChild( GraalViewZoomSetDialog.WIDGET );

    GraalExitDialog();

    if ( ZoomSet != (char *)NULL )
    {
      ZoomPercent = atoi( ZoomSet );

      if ( ( ZoomPercent < GRAAL_PERCENT_ZOOM_MIN ) ||
           ( ZoomPercent > GRAAL_PERCENT_ZOOM_MAX ) )
      {
        GraalErrorMessage( GraalMainWindow, "The value must be between 5% and 95% !" );
      }
      else
      {
        GraalPercentZoom = ZoomPercent;
      }
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackViewZoomSetCancel                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackViewZoomSetCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalViewZoomSetDialog.WIDGET );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                      CallbackViewZoomGotoOk                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackViewZoomGotoOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *ZoomGoto;
    int   Index;
    long  GotoX;
    long  GotoY;

    XmStringGetLtoR( CallData->value,
                     XmSTRING_DEFAULT_CHARSET,
                     &ZoomGoto );

    XtUnmanageChild( GraalViewZoomGotoDialog.WIDGET );

    GraalExitDialog();

    if ( ZoomGoto != (char *)NULL )
    {
      for ( Index = 0; ZoomGoto[ Index ]; Index++ )
      {
        if ( ZoomGoto[ Index ] == ',' ) 
        {
          ZoomGoto[ Index ] = '\0';

          GotoX    = atoi( ZoomGoto );
          GotoY    = atoi( ZoomGoto + Index + 1 );
          ZoomGoto = (char *)NULL;

          GraalZoomCenter( GotoX, GotoY );

          break;
        }
      }

      if ( ZoomGoto != (char *)NULL )
      {
        GraalErrorMessage( GraalMainWindow, "A coordinate must be specified  !" );
      }
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackViewZoomGotoCancel               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackViewZoomGotoCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalViewZoomGotoDialog.WIDGET );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                      CallbackViewMoveSetOk                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackViewMoveSetOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *MoveSet;
    int   MovePercent;

    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &MoveSet );

    XtUnmanageChild( GraalViewMoveSetDialog.WIDGET );

    GraalExitDialog();

    if ( MoveSet != (char *)NULL )
    {
      MovePercent = atoi( MoveSet );

      if ( ( MovePercent < GRAAL_PERCENT_MOVE_MIN ) ||
           ( MovePercent > GRAAL_PERCENT_MOVE_MAX ) )
      {
        GraalErrorMessage( GraalMainWindow, "The value must be between 5% and 95% !" );
      }
      else
      {   
        GraalPercentMove = MovePercent;
      }
    }  
  }  

/*------------------------------------------------------------\
|                                                             |
|                    CallbackViewMoveSetCancel                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackViewMoveSetCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalViewMoveSetDialog.WIDGET );
 
    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                      CallbackViewGridXOk                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackViewGridXOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *GridSet;
    int   GridPercent;

    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &GridSet );

    XtUnmanageChild( GraalViewGridXDialog.WIDGET );

    GraalExitDialog();

    if ( GridSet != (char *)NULL )
    {
      GridPercent = atoi( GridSet );

      if ( GridPercent < 2 )
      {
        GraalErrorMessage( GraalMainWindow, "The value must be greater than one !" );
      }
      else
      {   
        GraalLambdaUserGridDx = GridPercent;
        GraalZoomRefresh();
      }
    }  
  }  

/*------------------------------------------------------------\
|                                                             |
|                    CallbackViewGridXCancel                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackViewGridXCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalViewGridXDialog.WIDGET );
 
    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                      CallbackViewGridYOk                    |
|                                                             |
\------------------------------------------------------------*/

  void CallbackViewGridYOk( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    char *GridSet;
    int   GridPercent;

    XmStringGetLtoR(  CallData->value,
                      XmSTRING_DEFAULT_CHARSET,
                     &GridSet );

    XtUnmanageChild( GraalViewGridYDialog.WIDGET );

    GraalExitDialog();

    if ( GridSet != (char *)NULL )
    {
      GridPercent = atoi( GridSet );

      if ( GridPercent < 2 )
      {
        GraalErrorMessage( GraalMainWindow, "The value must be greater than one !" );
      }
      else
      {   
        GraalLambdaUserGridDy = GridPercent;
        GraalZoomRefresh();
      }
    }
  }  

/*------------------------------------------------------------\
|                                                             |
|                    CallbackViewGridYCancel                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackViewGridYCancel( MyWidget, ClientData, CallData )

      Widget                        MyWidget;
      caddr_t                       ClientData;
      XmSelectionBoxCallbackStruct *CallData;
  {
    XtUnmanageChild( GraalViewGridYDialog.WIDGET );
 
    GraalExitDialog();
  }
