/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  GMV101.h                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef GRAAL_GMV
# define GRAAL_GMV 

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  extern char GraalFirstViewLayer;

/*------------------------------------------------------------\
|                                                             |
|                        Panel And Menu                       |
|                                                             |
\------------------------------------------------------------*/

  extern GraalMenuItem  GraalViewMenu[];
  extern GraalPanelItem GraalViewArrowsPanel;
  extern GraalPanelItem GraalViewZoomPanel;
  extern GraalPanelItem GraalViewGridPanel;
  extern GraalPanelItem GraalViewLayerPanel;
  extern GraalPanelItem GraalViewMapPanel;
 
  extern int  GraalPercentZoom;
  extern int  GraalPercentMove;

  extern int  GraalViewArrowsDefaultValues[4];
  extern int  GraalViewZoomDefaultValues[4];
  extern int  GraalViewLayerDefaultValues[4];
  extern int  GraalViewGridDefaultValues[4];
  extern int  GraalViewMapDefaultValues[4];
  
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                           Values                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Callback                           |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Zoom                             |
|                                                             |
\------------------------------------------------------------*/

  extern void GraalComputeAndDisplayMap();
  extern void GraalInitializeZoom();
  extern void GraalBuildViewDialog();
  extern void GraalBuildPanelMap();
  extern void GraalInitializeMapEvent();

  extern void GraalZoomCenter();
  extern void GraalZoomRefresh();
  extern void GraalZoomIn();
  extern void GraalZoomPan();

# endif
