/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Tools.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RFM_H
# include RPR_H
# include GTB_H
# include GSB_H
# include GMX_H
# include GRM_H
# include GMT_H

# include "GMT_tools.h"
# include "GMT_message.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        GraalToolsEqui                       |
|                                                             |
\------------------------------------------------------------*/

  void GraalToolsEqui()

  { 
    GraalSetMouseCursor( GraalGraphicWindow, GRAAL_WATCH_CURSOR  );

    if ( GraalHeadSelect != (graalselect *)NULL )
    {
      GraalExtractEqui( GraalHeadSelect->RECTANGLE );
    }

    GraalDelSelect();
    GraalZoomRefresh();
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalToolsFlatten                       |
|                                                             |
\------------------------------------------------------------*/

  void GraalToolsFlatten()

  { 
    graalselect *Select;
    rdsrec_list *Rectangle;
    rdsins_list *Instance;

    GraalSetMouseCursor( GraalGraphicWindow, GRAAL_WATCH_CURSOR  );

    GraalDelPeek();
    
    for ( Select  = GraalHeadSelect;
          Select != (graalselect *)NULL;
          Select  = Select->NEXT )
    {
      Rectangle = Select->RECTANGLE;

      Instance = (rdsins_list *)GRAAL_PREVIOUS( Rectangle );

      GraalFlatInstance( Instance );
    }

    GraalDelSelect();
    GraalZoomRefresh();
    GraalDisplayToolsMessage();
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalToolsUnflatten                     |
|                                                             |
\------------------------------------------------------------*/

  void GraalToolsUnflatten()

  { 
    graalselect *Select;
    rdsrec_list *Rectangle;
    rdsins_list *Instance;

    GraalSetMouseCursor( GraalGraphicWindow, GRAAL_WATCH_CURSOR  );
    
    for ( Select  = GraalHeadSelect;
          Select != (graalselect *)NULL;
          Select  = Select->NEXT )
    {
      Rectangle = Select->RECTANGLE;

      Instance = (rdsins_list *)GRAAL_PREVIOUS( Rectangle );
      GraalUnflatInstance( Instance );
    }

    GraalDelSelect();
    GraalZoomRefresh();
  }

/*------------------------------------------------------------\
|                                                             |
|                        GraalToolsPeek                       |
|                                                             |
\------------------------------------------------------------*/

  void GraalToolsPeek( LambdaX1, LambdaY1, LambdaX2, LambdaY2 )

     long LambdaX1;
     long LambdaY1;
     long LambdaX2;
     long LambdaY2;
  { 
    long         Offset;
    graalwin    *ScanWin;
    graalwinrec *ScanWinRec;
    rdsrec_list *Rec;
    graalpeek   *Peek;
    char         ScanRec;
    char         Layer;
    long         XabMin;
    long         XabMax;
    long         YabMin;
    long         YabMax;
    long         Xmin;
    long         Xmax;
    long         Ymin;
    long         Ymax;
    long         X;
    long         Y;
    long         Swap;

    if ( ( LambdaX1 != LambdaX2 ) &&
         ( LambdaY1 != LambdaY2 ) )
    {
      if ( LambdaX1 > LambdaX2 )
      {
        Swap = LambdaX1; LambdaX1 = LambdaX2; LambdaX2 = Swap;
      }

      if ( LambdaY1 > LambdaY2 )
      {
        Swap = LambdaY1; LambdaY1 = LambdaY2; LambdaY2 = Swap;
      }
    }

    if ( GraalFigureMbk != (phfig_list *)NULL )
    {
      GraalSetMouseCursor( GraalGraphicWindow, GRAAL_WATCH_CURSOR  );

      GraalDelEqui();
      GraalDelPeek();

      LambdaX1 = LambdaX1 * RDS_LAMBDA; 
      LambdaX2 = LambdaX2 * RDS_LAMBDA; 
      LambdaY1 = LambdaY1 * RDS_LAMBDA; 
      LambdaY2 = LambdaY2 * RDS_LAMBDA; 

      XabMin  = LambdaX1 - GRAAL_PEEK_BOUND;
      YabMin  = LambdaY1 - GRAAL_PEEK_BOUND;
      XabMax  = LambdaX2 + GRAAL_PEEK_BOUND;
      YabMax  = LambdaY2 + GRAAL_PEEK_BOUND;

      Xmin = ( LambdaX1 - GraalWindowXmin ) / GraalWindowSide;
      Xmax = ( LambdaX2 - GraalWindowXmin ) / GraalWindowSide;
      Ymin = ( LambdaY1 - GraalWindowYmin ) / GraalWindowSide;
      Ymax = ( LambdaY2 - GraalWindowYmin ) / GraalWindowSide;

      Y = Ymin;

      while ( Y <= Ymax )
      {
        X = Xmin;

        while ( X <= Xmax )
        {
          Offset = ( Y * GraalWindowDx ) + X;

          if ( ( ScanWin = GraalWindowTable[ Offset ] ) != (graalwin *)NULL )
          {
            for ( ScanWinRec  = ScanWin->LAYERTAB[ RDS_ABOX ];
                  ScanWinRec != (graalwinrec *)NULL;
                  ScanWinRec  = ScanWinRec->NEXT )
            {
              for ( ScanRec = 0; ScanRec < GRAAL_MAX_REC ; ScanRec++ )
              {
                Rec = ScanWinRec->RECTAB[ ScanRec ];

                if ( ( Rec != (rdsrec_list *)NULL      ) &&
                     ( ! IsRdsFigRec( Rec )            ) &&
                     ( ! IsGraalDeleted( Rec )         ) &&
                     ( ! IsGraalFlatten( Rec )         ) &&
                     ( ! IsGraalPeek( Rec )            ) &&
                     ( ( Rec->X + Rec->DX ) >=  XabMin ) &&
                     ( ( Rec->Y + Rec->DY ) >=  YabMin ) &&
                     ( ( Rec->X           ) <=  XabMax ) &&
                     ( ( Rec->Y           ) <=  YabMax ) )
                {
                  GraalAddPeek( Rec );
                }
              }
            }
          }

          X = X + 1;
        }

        Y = Y + 1;
      }

      for ( Peek  = GraalHeadPeek;
            Peek != (graalpeek *)NULL;
            Peek  = Peek->NEXT )
      {
        GraalPeekInstance( Peek->RECTANGLE,
                           LambdaX1, LambdaY1,
                           LambdaX2, LambdaY2 );
      }

      GraalZoomRefresh();
      GraalDisplayToolsMessage();

      GraalSetMouseCursor( GraalGraphicWindow, GRAAL_NORMAL_CURSOR  );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                        GraalToolsUnpeek                     |
|                                                             |
\------------------------------------------------------------*/

  void GraalToolsUnpeek()
  {
    if ( GraalHeadPeek != (graalpeek *)NULL )
    {
      GraalSetMouseCursor( GraalGraphicWindow, GRAAL_WATCH_CURSOR  );
      GraalDelEqui();
      GraalDelPeek();
      GraalZoomRefresh();
      GraalSetMouseCursor( GraalGraphicWindow, GRAAL_NORMAL_CURSOR  );
    }
  }
