/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Message.c                        |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>
# include <Xm/CascadeBG.h>
 

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GSB_H
# include GMT_H
# include "GMT_tools.h"
# include "GMT_message.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  static char MessageBuffer[ 512 ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                     GraalPromptToolsPeek                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptToolsPeek()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Peek" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select window" );

    switch ( GraalCountEventEdit )
    {
      case 0 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first corner" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter next corner" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalPromptToolsDruc                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptToolsDruc()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Druc" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select window" );

    switch ( GraalCountEventEdit )
    {
      case 0 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first corner" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter next corner" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalPromptToolsEqui                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptToolsEqui()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Equi" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select object" );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter select point" );
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalPromptToolsFlatten                 |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptToolsFlatten()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Flatten" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select window" );

    switch ( GraalCountEventEdit )
    {
      case 0 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first corner" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter next corner" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                     GraalPromptToolsUnflatten               |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptToolsUnflatten()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Unflatten" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select window" );

    switch ( GraalCountEventEdit )
    {
      case 0 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first corner" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter next corner" );
    }
  }
