/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   Menu.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <string.h>
# include <Xm/Xm.h>
# include <Xm/FileSB.h>
# include <Xm/SelectioB.h>
# include <Xm/PushBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GSB_H
# include GMF_H

# include "GMF_menu.h"
# include "GMF_dialog.h"
# include "GMF_file.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Menu                             |
|                                                             |
\------------------------------------------------------------*/

   GraalMenuItem GraalFileMenu[] =

         {
           {
             "New",
             'N',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackFileNew,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Open",
             'O',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackFileOpen,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Save     ",
             'S',
             "Ctrl<Key>W",
             "Ctrl W",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackFileSave,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Save As",
             'A',
             NULL,
             NULL,
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackFileSaveAs,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           {
             "Quit      ",
             'Q',
             "Ctrl<Key>Q",
             "Ctrl Q",
             &xmPushButtonGadgetClass,
             False,
             False,
             False,
             CallbackFileQuit,
             (XtPointer)NULL,
             (Widget)NULL,
             (Widget)NULL,
             (GraalMenuItem *)NULL
           }
           ,
           NULL
         };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                     CallbackFileNew                         |
|                                                             |
\------------------------------------------------------------*/

  void CallbackFileNew( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( GraalHeadUndo != (graalundo *)NULL )
    {
      CallbackFileSaveAs( NULL, NULL, NULL );
    }

    GraalFileNew();
  }

/*------------------------------------------------------------\
|                                                             |
|                     CallbackFileOpen                        |
|                                                             |
\------------------------------------------------------------*/

  void CallbackFileOpen( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XmString Filter;

    if ( GraalFileFilter[2] == '\0' )
    {
      strcat( GraalFileFilter, IN_PH );
      strcat( GraalFileExtention, IN_PH );

      Filter    = XmStringCreateSimple( GraalFileFilter ); 

      XtVaSetValues( GraalFileOpenDialog.WIDGET, 
                     XmNpattern, Filter, NULL);

      XmStringFree( Filter );
    }

    GraalEnterDialog( &GraalFileOpenDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                     CallbackFileSave                        |
|                                                             |
\------------------------------------------------------------*/

  void CallbackFileSave( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( GraalFigureMbk != (phfig_list *)NULL )
    {
      if ( ( GraalFigureMbk->NAME == (char *)NULL  ) ||
           ( ! strcmp( GraalFigureMbk->NAME, 
                       GRAAL_DEFAULT_FIGURE_NAME ) ) )

      {
        CallbackFileSaveAs( NULL, NULL, NULL );
      }
      else
      { 
        GraalFileSave();
      }
    }
    else
    {
      GraalErrorMessage( GraalMainWindow, "No current figure !" ); 
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                     CallbackFileSaveAs                      |
|                                                             |
\------------------------------------------------------------*/

  void CallbackFileSaveAs( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( GraalFigureMbk == (phfig_list *)NULL )
    {
      GraalErrorMessage( GraalMainWindow, "No current figure !" ); 
    }
    else
    {
      GraalEnterDialog( &GraalFileSaveAsDialog );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                     CallbackFileQuit                        |
|                                                             |
\------------------------------------------------------------*/

  void CallbackFileQuit( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalFileQuitDialog );
  }
