/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                   Panel.c                         |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <string.h>
# include <Xm/Xm.h>
# include <Xm/FileSB.h>
# include <Xm/SelectioB.h>
# include <Xm/PushBG.h>

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GSB_H
# include GME_H

# include "GME_panel.h"
# include "GME_message.h"
# include "GME_dialog.h"
# include "GME_modify.h"
# include "GME_search.h"
# include "GME_select.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                             Panel                           |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        Search View Panel                    |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalEditSearchViewButtonName[] =

   {
     "Continue",
     "Abort"
   };

   static GraalPanelButtonItem GraalEditSearchViewButton[] =

         {
           {
             &GraalEditSearchViewButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 0,
             1, 1,
             CallbackEditSearchViewContinue,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalEditSearchViewButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 1,
             1, 1,
             CallbackEditSearchViewAbort,
             (XtPointer)NULL,
             (Widget)NULL   
           }
           ,
           NULL 
         };

   GraalPanelItem GraalEditSearchViewPanel  =

         {
           "View search",
           1,
           GRAAL_EDIT_VIEW_SEARCH_X,
           GRAAL_EDIT_VIEW_SEARCH_Y,
           90, 
           50,
           1,  
           2,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalEditSearchViewButton
         };

  int GraalEditSearchViewDefaultValues[ 4 ] =

         {
           GRAAL_EDIT_VIEW_SEARCH_X, 
           GRAAL_EDIT_VIEW_SEARCH_Y,
           90, 50
         };

/*------------------------------------------------------------\
|                                                             |
|                        Identify Edit Panel                  |
|                                                             |
\------------------------------------------------------------*/


   static char *GraalEditIdentifyButtonName[] =

   {
     "Text",
     "Close"
   };

   GraalPanelButtonItem GraalEditIdentifyButton[] =

         {
           {
             &GraalEditIdentifyButtonName[0],
             "Nothing", NULL, 0, 0,
             NULL,
             NULL,
              0, 0,
              8, 9,
             NULL,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalEditIdentifyButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             3, 9,
             2, 1,
             CallbackEditCloseIdentify,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalEditIdentifyPanel =

         {
           "Identify",
           1,
           GRAAL_EDIT_IDENTIFY_X,
           GRAAL_EDIT_IDENTIFY_Y,
           360,
           250,
           8,
           10,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalEditIdentifyButton
         };

  int GraalEditIdentifyDefaultValues[ 4 ] =

         {
           GRAAL_EDIT_IDENTIFY_X, 
           GRAAL_EDIT_IDENTIFY_Y,
           360, 250
         };

/*------------------------------------------------------------\
|                                                             |
|                        Select Panel                         |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalEditSelectButtonName[] =

   {
     "Select",
     "Accept",
     "Cancel"
   };

   GraalPanelButtonItem GraalEditSelectButton[] =

         {
           {
             &GraalEditSelectButtonName[0],
             "List",
             "List", 0, 0,
             NULL,
             NULL,
             0, 0,
             8, 9,
             CallbackEditSelectList,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalEditSelectButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             1, 9,
             2, 1,
             CallbackEditSelectAccept,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalEditSelectButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             5, 9,
             2, 1,
             CallbackEditSelectCancel,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalEditSelectPanel =

         {
           "Select",
           1,
           GRAAL_EDIT_SELECT_X,
           GRAAL_EDIT_SELECT_Y,
           360,
           250,
           8,
           10,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalEditSelectButton
         };

  int GraalEditSelectDefaultValues[ 4 ] =

         {
           GRAAL_EDIT_IDENTIFY_X,
           GRAAL_EDIT_IDENTIFY_Y,
           360, 250
         };

/*------------------------------------------------------------\
|                                                             |
|                      Search Element Panel                   |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalEditSearchButtonName[] =

   {
     "Connector",
     "Instance",
     "Reference",
     "Segment",
     "Close"
   };

   static GraalPanelButtonItem GraalEditSearchButton[] =

         {
           {
             &GraalEditSearchButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 0,
             1, 1,
             CallbackEditSearchConnector,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalEditSearchButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 1,
             1, 1,
             CallbackEditSearchInstance,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalEditSearchButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 2,
             1, 1,
             CallbackEditSearchReference,
             (XtPointer)NULL,
             (Widget)NULL   
           }
           ,
           {
             &GraalEditSearchButtonName[3],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 3,
             1, 1,
             CallbackEditSearchSegment,
             (XtPointer)NULL,
             (Widget)NULL   
           }
           ,
           {
             &GraalEditSearchButtonName[4],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 4,
             1, 1,
             CallbackEditCloseSearch,
             (XtPointer)NULL,
             (Widget)NULL
           } 
           ,
           NULL
         };
           
   GraalPanelItem GraalEditSearchPanel  =

         {
           "Search",
           1,
           GRAAL_EDIT_SEARCH_X,
           GRAAL_EDIT_SEARCH_Y,
           90,
           125, 
           1, 
           5,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalEditSearchButton
         };

  int GraalEditSearchDefaultValues[ 4 ] =

         {
           GRAAL_EDIT_SEARCH_X,
           GRAAL_EDIT_SEARCH_Y,
           90, 125
         };

/*------------------------------------------------------------\
|                                                             |
|                   Modify Segment Panel                      |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalModifySegmentButtonName[] =

   {
     "Width",
     "Name",
     "Apply",
     "Cancel"
   };

   static GraalPanelButtonItem GraalModifySegmentButton[] =

         {
           {
             &GRAAL_SEGMENT_NAME_TABLE[NWELL][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[NWELL][1],
             &GRAAL_SEGMENT_NAME_TABLE[NWELL][2],
             0, 0,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)NWELL,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[PWELL][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[PWELL][1],
             &GRAAL_SEGMENT_NAME_TABLE[PWELL][2],
             1, 0,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)PWELL,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[NDIF][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[NDIF][1],
             &GRAAL_SEGMENT_NAME_TABLE[NDIF][2],
             0, 1,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)NDIF,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[PDIF][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[PDIF][1],
             &GRAAL_SEGMENT_NAME_TABLE[PDIF][2],
             1, 1,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)PDIF,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[NTIE][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[NTIE][1],
             &GRAAL_SEGMENT_NAME_TABLE[NTIE][2],
             0, 2,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)NTIE,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[PTIE][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[PTIE][1],
             &GRAAL_SEGMENT_NAME_TABLE[PTIE][2],
             1, 2,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)PTIE,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[POLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[POLY][1],
             &GRAAL_SEGMENT_NAME_TABLE[POLY][2],
             0, 3,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)POLY,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_SEGMENT_NAME_TABLE[TPOLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[TPOLY][1],
             &GRAAL_SEGMENT_NAME_TABLE[TPOLY][2],
             1, 3,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)TPOLY,
             (Widget)NULL
           }    
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[ALU1][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[ALU1][1],
             &GRAAL_SEGMENT_NAME_TABLE[ALU1][2],
             0, 4,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)ALU1,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_SEGMENT_NAME_TABLE[TALU1][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[TALU1][1],
             &GRAAL_SEGMENT_NAME_TABLE[TALU1][2],
             1, 4,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)TALU1,
             (Widget)NULL
           }    
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[ALU2][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[ALU2][1],
             &GRAAL_SEGMENT_NAME_TABLE[ALU2][2],
             0, 5,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)ALU2,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_SEGMENT_NAME_TABLE[TALU2][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[TALU2][1],
             &GRAAL_SEGMENT_NAME_TABLE[TALU2][2],
             1, 5,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)TALU2,
             (Widget)NULL
           }    
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[ALU3][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[ALU3][1],
             &GRAAL_SEGMENT_NAME_TABLE[ALU3][2],
             0, 6,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)ALU3,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_SEGMENT_NAME_TABLE[TALU3][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[TALU3][1],
             &GRAAL_SEGMENT_NAME_TABLE[TALU3][2],
             1, 6,
             1, 1,
             CallbackModifySegmentLayer,
             (XtPointer)TALU3,
             (Widget)NULL
           }
           ,
           {
             &GraalModifySegmentButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 7,
             2, 1,
             CallbackModifySegmentWidth,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalModifySegmentButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 8,
             2, 1,
             CallbackModifySegmentName,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalModifySegmentButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 9,
             2, 1,
             CallbackModifySegmentApply,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalModifySegmentButtonName[3],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 10,
             2, 1,
             CallbackModifySegmentCancel,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalModifySegmentPanel  =

         {
           "Modify Segment",
           1,
           GRAAL_MODIFY_SEGMENT_X,
           GRAAL_MODIFY_SEGMENT_Y, 
           90,
           275,
           2,  
           11,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalModifySegmentButton
         };

  int GraalModifySegmentDefaultValues[ 4 ] =

         {
           GRAAL_MODIFY_SEGMENT_X, 
           GRAAL_MODIFY_SEGMENT_Y,
           90, 275
         };

/*------------------------------------------------------------\
|                                                             |
|                          Via Panel                          |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalModifyViaButtonName [] =

   {
     "Apply",
     "Cancel"
   };

   static GraalPanelButtonItem GraalModifyViaButton[] =

         {
           {
             &GRAAL_VIA_NAME_TABLE[CONT_DIF_N][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_DIF_N][1],
             &GRAAL_VIA_NAME_TABLE[CONT_DIF_N][2],
             0, 0,
             1, 1,
             CallbackModifyViaType,
             (XtPointer)CONT_DIF_N,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_DIF_P][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_DIF_P][1],
             &GRAAL_VIA_NAME_TABLE[CONT_DIF_P][2],
             0, 1,
             1, 1,
             CallbackModifyViaType,
             (XtPointer)CONT_DIF_P,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_BODY_N][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_BODY_N][1],
             &GRAAL_VIA_NAME_TABLE[CONT_BODY_N][2],
             0, 2,
             1, 1,
             CallbackModifyViaType,
             (XtPointer)CONT_BODY_N,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_BODY_P][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_BODY_P][1],
             &GRAAL_VIA_NAME_TABLE[CONT_BODY_P][2],
             0, 3,
             1, 1,
             CallbackModifyViaType,
             (XtPointer)CONT_BODY_P,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[C_X_N][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[C_X_N][1],
             &GRAAL_VIA_NAME_TABLE[C_X_N][2],
             0, 4,
             1, 1,
             CallbackModifyViaType,
             (XtPointer)C_X_N,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[C_X_P][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[C_X_P][1],
             &GRAAL_VIA_NAME_TABLE[C_X_P][2],
             0, 5,
             1, 1,
             CallbackModifyViaType,
             (XtPointer)C_X_P,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_POLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_POLY][1],
             &GRAAL_VIA_NAME_TABLE[CONT_POLY][2],
             0, 6,
             1, 1,
             CallbackModifyViaType,
             (XtPointer)CONT_POLY,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_VIA][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_VIA][1],
             &GRAAL_VIA_NAME_TABLE[CONT_VIA][2],
             0, 7,
             1, 1,
             CallbackModifyViaType,
             (XtPointer)CONT_VIA,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_VIA2][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_VIA2][1],
             &GRAAL_VIA_NAME_TABLE[CONT_VIA2][2],
             0, 8,
             1, 1,
             CallbackModifyViaType,
             (XtPointer)CONT_VIA2,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_VIA_NAME_TABLE[CONT_VIA3][0],
             NULL, NULL, 0, 0,
             &GRAAL_VIA_NAME_TABLE[CONT_VIA3][1],
             &GRAAL_VIA_NAME_TABLE[CONT_VIA3][2],
             0, 9,
             1, 1,
             CallbackModifyViaType,
             (XtPointer)CONT_VIA3,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyViaButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 10,
             1, 1,
             CallbackModifyViaApply,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyViaButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 11,
             1, 1,
             CallbackModifyViaCancel,
             (XtPointer)NULL,
             (Widget)NULL
           }
           , 
           NULL
         };

   GraalPanelItem GraalModifyViaPanel  =

         {
           "Modify Via",
           1,
           GRAAL_MODIFY_VIA_X,
           GRAAL_MODIFY_VIA_Y, 
           90, 
           300,
           1,  
           12,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalModifyViaButton
         };

  int GraalModifyViaDefaultValues[ 4 ] =

         {
           GRAAL_MODIFY_VIA_X, 
           GRAAL_MODIFY_VIA_Y,
           90, 300
         };

/*------------------------------------------------------------\
|                                                             |
|                        Transistor Panel                     |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalModifyTransistorButtonName [] =

   {
     "Length",
     "Apply",
     "Cancel"
   };

   static GraalPanelButtonItem GraalModifyTransistorButton[] =

         {
           {
             &GRAAL_SEGMENT_NAME_TABLE[ NTRANS ][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[ NTRANS ][1],
             &GRAAL_SEGMENT_NAME_TABLE[ NTRANS ][2],
             0, 0,
             1, 1,
             CallbackModifyTransistorType,
             (XtPointer)NTRANS,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SEGMENT_NAME_TABLE[ PTRANS ][0],
             NULL, NULL, 0, 0,
             &GRAAL_SEGMENT_NAME_TABLE[ PTRANS ][1],
             &GRAAL_SEGMENT_NAME_TABLE[ PTRANS ][2],
             0, 1,
             1, 1,
             CallbackModifyTransistorType,
             (XtPointer)PTRANS,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyTransistorButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 2,
             1, 1,
             CallbackModifyTransistorLength,
             (XtPointer) NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyTransistorButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 3,
             1, 1,
             CallbackModifyTransistorApply,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyTransistorButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 4,
             1, 1,
             CallbackModifyTransistorCancel,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalModifyTransistorPanel  =

         {
           "Modify Transistor",
           1,
           GRAAL_MODIFY_TRANSISTOR_X,
           GRAAL_MODIFY_TRANSISTOR_Y,
           90, 
           125,
           1,  
           5,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalModifyTransistorButton
         };

  int GraalModifyTransistorDefaultValues[ 4 ] =

         {
           GRAAL_MODIFY_TRANSISTOR_X, 
           GRAAL_MODIFY_TRANSISTOR_Y,
           90, 125
         };

/*------------------------------------------------------------\
|                                                             |
|                       Connector Panel                       |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalModifyConnectorButtonName[] =

   {
     "Width",
     "Name",
     "Apply",
     "Cancel"
   };

   static GraalPanelButtonItem GraalModifyConnectorButton[] =

         {
           {
             &GRAAL_CONNECTOR_NAME_TABLE[NWELL][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[NWELL][1],
             &GRAAL_CONNECTOR_NAME_TABLE[NWELL][2],
             0, 0,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)NWELL,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[PWELL][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[PWELL][1],
             &GRAAL_CONNECTOR_NAME_TABLE[PWELL][2],
             1, 0,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)PWELL,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[NDIF][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[NDIF][1],
             &GRAAL_CONNECTOR_NAME_TABLE[NDIF][2],
             0, 1,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)NDIF,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[PDIF][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[PDIF][1],
             &GRAAL_CONNECTOR_NAME_TABLE[PDIF][2],
             1, 1,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)PDIF,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[NTIE][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[NTIE][1],
             &GRAAL_CONNECTOR_NAME_TABLE[NTIE][2],
             0, 2,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)NTIE,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[PTIE][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[PTIE][1],
             &GRAAL_CONNECTOR_NAME_TABLE[PTIE][2],
             1, 2,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)PTIE,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[POLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[POLY][1],
             &GRAAL_CONNECTOR_NAME_TABLE[POLY][2],
             0, 3,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)POLY,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_CONNECTOR_NAME_TABLE[TPOLY][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[TPOLY][1],
             &GRAAL_CONNECTOR_NAME_TABLE[TPOLY][2],
             1, 3,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)TPOLY,
             (Widget)NULL
           }    
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[ALU1][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[ALU1][1],
             &GRAAL_CONNECTOR_NAME_TABLE[ALU1][2],
             0, 4,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)ALU1,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_CONNECTOR_NAME_TABLE[TALU1][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[TALU1][1],
             &GRAAL_CONNECTOR_NAME_TABLE[TALU1][2],
             1, 4,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)TALU1,
             (Widget)NULL
           }    
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[ALU2][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[ALU2][1],
             &GRAAL_CONNECTOR_NAME_TABLE[ALU2][2],
             0, 5,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)ALU2,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_CONNECTOR_NAME_TABLE[TALU2][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[TALU2][1],
             &GRAAL_CONNECTOR_NAME_TABLE[TALU2][2],
             1, 5,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)TALU2,
             (Widget)NULL
           }    
           ,
           {
             &GRAAL_CONNECTOR_NAME_TABLE[ALU3][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[ALU3][1],
             &GRAAL_CONNECTOR_NAME_TABLE[ALU3][2],
             0, 6,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)ALU3,
             (Widget)NULL
           }    
           , 
           {
             &GRAAL_CONNECTOR_NAME_TABLE[TALU3][0],
             NULL, NULL, 0, 0,
             &GRAAL_CONNECTOR_NAME_TABLE[TALU3][1],
             &GRAAL_CONNECTOR_NAME_TABLE[TALU3][2],
             1, 6,
             1, 1,
             CallbackModifyConnectorLayer,
             (XtPointer)TALU3,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyConnectorButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 7,
             2, 1,
             CallbackModifyConnectorWidth,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_NORTH][0],
             NULL, NULL, 0, 0,
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_NORTH][1],
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_NORTH][2],
             0, 8,
             2, 1,
             CallbackModifyConnectorOrient,
             (XtPointer)GRAAL_NORTH,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_SOUTH][0],
             NULL, NULL, 0, 0,
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_SOUTH][1],
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_SOUTH][2],
             0, 9,
             2, 1,
             CallbackModifyConnectorOrient,
             (XtPointer)GRAAL_SOUTH,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_EAST][0], 
             NULL, NULL, 0, 0,
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_EAST][1], 
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_EAST][2], 
             0, 10,
             2, 1,
             CallbackModifyConnectorOrient,
             (XtPointer)GRAAL_EAST,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_WEST][0], 
             NULL, NULL, 0, 0,
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_WEST][1], 
             &GRAAL_ORIENT_NAME_TABLE[GRAAL_WEST][2], 
             0, 11,
             2, 1,
             CallbackModifyConnectorOrient,
             (XtPointer)GRAAL_WEST,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyConnectorButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 12,
             2, 1,
             CallbackModifyConnectorName,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyConnectorButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 13,
             2, 1,
             CallbackModifyConnectorApply,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyConnectorButtonName[3],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 14,
             2, 1,
             CallbackModifyConnectorCancel,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           NULL
         };

   GraalPanelItem GraalModifyConnectorPanel  =

         {
           "Modify Connector",
           1,
           GRAAL_MODIFY_CONNECTOR_X,
           GRAAL_MODIFY_CONNECTOR_Y,
           90, 
           375,
           2,  
           15,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalModifyConnectorButton
         };

  int GraalModifyConnectorDefaultValues[ 4 ] =

         {
           GRAAL_MODIFY_CONNECTOR_X, 
           GRAAL_MODIFY_CONNECTOR_Y,
           90, 375
         };

/*------------------------------------------------------------\
|                                                             |
|                        Reference Panel                      |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalModifyReferenceButtonName[] =

   {
     "Name",
     "Apply",
     "Cancel"
   };
 
   static GraalPanelButtonItem GraalModifyReferenceButton[] =

         {
           {
             &GRAAL_REFERENCE_NAME_TABLE[MBK_REF_REF][0],
             NULL, NULL, 0, 0,
             &GRAAL_REFERENCE_NAME_TABLE[MBK_REF_REF][1],
             &GRAAL_REFERENCE_NAME_TABLE[MBK_REF_REF][2],
             0, 0,
             1, 1,
             CallbackModifyReferenceType,
             (XtPointer)MBK_REF_REF,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_REFERENCE_NAME_TABLE[MBK_REF_CON][0],
             NULL, NULL, 0, 0,
             &GRAAL_REFERENCE_NAME_TABLE[MBK_REF_CON][1],
             &GRAAL_REFERENCE_NAME_TABLE[MBK_REF_CON][2],
             0, 1,
             1, 1,
             CallbackModifyReferenceType,
             (XtPointer)MBK_REF_CON,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyReferenceButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 2,
             1, 1,
             CallbackModifyReferenceName,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyReferenceButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 3,
             1, 1,
             CallbackModifyReferenceApply,
             (XtPointer)NULL,
             (Widget)NULL
           }
           , 
           {
             &GraalModifyReferenceButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 4,
             1, 1,
             CallbackModifyReferenceCancel,
             (XtPointer)NULL,
             (Widget)NULL   
           }
           ,
           NULL
        };

   GraalPanelItem GraalModifyReferencePanel  =

         {
           "Modify Reference",
           1,
           GRAAL_MODIFY_REFERENCE_X,
           GRAAL_MODIFY_REFERENCE_Y,
           90, 
           125,
           1,  
           5,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalModifyReferenceButton
         };

  int GraalModifyReferenceDefaultValues[ 4 ] =

         {
           GRAAL_MODIFY_REFERENCE_X,
           GRAAL_MODIFY_REFERENCE_Y, 
           90, 125
         };

/*------------------------------------------------------------\
|                                                             |
|                        Instance  Panel                      |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalModifyInstanceButtonName[] =

   {
     "Name",
     "Model",
     "Apply",
     "Cancel"
   };

   static GraalPanelButtonItem GraalModifyInstanceButton[] =

         {
           {
             &GRAAL_SYMMETRY_NAME_TABLE[NOSYM][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[NOSYM][1],
             &GRAAL_SYMMETRY_NAME_TABLE[NOSYM][2],
             0, 0,
             1, 1,
             CallbackModifyInstanceSym,
             (XtPointer)NOSYM,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[SYM_X][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[SYM_X][1],
             &GRAAL_SYMMETRY_NAME_TABLE[SYM_X][2],
             0, 1,
             1, 1,
             CallbackModifyInstanceSym,
             (XtPointer)SYM_X,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[SYM_Y][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[SYM_Y][1],
             &GRAAL_SYMMETRY_NAME_TABLE[SYM_Y][2],
             0, 2,
             1, 1,
             CallbackModifyInstanceSym,
             (XtPointer)SYM_Y,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[SYMXY][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[SYMXY][1],
             &GRAAL_SYMMETRY_NAME_TABLE[SYMXY][2],
             0, 3,
             1, 1,
             CallbackModifyInstanceSym,
             (XtPointer)SYMXY,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[ROT_P][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[ROT_P][1],
             &GRAAL_SYMMETRY_NAME_TABLE[ROT_P][2],
             0, 4,
             1, 1,
             CallbackModifyInstanceSym,
             (XtPointer)ROT_P,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[ROT_M][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[ROT_M][1],
             &GRAAL_SYMMETRY_NAME_TABLE[ROT_M][2],
             0, 5,
             1, 1,
             CallbackModifyInstanceSym,
             (XtPointer)ROT_M,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[SY_RP][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[SY_RP][1],
             &GRAAL_SYMMETRY_NAME_TABLE[SY_RP][2],
             0, 6,
             1, 1,
             CallbackModifyInstanceSym,
             (XtPointer)SY_RP,
             (Widget)NULL
           }
           ,
           {
             &GRAAL_SYMMETRY_NAME_TABLE[SY_RM][0],
             NULL, NULL, 0, 0,
             &GRAAL_SYMMETRY_NAME_TABLE[SY_RM][1],
             &GRAAL_SYMMETRY_NAME_TABLE[SY_RM][2],
             0, 7,
             1, 1,
             CallbackModifyInstanceSym,
             (XtPointer)SY_RM,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyInstanceButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 8,
             1, 1,
             CallbackModifyInstanceName,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyInstanceButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 9,
             1, 1,
             CallbackModifyInstanceModel,
             (XtPointer)NULL,
             (Widget)NULL
           }
           ,
           {
             &GraalModifyInstanceButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 10,
             1, 1,
             CallbackModifyInstanceApply,
             (XtPointer)NULL,
             (Widget)NULL
           }
           , 
           {
             &GraalModifyInstanceButtonName[3],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 11,
             1, 1,
             CallbackModifyInstanceCancel,
             (XtPointer)NULL,
             (Widget)NULL   
           }
           ,
           NULL
        };  

   GraalPanelItem GraalModifyInstancePanel  =

         {
           "Modify Instance",
           1,
           GRAAL_MODIFY_INSTANCE_X,
           GRAAL_MODIFY_INSTANCE_Y,
           90, 
           300,
           1,  
           12,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalModifyInstanceButton
         };

  int GraalModifyInstanceDefaultValues[ 4 ] =

         {
           GRAAL_MODIFY_INSTANCE_X,
           GRAAL_MODIFY_INSTANCE_Y,
           90, 300
         };


/*------------------------------------------------------------\
|                                                             |
|                         Global Edit                         |
|                                                             |
\------------------------------------------------------------*/

   static char *GraalEditGlobalButtonName[] =

   {
     "Undo",
     "Copy",
     "Move",
     "Delete",
     "Stretch",
     "Modify",
     "Identify",
     "Close"
   };

   static GraalPanelButtonItem GraalEditGlobalButton[] =
 
         {
           {
             &GraalEditGlobalButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 0,
             1, 1,
             CallbackEditGlobalUndo,
             (XtPointer)0,
             (Widget)NULL
           }
           ,
           {
             &GraalEditGlobalButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 1,
             1, 1,
             CallbackEditGlobalCopy,
             (XtPointer)0,
             (Widget)NULL
           }
           ,
           {
             &GraalEditGlobalButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 2,
             1, 1,
             CallbackEditGlobalMove,
             (XtPointer)0,
             (Widget)NULL
           }
           ,
           {
             &GraalEditGlobalButtonName[3],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 3,
             1, 1,
             CallbackEditGlobalDelete,
             (XtPointer)0,
             (Widget)NULL
           }
           ,
           {
             &GraalEditGlobalButtonName[4],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 4,
             1, 1,
             CallbackEditGlobalStretch,
             (XtPointer)0,
             (Widget)NULL
           }
           ,
           {
             &GraalEditGlobalButtonName[5],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 5,
             1, 1,
             CallbackEditGlobalModify,
             (XtPointer)0,
             (Widget)NULL
           }
           ,
           {
             &GraalEditGlobalButtonName[6],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 6,
             1, 1,
             CallbackEditGlobalIdentify,
             (XtPointer)0,
             (Widget)NULL
           } 
           ,
           {
             &GraalEditGlobalButtonName[7],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 7,
             1, 1,
             CallbackEditCloseGlobal,
             (XtPointer)0,
             (Widget)NULL   
           }
           ,
           NULL
         };

   GraalPanelItem GraalEditGlobalPanel  =

         {
           "Edit",
           1,
           GRAAL_EDIT_GLOBAL_X,
           GRAAL_EDIT_GLOBAL_Y,
           90, 
           200,
           1, 
           8,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalEditGlobalButton
         };

  int GraalEditGlobalDefaultValues[ 4 ] =

         {
           GRAAL_EDIT_GLOBAL_X, 
           GRAAL_EDIT_GLOBAL_Y,
           90, 200
         };

/*------------------------------------------------------------\
|                                                             |
|                         Global Window                       |
|                                                             |
\------------------------------------------------------------*/

   static GraalPanelButtonItem GraalWindowGlobalButton[] =
 
         {
           {
             &GraalEditGlobalButtonName[0],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 0,
             1, 1,
             CallbackEditGlobalUndo,
             (XtPointer)0,
             (Widget)NULL
           }
           ,
           {
             &GraalEditGlobalButtonName[1],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 1,
             1, 1,
             CallbackEditGlobalCopy,
             (XtPointer)1,
             (Widget)NULL
           }
           ,
           {
             &GraalEditGlobalButtonName[2],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 2,
             1, 1,
             CallbackEditGlobalMove,
             (XtPointer)1,
             (Widget)NULL
           }
           ,
           {
             &GraalEditGlobalButtonName[3],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 3,
             1, 1,
             CallbackEditGlobalDelete,
             (XtPointer)1,
             (Widget)NULL
           }
           ,
           {
             &GraalEditGlobalButtonName[5],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 4,
             1, 1,
             CallbackEditGlobalModify,
             (XtPointer)1,
             (Widget)NULL
           }
           ,
           {
             &GraalEditGlobalButtonName[6],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 5,
             1, 1,
             CallbackEditGlobalIdentify,
             (XtPointer)1,
             (Widget)NULL
           } 
           ,
           {
             &GraalEditGlobalButtonName[7],
             NULL, NULL, 0, 0,
             NULL,
             NULL,
             0, 6,
             1, 1,
             CallbackEditCloseGlobal,
             (XtPointer)1,
             (Widget)NULL   
           }
           ,
           NULL
         };

   GraalPanelItem GraalWindowGlobalPanel  =

         {
           "Window",
           1,
           GRAAL_WINDOW_GLOBAL_X,
           GRAAL_WINDOW_GLOBAL_Y,
           90,
           175,
           1,
           7,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           (Widget)NULL,
           GraalWindowGlobalButton
         };

  int GraalWindowGlobalDefaultValues[ 4 ] =

         {
           GRAAL_WINDOW_GLOBAL_X,
           GRAAL_WINDOW_GLOBAL_Y,
           90, 175
         };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    Callback For Global Edit                 |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditGlobalUndo                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditGlobalUndo( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEditUndo();
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditGlobalCopy                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditGlobalCopy( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ClientData )
    {
      GraalChangeEditMode( GRAAL_SELECT_WINDOW_COPY,
                           GraalPromptSelectWindowCopy );
    }
    else
    {
      GraalChangeEditMode( GRAAL_SELECT_POINT_COPY,
                           GraalPromptSelectPointCopy );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditGlobalMove                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditGlobalMove( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ClientData )
    {
      GraalChangeEditMode( GRAAL_SELECT_WINDOW_MOVE,
                           GraalPromptSelectWindowMove );
    }
    else
    {
      GraalChangeEditMode( GRAAL_SELECT_POINT_MOVE,
                           GraalPromptSelectPointMove );
    }
  }
/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditGlobalDelete                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditGlobalDelete( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ClientData )
    {
      GraalChangeEditMode( GRAAL_SELECT_WINDOW_DELETE,
                           GraalPromptSelectWindowDelete );
    }
    else
    {
      GraalChangeEditMode( GRAAL_SELECT_POINT_DELETE,
                           GraalPromptSelectPointDelete );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackEditGlobalStretch                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditGlobalStretch( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalChangeEditMode( GRAAL_SELECT_POINT_STRETCH,
                         GraalPromptSelectPointStretch );
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackEditGlobalModify                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditGlobalModify( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ClientData )
    {
      GraalChangeEditMode( GRAAL_SELECT_WINDOW_MODIFY,
                           GraalPromptSelectWindowModify );
    }
    else
    {
      GraalChangeEditMode( GRAAL_SELECT_POINT_MODIFY,
                           GraalPromptSelectPointModify );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackEditGlobalIdentify                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditGlobalIdentify( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ClientData )
    {
      GraalChangeEditMode( GRAAL_SELECT_WINDOW_IDENTIFY,
                           GraalPromptSelectWindowIdentify );
    }
    else
    {
      GraalChangeEditMode( GRAAL_SELECT_POINT_IDENTIFY,
                           GraalPromptSelectPointIdentify );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditCloseGlobal                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditCloseGlobal( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    if ( ClientData )
    {
      XtUnmanageChild( GraalWindowGlobalPanel.PANEL );
    }
    else
    {
      XtUnmanageChild( GraalEditGlobalPanel.PANEL );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                       Callback For Search                   |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditSearchConnector              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditSearchConnector( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalSearchConnectorDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditSearchInstance               |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackEditSearchInstance( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData; 
  {
    GraalEnterDialog( &GraalSearchInstanceDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditSearchReference              |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackEditSearchReference( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData; 
  {
    GraalEnterDialog( &GraalSearchReferenceDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditSearchSegment                |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackEditSearchSegment( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData; 
  {
    GraalEnterDialog( &GraalSearchSegmentDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditCloseSearch                  |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackEditCloseSearch( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData; 
  {
    XtUnmanageChild( GraalEditSearchPanel.PANEL );
  }

/*------------------------------------------------------------\
|                                                             |
|                    Callback For View Search                 |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                  CallbackEditSearchViewContinue             |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditSearchViewContinue( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackEditSearchViewAbort                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditSearchViewAbort( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalSearchAbort = GRAAL_TRUE; 

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Identify                   |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditCloseIdentify                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditCloseIdentify(  MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalEditIdentifyPanel.PANEL );

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                    GraalDisplayIdentifyMessage              |
|                                                             |
\------------------------------------------------------------*/

  void GraalDisplayIdentifyMessage( Message )

    char *Message;
  {
    XmTextSetString( GraalEditIdentifyButton[0].BUTTON, Message );
  }

/*------------------------------------------------------------\
|                                                             |
|                     Callback For Select                     |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditSelectList                   |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditSelectList(  MyWidget, ClientData, CallData )

       Widget                MyWidget;
       caddr_t               ClientData;
       XmListCallbackStruct *CallData;
  {
    GraalEditSelectRectangle( CallData->item_position - 1 );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditSelectAccept                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditSelectAccept(  MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalEditSelectPanel.PANEL );

    GraalExitDialog();

    GraalEditSelectAccept();
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackEditSelectCancel                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackEditSelectCancel(  MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    XtUnmanageChild( GraalEditSelectPanel.PANEL );

    GraalExitDialog();

    GraalEditSelectCancel();
  }

/*------------------------------------------------------------\
|                                                             |
|                  GraalDisplaySelectList                     |
|                                                             |
\------------------------------------------------------------*/

  void GraalDisplaySelectList( Message )

    char *Message;
  {
    XmString     Label;

    if ( Message == (char *)NULL )
    {
      XmListDeleteAllItems( GraalEditSelectButton[ 0 ].BUTTON );
    }
    else
    {
      Label = XmStringCreateSimple( Message );
      XmListAddItem( GraalEditSelectButton[ 0 ].BUTTON , Label , NULL );
      XmStringFree( Label );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    Callback For Modify Segment              |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackModifySegmentLayer               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifySegmentLayer( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalSegmentMLayer = (int)ClientData;
    GraalSegmentMWidth = GRAAL_SEGMENT_VALUE_TABLE[ GraalSegmentMLayer ][0];

    GraalPromptModifySegment();
  }
 
/*------------------------------------------------------------\
|                                                             |
|                    CallbackModifySegmentWidth               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifySegmentWidth( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalModifySegmentWidthDialog );
  }
 
/*------------------------------------------------------------\
|                                                             |
|                    CallbackModifySegmentName                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifySegmentName( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalModifySegmentNameDialog );
  }
 
/*------------------------------------------------------------\
|                                                             |
|                    CallbackModifySegmentApply               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifySegmentApply( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalModifyLock   = GRAAL_FALSE;
    GraalModifyAbort  = GRAAL_FALSE;
    GraalModifyApply  = GRAAL_TRUE;

    GraalExitDialog();
  }
 
/*------------------------------------------------------------\
|                                                             |
|                    CallbackModifySegmentCancel              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifySegmentCancel( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalModifyLock   = GRAAL_FALSE;
    GraalModifyAbort  = GRAAL_TRUE;
    GraalModifyApply  = GRAAL_FALSE;

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                 Callback For Modify Transistor              |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                   CallbackModifyTransistorType              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyTransistorType( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalTransistorMType   = (int)ClientData;
    GraalTransistorMLength = GRAAL_SEGMENT_VALUE_TABLE[ GraalTransistorMType ][0];

    GraalPromptModifyTransistor();
  }
 
/*------------------------------------------------------------\
|                                                             |
|                  CallbackModifyTransistorLength             |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyTransistorLength( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalModifyTransistorLengthDialog );
  }
 
/*------------------------------------------------------------\
|                                                             |
|                   CallbackModifyTransistorApply             |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyTransistorApply( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalModifyLock   = GRAAL_FALSE;
    GraalModifyAbort  = GRAAL_FALSE;
    GraalModifyApply  = GRAAL_TRUE;

    GraalExitDialog();
  }
 
/*------------------------------------------------------------\
|                                                             |
|                  CallbackModifyTransistorCancel             |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyTransistorCancel( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalModifyLock   = GRAAL_FALSE;
    GraalModifyAbort  = GRAAL_TRUE;
    GraalModifyApply  = GRAAL_FALSE;

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                   Callback For Modify Connector             |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackModifyConnectorLayer             |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyConnectorLayer( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalConnectorMLayer = (int)ClientData;
    GraalConnectorMWidth = GRAAL_SEGMENT_VALUE_TABLE[ GraalConnectorMLayer ][0];

    GraalPromptModifyConnector();
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackModifyConnectorOrient            |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyConnectorOrient( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalConnectorMOrient = (int)ClientData;

    GraalPromptModifyConnector();
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackModifyConnectorName              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyConnectorName( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalModifyConnectorNameDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                  CallbackModifyConnectorWidth               |
|                                                             |
\------------------------------------------------------------*/
 
  void CallbackModifyConnectorWidth( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalModifyConnectorWidthDialog );
  }
 
/*------------------------------------------------------------\
|                                                             |
|                  CallbackModifyConnectorApply               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyConnectorApply( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalModifyLock   = GRAAL_FALSE;
    GraalModifyAbort  = GRAAL_FALSE;
    GraalModifyApply  = GRAAL_TRUE;

    GraalExitDialog();
  }
 
/*------------------------------------------------------------\
|                                                             |
|                  CallbackModifyConnectorCancel              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyConnectorCancel( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalModifyLock   = GRAAL_FALSE;
    GraalModifyAbort  = GRAAL_TRUE;
    GraalModifyApply  = GRAAL_FALSE;

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                    Callback For Modify Reference            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    CallbackModifyReferenceType              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyReferenceType( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalReferenceMType = (int)ClientData;

    GraalPromptModifyReference();
  }
 
/*------------------------------------------------------------\
|                                                             |
|                    CallbackModifyReferenceName              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyReferenceName( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalModifyReferenceNameDialog );
  }
 
/*------------------------------------------------------------\
|                                                             |
|                  CallbackModifyReferenceApply               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyReferenceApply( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalModifyLock   = GRAAL_FALSE;
    GraalModifyAbort  = GRAAL_FALSE;
    GraalModifyApply  = GRAAL_TRUE;

    GraalExitDialog();
  }
 
/*------------------------------------------------------------\
|                                                             |
|                  CallbackModifyReferenceCancel              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyReferenceCancel( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalModifyLock   = GRAAL_FALSE;
    GraalModifyAbort  = GRAAL_TRUE;
    GraalModifyApply  = GRAAL_FALSE;

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                    Callback For Modify Instance             |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                     CallbackModifyInstanceSym               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyInstanceSym( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalInstanceMSym = (int)ClientData;

    GraalPromptModifyInstance();
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackModifyInstanceName               |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyInstanceName( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalModifyInstanceNameDialog );
  }

/*------------------------------------------------------------\
|                                                             |
|                    CallbackModifyInstanceModel              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyInstanceModel( MyWidget, ClientData, CallData )

       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalEnterDialog( &GraalModifyInstanceModelDialog );
  }
 
/*------------------------------------------------------------\
|                                                             |
|                  CallbackModifyInstanceApply                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyInstanceApply( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalModifyLock   = GRAAL_FALSE;
    GraalModifyAbort  = GRAAL_FALSE;
    GraalModifyApply  = GRAAL_TRUE;

    GraalExitDialog();
  }
 
/*------------------------------------------------------------\
|                                                             |
|                   CallbackModifyInstanceCancel              |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyInstanceCancel( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalModifyLock   = GRAAL_FALSE;
    GraalModifyAbort  = GRAAL_TRUE;
    GraalModifyApply  = GRAAL_FALSE;

    GraalExitDialog();
  }

/*------------------------------------------------------------\
|                                                             |
|                    Callback For Modify Via                  |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      CallbackModifyViaType                  |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyViaType( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalViaMType = (int)ClientData;

    GraalPromptModifyVia();
  }
 
/*------------------------------------------------------------\
|                                                             |
|                      CallbackModifyViaApply                 |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyViaApply( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalModifyLock   = GRAAL_FALSE;
    GraalModifyAbort  = GRAAL_FALSE;
    GraalModifyApply  = GRAAL_TRUE;

    GraalExitDialog();
  }
 
/*------------------------------------------------------------\
|                                                             |
|                      CallbackModifyViaCancel                |
|                                                             |
\------------------------------------------------------------*/

  void CallbackModifyViaCancel( MyWidget, ClientData, CallData )
 
       Widget  MyWidget;
       caddr_t ClientData;
       caddr_t CallData;
  {
    GraalModifyLock   = GRAAL_FALSE;
    GraalModifyAbort  = GRAAL_TRUE;
    GraalModifyApply  = GRAAL_FALSE;

    GraalExitDialog();
  }
