/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Message.c                        |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/PushBG.h>
# include <Xm/CascadeBG.h>
 

# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GMX_H
# include GTB_H
# include GSB_H
# include GMC_H
# include "GMC_message.h"
# include "GMC_create.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  static char MessageBuffer[ 512 ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    GraalPromptCreateSegment                 |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptCreateSegment()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Create Segment" );

    if ( GraalSegmentName == (char *)NULL )
    {
      sprintf( MessageBuffer, "Layer: %s   Width: %2d   Name: none",
               GRAAL_SEGMENT_NAME_TABLE[ GraalSegmentLayer ][0] ,
               GraalSegmentWidth );
    }
    else
    {
      sprintf( MessageBuffer, "Layer: %s   Width: %2d   Name: %s",
               GRAAL_SEGMENT_NAME_TABLE[ GraalSegmentLayer ][0] ,
               GraalSegmentWidth, GraalSegmentName );
    }

    GraalDisplayMessage( GRAAL_MESSAGE_INFO, MessageBuffer );

    switch ( GraalCountEventEdit )
    {
      case 0 : 

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first point" );

      break;

      case 1 :

        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter second point" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    GraalPromptCreateConnector               |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptCreateConnector()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Create Connector" );

    sprintf( MessageBuffer, "Layer: %s   Width: %2d   Orient: %s",
             GRAAL_CONNECTOR_NAME_TABLE[ GraalConnectorLayer ][0],
             GraalConnectorWidth, 
             GRAAL_ORIENT_NAME_TABLE[ GraalConnectorOrient ][0] );

    GraalDisplayMessage( GRAAL_MESSAGE_INFO, MessageBuffer );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter center point" );
  }

/*------------------------------------------------------------\
|                                                             |
|                    GraalPromptCreateReference               |
|                                                             |
\------------------------------------------------------------*/

  void GraalPromptCreateReference()

  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Create Reference" );

    sprintf( MessageBuffer, "Type: %s",
             GRAAL_REFERENCE_NAME_TABLE[GraalReferenceType][0] );

    GraalDisplayMessage( GRAAL_MESSAGE_INFO, MessageBuffer );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter center point" );
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalPromptCreateVia                   |
|                                                             |
\------------------------------------------------------------*/
 
  void GraalPromptCreateVia()
 
  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Create Via" );
 
    sprintf( MessageBuffer, "Type: %s",
             GRAAL_VIA_NAME_TABLE[ GraalViaType ][0] );
 
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, MessageBuffer );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter center point" );
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalPromptCreateTransistor            |
|                                                             |
\------------------------------------------------------------*/
 
  void GraalPromptCreateTransistor()
 
  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Create Transistor" );
 
    sprintf( MessageBuffer, "Type: %s   Length: %2d",
             GRAAL_SEGMENT_NAME_TABLE[ GraalTransistorType ][0],
             GraalTransistorLength );
 
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, MessageBuffer );
 
    switch ( GraalCountEventEdit )
    {
      case 0 :
 
        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first point" );
 
      break;

      case 1 :
 
        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter second point" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    GraalPromptCreateAbutmentBox             |
|                                                             |
\------------------------------------------------------------*/
 
  void GraalPromptCreateAbutmentBox()
 
  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Create Abutmentbox" );
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, "Select window" );
 
    switch ( GraalCountEventEdit )
    {
      case 0 :
 
        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter first corner" );
 
      break;

      case 1 :
 
        GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter second corner" );
    } 
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalPromptCreateInstance              |
|                                                             |
\------------------------------------------------------------*/
 
  void GraalPromptCreateInstance()
 
  {
    GraalDisplayMessage( GRAAL_MESSAGE_MODE, "Create Instance" );
 
    sprintf( MessageBuffer, "Symmetry: %s",
             GRAAL_SYMMETRY_NAME_TABLE[ GraalInstanceSym ][0]  );
 
    GraalDisplayMessage( GRAAL_MESSAGE_INFO, MessageBuffer );
    GraalDisplayMessage( GRAAL_MESSAGE_PROMPT, "Enter base point" );
  }
