#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

/* Color Map Size */
#define CMAPSIZE              0x23

/* one graphic context per manipulated object */
/* order due to the 'real' layout */
#define GC_BLKN               0x00
#define GC_BLKP               0x01
#define GC_NTIE               0x02
#define GC_PTIE               0x03
#define GC_DIFN               0x04
#define GC_DIFP               0x05
#define GC_GATE               0x06
#define GC_POLY               0x07
#define GC_TPOLY              0x08
#define GC_ALU1               0x09
#define GC_TALU1              0x0A
#define GC_CONT_POLY          0x0B
#define GC_CONT_DIFN          0x0C
#define GC_CONT_DIFP          0x0D
#define GC_CONT_BODY_N        0x0E
#define GC_CONT_BODY_P        0x0F
#define GC_ALU2               0x10
#define GC_TALU2              0x11
#define GC_CONT_VIA           0x12
#define GC_ALU3               0x13
#define GC_TALU3              0x14
#define GC_CONT_VIA2          0x15

/* virtual objects */
#define GC_REF                0x16
#define GC_INSTANCE           0x17
#define GC_DEFAULT            0x18

/* text in the view window, must be clipped */
#define GC_FGND               0x19

/* one color per object */
#define COLOR_BLKN            0x00
#define COLOR_BLKP            0x01
#define COLOR_NTIE            0x02
#define COLOR_PTIE            0x03
#define COLOR_DIFN            0x04
#define COLOR_DIFP            0x05
#define COLOR_GATE            0x06
#define COLOR_POLY            0x07
#define COLOR_TPOLY           0x08
#define COLOR_ALU1            0x09
#define COLOR_TALU1           0x0A
#define COLOR_CONT_POLY       0x0B
#define COLOR_CONT_DIFN       0x0C
#define COLOR_CONT_DIFP       0x0D
#define COLOR_CONT_BODY_N     0x0E
#define COLOR_CONT_BODY_P     0x0F
#define COLOR_ALU2            0x10
#define COLOR_TALU2           0x11
#define COLOR_CONT_VIA        0x12
#define COLOR_ALU3            0x13
#define COLOR_TALU3           0x14
#define COLOR_CONT_VIA2       0x15

#define COLOR_REF             0x16
#define COLOR_INSTANCE        0x17
#define COLOR_DEFAULT         0x18
#define COLOR_FGND            0x19
#define COLOR_BGND            0x1A

#define COLOR_M_BGND          0x1B
#define COLOR_ICON            0x1C
#define COLOR_ICON_TEXT       0x1D
#define COLOR_ICON_INV        0x1E
#define COLOR_ICON_TEXT_INV   0x1F
#define COLOR_TEXT        	   0x20

#define COLOR_BUTTON1         0x21
#define COLOR_BUTTON2         0x22

/* fill style */
#define FILL                  0
#define PATTERN               1
#define OUTLINE               2

/* window behaviour codes */
#define NO_WINDOW_ACTION      0x00
#define OPEN_WINDOW_INSPECT   0x01
#define OPEN_WINDOW_SETUP     0x02
#define OPEN_WINDOW_MESSAGE   0x03
#define CLOSE_GENVIEW         0x04
#define CLOSE_WINDOW          0x05

/* what's to be done on a CLOSE_WINDOW action, in order to postpone an action */
#define NO_REFRESH            0x00
#define REFRESH_ALL           0x10
#define REFRESH_AREA          0x20

/* mask value used to test retuned values that are ored */
#define REFRESH_MASK          0xF0
#define WINDOW_MASK           0x0F

/* icon state */
#define OFF                   0
#define ON                    1
 
/* functions type */
extern void V_getColors();
extern void V_setGc();
extern void V_getFonts();
extern void V_drawZoomBox();
extern void V_drawFactIcon();
extern void V_coverIcon();
extern void V_setClip();
extern void V_refresh();
extern void V_drawBox();
extern void V_drawString();
extern void V_fitscreen();
extern void V_pan();
extern void V_drawCoords();
extern void V_drawRelCoords();
extern void V_setMenu();
extern void V_drawMenu();
extern void V_iconOn() ;
extern void V_iconOff() ;
extern int V_scrollH();
extern int V_scrollV();
extern int V_scrollRL();
extern int V_scrollLR() ;
extern int V_scrollLH();
extern int V_scrollHL();
extern int V_view_event();
extern int V_clickedIcon();
extern void V_drawPointer();
extern void put_str();
extern void I_setMenu();
extern void I_drawMenu();
extern void I_iconOn() ;
extern void I_iconOff() ;
extern void I_out();
extern void writeLine();
extern void i_pageUp();
extern void i_pageDn();
extern void i_lineUp();
extern void i_lineDn();
extern void clearscreen();
extern void I_open();
extern int I_event();
extern int I_clickedIcon();
extern void T_setMenu();
extern void T_drawMenu();
extern void T_iconOn() ;
extern void T_iconOff() ;
extern void T_out();
extern void T_writeLine();
extern void T_pageUp();
extern void T_pageDn();
extern void T_lineUp();
extern void T_lineDn();
extern void T_clearscreen();
extern void T_free();
extern int readLine();
extern int T_event();
extern int T_clickedIcon();
extern void C_InitGc();
extern void InitConf();
extern void E_setMenu();
extern void E_drawMenu();
extern void V_surround();
