#include "v_menu.h"
#include "v_view.h"
#include MUT_H
#include MPH_H
#include "mbk_extern.h"
#include "g_visu.h"
#include "g_extern.c"
#include "v_extern.h"
#include "i_lines.h"
#include "m_mes_id.h"

extern int V_lock; /* peek lock mode */
extern int C_atomicValue; /* atomic peek mode */

int V_scrollH(lambda)
long lambda;
{
int message;

	if (lambda > 0)
		message = V_scrollRL((long)(lambda));
	else if (lambda < 0)
		message = V_scrollLR((long)(-lambda));
	V_drawInsRef();
	V_drawAB();
	V_saveWindow();
	return message;
}

int V_scrollV(lambda)
long lambda;
{
int message;

	if (lambda > 0)
		message = V_scrollLH((long)(lambda));
	else if (lambda < 0)
		message = V_scrollHL((long)(-lambda));
	V_drawInsRef();
	V_drawAB();
	V_saveWindow();
	return message;
}

/* The following functions actually performs the scrolling */

/* horizontal scroll	right -> left */
int V_scrollRL(nPixels)
PIXEL nPixels;
{
GC gc;
LAMBDA nLambda;

	/* moving the area the way it should */
	if (!(nLambda = (long)(nPixels / scale)))
			return M_id = M_SCROLL;
	nPixels = nLambda * scale;
	gc = V_gcCao[GC_FGND];
	XCopyArea(display, V_window, V_window, gc, 0, YMENU,
			dxWin - nPixels, dyWin, nPixels, YMENU);
	/* clearing the leftover after moving */
	XSetForeground(display, gc, V_colors[COLOR_BGND]);
	XFillRectangle(display, V_window, gc, 0, YMENU, nPixels, dyWin);
	XFillRectangle(display, V_PixSave, gc, 0, YMENU, nPixels, dyWin);
	XSetForeground(display, gc, V_colors[COLOR_FGND]);

	scroll(WEST, nLambda);
	
	if (V_lock == 1)
		if (peek(xscreen - 4 , yscreen - 4, nLambda + 8, dyscreen + 8) == 1) {
			V_peek_it(OFF, 0, YMENU, nPixels, dyWin);
			unpeek();
		}
	if (!C_atomicValue || !V_lock)
		put_it(V_PixSave, xscreen - 4, yscreen - 4, nLambda + 8, dyscreen + 8);
	XCopyArea(display, V_PixSave, V_window, gc,
					0, YMENU, nPixels, dyWin, 0, YMENU);
	return M_NONE;
}

/* horizontal V_scroll left -> right */
int V_scrollLR(nPixels)
PIXEL nPixels;
{
GC gc;
LAMBDA nLambda;

	/* moving the area the way it should */
	if (!(nLambda =(long)(nPixels / scale)))
		return M_id = M_SCROLL;
	nPixels = nLambda * scale;
	gc = V_gcCao[GC_FGND];
	XCopyArea(display, V_window, V_window, gc, nPixels, YMENU,
			dxWin - nPixels, dyWin, 0, YMENU);
	XSetForeground(display, gc, V_colors[COLOR_BGND]);
	XFillRectangle(display, V_window, gc, dxWin - nPixels, YMENU,
			nPixels, dyWin);
	/* clearing part of the pixmap */
	XFillRectangle(display, V_PixSave, gc, dxWin - nPixels, YMENU,
			nPixels, dyWin);
	XSetForeground(display, gc, V_colors[COLOR_FGND]);

	scroll(EAST,(long)(nPixels / scale));
	if (V_lock == 1)
		if (peek(xscreen + dxscreen -(long)(nPixels / scale) - 4, yscreen - 4,
			(long)(nPixels / scale) + 8, dyscreen + 8) == 1) {
			V_peek_it(OFF, dxWin - nPixels - 2, YMENU, nPixels + 4, dyWin);
			unpeek();
		}
	if (!C_atomicValue || !V_lock)
		put_it(V_PixSave, xscreen + dxscreen -(long)(nPixels / scale) - 4,
					yscreen - 4,(long)(nPixels / scale)+8, dyscreen+8);
	XCopyArea(display, V_PixSave, V_window, gc, dxWin - nPixels, YMENU,
			nPixels, dyWin, dxWin - nPixels, YMENU);
	return M_NONE;
}

/* vertical V_scroll bottom to top */
int V_scrollLH(nPixels)
PIXEL nPixels;
{
GC gc;
LAMBDA nLambda;

	/* moving the area the way it should */
	if (!(nLambda =(long)(nPixels / scale)))
			return M_id = M_SCROLL;
	nPixels = nLambda * scale;
	gc = V_gcCao[GC_FGND];
	XCopyArea(display, V_window, V_window, gc, 0, nPixels + YMENU,
			dxWin, dyWin - nPixels, 0, YMENU);
	scroll(SOUTH,(long)(nPixels / scale));
	XSetForeground(display, gc, V_colors[COLOR_BGND]);
	XFillRectangle(display, V_window, gc, 0, dyWin + YMENU - nPixels,
			dxWin, nPixels);
	/* clearing part of the pixmap */
	XFillRectangle(display, V_PixSave, gc, 0, dyWin + YMENU - nPixels,
			dxWin, nPixels);
	XSetForeground(display, gc, V_colors[COLOR_FGND]);
	if (V_lock == 1)
		if (peek(xscreen - 4, yscreen - 4, dxscreen + 8,
				(long)(nPixels / scale) +8) == 1) {
			V_peek_it(OFF, 0, dyWin + YMENU - nPixels - 2, dxWin, nPixels + 4);
			unpeek();
		}
	if (!C_atomicValue || !V_lock)
		put_it(V_PixSave, xscreen - 4, yscreen - 4, dxscreen + 8,
					(long)(nPixels / scale) + 8);
	XCopyArea(display, V_PixSave, V_window, gc, 0, dyWin + YMENU - nPixels,
					dxWin, nPixels + 1, 0, dyWin + YMENU - nPixels);
	return M_NONE;
}

/* vertical V_scroll top to bottom */
int V_scrollHL(nPixels)
PIXEL nPixels;
{
GC gc;
LAMBDA nLambda;

	/* moving the area the way it should */
	if (!(nLambda =(long)(nPixels / scale)))
		return M_id = M_SCROLL;
	nPixels = nLambda * scale;
	gc = V_gcCao[GC_FGND];
	XCopyArea(display, V_window, V_window, gc, 0, YMENU,
			dxWin, dyWin - nPixels, 0, nPixels + YMENU);
	scroll(NORTH,(long)(nPixels / scale));
	XSetForeground(display, gc, V_colors[COLOR_BGND]);
	XFillRectangle(display, V_window, gc, 0, YMENU,
			dxWin, nPixels);
	/* clearing part of the pixmap */
	XFillRectangle(display, V_PixSave, gc, 0, YMENU,
			dxWin, nPixels);
	XSetForeground(display, gc, V_colors[COLOR_FGND]);
	if (V_lock == 1)
		if (peek(xscreen - 4, yscreen + dyscreen - (long)(nPixels / scale) - 4,
			dxscreen + 8,(long)(nPixels / scale) + 8) == 1) {
			V_peek_it(OFF, 0, YMENU, dxWin, nPixels);
			unpeek();
		}
	if (!C_atomicValue || !V_lock)
		put_it(V_PixSave, xscreen - 4,
					yscreen + dyscreen - (long)(nPixels / scale) - 4,
					dxscreen + 8,(long)(nPixels / scale) + 8);
	XCopyArea(display, V_PixSave, V_window, gc, 0, YMENU, dxWin, nPixels,
					0, YMENU);
	return M_NONE;
}
