#include "g_visu.h"
#include "v_view.h"
#include "m_menu.h"
#include "m_mes_id.h"
#include "v_menu.h"
#include "v_extern.h"
#include "logomasi.h"

static YRectangle *M_icon_pos;
LAMBDA xmap, ymap;
float s1, s2;
int xvmap, yvmap, dyvmap;
static int oldx, oldy;
extern LAMBDA dxvisu, dyvisu;
extern LAMBDA xvisu, yvisu;
extern int firstMove;

static Pixmap icon;
static char *M_menu[] = {
		"OK",
		"OK",
		"CANCEL"
};

void
	M_setMenu()
{
static int first;

	if (first == 0) {
		M_icon_pos = (YRectangle *)mbkalloc(3 * sizeof(YRectangle));
		icon = XCreatePixmapFromBitmapData(display, M_window, logomasi,
														LOGO_DX, LOGO_DY,
														V_colors[COLOR_POLY],
														V_colors[COLOR_M_BGND], 8);
		first ++;
	}
	M_icon_pos[M_OK].x = M_OK_X;
	M_icon_pos[M_OK].y = M_OK_Y;
	M_icon_pos[M_OK].width = M_OK_DX;
	M_icon_pos[M_OK].height = M_OK_DY;
	M_icon_pos[M_OK].t = M_OK_T;

	M_icon_pos[M_OK_OP].x = M_OK_OP_X;
	M_icon_pos[M_OK_OP].y = M_OK_OP_Y;
	M_icon_pos[M_OK_OP].width = M_OK_OP_DX;
	M_icon_pos[M_OK_OP].height = M_OK_OP_DY;
	M_icon_pos[M_OK_OP].t = M_OK_OP_T;

	M_icon_pos[M_CANCEL].x = M_CANCEL_X;
	M_icon_pos[M_CANCEL].y = M_CANCEL_Y;
	M_icon_pos[M_CANCEL].width = M_CANCEL_DX;
	M_icon_pos[M_CANCEL].height = M_CANCEL_DY;
	M_icon_pos[M_CANCEL].t = M_CANCEL_T;
}

void
	M_drawMenu()
{
void M_drawIcon();
void M_moveCurs();
register int i;
Window w;
int forget_me;
unsigned int dx, dy, mdy;

	XGetGeometry(display, M_window, &w, &forget_me, &forget_me,
			&dx, &dy, &forget_me, &forget_me);
	XFillRectangle(display, M_window, C_gcBgnd, 0, 0, dx, dy);
	/* centering the menu each time it appears */
	switch (M_id) {
		case M_LOAD:
		case M_SAVE:
		case M_SHELL:
		case M_ELOAD:
		case M_PARAM:
		case M_TRACE:
		case M_UNTRACE:
		case M_EXIT:
			dy = (int)((dx/2) - (M_CANCEL_X + M_CANCEL_DX - M_OK_OP_X)/2);
			for (i = M_OK_OP; i <= M_CANCEL; i++) {
				M_icon_pos[i].t += M_icon_pos[i].x += dy;
				M_drawIcon(i, OFF);
			}
			break;

		case M_GENVIEW :
			dy = (int)((dx / 2) - (LOGO_DX / 2));
			XCopyArea(display, icon, M_window, C_gcIconText, 0, 0,
							LOGO_DX, LOGO_DY, dy, M_OK_Y + M_OK_DY);
		case M_LOOM :
		case M_ZOOM :
		case M_SCROLL :
		case M_NO_UNTRACE :
			dy = (int)((dx/2) - (M_OK_X + M_OK_DX)/2);
			M_icon_pos[M_OK].t += M_icon_pos[M_OK].x += dy;
			M_drawIcon(M_OK, OFF);
			break;

		case M_MAP :
			mdy = (int)((dx/2) - (M_OK_X + M_OK_DX)/2);
			M_icon_pos[M_OK].t += M_icon_pos[M_OK].x += mdy;
			M_drawIcon(M_OK, OFF);
			XFillRectangle(display, M_window, C_gcText, 0, 
								(int)(M_icon_pos[M_OK].y 
								+ M_icon_pos[M_OK].height + 38), 
								dx, dy);
			if ((dxvisu == 0) || (dyvisu == 0)) break;
			s1 = (float)((float)(dx - 4) / (float)dxvisu);
			s2 = (float)((float)(dy	- M_icon_pos[M_OK].y - 
						M_icon_pos[M_OK].height - 50) / (float)dyvisu);
			if (s1 > s2) s1 = s2;
			xvmap = (int)(dx - dxvisu * s1)/2;
			yvmap = (int)((dy - dyvisu * s1) + M_icon_pos[M_OK].y + 
							 	M_icon_pos[M_OK].height + 42)/2;
			XDrawRectangle(display, M_window, V_gcCao[GC_INSTANCE], xvmap, yvmap,
								(unsigned int)(dxvisu * s1),
								(unsigned int)(dyvisu * s1));
			dyvmap = (int)((dyvisu * s1));
			firstMove = 0;
			M_moveCurs();
			break;

		default :
			break;
	}
}


void
	M_moveView(x, y)
int x, y;
{
	if (y < yvmap || dxvisu == 0 || dyvisu == 0)
		return;
	XSetFunction(display, C_gcIconInv, GXxor);
	if (firstMove != 0)
		XFillRectangle(display, M_window, C_gcIconInv, oldx, oldy, 
							(unsigned int)(4), (unsigned int)(4));
	oldx = x; oldy = y;
	XFillRectangle(display, M_window, C_gcIconInv, x, y,
						(unsigned int)(4), (unsigned int)(4));
	XSetFunction(display, C_gcIconInv, GXcopy);
	xy_move((int)(((x - xvmap) / (2 * s1)) + (xvisu / 2)) * 2,
				(int)(((yvmap + dyvmap - y) / (2 * s1)) + (yvisu / 2)) * 2);
	V_refresh();
	firstMove = 1;
}

void
	M_moveCurs()
{
extern LAMBDA xscreen, yscreen, dxscreen, dyscreen;
int tmpx, tmpy;

	if (M_window == 0)
		return;
	tmpx = (xscreen + dxscreen/2 - xvisu) * s1 + xvmap;
	tmpy = yvmap + dyvmap - (yscreen + dyscreen/2 - yvisu) * s1;
	XSetFunction(display, C_gcIconInv, GXxor);
	if (firstMove != 0)
		XFillRectangle(display, M_window, C_gcIconInv, oldx, oldy, 
							(unsigned int)(4), (unsigned int)(4));
	XFillRectangle(display, M_window, C_gcIconInv, oldx = tmpx, oldy = tmpy,
						(unsigned int)(4), (unsigned int)(4));
	XSetFunction(display, C_gcIconInv, GXcopy);
	firstMove = 1;
}

void
	M_drawIcon(icon, state)
int icon, state;
{
	XFillRectangle(display, M_window, C_gcIcon, (int)M_icon_pos[icon].x,
			(int)M_icon_pos[icon].y, (unsigned int)(M_icon_pos[icon].width + 1),
			(unsigned int)(M_icon_pos[icon].height + 1));
	V_surround(M_window,  M_icon_pos[icon].x, M_icon_pos[icon].y,
					M_icon_pos[icon].width, M_icon_pos[icon].height, state);
	XDrawImageString(display, M_window, C_gcIconText, 
							(int)(M_icon_pos[icon].t - state),
							(int)(M_icon_pos[icon].y + 12 - state),
							M_menu[icon], strlen (M_menu[icon]));
}

int
	M_clickedIcon (xClick, yClick)
int xClick, yClick;
{
register int i;

	switch (M_id) {
		case M_LOAD :
		case M_ELOAD :
		case M_SAVE :
		case M_PARAM :
		case M_TRACE :
		case M_UNTRACE :
		case M_SHELL :
		case M_EXIT :

			for (i = M_OK_OP; i <= M_CANCEL; i++)
				if (((xClick > M_icon_pos[i].x) &&
					 (xClick < M_icon_pos[i].x + M_icon_pos[i].width)) &&
					 ((yClick > M_icon_pos[i].y) &&
					 (yClick < M_icon_pos[i].y + M_icon_pos[i].height)))
					return i;
			break;

		case M_GENVIEW :
		case M_LOOM :
		case M_ZOOM :
		case M_SCROLL :
		case M_MAP :
		case M_NO_UNTRACE :
			if (((xClick > M_icon_pos[M_OK].x) &&
				 (xClick < M_icon_pos[M_OK].x + M_icon_pos[M_OK].width)) &&
				 ((yClick > M_icon_pos[M_OK].y) &&
				 (yClick < M_icon_pos[M_OK].y + M_icon_pos[M_OK].height)))
				return M_OK;
			break;
		
		default :
			break;
	}
	return INSCREEN;
}
