#include <stdio.h>
#include MUT_H
#include MPH_H
#include "mbk_extern.h"
#include "g_visu.h"
#include "g_extern.c"
#include "v_menu.h"
#include "v_view.h"
#include "v_extern.h"

#define CH 10
#define CW 6
#define STRLEN(a) (a == NULL ? 0 : strlen(a))

void string_coord (pt, x, y)
X_RECT *pt;
LAMBDA *x, *y;
{
char orient;

	switch (pt->TYPE & MASK) {
		case INSCON:
			orient = ((phcon_list *)pt->PTMBK)->ORIENT;
			switch ((pt->TYPE >> 3) & 0x07) {
				case SYM_X:
					if (orient == EAST)
						orient = WEST;
					else if (orient == WEST)
						orient = EAST;
					break;
				case SYM_Y:
					if (orient == NORTH)
						orient = SOUTH;
					else if (orient == SOUTH)
						orient = NORTH;
					break;
				case SYMXY:
					switch (orient) {
						case EAST:
							orient = WEST;
							break;
						case WEST:
							orient = EAST;
							break;
						case NORTH:
							orient = SOUTH;
							break;
						case SOUTH:
							orient = NORTH;
					}
				default: /* NOSYM and not managed symetries */
					break;
			}
			switch (orient) {
				case WEST:
					*x = pt->X + pt->DX;
					*y = pt->Y - pt->DY / 2;
					break;
				case EAST:
					*x = pt->X
						- ((3 + (STRLEN(((phcon_list *)pt->PTMBK)->NAME))) * CW)
						/ scale;
					*y = pt->Y - pt->DY / 2;
					break;
				case SOUTH:
					*x = pt->X;
					*y = pt->Y + CH / scale;
					break;
				case NORTH:
					*x = pt->X;
					*y = pt->Y - pt->DY - 2 * CH / scale;
					break;
			}
			break;
		case FIGCON:
			switch (((phcon_list *)pt->PTMBK)->ORIENT) {
				case EAST:
					*x = pt->X + pt->DX;
					*y = pt->Y - pt->DY / 2;
					break;
				case WEST:
					*x = pt->X
						- ((3 + (STRLEN(((phcon_list *)pt->PTMBK)->NAME))) * CW)
						/ scale;
					*y = pt->Y - pt->DY / 2;
					break;
				case NORTH:
					*x = pt->X;
					*y = pt->Y + CH / scale;
					break;
				case SOUTH:
					*x = pt->X;
					*y = pt->Y - pt->DY - 2 * CH / scale;
					break;
			}
			break;
		case REF:
			*x = pt->X + pt->DX / 2
					- (STRLEN(((phref_list *)pt->PTMBK)->NAME) * CW)
					/ (2 * scale);
			*y = pt->Y - pt->DY / 2 + CH / (2 * scale);
			break;
		case SEG:
			*x = pt->X + pt->DX / 2
					- (STRLEN(((phseg_list *)pt->PTMBK)->NAME) * CW)
					/ (2 * scale);
			*y = pt->Y - pt->DY / 2 + CH / (2 * scale);
			break;
		case INS:
			*x = pt->X + pt->DX / 2
					- (STRLEN(((phins_list *)pt->PTMBK)->INSNAME) * CW)
					/ (2 * scale);
			*y = pt->Y - pt->DY / 2 - CH / (2 * scale); /* well centered */
			break;
	}
}
