/***************************************************************/
/* module   : m_affect.c                                         */
/* date     : 28/07/92                                         */
/* auteurs  : RENAUD & VENOT & PITON                           */
/***************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <malloc.h>
#include <varargs.h>

#include PAT_H
#include PHL_H
#include "libpat_l.h"


/* ###--------------------------------------------------------------### */
/* function     : M_AFFECT                                              */
/* description  : set GNP_TAB_PAIOL_CREE to GNP_ACTIF if not done yet	*/ 
/*        create a PAEVT list according to value and connector  	*/
/*        Create or set the good PAPAT structure			*/
/* called func. : CheckPattern, pat_crtpaiol, Erreur, MajPatternCourant	*/
/*        SplitIdent, CheckIdent, TraiterChaine, CheckWidth, FindIdent  */
/*        FormatValue, ExisteIdent, CreatePaevt, CreatePapat		*/ 
/* ###--------------------------------------------------------------### */

void M_AFFECT (va_alist)
va_dcl
{
va_list  pa;
char    *param,*valeur;
char     field_ident [64];
char	 buffer	     [80];
char     tmp_valeur  [1024];
char     value       [1024];
int      dim = 0,num_ident,sens,i,j;
struct alpha_num decomp;
struct paevt *tmp_paevt = NULL;

    if (racine_paseq == NULL)
      Erreur ("AFFECT must declare output file's name first\n");

    va_start(pa);
    param = va_arg(pa, char *);
    if (param == NULL) 
        Erreur ("AFFECT needs any parameters\n");
    strcpy(buffer,param); 

    if ( GNP_TAB_PAIOL_CREE ==  GNP_INACTIF) 
    {
       racine_paiol = (struct paiol *) reverse (racine_paiol);
       racine_paiol = pat_crtpaiol(racine_paiol);
       GNP_TAB_PAIOL_CREE = GNP_ACTIF;
    }

    CheckPattern (buffer);
    MajPatternCourant(buffer);

    param = va_arg(pa, char *);
    if ( param == NULL) 
        Erreur ("AFFECT expected an ident\n");
    
    while (param != NULL) 
    {
       valeur = va_arg(pa, char *);
       if (valeur == NULL) 
           Erreur ("AFFECT expected a string value or 0\n");
       strcpy (tmp_valeur,valeur);
       
       strcpy (buffer,param);
       SplitIdent (buffer,field_ident);
       CheckIdent (buffer);
       if (strlen (field_ident) != 0) 
       {
          TraiterChaine (field_ident,&decomp );
          CheckWidth (&decomp);
          if (strlen (decomp.alpha) != 0) 
               Erreur ("AFFECT expected a group name or paiol name\n");
          if (strlen (decomp.gauche) != 0) 
             {
                strcat(buffer," ");
                strcat(buffer,decomp.gauche);
             }
       }
       num_ident = FindIdent (buffer,hash_paiol);
       if ( num_ident != -1) 
       {
         switch (
             ((struct paiol *)tab_ident[num_ident].pointeur)->MODE) 
         {
           case 'R': case 'S': case 'O': 
	   {
	     valeur = tmp_valeur;
	     if (tmp_valeur[0] == '?')
		valeur++;
             FormatValue (value,valeur,1,GNP_UP,1);
             break;
           }
	   case 'T':
	   {
	     valeur = tmp_valeur;
	     if (tmp_valeur[0] == '?')
	     {
		valeur++;
		FormatValue (value,valeur,1,GNP_UP,1);
	     }
	     else
		FormatValue (value,tmp_valeur,1,GNP_UP,0);
	     break;
	   }
           case 'I': 
           {
             FormatValue (value,tmp_valeur,1,GNP_UP,0);
             break;
           }
           default: 
               Erreur ("unconsistent internal structures\n");
         }
         tmp_paevt = CreatePaevt (tmp_paevt,num_ident,value[0]);
       }
       else 
       {
         num_ident = FindIdent (buffer,hash_pagrp);
         if  ( num_ident == -1) 
             Erreur ("AFFECT not yet declared identifier\n");
         else 
         {
           sens = ExisteIdent(buffer,hash_pagrp)-> sens;
           dim = ((struct pagrp *)tab_ident[num_ident].pointeur)->LENGTH;
           switch (
               ((struct paiol *)tab_ident[num_ident -1].pointeur)->MODE) 
           {
             case 'R': case 'S': case 'O': 
	     {
	       valeur = tmp_valeur;
	       if (tmp_valeur[0] == '?')
		valeur++;
               FormatValue (value,valeur,dim,sens,1);
               break;
             }
	     case 'T':
	     {
	       valeur = tmp_valeur;
	       if (tmp_valeur[0] == '?')
	       {
		   valeur++;
		   FormatValue (value,valeur,dim,sens,1);
	       }
	       else
		   FormatValue (value,tmp_valeur,dim,sens,0);
	       break;
	     }
             case 'I': 
             {
               FormatValue (value,tmp_valeur,dim,sens,0);
               break;
             }
             default: 
                 Erreur ("unconsistent internal structures\n");
           }
           for (j =0, i = dim; i > 0; i--, j++ )  
              tmp_paevt = CreatePaevt (tmp_paevt,num_ident -i,value[j]);
         }
       }
       param = va_arg(pa, char *);
    }
    va_end (pa);
    CreatePapat (NULL,tmp_paevt,NULL);
}
