/*******************************************************************************
* data structure for router calls in genlib custom approach                    *
*******************************************************************************/
typedef struct genChannel {       /* channel for genlib               */
	struct genChannel  *NEXT;      /* next channel                     */
	char               *NAME;      /* channel name                     */
	struct genNetlist  *NETS;      /* nets to be routed in the channel */
	struct genNetlist  *SUPPLIES;  /* supplies to be splatshed         */
	long               COORDINATE; /* useful channel coordinate        */
	char               DIRECTION;  /* channel direction                */
} channel_list;

typedef struct genNetlist {       /* list of net for a channel        */
	struct genNetlist  *NEXT;      /* next net                         */
	char               *NAME;      /* net name                         */
	struct genPoints   *POINTS;    /* list of points to be routed      */
} bnet_list;

typedef struct genPoints {        /* routing physical endpoint        */
	struct genPoints   *NEXT;      /* next point                       */
	char               *NAME;      /* resulting connector name         */
	long               X, Y;       /* physical connector coordinates   */
	char               FACE;       /* face of the connector on channel */
	phcon_list         *MBK;       /* pointer to the mbk connector     */
	ConnectorList      *SCR;       /* symbolic grided connector        */
} pt_list;


#define MAX(a,b) ((a)>(b) ? (a) : (b))
#define MIN(a,b) ((a)>(b) ? (b) : (a))
#define FLOPCOORD (long)0xFced


extern channel_list *CHANNELS;
extern char buffer[];

extern channel_list *addchannel();
extern bnet_list *addnet();
extern pt_list *addpoint();
extern char *genNAME();
extern void scrtopitched();
extern void scrtombk();
extern char modelface();
extern char *getname();
extern ptype_list *sort_ptype();
extern int tobedeleted();
extern int null();
extern void destroysegments();
extern channel_list *checkandbuild();

#define PITCH  5
#define AL_AL  4
#define GRID  -1
#define VER    0
#define HOR    1

extern void DEF_CHANNEL();
extern void DEF_CHANNEL_TOP();
extern void DEF_CHANNEL_BOTTOM();
extern void DEF_CHANNEL_LEFT();
extern void DEF_CHANNEL_RIGHT();
extern void NET_INSTANCE();
extern void NET_CHANNEL();
extern void ROUTE_CHANNEL();
extern void MAKE_BLOC();
extern void SUPPLY();
