/*      Alliance CAD System 2.0                                   */
/*        FITPATH Package 0.0                                     */
/*                                                                */
/*  Author  :      Jean-Paul CHAPUT                               */
/*  E-mail  :  cao-vlsi@masi.ibp.fr                               */
/* ************************************************************** */
/*  Header  :  "FpgenMBK.h"                                       */


#ifndef  _FpgenMBK_
#define  _FpgenMBK_

/* Definition of error constants of module. */
#define        E_FPGEN_DPINVMissName           2
#define        E_FPGEN_DPINVWidth              3
#define        E_FPGEN_DPINVDrive              4

#define        E_FPGEN_DEFLOWidthMax           5
#define        E_FPGEN_DEFLOWidthEven          6
#define        E_FPGEN_DEFLOLsbPos             7
#define        E_FPGEN_DEFLOCall               8
#define        E_FPGEN_DEFLOBadType            9

#define        E_FPGEN_SAVLOCall              10
#define        E_FPGEN_SAVLOMissVDD           11
#define        E_FPGEN_SAVLOMissVSS           12

#define        E_FPGEN_LOCONBadSide           13
#define        E_FPGEN_LOCONPOWERDuplicate    14
#define        E_FPGEN_LOCONPOWERBadNamePower 15

#define        E_FPGEN_COMMONMissDefLo        16
#define        E_FPGEN_COMMONBusName          17
#define        E_FPGEN_COMMONNumSig           18
#define        E_FPGEN_COMMONMissName         19
#define        E_FPGEN_COMMONWidth            20
#define        E_FPGEN_COMMONSlice            21
#define        E_FPGEN_COMMONDrive            22
#define        E_FPGEN_COMMONBadModelName     23
#define        E_FPGEN_HIDDCOMFuncId          24

#define        E_FPGEN_CONMODEUnknow          25
#define        E_FPGEN_MATCHINTERFNoMoreCon   26
#define        E_FPGEN_MATCHINTERFNoMoreSig   27

#define        E_FPGEN_RFGInvalidWords        28

#define        E_FPGEN_NAMETOSIGCtrlData      29
#define        E_FPGEN_NAMETOSIGCtrlCtrl      30


/* Definition of warning constants of module. */
#define        W_FPGEN_DEFLOMbkSepar           2
#define        W_FPGEN_DEFLOMbkInOutPH         3


/* Definition of normal constants of module. */
#define        C_FPGEN_FuncNameMaxLen          256

#define        C_FPGEN_RFGMinWords             2
#define        C_FPGEN_RFGMaxWords             256

#define        C_FPGEN_TypeSigCTRL             2
#define        C_FPGEN_TypeSigDATA             3

#define        C_FPGEN_RootNameBuff            0
#define        C_FPGEN_RootNameInv             1
#define        C_FPGEN_RootNameOr2             2
#define        C_FPGEN_RootNameNor2            3
#define        C_FPGEN_RootNameOr3             4
#define        C_FPGEN_RootNameNor3            5
#define        C_FPGEN_RootNameAnd2            6
#define        C_FPGEN_RootNameNand2           7
#define        C_FPGEN_RootNameAnd3            8
#define        C_FPGEN_RootNameNand3           9
#define        C_FPGEN_RootNameXor2            10
#define        C_FPGEN_RootNameXnor2           11
#define        C_FPGEN_RootNameNor2mask        12
#define        C_FPGEN_RootNameNand2mask       13
#define        C_FPGEN_RootNameXnor2mask       14
#define        C_FPGEN_RootNameNmux2cs         15
#define        C_FPGEN_RootNameMux2cs          16
#define        C_FPGEN_RootNameMux3cd          17
#define        C_FPGEN_RootNameNmux2fs         18
#define        C_FPGEN_RootNameMux2fs          19
#define        C_FPGEN_RootNameMux3fd          20
#define        C_FPGEN_RootNameBuse            21
#define        C_FPGEN_RootNameNbuse           22
#define        C_FPGEN_RootNameAdd2f           23
#define        C_FPGEN_RootNameAdsb2f          24
#define        C_FPGEN_RootNameShift           25
#define        C_FPGEN_RootNameConst           26
#define        C_FPGEN_RootNameNul             27
#define        C_FPGEN_RootNamePlatch1         28
#define        C_FPGEN_RootNameNplatch1        29
#define        C_FPGEN_RootNamePms             30
#define        C_FPGEN_RootNamePdff            31
#define        C_FPGEN_RootNamePdfft           32
#define        C_FPGEN_RootNameRfg1cc          33
#define        C_FPGEN_RootNameRfg2cc          34
#define        C_FPGEN_RootNameRfg1fc          35
#define        C_FPGEN_RootNameRfg2fc          36
#define        C_FPGEN_RootNameRfg1c0          37
#define        C_FPGEN_RootNameRfg2c0          38
#define        C_FPGEN_RootNameRfg1f0          39
#define        C_FPGEN_RootNameRfg2f0          40
#define        C_FPGEN_RootNameNB              41


/* Declaration of interface functions of module. */
#ifndef  ANSI_PROTO
extern void  DmlMBK_ErrorFpgen();
extern void  DmlMBK_WarngFpgen();

extern void  DmlMBK_DefLoFig();
extern void  DmlMBK_SavLoFig();
extern long  DmlMBK_LoConPower();
extern void  DmlMBK_LoCon();
extern void  DmlMBK_Import();
extern void  DmlMBK_Flatten();
extern void  DmlMBK_GenericBool();
extern void  DmlMBK_GenericMask();
extern void  DmlMBK_GenericMux();
extern void  DmlMBK_GenericBuse();
extern void  DmlMBK_GenericAddf();
extern void  DmlMBK_GenericShift();
extern void  DmlMBK_GenericComp();
extern void  DmlMBK_GenericDff();
extern void  DmlMBK_GenericRfg();
#else
extern void  DmlMBK_ErrorFpgen(void);
extern void  DmlMBK_WarngFpgen(void);

extern void  DmlMBK_DefLoFig(void);
extern void  DmlMBK_SavLoFig(void);
extern long  DmlMBK_LoConPower(char *aConName);
extern void  DmlMBK_LoCon(     char *aConName,
						       char  aConSide);
/* extern void  DmlMBK_Import(va_list) va_dcl */
extern void  DmlMBK_Flatten(void);
extern void  DmlMBK_GenericBool(  long  aFuncId, va_alist  aStdArgs);
extern void  DmlMBK_GenericMask(  long  aFuncId, va_alist  aStdArgs);
extern void  DmlMBK_GenericMux(   long  aFuncId, va_alist  aStdArgs);
extern void  DmlMBK_GenericBuse(  long  aFuncId, va_alist  aStdArgs);
extern void  DmlMBK_GenericAddf(  long  aFuncId, va_alist  aStdArgs);
extern void  DmlMBK_GenericShift( long  aFuncId, va_alist  aStdArgs);
extern void  DmlMBK_GenericConst( long  aFuncId, va_alist  aStdArgs);
extern void  DmlMBK_GenericComp(  long  aFuncId, va_alist  aStdArgs);
extern void  DmlMBK_GenericDff(   long  aFuncId, va_alist  aStdArgs);
extern void  DmlMBK_GenericRfg(   long  aFuncId, va_alist  aStdArgs);
#endif


/* Declaration of external variables of module. */


/* Declarations of external structures of module.   */
/* Structure keeping together all global variables. */
typedef struct {
	losig_list *SigVss;    /* Implicite signal "Vss".             */
	losig_list *SigVdd;    /* Implicite signal "Vdd".             */
	locon_list *ConVss;    /* Implicite terminal "Vss".           */
	locon_list *ConVdd;    /* Implicite terminal "Vdd".           */
	      long  ConMode;   /* Management mode of CTRL terminals.  */
		  long  Msb0;      /* Index associated to MSB.            */
	      long  TypeDP;    /* Data-Path type (BLOCK or TERMINAL). */
		  char *CurrFunc;  /* Name of current function.           */
	lofig_list *CurrLofig; /* Current data-path logical figure.   */
	      long  CallDefLo; /* Numbers of calls to "DP_DEFLOFIG".  */
	      long  CallSavLo; /* Numbers of calls to "DP_SAVLOFIG".  */
	} FpgenVGlob_t;

extern FpgenVGlob_t  fpgen_Glob;

#endif
