#include  <stdio.h>

#include  <genlib.h>

#include  "support.h"
#include  "dplimits.h"
#include  "add2.h"

/*      Alliance CAD System 2.0                                   */
/*        FITPATH Package 0.0                                     */
/*                                                                */
/*  Author  :      Jean-Paul CHAPUT                               */
/*  E-mail  :  cao-vlsi@masi.ibp.fr                               */
/* ************************************************************** */
/*  module  :      "add2.c"                                       */


/* Module internal constants. */

/* Names of additional leaf cells. */
static char *TabLeafCellAdd2[6] = {   "bcsa_fp",
								      "csa0_fp",
									 "csai_fp",
									"csap_fp",
                                   "csai0_fp",
                                  "csap0_fp"
                                   };


/* Interface function of module.
   extern       char *Dgn_DispachAdd2();
   */

/* Internal functions of module. */
static       void  Dgn_ErrorAdd2();
static       void  Dgn_VhdlAdd2();
static       void  Dgn_NetlistAdd2();


/*  Function  :  'Dgn_DispatchAdd2'                                */
/* -------------------------------------------------------------- */
/*  Interface of add2erter/buffer generator.                       */

extern char *Dgn_DispatchAdd2(add2_modelname,
							  add2_width    ,
							  add2_slice    ,
							  add2_msb0     ,
							  add2_vhdl     ,
							  add2_netlist  ,
							  add2_icon     )
	char *add2_modelname;  /* Model name.                    */
	long  add2_width;      /* Bus wide.                      */
	long  add2_slice;      /* give the LSB starting slice.   */
	long  add2_msb0;       /* Zero as MSB index.             */
	long  add2_vhdl;       /* Generation of behavioral view. */
	long  add2_netlist;    /* Generation of netlist view.    */
	long  add2_icon;       /* Generation of icon.            */
{
	static short  DispachAdd2_FirstCall = FALSE;
	static  char  ModelName[C_SUPP_MBKSZNAME];

	/* The first time the generator is call : */
	/*     - Load specific errors.            */
	if (!DispachAdd2_FirstCall)
	{
		Dgn_ErrorAdd2();
		DispachAdd2_FirstCall = TRUE;
	}

	/* Check if, at least, one view is asked. */
	if (   (add2_netlist == FALSE)
		 &&(add2_vhdl    == FALSE)
		 &&(add2_icon    == FALSE) )
		Dut_PrintError( E_ADD2_ERROR, E_ADD2_NOVIEW);

	/* Check the bus wide. */
	if ((add2_width < 0) || (add2_width > C_DPLIMITS_MAXSLICE))
		Dut_PrintError( E_ADD2_ERROR, E_ADD2_WIDTH, add2_width);

	/* Check the LSB starting slice. */
	if ((add2_slice < 0) || ( add2_slice
							+add2_width > DP_WIDTH))
		Dut_PrintError( E_ADD2_ERROR, E_ADD2_SLICE, add2_slice);

	/* Check the model name. */
	if (add2_modelname == (char*)NULL)
#ifndef  CRUNCH_FILENAME
		/* Build a more explicit model name. */
		(void*)sprintf( ModelName, "add2_%ldx%ldx%ld%c_cl",
					                   DP_WIDTH              ,
					                 add2_width              ,
					                 add2_slice              ,
					               ((add2_msb0 ) ? 'm' : 'l'));
#else
		/* Build the crunched model name. */
		strcpy( ModelName, Dut_MakeCrunchModelName(
									    "iv"       ,
									8L,  DP_WIDTH-1,
									8L, add2_width-1,
									8L, add2_slice  ,
									0L, add2_msb0   ));
#endif
	else
		strcpy( ModelName, add2_modelname);

	/* Generation of behaviorial view. */
	if (add2_vhdl)
		Dgn_VhdlAdd2( ModelName,
			   	   	 add2_width,
			   		 add2_slice,
			   		 add2_msb0 );

	/* Generation of netlist view. */
	if (add2_netlist)
		Dgn_NetlistAdd2( ModelName,
						add2_width,
						add2_slice,
						add2_msb0 );

	/* Generation of icone. */
	/* if (add2_icon) */
	
	/* Return name of the generated model. */
	return((add2_modelname == (char*)NULL) ?     ModelName 
		                                  : add2_modelname);
}


/*  Function  :  'Dgn_ErrorAdd2'                                   */
/* -------------------------------------------------------------- */
/*  Adds generator specific errors to the main errors data base.  */

static void  Dgn_ErrorAdd2()
{
	Dut_AddError( E_ADD2_ERROR, E_ADD2_WIDTH,
				  "add2alid bus width : %ld.");
	Dut_AddError( E_ADD2_ERROR, E_ADD2_MODELNAME,
				  "Missing model name.");
	Dut_AddError( E_ADD2_ERROR, E_ADD2_NOVIEW,
				  "No view to generate.");
	Dut_AddError( E_ADD2_ERROR, E_ADD2_OPENVBE,
				  "Unable to create file : \"%s\".");
}


/*  Function  :  'Dgn_NetListAdd2'                                 */
/* -------------------------------------------------------------- */
/*  Generation of adder behvioral view.                 */

static void  Dgn_VhdlAdd2(add2_modelname,
					      add2_width    ,
					      add2_slice    ,
						  add2_msb0     )
	char *add2_modelname;  /* Nom du modele.           */
	long  add2_width;      /* Largeur du bus.          */
	long  add2_slice;      /* LSB starting slice.      */
	long  add2_msb0;       /* Zero comme index du MSB. */
{
	FILE *Add2File;
	long  BitIndex,     LenString,      TmpTime;
	char  BusWide[256], BusWide0[256], BusWide1[256], TmpString[256];

	/* *** Creating the file holding behavioral view. *** */
	if ((Add2File=mbkfopen(add2_modelname,
						            "vbe",
						       WRITE_TEXT)) == (FILE*)NULL)
		Dut_PrintError( E_ADD2_ERROR, E_ADD2_OPENVBE,
					                  add2_modelname);

	/* *** Write an identification header *** */

	/* Standart begin of header. */
	fprintf( Add2File, 
"-- ###-------------------------------------------------------------###\n"
			);
	fprintf( Add2File, 
"-- #                                                                 #\n"
			);
	fprintf( Add2File,
"-- #    Alliance CAD System 2.0                                      #\n"
			);
    fprintf( Add2File,
"-- #      FITPATH Package 0.0                                        #\n"
			);
    fprintf( Add2File,
"-- #                                                                 #\n"
			);
    fprintf( Add2File,
"-- # Author :     Jean-Paul CHAPUT                                   #\n" 
			);
    fprintf( Add2File,
"-- # E-mail : cao-vlsi@masi.ibp.fr                                   #\n"
			);
	fprintf( Add2File, 
"-- # *************************************************************** #\n"
			);
	fprintf( Add2File,
"-- #                                                                 #\n"
			);
    fprintf( Add2File,
"-- # Generator : \"add2g\" (add2erter buffer)                            #\n"
			);
	fprintf( Add2File, 
"-- # --------------------------------------------------------------- #\n"
			);

	/* Print name of the generated file. */
	sprintf( TmpString, "\"%s.vbe\"."           , add2_modelname);
    fprintf( Add2File  , "-- # File : %-55s  #\n",      TmpString);
	fprintf( Add2File,
"-- #                                                                 #\n"
			);

	/* Print date of generation. */
	TmpTime                = time((time_t*)NULL);
	sprintf( TmpString, "%s", asctime(localtime(&TmpTime)) );
	LenString              = strlen( TmpString);
	TmpString[LenString-1] = (char)0;
    fprintf( Add2File  , "-- #           Date : %-45s  #\n", TmpString);

	/* Give the call used to generate the model. */
	sprintf(  TmpString, "\"add2g %ld %ld %ld %s -vhdl -o %s\"" ,
			                        DP_WIDTH                      ,
			                       add2_width                      ,
			                       add2_slice                      ,
			                      (add2_msb0     ) ? " -msb0"  : "",
			                       add2_modelname                  );
    fprintf( Add2File  , "-- # Generator Call : %-45s  #\n", TmpString);

	fprintf( Add2File, 
"-- ###-------------------------------------------------------------###\n"
			);


	/* Select terminals (and signals) bus indexation. */
	/* (depending to the flag "add2_msb0")             */
	if (!add2_msb0)
		{ sprintf( BusWide, "(%ld downto %ld)", add2_width-1
				                                +add2_slice  ,
				                                add2_slice  );

		  sprintf( BusWide0,"(%ld downto %ld)", add2_width
				                                +add2_slice  ,
				                                add2_slice+1);

		  sprintf( BusWide1,"(%ld downto %ld)", add2_width
				                                +add2_slice  ,
				                                add2_slice  );
        }
	else
		{ sprintf( BusWide, "(%ld to %ld)", DP_WIDTH-add2_slice
				                                    -add2_width   ,
				                            DP_WIDTH-add2_slice-1);

		  sprintf( BusWide0,"(%ld to %ld)", DP_WIDTH-add2_slice
				                                    -add2_width+1 ,
				                            DP_WIDTH-add2_slice  );

		  sprintf( BusWide1,"(%ld to %ld)", DP_WIDTH-add2_slice
				                                    -add2_width+1 ,
				                            DP_WIDTH-add2_slice-1);
        }

	/* *** Interface description. *** */
	fprintf( Add2File, "\nENTITY %s IS\n\tPORT(\n", add2_modelname);

    /* Control terminals. */
	fprintf( Add2File, "%14s :  out BIT;\n", "cout");
	fprintf( Add2File, "%14s :  out BIT;\n", "ovr" );

	/* Terminals of data buses. */
	fprintf( Add2File, "%14s :  in BIT_VECTOR%s;\n", "i0", BusWide);
	fprintf( Add2File, "%14s :  in BIT_VECTOR%s;\n", "i1", BusWide);
	fprintf( Add2File, "%14s : out BIT_VECTOR%s;\n", "o", BusWide );

	/* Supplies terminals. */
	fprintf( Add2File, "%14s :  in BIT;\n", "vdd");
	fprintf( Add2File, "%14s :  in BIT\n" , "vss");


	/* *** End of interface description *** */
	fprintf( Add2File, "\t);\nEND %s;\n\n\n", add2_modelname);


	/* *** Behavioral view *** */
	fprintf( Add2File, "ARCHITECTURE behaviour_data_flow OF %s IS\n\n",
			                                            add2_modelname);

    fprintf( Add2File, "SIGNAL carry : BIT_VECTOR%s;\n",BusWide1);

	fprintf( Add2File, "BEGIN\n\n");
	fprintf( Add2File, "\tcarry(0) <= '0';\n\n" );
	fprintf( Add2File, "\to%s <= i0%s xor i1%s xor carry%s;\n\n", BusWide, BusWide, BusWide, BusWide);
	fprintf( Add2File, "\tcarry%s <= (i0%s and i1%s) or (i0%s and carry%s) or (carry%s and i1%s);\n\n" , BusWide0, BusWide, BusWide, BusWide, BusWide, BusWide, BusWide);
	fprintf( Add2File, "\tcout <= carry(%ld);\n\n", DP_WIDTH-add2_slice );
	fprintf( Add2File, "\tovr <= carry(%ld) xor carry(%ld);\n\n" ,DP_WIDTH-add2_slice , DP_WIDTH-add2_slice-1);

	/* Check supplies connections. */
	fprintf( Add2File, "\t-- ****************>");
	fprintf( Add2File, " Supplies Check "      );
	fprintf( Add2File, "<****************\n\n" );

	fprintf( Add2File, "\tASSERT((vdd = '1') and (vss = '0'))\n");
	fprintf( Add2File, "\t\tREPORT \"Power supply is missing on %s.\"\n",
			                                              add2_modelname);
	fprintf( Add2File, "\t\tSEVERITY WARNING;\n\n");

	/* *** End of behavioral view *** */
	fprintf( Add2File, "END behaviour_data_flow;\n");

	/* *** Close the file holding the behavioral view *** */
	fclose( Add2File);
}


/*  Function  :  'Dgn_NetListAdd2'                                 */
/* -------------------------------------------------------------- */
/*  Generation of adder netlist view.                   */

static void  Dgn_NetlistAdd2(add2_modelname,
						     add2_width    ,
						     add2_slice    ,
						     add2_msb0     )
	char *add2_modelname;  /* Model name.            */
	long  add2_width;      /* Bus wide.              */
	long  add2_slice;      /* LSB starting slice.    */
	long  add2_msb0;       /* Zero as MSB index.     */
{
	int   number;
	long  BusIndex;
	long  SignalIndex0;
	long  SignalIndex1;
	long  LeafCellIndex;

	char *LeafCellSliceName;
	char  LeafCellInstaName[C_SUPP_MBKSZNAME];

	char  BusNameI0[C_SUPP_MBKSZNAME];
	char  BusNameI1[C_SUPP_MBKSZNAME];
	char  BusNameO[ C_SUPP_MBKSZNAME];

	char  PinNameI0[C_SUPP_MBKSZNAME];
	char  PinNameI1[C_SUPP_MBKSZNAME];
	char  PinNameO[ C_SUPP_MBKSZNAME];
	char  SignalName0[C_SUPP_MBKSZNAME];
	char  SignalName1[C_SUPP_MBKSZNAME];


	/* Select name of the leaf cell model. */

	/* Creation of the new logical figure. */
	DEF_LOFIG( add2_modelname);

	/* Name of data bus terminals. */
	if (!add2_msb0)
	{
		sprintf( BusNameI0,"i0[%ld:%ld]", add2_width-1+add2_slice, add2_slice);
		sprintf( BusNameI1,"i1[%ld:%ld]", add2_width-1+add2_slice, add2_slice);
		sprintf( BusNameO , "o[%ld:%ld]", add2_width-1+add2_slice, add2_slice);
	}
	else
	{
		sprintf( BusNameI0,"i0[%ld:%ld]", DP_WIDTH-add2_slice
				                                  -add2_width  ,
				                          DP_WIDTH-add2_slice-1);
		sprintf( BusNameI1,"i1[%ld:%ld]", DP_WIDTH-add2_slice
				                                  -add2_width  ,
				                          DP_WIDTH-add2_slice-1);
		sprintf( BusNameO , "o[%ld:%ld]", DP_WIDTH-add2_slice
				                                  -add2_width  ,
				                          DP_WIDTH-add2_slice-1);
	}

 
	/* Creation of figure terminals. */

	/* **** Control terminals **** */
	LOCON( "cout" , OUT , "cout"  );
	LOCON( "ovr"  , OUT   , "ovr"   );

    /* **** Data bus terminals **** */
	LOCON( BusNameI0, IN  , BusNameI0);
	LOCON( BusNameI1, IN  , BusNameI1);
	LOCON( BusNameO , OUT , BusNameO );

	/* **** Supply terminals **** */
	LOCON( "vdd",  INOUT ,  "vdd"); 
	LOCON( "vss",  INOUT ,  "vss"); 
	
	
	/* Creation of leaf cells instances. */

         

	/* ("normals" cells of column)       */
	for( LeafCellIndex=add2_slice;
		 LeafCellIndex<add2_slice+add2_width-1; LeafCellIndex++)
	{
		number = (add2_slice+add2_width-1-LeafCellIndex)%2;
        SignalIndex0 = ( add2_slice + add2_width -2 - LeafCellIndex ) ;
        SignalIndex1 = ( add2_slice + add2_width -1 - LeafCellIndex ) ;
		

		/* Build terminal leaf cell name. */
        if (LeafCellIndex==add2_slice)
          {
              if (number==0)
           	      LeafCellSliceName=TabLeafCellAdd2[4];
              else
           	      LeafCellSliceName=TabLeafCellAdd2[5];
          }
		/* Build leaf cell name. */
        else
          {
              if (number==0)
               	  LeafCellSliceName=TabLeafCellAdd2[2];
        	  else
           		  LeafCellSliceName=TabLeafCellAdd2[3];
          }
		     
		/* Compute terminal index. */
		if (!add2_msb0) BusIndex =              LeafCellIndex;
		else            BusIndex = DP_WIDTH -1 -LeafCellIndex;

		/* Build signals names. */
		sprintf( PinNameI0, "i0[%ld]", BusIndex);
		sprintf( PinNameI1, "i1[%ld]", BusIndex);
		sprintf( PinNameO ,  "o[%ld]", BusIndex);
		sprintf( SignalName0 , "cin_%ld", SignalIndex0 );
		sprintf( SignalName1 , "cin_%ld", SignalIndex1 );

		/* Built instance name. */
		sprintf(LeafCellInstaName, "csa_%ld", (LeafCellIndex-add2_slice) ); 

        
        if (LeafCellIndex==add2_slice)

		/* Terminal leaf cell instanciation. */
		LOINS( LeafCellSliceName,
			   LeafCellInstaName,
			          PinNameI0 ,
			          PinNameI1 ,
			          PinNameO  ,
                      SignalName0 , "vdd", "vss", EOL);
	
        else
		/* Leaf cell instanciation. */
		LOINS( LeafCellSliceName,
			   LeafCellInstaName,
	        		  PinNameI0 ,
	         		  PinNameI1 ,
					  SignalName1,
	      		      PinNameO  ,
               		  SignalName0, "vdd", "vss", EOL);
	}

    /* Creation of intermediaire cells */
    /* Intermediaire instance */
    LeafCellSliceName = TabLeafCellAdd2[1];
	LeafCellIndex = add2_slice+add2_width-1;

	/* Compute terminal index. */
	if (!add2_msb0) BusIndex =              LeafCellIndex ;
	else            BusIndex = DP_WIDTH -1 -LeafCellIndex;

	/* Build signals names. */
	sprintf( PinNameI0, "i0[%ld]", BusIndex);
	sprintf( PinNameI1, "i1[%ld]", BusIndex);
	sprintf( PinNameO ,  "o[%ld]", BusIndex);

	/* Built instance name. */
	sprintf(LeafCellInstaName, "csa_%ld", (DP_WIDTH-add2_slice-1) ); 

	/* Intermediaire instanciation */
	LOINS( LeafCellSliceName,
		   LeafCellInstaName,
                   PinNameI0,
		    	   PinNameI1,
			        "cin_0" ,
			         "cout" ,
                   PinNameO , "vdd","vss",EOL);

	/* Creation of buffer instance. */

	/*  buffer instance name. */
	sprintf(LeafCellInstaName, "bcsa_%ld",(DP_WIDTH-add2_slice)); 
	LeafCellSliceName = TabLeafCellAdd2[0];

	/* Buffer instanciation. */
	LOINS( LeafCellSliceName,
		   LeafCellInstaName,
		           "cin_0"  ,
		            "cout"  ,
		            "ovr"   , "vdd", "vss", VSS, EOL);

	/* Ends and write to disk the new figure. */
	SAVE_LOFIG();
}
