# include <stdio.h>
# include <stdlib.h>
# include MLO_H
# include MPH_H
# include MUT_H
# include "scr.h"
# include "ChannelRout.h"
# include "ScrDataBase.h"

/***********************************************************************/
/*       CHARGEMENT DES LISTES NORTH, SOUTH, WEST ET EAST              */
/***********************************************************************/
ConnectorList   *U_GetConList(ptfich)

FILE            *ptfich;

{
 ConnectorList  *LeadConList = NULL;
 ConnectorList  *CurrentList = NULL;
 ConnectorList  *PrevCurrentList = NULL;
 long           Mark = 0;
 char		car;
 char		string[10];
 int		i=0;


 if ((car = getc(ptfich)) == '{') 
  if ((car = getc(ptfich)) != '}') {
   while ((car != ' ') && (car != ',') && (car != '}')) {
    if (car != '\n') string[i++] = car;
    car = getc(ptfich);
   }
   string[i] = '\0';
   LeadConList = (ConnectorList *) mbkalloc (sizeof(ConnectorList));
   PrevCurrentList = LeadConList;
   LeadConList->NextCon = NULL;
   LeadConList->ConName = atol(string);
   LeadConList->Mark = Mark;
   Mark++;
   
   while (car != '}') {
    i = 0;
    car = getc(ptfich);
    while ((car != ' ') && (car != ',') && (car != '}')) {
     if (car != '\n') string[i++] = car;
     car = getc(ptfich);
    }
    string[i] = '\0';
    CurrentList = (ConnectorList *) mbkalloc (sizeof(ConnectorList));
    PrevCurrentList->NextCon = CurrentList;
    PrevCurrentList = CurrentList;
    CurrentList->NextCon = NULL;
    CurrentList->ConName = atol(string);
    CurrentList->Mark = Mark;
    Mark++;
   }
  }
  else LeadConList = NULL;
 car = getc(ptfich);
 return (LeadConList);
}
/******************************************************************************/
/*	Function : U_GetChannel()                                             */
/******************************************************************************/
void	U_GetChannel(FichName, LeadNorthList, LeadSouthList, 
                     LeadWestList, LeadEastList)

char		*FichName;
ConnectorList   **LeadNorthList;
ConnectorList   **LeadSouthList;
ConnectorList   **LeadWestList;
ConnectorList   **LeadEastList;

{
 FILE	*ptfich;
 
 if ((ptfich = fopen(FichName,"r")) == NULL)  {
  fprintf(stdout,"fichier inexistant \n");
  exit(0);
 }
 else {
  *LeadNorthList = U_GetConList(ptfich);
  *LeadSouthList = U_GetConList(ptfich);
  *LeadWestList  = U_GetConList(ptfich);
  *LeadEastList  = U_GetConList(ptfich);
  fclose(ptfich);
 }
}
/******************************************************************************/
/*                  VISUALISATION DE LA LISTE DES CONNECTEURS                 */
/******************************************************************************/
void  U_PrintList(LeadConList)

ConnectorList	*LeadConList;

{
 ConnectorList	*CurrentConList;
 CurrentConList = LeadConList;

 if (LeadConList)
  while (CurrentConList) {
   printf("ConName= %ld \t  Mark= %ld \n",CurrentConList->ConName,
                                       CurrentConList->Mark);
   CurrentConList = CurrentConList->NextCon;
  }
}

/******************************************************************************/
/*              VISUALISATION DE LA LISTE DES COLONNES                        */
/******************************************************************************/
void U_PrintColumn(LeadColumn)

StaticColumn	*LeadColumn;
{
 StaticColumn	*CurrentColumn = NULL;

 CurrentColumn = LeadColumn;
 while (CurrentColumn) {
  printf("NorthCon = %ld \t SouthCon = %ld \n",CurrentColumn->NorthCon,
         CurrentColumn->SouthCon);
  CurrentColumn = CurrentColumn->NextCol;
 }
}

/******************************************************************************/
/*                        LARGEUR DU CANAL                                    */
/******************************************************************************/
long	U_ChannelWidth(LeadNorth, LeadSouth)

StaticColumn	*LeadNorth;
StaticColumn	*LeadSouth;

{
 StaticColumn	*CurrentColumn = NULL;
 long		NorthWidth = 0;
 long		SouthWidth = 0;

 for (CurrentColumn = LeadNorth; CurrentColumn;
      CurrentColumn = CurrentColumn->NextCol, NorthWidth++);
 for (CurrentColumn = LeadSouth; CurrentColumn;
      CurrentColumn = CurrentColumn->NextCol, SouthWidth++);
 return(MAX(NorthWidth, SouthWidth));
}

/******************************************************************************/
/*                  VISUALISATION DE LA BASE DE DONNEE STATIQUE               */
/******************************************************************************/
void U_PrintStaticDataBase(LeadColumn)

StaticColumn	*LeadColumn;

{
 StaticColumn	*CurrentColumn = NULL;
 StaticPoint	*CurrentPoint  = NULL;

 for (CurrentColumn = LeadColumn;CurrentColumn;
      CurrentColumn = CurrentColumn->NextCol) {
  printf("NorthCon = %ld \t SouthCon = %ld \n",CurrentColumn->NorthCon,
         CurrentColumn->SouthCon);
  for (CurrentPoint = CurrentColumn->PointList; CurrentPoint;
       CurrentPoint = CurrentPoint->NextPoint) 
   printf("Via = %d \t Layer1 = %c \t Layer2 = %c \t Name = %ld \n",
          CurrentPoint->Via, CurrentPoint->Layer1, CurrentPoint->Layer2,
          CurrentPoint->PointName);
 }
}
/******************************************************************************/
/*               VISUALISATION DE LA LISTE DES  SEGMENTS                      */
/******************************************************************************/
void	U_PrintSegmentList(LeadList)

SegmentList	*LeadList;

{
 SegmentList	*CurrentList = NULL;

 for (CurrentList = LeadList; CurrentList; CurrentList = CurrentList->NextSeg) {
  fprintf(stdout,"Name = %s \t X1Seg = %3ld \t Y1Seg = %3ld \t ",
          CurrentList->SegName, CurrentList->X1Seg, CurrentList->Y1Seg);
  fprintf(stdout,"X2Seg= %3ld \t Y2Seg= %3ld \n",
          CurrentList->X2Seg, CurrentList->Y2Seg);
 }
          
}

/******************************************************************************/
/*               VISUALISATION DE LA LISTE DES  SEGMENTS                      */
/******************************************************************************/
void	U_PrintViasList(LeadList)

ViasList	*LeadList;

{
 ViasList	*CurrentList = NULL;

 for (CurrentList = LeadList; CurrentList; CurrentList = CurrentList->NextVia)
  fprintf(stdout,"XVia = %ld \t YVia = %ld \t \n",
          CurrentList->XVia, CurrentList->YVia);
}

/******************************************************************************/
/*              SAUVEGARDE DU RESULTAT DE ROUTAGE                             */
/******************************************************************************/
void	U_SaveChannel(
                      FigName, LeadH_Segment, LeadV_Segment,
                      LeadVia, Width, Height,
		      LeadWestList, LeadEastList
                     )

char		*FigName;
SegmentList	*LeadH_Segment;
SegmentList	*LeadV_Segment;
ViasList	*LeadVia;
long		Width;
long		Height;
ConnectorList   *LeadWestList;
ConnectorList   *LeadEastList;

{
 phfig_list	*ptfig = NULL;
 SegmentList	*CurrentSegment = NULL;
 ViasList	*CurrentVia     = NULL;
 long		Layer1Length    = 0; 
 long		Layer2Length    = 0; 
 long		ViasNumber      = 0;

 ptfig = addphfig(FigName);
fprintf(stdout,"Width = %ld \n",Width);
fprintf(stdout,"Height = %ld \n",Height);

 ptfig->XAB1 = ptfig->YAB1 = ((long ) 0);
 ptfig->XAB2 = ((Width - 1) * PITCH_X * SCALE_X);
 ptfig->YAB2 = ((Height + 1 )  * PITCH_Y * SCALE_X);

fprintf(stderr,"XAB1 = %ld \n",ptfig->XAB1);
fprintf(stderr,"XAB2 = %ld \n",ptfig->XAB2);
fprintf(stderr,"YAB1 = %ld \n",ptfig->YAB1);
fprintf(stderr,"YAB2 = %ld \n",ptfig->YAB2);

fflush(stderr);

 for (CurrentSegment = LeadH_Segment; CurrentSegment;
      CurrentSegment = CurrentSegment->NextSeg) {
  addphseg(ptfig, ((char ) ALU1), (WIDTH_LAYER1 * SCALE_X),
           ((CurrentSegment->X1Seg) * PITCH_X * SCALE_X), 
           ((CurrentSegment->Y1Seg) * PITCH_Y * SCALE_X), 
           ((CurrentSegment->X2Seg) * PITCH_X * SCALE_X), 
           ((CurrentSegment->Y2Seg) * PITCH_Y * SCALE_X), 
	   CurrentSegment->SegName);
  Layer1Length = Layer1Length + (CurrentSegment->X2Seg - CurrentSegment->X1Seg);
 }
 Layer1Length = Layer1Length * PITCH_X * SCALE_X;
                    
 for (CurrentSegment = LeadV_Segment; CurrentSegment;
      CurrentSegment = CurrentSegment->NextSeg) {
  addphseg(ptfig, ((char ) ALU2), (WIDTH_LAYER2 * SCALE_X),
           ((CurrentSegment->X1Seg) * PITCH_X * SCALE_X), 
           ((CurrentSegment->Y1Seg) * PITCH_Y * SCALE_X), 
           ((CurrentSegment->X2Seg) * PITCH_X * SCALE_X), 
           ((CurrentSegment->Y2Seg) * PITCH_Y * SCALE_X), 
	   CurrentSegment->SegName);
  Layer2Length = Layer2Length + (CurrentSegment->Y2Seg - CurrentSegment->Y1Seg);
 }
 Layer2Length = Layer2Length * PITCH_Y * SCALE_X;

 for (CurrentVia = LeadVia; CurrentVia; CurrentVia = CurrentVia->NextVia) {
  addphvia(ptfig, ((char ) CONT_VIA), 
           ((CurrentVia->XVia) * PITCH_X * SCALE_X),
           ((CurrentVia->YVia) * PITCH_Y * SCALE_X));
  ViasNumber = ViasNumber + 1;
 }

 for (CurrentSegment = LeadV_Segment; CurrentSegment;
      CurrentSegment = CurrentSegment->NextSeg) {
  if (CurrentSegment->Y1Seg == 0) 
   addphcon(ptfig, SOUTH, CurrentSegment->SegName, 
            ((CurrentSegment->X1Seg) * PITCH_X * SCALE_X),
            ((CurrentSegment->Y1Seg) * PITCH_Y * SCALE_X),
            ((char ) ALU2), (WIDTH_LAYER2 * SCALE_X));
  if (CurrentSegment->Y2Seg == (Height + 1)) 
   addphcon(ptfig, NORTH, CurrentSegment->SegName, 
            ((CurrentSegment->X2Seg) * PITCH_X * SCALE_X),
            ((CurrentSegment->Y2Seg) * PITCH_Y * SCALE_X),
            ((char ) ALU2), (WIDTH_LAYER2 * SCALE_X));
 }

 if (LeadWestList && LeadEastList) {
  for (CurrentSegment = LeadH_Segment; CurrentSegment;
       CurrentSegment = CurrentSegment->NextSeg) {
   if (CurrentSegment->X1Seg == 0) 
    addphcon(ptfig, WEST, CurrentSegment->SegName,
             ((CurrentSegment->X1Seg) * PITCH_X * SCALE_X),
             ((CurrentSegment->Y1Seg) * PITCH_Y * SCALE_X),
             ((char ) ALU1), (WIDTH_LAYER1 * SCALE_X));
   if (CurrentSegment->X2Seg == (Width - 1)) 
    addphcon(ptfig, EAST, CurrentSegment->SegName,
             ((CurrentSegment->X2Seg) * PITCH_X * SCALE_X),
             ((CurrentSegment->Y2Seg) * PITCH_Y * SCALE_X),
             ((char ) ALU1), (WIDTH_LAYER1 * SCALE_X));
  }
 }
 else
  if (LeadWestList) {
   for (CurrentSegment = LeadH_Segment; CurrentSegment;
       CurrentSegment = CurrentSegment->NextSeg) 
   if (CurrentSegment->X1Seg == 0) 
    addphcon(ptfig, WEST, CurrentSegment->SegName,
             ((CurrentSegment->X1Seg) * PITCH_X * SCALE_X),
             ((CurrentSegment->Y1Seg) * PITCH_Y * SCALE_X),
             ((char ) ALU1), (WIDTH_LAYER1 * SCALE_X));
  }
  else 
   if (LeadEastList) {
    for (CurrentSegment = LeadH_Segment; CurrentSegment; 
        CurrentSegment = CurrentSegment->NextSeg) 
    if (CurrentSegment->X2Seg == (Width - 1)) 
     addphcon(ptfig, EAST, CurrentSegment->SegName, 
              ((CurrentSegment->X2Seg) * PITCH_X * SCALE_X), 
              ((CurrentSegment->Y2Seg) * PITCH_Y * SCALE_X),
              ((char ) ALU1), (WIDTH_LAYER1 * SCALE_X));
   }

fprintf(stdout,"Layer1 Length = %ld \n",Layer1Length);
fprintf(stdout,"Layer2 Length = %ld \n",Layer2Length);
fprintf(stdout,"ViasNumber = %ld \n",ViasNumber);
 savephfig(ptfig);
}
/******************************************************************************/
