/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : conflit.c                                                   */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Marc LAURENTIN                        le : 06/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "head.h"

/****************************************************/
/**    chaine pth0 et pth1 dans un ptype_list      **/
/**       de type CONFLICT de cone                 **/
/****************************************************/
void AddCouple(cone, pth0, pth1)
cone_list *cone;
list_list *pth0, *pth1;
{
ptype_list *user;
chain_list *chain0=NULL, *chainUp=NULL;

chain0=addchain(chain0,(void*)pth0);
chain0=addchain(chain0,(void*)pth1);
if ((user=getptype(cone->USER,CONFLICT)) == NULL) 
   {
   chainUp=addchain(chainUp,(void*)chain0);
   cone->USER=addptype(cone->USER,CONFLICT,(void*)chainUp);
   }

else 
   {
   chainUp=(chain_list*)user->DATA;
   chainUp=addchain(chainUp,(void*)chain0);
   user->DATA=(void*)chainUp;
   }
}


/****************************************************************************
 *                         fonction conflit();                              *
 ****************************************************************************/
    /*--------------------------------------------------------------+
    |     elimination des fausses branches et des faux conflicts    |
    + -------------------------------------------------------------*/
short fcfConflit(bfig,ptcone)
befig_list * bfig;
cone_list   *ptcone;
{
list_list   *path0, *path1;
chain_list  *chain;
ptype_list  *user;
pNode       s0, s1, sf, sc ;


/*----------------------*
 | Nettoyage des champs |
 *----------------------*/
   if ((user=getptype(ptcone->USER,CONFLICT)) != NULL) 
   {
      for (chain=(chain_list*)user->DATA; chain; chain=chain->NEXT)
      freechain(chain->DATA);
      chain=(chain_list*)user->DATA;
      freechain(chain);
      ptcone->USER=delptype(ptcone->USER,CONFLICT);
   }
       
   for (path0=ptcone->PATH; path0!=NULL; path0=path0->NEXT)
   {
   ptype_list * user0 ;

      if (/*((path0->TYPE & CONFLICT) != CONFLICT) || */
          ((path0->TYPE & BLEEDER) == BLEEDER)) continue;

      if((user0=getptype(path0->USER,BDD_PTR))==NULL)
      {
      fcfFatalError(1,"fcfConflit",NULL,NULL,0);
      }
      else s0=(pNode)user0->DATA;


      /*-----------+
      | Contrainte |
      +-----------*/
      if(FCF_X_CONTR != 0)
      s0=fcfContrainte(bfig,ptcone,s0,bfig->BEOUT);

      if(s0==NULL)
      return(-1) ;

      if (s0 == zero) 
      { 
      path0->TYPE |= BLEEDER;
      fausse_b++;
      continue;
      }

      for (path1=path0->NEXT; path1!=NULL; path1=path1->NEXT)
      {
      ptype_list *username0;
      ptype_list *username1;
      ptype_list * user1;

         if (/*((path1->TYPE & CONFLICT) != CONFLICT) || */
            ((path1->TYPE & BLEEDER) == BLEEDER)) continue;


         if (((((path0->TYPE & VDD) == VDD) || ((path0->TYPE & EXT) == EXT))
            && (((path1->TYPE & VSS) == VSS) || ((path1->TYPE & EXT) == EXT)))
            || ((((path0->TYPE & VSS) == VSS) || ((path0->TYPE & EXT) == EXT))
            && (((path1->TYPE & VDD) == VDD) || ((path1->TYPE & EXT) == EXT))))
         {
            if((user1=getptype(path1->USER,BDD_PTR))==NULL)
            {
            fcfFatalError(1,"fcfConflit",NULL,NULL,0);
            }
            else s1=(pNode)user1->DATA;


            /*-----------+
            | Contrainte |
            +-----------*/
            if(FCF_X_CONTR !=0)
            s1=fcfContrainte(bfig,ptcone,s1,bfig->BEOUT);

            if(s1==NULL)
            return(-1) ;

            if (s1 == zero) 
            { 
            path1->TYPE |= BLEEDER;
            fausse_b++;
            continue;
            }

         sf=applyBinBdd(AND,s0,s1);

            if(cfAbandon(bfig,ptcone) !=0)
            return(-1) ;

            /*-----------+
            | Contrainte |
            +-----------*/
            if(FCF_X_CONTR != 0)
            sf=fcfContrainte(bfig,ptcone,sf,bfig->BEOUT);

            if(sf==NULL)
            return(-1) ;

            if ((sf==zero) || ((s0 == s1) && (
              (((path0->TYPE & VDD) == VDD) && ((path1->TYPE & EXT) == EXT)) ||
              (((path1->TYPE & VDD) == VDD) && ((path0->TYPE & EXT) == EXT)) ||
              (((path1->TYPE & EXT) == EXT) && ((path0->TYPE & EXT) == EXT)))))
            continue;
            else
            {
            AddCouple(ptcone,path0,path1);  
            }
         }
      }                                                 /* finfor2*/
   }                                                     /* finfor1*/

   if ((getptype(ptcone->USER,CONFLICT)) == NULL) 
   {
   list_list * path ;
   ptcone->TYPE ^= CONFLICT;

      for(path=ptcone->PATH ; path != NULL ; path=path->NEXT)
      {
      path->TYPE &= ~CONFLICT ;
      }
   no_conf++;
   }
return(0);
} 



