/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : checkBeh.c                                                  */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Luc Burgun                            le : 06/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include"head.h"

/*-------------------------------------------------------------------------
checkExpr 	: verifie le non partage des expressions dans un ABL 
---------------------------------------------------------------------------
retour		: un void.
---------------------------------------------------------------------------*/

void checkExpr(expr,pTable)
chain_list *expr;
pTH pTable;
{
int exprRed = VIDETH;

if (ATOM(expr))
   {
   if ((exprRed = searchTH(pTable,expr)) != VIDETH)
      {
      printf("checkExprBeh : Warning - reduced expression\n");
      displayExpr((chain_list *)exprRed);
      displayExpr(expr);
      }
   else
      {
      addTH(pTable,expr,expr);
      }
   }
else
   {
   chain_list *oldExpr = expr;

   if ((exprRed = searchTH(pTable,expr)) != VIDETH) /* operateur */
      {
      printf("checkExprBeh : Warning - reduced expression\n");
      displayExpr((chain_list *) exprRed);
      displayExpr(expr);
      }
   else
      {
      addTH(pTable,expr,expr);
      }

   while ((expr = CDR(expr)) && 
          (exprRed == VIDETH)) /* liste des arguments */
      {
      if ((exprRed = searchTH(pTable,expr)) != VIDETH)
         {
         printf("checkExprBeh : Warning - reduced expression\n");
         displayExpr((chain_list *) exprRed);
         displayExpr(oldExpr);
         }
      else
         {
         addTH(pTable,expr,oldExpr);
         checkExpr(CAR(expr),pTable);
         }
      }
   }
}
/*-------------------------------------------------------------------------
checkExprBeh 	: verifie le non partage des expressions dans une BEFIG 
---------------------------------------------------------------------------
retour		: un void.
---------------------------------------------------------------------------*/

void checkExprBeh(beh)
befig_list *beh;
{
beout_list *out;
bereg_list *reg;
bebus_list *bus;
biabl_list *biabl;
beaux_list *aux;
pTH  redTable;

redTable = createTH(10000);

aux = beh->BEAUX;
while (aux) 
   {
   if (aux->ABL)
      {
      checkExpr(aux->ABL,redTable);
      }
   aux = aux->NEXT;
   }

out = beh->BEOUT;
while (out) 
   {
   if (out->ABL)
      {
      checkExpr(out->ABL,redTable);
      }
   out = out->NEXT;
   }

reg = beh->BEREG;
while (reg) 
   {
   biabl = reg->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         checkExpr(biabl->CNDABL,redTable);
         checkExpr(biabl->VALABL,redTable);
         }
      biabl = biabl->NEXT;
      }
   reg = reg->NEXT;
   }

bus = beh->BEBUS;
while (bus) 
   {
   biabl = bus->BIABL;
   while (biabl)
      {
      if (biabl->CNDABL && biabl->VALABL)
         {
         checkExpr(biabl->CNDABL,redTable);
         checkExpr(biabl->VALABL,redTable);
         }
      biabl = biabl->NEXT;
      }
   bus = bus->NEXT;
   }
destroyTH(redTable);
}
