/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : pgm.c                                                       */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Marc LAURENTIN                        le : 06/09/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "declar.h"

#ident "@(#) Desb V2.87 du 10 Mai 1993 par Marc Laurentin"

extern void infLit();     /* Lecture du fichier INFO */
extern void d2vVhd();    /* generation du fichier vbe */

static char * d2vVERSION ;

/****************************************************************************
 *                         fonction main();                                 *
 ****************************************************************************/
main( argc , argv )

int 	argc ;
char 	*argv[];

{
desafig_list *getdesbfig() ;
lofig_list		*pt_mbkfig 		= NULL ;
desafig_list    	*pt_desafig		= NULL ;
char			old_trace_mode ;
char			old_debug_mode ;
long			start = 0 ;
long			end   = 0 ;
long                    counter = 1;

DESB_VERSION=namealloc("2.87");
DATE_VERSION=namealloc("23 Juin 1993");
d2vVERSION = namealloc("3.0");

DESB_NB_ERR=0;

mbkenv ();               /* environnement MBK */
desa_setenv();

/*------------------------------------------------------------+
|      OPTION POUR UNIVERSITE                                 |
+------------------------------------------------------------*/
#ifdef PARIS6
   if(dsbGetArg(argc,argv)== -1)
   {
   printf("\nDesb %s\nUsage   : desb [options] <file1> [file2] \n",DESB_VERSION);
      if(DESB_LANG=='F')
      {
      printf("Options : -i     lit le fichier .'inf'\n");
      printf("          -v     vectorise la description vhdl\n");
      printf("          -a     accelere desb si la convention '-s' est adoptee\n"); 
      printf("          -p=n   n est la profondeur pour l'analyse fonctionnelle\n");
      printf("          -os    un seul vdd et vss dans le vbe \n");
      printf("          -nh    genere une netlist hierarchisee de cones \n");
      printf("          file2  fichier vhdl genere (file1 par default)\n");
      printf("\n");
      }
      else if(DESB_LANG=='E')
      {
      printf("Options : -i     reads the '.inf' file\n");
      printf("          -v     vectorises the vhdl description\n");
      printf("          -a     accelerates DESB when '_s' convention is adopted\n");
      printf("          -p=n   n is the depth for functional analysis \n");
      printf("          -os    Only one vdd and vss in the vhdl description\n");
      printf("          -nh    generates a hierarchical cone netlist \n");
      printf("          file2  is the vhdl file to be generated (default is file1)\n");
      printf("\n");
      }
   exit(-1);
   }
#endif PARIS6
/*------------------------------------------------------------+
|      OPTION POUR  DISTRIB                                   |
+------------------------------------------------------------*/
#ifdef DISTRIB
   if(dsbGetArg(argc,argv)== -1)
   {
   printf("\nDesb %s\nUsage   : desb [options] <file1> [file2] \n",DESB_VERSION);
      if(DESB_LANG=='F')
      {
      printf("Options : -i     lit le fichier .'inf'\n");
      printf("          -v     vectorise la description vhdl\n");
      printf("          -a     accelere desb si la convention '-s' est adoptee\n"); 
      printf("          -p=n   n est la profondeur pour l'analyse fonctionnelle\n");
      printf("          -os    un seul vdd et vss dans le vbe \n");
      printf("          -nh    genere une netlist hierarchisee de cones \n");
      printf("          file2  fichier vhdl genere (file1 par default)\n");
      printf("\n");
      }
      else if(DESB_LANG=='E')
      {
      printf("Options : -i     reads the '.inf' file\n");
      printf("          -v     vectorises the vhdl description\n");
      printf("          -a     accelerates DESB when '_s' convention is adopted\n");
      printf("          -p=n   n is the depth for functional analysis \n");
      printf("          -os    Only one vdd and vss in the vhdl description\n");
      printf("          -nh    generates a hierarchical cone netlist \n");
      printf("          file2  is the vhdl file to be generated (default is file1)\n");
      printf("\n");
      }
   exit(-1);
   }
#endif DISTRIB
/*--------------------------------------------------------+
|      OPTION POUR BULL                                   |
+--------------------------------------------------------*/
#ifdef BULL
   if(dsbGetArg(argc,argv)== -1)
   {
   printf("\nDesb %s\nUsage   : desb [options] <file1> [file2] \n",DESB_VERSION);
      if(DESB_LANG=='F')
      {
      printf("Options : -i     lit le fichier .'inf'\n");
      printf("          -na    ne prend pas en compte les _s et les _l\n"); 
      printf("          -p=n   n est la profondeur pour l'analyse fonctionnelle\n");
      printf("\n");
      }
      else if(DESB_LANG=='E')
      {
      printf("Options : -i     reads the '.inf' file\n");
      printf("          -na    does not take into account _s and _l\n");
      printf("          -p=n   n is the depth for functional analysis \n");
      printf("\n");
      }
   exit(-1);
   }
#endif BULL

time(&start);

alliancebanner("desb","2.87","Functional Abstractor","91-93","1.2");

#ifdef BULL
   printf("\t\t\t");
   printf("       BULL PHASE II Release\n");
#endif BULL


/*-------------------------+
| Lecture du fichier INFO  |
+-------------------------*/
   if(DSB_INF !=0) 
   {
   char buff[80];
   sprintf(buff,"%s.inf",DSB_FIGNAME);
      if(mbkfopen(DSB_FIGNAME,"inf",READ_TEXT)==NULL)
   dsbFatalError(7,NULL,buff,0);
   dsbMessage(16,DSB_FIGNAME);
   infLit(DSB_FIGNAME,DESB_LANG);
   }

/*----------------------------*
| Chargement de la figure MBK |
+----------------------------*/
( void )time( &start ) ;
dsbMessage(1,DSB_FIGNAME);
SCALE_X = 100 ;
pt_mbkfig = getlofig ( DSB_FIGNAME, 'A' );
( void )time( &end ) ;
end -= start ;
/* printf( "%02d:%02d \n" , end/60 , end%60 ) ;*/
 

/*----------------------------+
| creation de la figure DESB  |
+----------------------------*/
(void)time(&start ) ;
pt_desafig = desb(DSB_FIGNAME,pt_mbkfig);
(void)time(&end);
end -= start ;

/* dsbRecapRecup(); */


/*--------------------------------------------------------------------------*
 | Destruction de la figure MBK                                             |
 *--------------------------------------------------------------------------*/
{
int test ;
time( &start ) ;
dsbMessage(13,NULL);
pt_mbkfig->LOCON = NULL ;
pt_mbkfig->LOTRS = NULL ;
test=dellofig( pt_mbkfig->NAME ) ;
   if(test!=1)
   {
   printf("dellofig  impossible \n");
   fflush(stdout);
   }
time( &end ) ;
}

/*--------------------------------------+
|  sauvegarde sur disque  eventuelle    | 
+--------------------------------------*/
   if(DSB_DEB != 0)
   {
      	( void )time( &start ) ;
        dsbMessage(12,pt_desafig->NAME);
        savedesa( pt_desafig ) ;
      	( void )time( &end ) ;
      	end -= start ;
  }


/*--------------------------------------------------------------------------*
 | generation d une figure MBK hierarchique                                 |
 *--------------------------------------------------------------------------*/
   if(DSB_HIERAR != 0)
   {
   time( &start ) ;
   dsbMessage(14,NULL);
   pt_mbkfig=dsbfigToMbkfig(pt_desafig);
   savelofig(pt_mbkfig);
   time( &end ) ;
   end -= start ;
   }

/*----------------------------+
| Generation du Vhdl          |
+----------------------------*/
   if(DSB_VBE !=0)
   {
   dsbMessage(15,NULL);
   d2vVhd(pt_desafig,VBE_NAME,DSB_VECTORISE,DSB_SUPPLY,d2vVERSION,DESB_LANG);
   }

dsbMessage(17,NULL);

/*------------------------------------------+
| Compte rendu sur la sortie standart       |
+------------------------------------------*/
   if (DESB_LANG=='F')
   fprintf(DESB_ERR_FILE,"[MES]Nombre Max de Noeud Bdd crees : %ld \n",MaxNoeud);
   else if (DESB_LANG=='E')
   fprintf(DESB_ERR_FILE,"[MES]Maximun pNode created by Bdd System %ld\n",MaxNoeud);

   if (DESB_RECAP_ERR != NULL)
   {
   chain_list * chain;
   fprintf(stderr,"------------------------------------------------------------\n");
   DESB_RECAP_ERR = reverse (DESB_RECAP_ERR);
      for (chain=DESB_RECAP_ERR;chain!=NULL;chain=chain->NEXT)
      {
      fprintf(stderr,"%s",chain->DATA);
      }
   }

   if (DESB_NB_ERR > 0)
   {
   fprintf(stderr,"------------------------------------------------------------\n");
      if (DESB_LANG=='F')
      {
      fprintf(stdout," %ld ERREUR(S) detectees \n",DESB_NB_ERR);
      fprintf(stdout," Consulter le fichier '%s.dsbr' pour plus d'information \n",DSB_FIGNAME);
      }
      else if (DESB_LANG =='E')
      {
      fprintf(stdout," %ld ERROR(S) detected \n",DESB_NB_ERR);
      fprintf(stdout,"See file '%s.dsbr' for more information\n",DSB_FIGNAME);
      }
   fprintf(stderr,"------------------------------------------------------------\n");
   fflush(stdout);
   exit(-1);
   }

   if(DESB_RECAP_ERR != NULL)
   {
      if (DESB_LANG=='F')
      {
      fprintf(stdout," Consulter le fichier '%s.dsbr' pour plus d'information \n",DSB_FIGNAME);
      }
      else if (DESB_LANG =='E')
      {
      fprintf(stdout,"See file '%s.dsbr' for more information\n",DSB_FIGNAME);
      }
   }
exit(0);
}


