/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : DESB  v2.n                                                  */
/*    Fichier : mem.c                                                       */
/*                                                                          */
/*    (c) copyright 1993 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Marc LAURENTIN                        le : 27/01/1993     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/
#include "declar.h"

#define CONE_PAQUET 100 
#define LIST_PAQUET 200 
#define LINK_PAQUET 300 

static int idxCone ;
static int idxList ;
static int idxLink ;

static cone_list * coneAvailable ; /* struct disponible dans la page */
static link_list * linkAvailable ;
static list_list * listAvailable ;

static chain_list * conePage ;     /* liste des page de structures */
static chain_list * linkPage ;
static chain_list * listPage ;

static cone_list * FREED_CONE ;    /* structure liberee */
static link_list * FREED_LINK ;
static list_list * FREED_LIST ;

static int recupLink =0 ;
static int recupList = 0 ;
static int alloueLink = 0 ;
static int alloueList = 0 ;
static int freedLink = 0 ;
static int freedList = 0 ;


/****************************************************************************
 *                         fonction initConeMem();                          *
 ****************************************************************************/
static void * initConeMem()
{
cone_list * cone=(cone_list*)mbkalloc(CONE_PAQUET * (sizeof(cone_list)));
conePage=addchain((chain_list*)NULL,(void*)cone);
FREED_CONE = NULL ;
idxCone = 1 ;
coneAvailable = cone ;
}

/****************************************************************************
 *                         fonction initLinkMem();                          *
 ****************************************************************************/
static void * initLinkMem()
{
link_list * link=(link_list*)mbkalloc(LINK_PAQUET * (sizeof(link_list)));
linkPage=addchain((chain_list*)NULL,(void*)link);
FREED_LINK = NULL ;
idxLink = 1 ;
linkAvailable = link ;
}

/****************************************************************************
 *                         fonction initListMem();                          *
 ****************************************************************************/
static void * initListMem()
{
list_list * list=(list_list*)mbkalloc(LIST_PAQUET * (sizeof(list_list)));
listPage=addchain((chain_list*)NULL,(void*)list);
FREED_LIST = NULL ;
idxList = 1 ;
listAvailable = list ;
}

/****************************************************************************
 *                         fonction addConePage();                          *
 ****************************************************************************/
static void * addConePage()
{
cone_list * cone=(cone_list*)mbkalloc(CONE_PAQUET * (sizeof(cone_list)));
conePage=addchain(conePage,(void*)cone);
idxCone = 1 ;
coneAvailable = cone ;
}

/****************************************************************************
 *                         fonction addLinkPage();                          *
 ****************************************************************************/
static void * addLinkPage()
{
link_list * link=(link_list*)mbkalloc(LINK_PAQUET * (sizeof(link_list)));
linkPage=addchain(linkPage,(void*)link);
idxLink = 1 ;
linkAvailable = link ;
}

/****************************************************************************
 *                         fonction addListPage();                          *
 ****************************************************************************/
static void * addListPage()
{
list_list * list=(list_list*)mbkalloc(LIST_PAQUET * (sizeof(list_list)));
listPage=addchain(listPage,(void*)list);
idxList = 1 ;
listAvailable = list ;
}

/****************************************************************************
 *                         fonction dsbGetFreeCone();                       *
 ****************************************************************************/
cone_list * dsbGetFreeCone()
{
cone_list * res ;

   if(FREED_CONE!=NULL)
   {
   res=FREED_CONE ;
   FREED_CONE=FREED_CONE->NEXT ;
   res->NEXT=NULL ;
   return(res);
   }

   if(idxCone<CONE_PAQUET)
   {
   idxCone++;
   coneAvailable++ ;
   coneAvailable->NEXT=NULL;
   return(coneAvailable);
   }
   else
   {
   addConePage();
   coneAvailable->NEXT=NULL;
   return(coneAvailable);
   }
}

/****************************************************************************
 *                         fonction dsbGetFreeLink();                       *
 ****************************************************************************/
link_list * dsbGetFreeLink()
{
link_list * res ;

   if(FREED_LINK!=NULL)
   {
   res=FREED_LINK ;
   FREED_LINK=FREED_LINK->NEXT ;
   res->NEXT=NULL ;
   recupLink++;
   return(res);
   }

   if(idxLink<LINK_PAQUET)
   {
   idxLink++;
   linkAvailable++ ;
   linkAvailable->NEXT=NULL;
   alloueLink ++ ;
   return(linkAvailable);
   }
   else
   {
   addLinkPage();
   linkAvailable->NEXT=NULL;
   alloueLink ++ ;
   return(linkAvailable);
   }
}

/****************************************************************************
 *                         fonction dsbGetFreeList();                       *
 ****************************************************************************/
list_list * dsbGetFreeList()
{
list_list * res ;

   if(FREED_LIST!=NULL)
   {
   res=FREED_LIST ;
   FREED_LIST=FREED_LIST->NEXT ;
   res->NEXT=NULL ;
   recupList++;
   return(res);
   }

   if(idxList<LIST_PAQUET)
   {
   idxList++;
   listAvailable++ ;
   listAvailable->NEXT=NULL;
   alloueList++;
   return(listAvailable);
   }
   else
   {
   addListPage();
   listAvailable->NEXT=NULL;
   alloueList++;
   return(listAvailable);
   }
}

/****************************************************************************
 *                         fonction dsbFreeCone();                          *
 ****************************************************************************/
void  * dsbFreeCone(cone)
cone_list * cone ;
{
cone->NEXT=FREED_CONE ;
FREED_CONE=cone ;
}

/****************************************************************************
 *                         fonction dsbFreeLink();                          *
 ****************************************************************************/
void  * dsbFreeLink(link)
link_list * link ;
{
link->NEXT=FREED_LINK ;
FREED_LINK=link ;
freedLink++;
}

/****************************************************************************
 *                         fonction dsbFreeList();                          *
 ****************************************************************************/
void  * dsbFreeList(list)
list_list * list ;
{
list->NEXT=FREED_LIST ;
FREED_LIST=list ;
freedList++;
}

/****************************************************************************
 *                         fonction dsbInitMem();                           *
 ****************************************************************************/
void * dsbInitMem()
{
initConeMem();
initLinkMem(); 
initListMem(); 
}

void * dsbRecapRecup()
{
printf("-------------------\n");
printf("link alloues   : %6d",alloueLink);
printf(" - %8ld\n",alloueLink*(sizeof(link_list)));
printf("link liberes   : %6d\n",freedLink);
printf("link recuperes : %6d\n",recupLink);
printf("-------------------\n");
printf("list alloues   : %6d",alloueList);
printf(" - %8ld\n",alloueList*(sizeof(list_list)));
printf("list liberes   : %6d\n",freedList);
printf("list recuperes : %6d\n",recupList);
fflush(stdout);
}
