/***
*	ERIC CHABOD
*	ANTOINE MARTIN
*	D.E.A. M.E.M.I. 1992
*
*   Laurent WINCKEL
*
*	PROJET BSG : Barrel Shifter Generator
*
*	NOM:	 bsg_netl.c
*   VERSION: 2.00
*	DATE:	 (29/09/1993)
*	OBJET:	 generation de la netlist.
*/

static char *netl_ident="@(#)(BSG) netlist view generation, version 2.00 (29/09/1993)";

static void gen_netlist( msb0 )
long msb0;
{
	long i;

	DEF_LOFIG( name );


	if ( msb0 )	
		for( i = 0; i <= ad_size; i++ )
			LOCON( NAME( "in_s[%d]", i ), IN, NAME( "in_s[%d]", i ) );
	else
		for( i = ad_size; i >= 0; i-- )
			LOCON( NAME( "in_s[%d]", i ), IN, NAME( "in_s[%d]", i ) );

	LOCON( "left", IN, "left" );
	LOCON( "rot", IN, "rot" );
	LOCON( "ext", IN, "ext" );

	if ( msb0 )	
	{
		for( i = 0; i <= size; i++ )
			LOCON( NAME( "in_d[%d]", i ), IN, NAME( "in_d[%d]", i ) );
	
		for( i = 0; i <= size; i++ )
			LOCON( NAME( "out_d[%d]", i ), OUT, NAME( "out_d[%d]", i ) );
	}
	else
	{
		for( i = size; i >= 0; i-- )
			LOCON( NAME( "in_d[%d]", i ), IN, NAME( "in_d[%d]", i ) );

		for( i = size; i >= 0; i-- )
			LOCON( NAME( "out_d[%d]", i ), OUT, NAME( "out_d[%d]", i ) );
	}

	/***
	*	alimentations
	*/
#ifdef  PUT_ALIM
	LOCON( "vdd", IN, "vdd" );
	LOCON( "vss", IN, "vss" );
#endif

	SAVE_LOFIG();
/*
	PRINTF( "Netlist generated...\n" );
*/
}
