/***
*	ERIC CHABOD
*	ANTOINE MARTIN
*	D.E.A. M.E.M.I. 1992
*
*   Laurent WINCKEL
*
*	PROJET BSG : Barrel Shifter Generator
*
*	NOM:	 bsg_main.c
*   VERSION: 2.00
*	DATE:	 (30/09/1993)
*	OBJET:	 fonction principale.
*/

static char *main_ident="@(#)(BSG) main, version 2.00 (30/09/1993)";

/*
 * $Log: main.c,v $
 *
 * Version 2.00  02/08/1993  bsg
 * up-date for alliance 2.0 (by Laurent WINCKEL).
 *
 * Revision 1.5  1993/01/19  18:21:46  bsg
 * the banner has changed, outline is available, standard whith RSA.
 *
 * Revision 1.3  1992/12/31  17:59:26  bsg
 * Afin d'etre sur que ca marche, on garde les meme noms d'instances
 * des cellules de decodage, mais on change uniquement les noms de modele
 * instancie. ainsi sont apparrues de nouvelles cellules:
 * bsdandh8_c,bsdandh16_c,bsdandh32_c,bsdandh64_c qui sont les memes cellules
 * que les sans h, mais sans le fils qui va vers les buffers d'adresses
 * nome com_1 et com_2. Pour les cellules de decodage impaire, ont disparues
 * bs_dandi16,bs_dandi32,bs_dandi64 remplacees par bsdandhi16_c,bsdandhi32_c,
 * bsdandhi64_c qui sont les meme mais sans le fils com_1 et com_2. Est
 * arrive egalement la cellule bsdandhi8_c qui est la meme que bsdandi8_c
 * mais sans com_1 et com_2. bsdandi8_c et bsdandi4_c reste les memes.
 * Il serait peut-etre bon dans un avenir lointain de tracer des fils,
 * plutot que de creer des cellules a tout va ...
 *
 * Revision 1.2  1992/12/31  13:26:55  bsg
 * L'entete d'appel est changer afin de gerer automatiquement le numero
 * de version
 *
 *
 */

#include "bsg_head.h"
#include "gbs200.h"

#include <string.h>

int main( argc, argv )
int argc;
char *argv[];
{
	long bits = 0L;
    long virtual = 0L;
    long msb0 = 0L;
	char *name = NULL;
    long layout = 0L, icon = 0L, vhdl = 0L, patterns = 0L, datasheet = 0L;
    long physical_box = 0L, logical_box = 0L;
	
	long i;
    char *prog_name, *result; 
	
	if((prog_name=strrchr(argv[0], '/'))!=NULL)
	    prog_name++;
	else
		prog_name=argv[0];
	
	if ( argc == 1 )
	{
		fprintf( stderr, "Usage: %s bits [-virtual] [-msb0]\n",prog_name );
		fprintf( stderr, "            [-layout] [-icon] [-vhdl] [-patterns] [-datasheet]\n" );
 	    fprintf( stderr, "            [-physical_box] [-logical_box]\n");
	    fprintf( stderr, "            [-o name_prefix]\n");

/*
		fprintf( stderr, "\nWhere options are:\n\n" );
		fprintf( stderr, " - bits      : number of bits. Must be in range 3-64.\n" );
		fprintf( stderr, " - bs_name   : cell name. Maximum 9 caracters long.\n" );
		fprintf( stderr, " - layout    : layout view generation.\n" );
		fprintf( stderr, " - steady     : when layout is selected, generate steady\n" );
		fprintf( stderr, "               connectors instead of virtuals.\n" );
		fprintf( stderr, " - netlist   : netlist view generation.\n" );
		fprintf( stderr, " - vhdl      : behavioral view and patterns generation.\n" );
		fprintf( stderr, " - outline   : outline view generation.\n" );
		fprintf( stderr, " - datasheet : datasheet generation.\n" );
*/

		exit( 1 );
	}

	bits = atoi( argv[1] );
	if ( bits < 3 || bits > 64 ) 
		bsg_argh( 1 );

	for( i = 2; i < argc; i++ )
	{
		if ( strcmp( argv[i], "-virtual" ) == 0 )
			virtual = 1L;
		else
		if ( strcmp( argv[i], "-msb0" ) == 0 )
			msb0 = 1L;
		else
		if ( strcmp( argv[i], "-layout" ) == 0 )
			layout = 1L;
		else
		if ( strcmp( argv[i], "-icon" ) == 0 )
			icon = 1L;
		else
		if ( strcmp( argv[i], "-vhdl" ) == 0 )
			vhdl = 1L;
		else
		if ( strcmp( argv[i], "-patterns" ) == 0 )
			patterns = 1L;
		else
		if ( strcmp( argv[i], "-datasheet" ) == 0 )
			datasheet = 1L;
		else
		if ( strcmp( argv[i], "-physical_box" ) == 0 )
			physical_box = 1L;
		else
		if ( strcmp( argv[i], "-logical_box" ) == 0 )
			logical_box = 1L;
		else
		if ( strcmp( argv[i], "-o") == 0 )
		{
/*
			long l;
*/

            i++;
            if ( i>=argc )
                bsg_argh( 10 );

			name = argv[i];
/*
			l = strlen( name );
			if ( l > 9 )
				bsg_argh( 5 );
*/
		}
		else
		{
        	fprintf( stderr, "\nError. Unknown parameter \"%s\".\nProgram aborted.\n\n", argv[i] );
         	exit( 1 );
		}
	}

	if( !layout && !icon && !vhdl && !patterns && !datasheet && !physical_box && !logical_box )
         bsg_argh( 8 ) ;

	if( layout && physical_box )
         bsg_argh( 9 ) ;

    alliancebanner("BSG", "2.00", "Barrel Shifter Generator", "1993", ALC_VER);

/*
	if ( v & V_LAYOUT )
		printf( "layout view has to be generated...\n" );
	if ( v & V_SOLID )
		printf( "steady connectors will be used instead of virtual ones...\n" );
	if ( v & V_NETLIST )
		printf( "netlist view has to be generated...\n" );
	if ( v & V_VHDL )
		printf( "vhdl v has to be generated...\n" );
	if ( v & V_OUTLINE )
		printf( "outline view has to be generated...\n" );
	if ( v & V_DATASHEET )
		printf( "datasheet has to be generated...\n" );

	printf("\n\n\n");
*/

	/***
	*	c'est bon. on peut y aller
	*/

	result=bsg( bits, virtual, msb0, name, layout, icon, vhdl, patterns, datasheet,
        physical_box, logical_box);

    if(!datasheet)
        printf("The prefix of all generated files is \"%s\".\n\n", result);

	return (0);

}
