/***
*	ERIC CHABOD
*	ANTOINE MARTIN
*	D.E.A. M.E.M.I. 1992
*
*   Laurent WINCKEL
*
*	PROJET BSG : Barrel Shifter Generator
*
*	NOM:	 bsg_disp.c
*   VERSION: 2.00
*	DATE:	 (06/01/1994)
*	OBJET:	 fonction generale de generation.
*/

static char *disp_ident="@(#)(BSG) dispatch, version 2.00 (06/01/1994)";

/*******************************************************************/

#include "bsg_head.h"

/*******************************************************************/

/* nombre de bits de donnees et d'adresse; nombre de bit slices */
static long size, ad_size, bs_size;

/* nombre d'adresses generables a partir de tous les bits d'adresse */
static long r_size;

/* nom du shifter */
static char *name;

static char *errors[] = {
"You may specify the number of data bits.",
"The number of data bits must be in range 3-64.",
"Cannot open behaviour file.",
"Cannot open pattern file.",
"Circuit name cannot be a null string.",
"Circuit name too long",
"Unknown parameter.",
"Cannot open datasheet file.",
"One view must be specified.",
"layout and a physical_box view cannot be used at same time.",
"\"name_prefix\" missing after \"-o\" option.",
};

/*******************************************************************/

#include "bsg_layo.c"
#include "bsg_icon.c"
#include "bsg_vhdl.c"
#include "bsg_patt.c"
#include "bsg_data.c"
#include "bsg_netl.c"

/*******************************************************************/

/***
*	fonction d'erreur.
*/
void bsg_argh( err )
long err;
{
	fprintf( stderr, "\nError. %s\nProgram aborted.\n\n", errors[err] );
	exit( err + 1 );
}

/***
* fonction globale
*/
char *bsg( bits, virtual, msb0, n, layout, icon, vhdl, patterns, datasheet,
    physical_box, logical_box )
long bits, virtual, msb0;
char *n;
long layout, icon, vhdl, patterns, datasheet, physical_box, logical_box;
{
	size = bits;

/* Verify all parameters. */

	if ( size < 3 || size > 64 ) 
		bsg_argh( 1 );

	bs_size = ( (size + 1) / 2) - 1;

	size--;

	if ( size < 4 ) 
	{
		ad_size = 1;
		r_size = 4;
	}
	else if ( size < 8 ) 
	{
		ad_size = 2;
		r_size = 8;
	}
	else if ( size < 16 ) 
	{
		ad_size = 3;
		r_size = 16;
	}
	else if ( size < 32 ) 
	{
		ad_size = 4;
		r_size = 32;
	}
	else 
	{
		ad_size = 5;
		r_size = 64;
	}

/*
	if ( STRLEN( n ) > 9 )
        bsg_argh( 5 );
*/
		
	if( !layout && !icon && !vhdl && !patterns && !datasheet && !physical_box && !logical_box )
         bsg_argh( 8 ) ;

	if( layout && physical_box )
         bsg_argh( 9 ) ;

/* Calculate a prefix for resulting blocks. */

    if ( n == NULL || STRLEN( n ) == 0 )
		name = NAME( "bs%d%s%s", size + 1, virtual ? "v" : "", msb0 ? "m" : "" );
	else
		name = n;

/*
	PRINTF( "Shifter name:   %s.\n", name );
	PRINTF( "Shifter size:   %d bits.\n", bits );
	PRINTF( "Address size:   %d bits.\n\n\n\n", ad_size + 1 );
*/

    mbkenv ();

/* Call view generators. */

	if ( layout || physical_box )
		gen_layout( virtual, msb0, physical_box ); 

	if ( icon )
		gen_icon( msb0 );

	if ( vhdl )
		gen_vbe( msb0 );

    if ( patterns )
		gen_pat( msb0 );

	if ( datasheet )
		gen_dsh( bits, virtual, msb0 );
	
	if ( physical_box ) 
	{
        OUTLINE() ;
    	SAVE_PHFIG();
	}

	if ( logical_box )
		gen_netlist( msb0 );

	return (name);
}
