
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_rmvberin.c					*/
/* date		: Sep  3 1993						*/
/* version	: v106							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: low-level function					*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <stdio.h>
#include MUT_H
#include LOG_H
#include BEH_H

/* ###--------------------------------------------------------------### */
/* function	: beh_rmvberin						*/
/* description	: delete a BERIN structure and return the pointer of	*/
/*		  the next object.					*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

struct berin *beh_rmvberin (listberin, berinname)

struct berin *listberin;	/* list of berin containing the object	*/
char         *berinname;	/* name of the BERIN to be deleted	*/

  {
  struct berin  headrin;
  struct berin *ptlastrin;
  struct berin *ptberin;

  if (listberin != NULL)
    {

	/* ###------------------------------------------------------### */
	/*    Search the object to be deleted				*/
	/* ###------------------------------------------------------### */

    headrin.NEXT = listberin;
    ptberin      = &headrin;
    while ((ptberin != NULL) && (ptberin->NAME != berinname))
      {
      ptlastrin = ptberin;
      ptberin   = ptberin->NEXT;
      }

    if (ptberin != NULL)
      {

	/* ###------------------------------------------------------### */
	/*    If the object doesn't exist return the list without	*/
	/* modification.						*/
	/* ###------------------------------------------------------### */

      ptlastrin->NEXT = ptberin->NEXT;
      mbkfree (ptberin);
      }

    listberin = headrin.NEXT;
    }

  return(listberin);
  }
