
/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : bibliotheques logiques                                      */
/*    Fichier : log120.h                                                    */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Burgun L.                             le : 26/01/92       */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#undef OR
#undef AND
#undef XOR
#undef NOT
#undef NOR
#undef NAND
#undef NXOR
#undef CONTRAINT
#undef STABLE

#define OR 0
#define AND 1
#define XOR 2 
#define NOT 3 
#define NOR 4 
#define NAND 5 
#define NXOR 6  
#define CONTRAINT 7  
#define STABLE 8  

/* ==============================================================
   La bibliotheque des Arbres binaires Lisp-like version 23/08/91
   Burgun L.
   Structures de donnees
   ==============================================================*/



/*-----------  Fonctions Lisp-Like de bas-niveau  -------------*/

#define CDR(expr) (expr->NEXT)
#define CAR(expr) ((chain_list *) expr->DATA)
#define CADR(expr) CAR(CDR(expr))
#define ATOM(expr) (!expr->NEXT)
#define VALUE_ATOM(expr) (char *) expr->DATA
#define OPER(expr) ((short) (CAR(expr))->DATA)


/*--  Declaration des fonctions et procedures de prefbib.c  --*/

/*-- fonctions de creation --*/

chain_list *createAtom();
chain_list *createExpr();
chain_list *createBinExpr();
chain_list *notExpr();
chain_list *charToExpr();
void addHExpr();
void addQExpr();
void freeExpr();

/*-- fonctions d'affichage --*/

char *operToChar();
int charToOper();
void displayExpr();
char *exprToChar();
char *identExpr();

/*-- fonctions de parcours --*/

void mapExpr();
chain_list *mapCarExpr();
int anyExpr();
int everyExpr();

/*-- fonctions de caracterisation --*/

int equalExpr();
int equalVarExpr();
int searchExpr();
int searchOperExpr();
int lengthExpr();
int profExpr();
int numberAtomExpr();
int numberOccExpr();
chain_list *supportChain_listExpr();
ptype_list *supportPtype_listExpr();

/*-- fonctions de modification physique ou de recopie --*/

chain_list *copyExpr();
chain_list *flatPolarityExpr();
chain_list *devXor2Expr();
chain_list *devXorExpr();
chain_list *substExpr();
void substPhyExpr();
void flatArityExpr();
chain_list *maxExpr();
chain_list *minExpr();
void sortExpr();
void normExpr();
chain_list *searchNumExpr();
void deleteNumExpr();
chain_list *simplifNotExpr();
chain_list *simplif10Expr();
int PMExpr();
void changeOperExpr();
