/* ###--------------------------------------------------------------### */
/*									*/
/* file		: dx_defs.h						*/
/* date		: Mar 31 1993						*/
/* version	: v0.1							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* description	: DLX assembler - defines (operation codes)		*/
/*									*/
/* ###--------------------------------------------------------------### */

#define DLX_PLSDFN 0
#define DLX_MNSDFN 1
#define DLX_SHLDFN 2
#define DLX_SHRDFN 3
#define DLX_ORDFN  4
#define DLX_ANDDFN 5
#define DLX_XORDFN 6

#define DLX_HSZDFN 97
#define DLX_ALODFN 20

#define DLX_PIPDFN 1			/* pipeline architecture	*/
#define DLX_MICDFN 0			/* micro-programmed architecture*/

#define _ADD	0x00000000
#define _ADDU	0x04000000
#define _SUB	0x08000000
#define _SUBU	0x0c000000
#define _ADDI	0x10000000
#define _ADDUI	0x14000000
#define _SUBI	0x18000000
#define _SUBUI	0x1c000000

#define _SLL	0x20000000
#define _SRL	0x24000000
#define _SRA	0x28000000
#define _SLLI	0x30000000
#define _SRLI	0x34000000
#define _SRAI	0x38000000
#define _LHI	0x3c000000

#define _SEQ	0x40000000
#define _SNE	0x44000000
#define _SGE	0x48000000
#define _SLE	0x4c000000
#define _SEQI	0x50000000
#define _SNEI	0x54000000
#define _SGEI	0x58000000
#define _SLEI	0x5c000000

#define _SGT	0x68000000
#define _SLT	0x6c000000
#define _SGTI	0x78000000
#define _SLTI	0x7c000000

#define _AND	0x80000000
#define _OR	0x84000000
#define _XOR	0x8C000000
#define _ANDI	0x90000000
#define _ORI	0x94000000
#define _XORI	0x9C000000

#define _SW	0xa0000000
#define _SH	0xa4000000
#define _SB	0xa8000000
#define _LBU	0xac000000
#define _LW	0xb0000000
#define _LH	0xb4000000
#define _LB	0xb8000000
#define _LHU	0xbc000000

#define _JR	0xc0000000
#define _JALR	0xc4000000
#define _MOVS2I	0xc8000000
#define _MOVI2S	0xcc000000
#define _BEQZ	0xd0000000
#define _BNEZ	0xd4000000

#define _J	0xe0000000
#define _JAL	0xe4000000
#define _RFE	0xe8000000
#define _TRAP	0xec000000

#define _NOP	0x00100000
#define _LOADI	0x01100000

#define _IAR	0x00000011
#define _SR	0x00000012
#define _TVR	0x00000014
