
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: vh_ltype.h						*/
/* date		: Sep 18 1992						*/
/* version	: v1.6							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* contents	: This file contains data structure definitions		*/
/*		  generated by the linker				*/
/*									*/
/* ###--------------------------------------------------------------### */

	/* ###------------------------------------------------------### */
	/*    Data Structure Definitions				*/
	/* ###------------------------------------------------------### */

typedef struct lkdfig			/* linked figure		*/
  {
  struct lkdfig	*NEXT;			/* next figure			*/
  char		*NAME;			/* figure's name		*/
  struct lkdins	*LKDINS;		/* list of instances		*/
  struct simsig	*SIMSIG;		/* list of simple signals	*/
  struct bussig	*BUSSIG;		/* list of bused signals	*/
  unsigned int   VALSIZ;		/* # of bytes needed for values	*/
  }
lkdfig_list;

typedef struct lkdins			/* linked instance		*/
  {
  struct lkdins  *NEXT;			/* next instance		*/
  char           *INSNAME;		/* instance's name		*/
  struct befig   *BEFIG;		/* instance model		*/
  struct wrssig  *WRSSIG;		/* written output ports		*/
  struct wriaux  *WRIAUX;		/* written internal signals	*/
  struct wribux  *WRIBUX;		/* written internal bused sig.	*/
  struct wrbsig  *WRBSIG;		/* written bused ports		*/
  struct wrireg  *WRIREG;		/* written registers		*/
  struct redlst  *REDLST;		/* read values			*/
  struct circuit *CIRCUI;		/* Circuit pointer used for BDDs*/
  char            EVAL;			/* Evaluation's flag		*/
  }
lkdins_list;

typedef struct simsig			/* simple signal		*/
  {
  struct simsig	*NEXT;			/* next simple signal		*/
  struct chain	*NAMECHAIN;		/* signal's name		*/
  struct chain	*REDINS;		/* list of instances reading the*/
					/* signal			*/
  char		*CURVAL;		/* signal's current value	*/
  char		 PRJVAL;		/* signal's projected value	*/
  }
simsig_list;

typedef struct bussig			/* bused signal			*/
  {
  struct bussig	*NEXT;			/* next simple signal		*/
  struct chain	*NAMECHAIN;		/* signal's name		*/
  struct chain	*REDINS;		/* list of instances reading the*/
					/* signal			*/
  char		*CURVAL;		/* signal's current value	*/
  struct prjbvl	*PRJBVL;		/* list of projected bi-values	*/
  char		 TYPE;			/* signal's type		*/
  }
bussig_list;

typedef struct wrbsig			/* written bused signal		*/
  {
  struct wrbsig	*NEXT;			/* next signal			*/
  struct bebus  *BEBUS;			/* formal bused signal (model)	*/
  struct bussig *BUSSIG;		/* actual bused signal		*/
  struct prjbvl *PRJBVL;		/* list of projected bi-values	*/
  }
wrbsig_list;

typedef struct wriaux                   /* written auxiliary signal 	*/
  {
  struct wriaux *NEXT;			/* next auxiliary signal       	*/
  struct lkdins	*LKDINS;		/* instance reading the aux.    */
  struct beaux  *BEAUX;			/* formal internal sig. (model)	*/
  char          *CURVAL;                /* aux. signal current value	*/
  char           PRJVAL;		/* aux. signal projected value  */
  }
wriaux_list;

typedef struct wrireg			/* written register		*/
  {
  struct wrireg	*NEXT;			/* next register		*/
  struct lkdins	*LKDINS;		/* instance reading the register*/
  struct bereg  *BEREG;			/* formal register (model)	*/
  char		*CURVAL;		/* register's current value	*/
  struct prjrvl *PRJRVL;		/* list of projected bi-values	*/
  }
wrireg_list;

typedef struct wribux			/* written internal bused sig.	*/
  {
  struct wribux	*NEXT;			/* next signal			*/
  struct lkdins	*LKDINS;		/* instance reading the register*/
  struct bebux  *BEBUX;			/* formal bused signal (model)	*/
  char		*CURVAL;		/* register's current value	*/
  struct prjbvl *PRJBVL;		/* list of projected bi-values	*/
  }
wribux_list;

typedef struct wrssig			/* written simple signal	*/
  {
  struct wrssig *NEXT;			/* next object			*/
  struct beout 	*BEOUT;			/* formal output port (model)	*/
  struct simsig	*SIMSIG;		/* actual signal		*/
  }
wrssig_list;

typedef struct redlst			/* list of read values		*/
  {
  struct redlst *NEXT;			/* next value			*/
  char          *VALU;			/* pointer on the value		*/
  }
redlst_list;

typedef struct prjbvl			/* projected bi-value		*/
  {
  struct prjbvl *NEXT;			/* next bi-value (local)	*/
  struct prjbvl *GLNEXT;		/* next bi-value (global)	*/
  char		 CNDVAL;		/* driver's condition value	*/
  char		 DRVVAL;		/* drove value			*/
  }
prjbvl_list;

typedef struct prjrvl			/* projected bi-value		*/
  {
  struct prjrvl *NEXT;			/* next bi-value		*/
  char		 CNDVAL;		/* driver's condition value	*/
  char		 DRVVAL;		/* drove value			*/
  }
prjrvl_list;
