
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: vh_debug.c						*/
/* date		: Aug 30 1993						*/
/* version	: v1.92							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* description	: Asimut's structure debugger.				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <stdio.h>
#include MUT_H
#include MLO_H
#include BEH_H
#include PAT_H
#include LOG_H
#include "vh_ltype.h"
#include "vh_dtype.h"
#include "vh_debug.h"

char *vhd_getcmd (prvcmd)

char prvcmd[3][20];

  {
  char readstr[60];
  char comd0[20];
  char comd1[20];
  char comd2[20];
  int  code;

  printf ("\n\n\n COMMAND >> ");
  fflush (stdout);
  comd0[0] = '\0';
  comd1[0] = '\0';
  comd2[0] = '\0';
  gets   (readstr);
  sscanf (readstr,"%s%s%s",comd0,comd1,comd2);

  if (strcmp(comd0,"."))
    {
    strcpy (prvcmd[0], comd0);
    strcpy (prvcmd[1], comd1);
    strcpy (prvcmd[2], comd2);
    }

  printf ("\n\n\n\n\n");
  return (prvcmd[0]);
  }

void dast_dbg (head_pnt,stru_name)

void  *head_pnt;
char  *stru_name;

  {

  char          *buffer=NULL;
  unsigned int   buff_size = 100;
  char          *key[VHD_MAXDFN];
  char		*tab[VHD_MAXDFN];
  void		*nxt[VHD_MAXDFN];
  short		 typ[VHD_MAXDFN];

  int		 i;
  int		 state;
  int		 newsta0;
  int		 newsta1;
  char          *readcmd = NULL;
  char		 readtab[3][20];
  int		 stk_pnt = 0;
  int            type = VHD__exitDFN;

  struct chain	*ptr_abl;
  struct chain	*nam_lst;

  struct lofig	*lofig_pnt;
  struct locon	*locon_pnt;
  struct losig	*losig_pnt;
  struct loins	*loins_pnt;
  struct ptype	*ptype_pnt;

  struct befig	*befig_pnt;
  struct bereg	*bereg_pnt;
  struct bemsg	*bemsg_pnt;
  struct beout	*beout_pnt;
  struct bebux	*bebux_pnt;
  struct bebus	*bebus_pnt;
  struct beaux	*beaux_pnt;
  struct bepor	*bepor_pnt;
  struct begen	*begen_pnt;
  struct biabl	*biabl_pnt;
  struct binode	*binode_pnt;
  struct berin	*berin_pnt;

  struct paseq  *paseq_pnt;
  struct pacom  *pacom_pnt;
  struct papat  *papat_pnt;
  struct paini  *paini_pnt;
  struct paevt  *paevt_pnt;
  struct paiol  *paiol_pnt;
  struct pagrp  *pagrp_pnt;

  struct lkdfig *lkdfig_pnt;
  struct lkdins *lkdins_pnt;
  struct simsig *simsig_pnt;
  struct bussig *bussig_pnt;
  struct redlst *redlst_pnt;
  struct wrbsig *wrbsig_pnt;
  struct wrssig *wrssig_pnt;
  struct wrireg *wrireg_pnt;
  struct wriaux *wriaux_pnt;
  struct wribux *wribux_pnt;
  struct prjbvl *prjbvl_pnt;
  struct prjrvl *prjrvl_pnt;

  struct chain	*chain_pnt;

  struct circuit *circuit_pnt;

  struct typoin  cur_pnt;
  struct typoin  stk[VHD_STKSIZ];

  char           empty[4];
  char           avail[12];

  buffer  = mbkalloc (buff_size);

  strcpy (empty,"");
  strcpy (avail,"AVAILABLE");

  key[VHD__setDFN]   = "_set";
  key[VHD__upDFN]    = "_up";
  key[VHD__topDFN]   = "_top";
  key[VHD__stopDFN]  = "_stop";
  key[VHD__backDFN]  = "_back";
  key[VHD__exitDFN]  = "_exit";

  key[VHD_lofigDFN]  = "lofig";
  key[VHD_loconDFN]  = "locon";
  key[VHD_losigDFN]  = "losig";
  key[VHD_loinsDFN]  = "loins";
  key[VHD_rootDFN]   = "root";
  key[VHD_nextDFN]   = "next";
  key[VHD_userDFN]   = "user";
  key[VHD_ptypeDFN]  = "ptype";

  key[VHD_befigDFN]  = "befig";
  key[VHD_beregDFN]  = "bereg";
  key[VHD_bemsgDFN]  = "bemsg";
  key[VHD_berinDFN]  = "berin";
  key[VHD_beoutDFN]  = "beout";
  key[VHD_bebusDFN]  = "bebus";
  key[VHD_beauxDFN]  = "beaux";
  key[VHD_bedlyDFN]  = "bedly";
  key[VHD_bebuxDFN]  = "bebux";
  key[VHD_beporDFN]  = "bepor";
  key[VHD_biablDFN]  = "biabl";
  key[VHD_binodeDFN] = "binode";

  key[VHD_lkdfigDFN] = "lkdfig";
  key[VHD_lkdinsDFN] = "lkdins";
  key[VHD_simsigDFN] = "simsig";
  key[VHD_bussigDFN] = "bussig";
  key[VHD_wrbsigDFN] = "wrbsig";
  key[VHD_wriregDFN] = "wrireg";
  key[VHD_wrssigDFN] = "wrssig";
  key[VHD_wriauxDFN] = "wriaux";
  key[VHD_wribuxDFN] = "wribux";
  key[VHD_redlstDFN] = "redlst";
  key[VHD_redinsDFN] = "redins";
  key[VHD_prjbvlDFN] = "prjbvl";
  key[VHD_prjrvlDFN] = "prjrvl";
  key[VHD_glnextDFN] = "glnext";

  key[VHD_dataDFN]   = "data";

  key[VHD_levelDFN]  = "level";
  key[VHD_curvalDFN] = "curval";
  key[VHD_prjvalDFN] = "prjval";
  key[VHD_typeDFN]   = "type";
  key[VHD_cndvalDFN] = "cndval";
  key[VHD_drvvalDFN] = "drvval";

  key[VHD_paseqDFN]  = "paseq";
  key[VHD_pacomDFN]  = "pacom";
  key[VHD_papatDFN]  = "papat";
  key[VHD_painiDFN]  = "paini";
  key[VHD_paevtDFN]  = "paevt";
  key[VHD_paiolDFN]  = "paiol";
  key[VHD_pagrpDFN]  = "pagrp";
  key[VHD_deccomDFN] = "deccom";
  key[VHD_oldcomDFN] = "oldcom";
  key[VHD_curcomDFN] = "curcom";
  key[VHD_oldpatDFN] = "oldpat";
  key[VHD_curpatDFN] = "curpat";
  key[VHD_nxtpatDFN] = "nxtpat";
  key[VHD_sigDFN]    = "sig";

  key[VHD_valuDFN]   = "valu";

  key[VHD_begenDFN]  = "begen";

  for (i=0 ; i<VHD_MAXDFN ; i++)
    {
    if (!strcmp (stru_name, key[i]))
      {
      type = i;
      break;
      }
    }
  if (head_pnt == NULL)
    type = VHD__exitDFN;
  cur_pnt.data = head_pnt;
  cur_pnt.type = type;
  state        = type;

  while (state != VHD__exitDFN)
    {

    for (i=0 ; i<VHD_MAXDFN ; i++)
      {
      tab[i] = empty;
      nxt[i] = NULL;
      typ[i] = i;
      }

    tab[VHD__exitDFN] = avail;
    tab[VHD__setDFN] = avail;
    tab[VHD__stopDFN] = avail;

    if (stk_pnt != 0)
      {
      tab[VHD__upDFN] = avail;
      tab[VHD__topDFN] = avail;
      tab[VHD__backDFN] = avail;
      }

    switch (state)
      {
      case (VHD_lofigDFN):

	/* ###------------------------------------------------------### */
	/*			lofig					*/
	/* ###------------------------------------------------------### */

        lofig_pnt = (struct lofig *)(cur_pnt.data);

        if (lofig_pnt->LOCON != NULL)
          {
          tab[VHD_loconDFN] = avail;
          nxt[VHD_loconDFN] = (void *)lofig_pnt->LOCON;
          typ[VHD_loconDFN] = VHD_loconDFN;
          }
        if (lofig_pnt->LOSIG != NULL)
          {
          tab[VHD_losigDFN] = avail;
          nxt[VHD_losigDFN] = (void *)lofig_pnt->LOSIG;
          typ[VHD_losigDFN] = VHD_losigDFN;
          }
        if (lofig_pnt->LOINS != NULL)
          {
          tab[VHD_loinsDFN] = avail;
          nxt[VHD_loinsDFN] = (void *)lofig_pnt->LOINS;
          typ[VHD_loinsDFN] = VHD_loinsDFN;
          }
        if (lofig_pnt->USER != NULL)
          {
          tab[VHD_userDFN] = avail;
          nxt[VHD_userDFN] = (void *)lofig_pnt->USER;
          typ[VHD_userDFN] = VHD_ptypeDFN;
          }
        if (lofig_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)lofig_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_lofigDFN;
          }

        printf ("   name        : %s\n",lofig_pnt->NAME);

        nam_lst = lofig_pnt->MODELCHAIN;
        printf ("   modelchain  :\n");
        while (nam_lst != NULL)
          {
          printf ("                 %s\n",(char *)nam_lst->DATA);
          nam_lst = nam_lst->NEXT;
          }
        printf ("   mode        : %c\n",lofig_pnt->MODE);
        printf ("-> locon       : %s\n",tab[VHD_loconDFN]);
        printf ("-> losig       : %s\n",tab[VHD_losigDFN]);
        printf ("-> loins       : %s\n",tab[VHD_loinsDFN]);
        printf ("-> user        : %s\n",tab[VHD_userDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_loconDFN):

	/* ###------------------------------------------------------### */
	/*			locon					*/
	/* ###------------------------------------------------------### */

        locon_pnt = (struct locon *)(cur_pnt.data);

        if (locon_pnt->SIG != NULL)
          {
          tab[VHD_sigDFN] = avail;
          nxt[VHD_sigDFN] = (void *)locon_pnt->SIG;
          typ[VHD_sigDFN] = VHD_losigDFN;
          }
        if (locon_pnt->ROOT != NULL)
          {
          tab[VHD_rootDFN] = avail;
          nxt[VHD_rootDFN] = (void *)locon_pnt->ROOT;
          if (locon_pnt->TYPE == 'E')
            typ[VHD_rootDFN] = VHD_lofigDFN;
          else
            typ[VHD_rootDFN] = VHD_loinsDFN;
          }
        if (locon_pnt->USER != NULL)
          {
          tab[VHD_userDFN] = avail;
          nxt[VHD_userDFN] = (void *)locon_pnt->USER;
          typ[VHD_userDFN] = VHD_ptypeDFN;
          }
        if (locon_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)locon_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_loconDFN;
          }

        printf ("   name        : %s\n",locon_pnt->NAME);
        printf ("-> sig         : %s\n",tab[VHD_sigDFN]);
        printf ("-> root        : %s\n",tab[VHD_rootDFN]);
        printf ("   direction   : %c\n",locon_pnt->DIRECTION);
        printf ("   type        : %c\n",locon_pnt->TYPE);
        printf ("-> user        : %s\n",tab[VHD_userDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_losigDFN):

	/* ###------------------------------------------------------### */
	/*			losig					*/
	/* ###------------------------------------------------------### */

        losig_pnt = (struct losig *)(cur_pnt.data);

        if (losig_pnt->USER != NULL)
          {
          tab[VHD_userDFN] = avail;
          nxt[VHD_userDFN] = (void *)losig_pnt->USER;
          typ[VHD_userDFN] = VHD_ptypeDFN;
          }
        if (losig_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)losig_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_losigDFN;
          }

        nam_lst = losig_pnt->NAMECHAIN;
        printf ("   namechain   :\n");
        while (nam_lst != NULL)
          {
          printf ("                 %s\n",(char *)nam_lst->DATA);
          nam_lst = nam_lst->NEXT;
          }
        printf ("   type        : %c\n",losig_pnt->TYPE);
        printf ("   index       : %ld\n",losig_pnt->INDEX);
        printf ("-> user        : %s\n",tab[VHD_userDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_loinsDFN):

	/* ###------------------------------------------------------### */
	/*			loins					*/
	/* ###------------------------------------------------------### */

        loins_pnt = (struct loins *)(cur_pnt.data);

        if (loins_pnt->LOCON != NULL)
          {
          tab[VHD_loconDFN] = avail;
          nxt[VHD_loconDFN] = (void *)loins_pnt->LOCON;
          typ[VHD_loconDFN] = VHD_loconDFN;
          }
        if (loins_pnt->USER != NULL)
          {
          tab[VHD_userDFN] = avail;
          nxt[VHD_userDFN] = (void *)loins_pnt->USER;
          typ[VHD_userDFN] = VHD_ptypeDFN;
          }
        if (loins_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)loins_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_loinsDFN;
          }

        printf ("   insname     : %s\n",loins_pnt->INSNAME);
        printf ("   figname     : %s\n",loins_pnt->FIGNAME);
        printf ("-> locon       : %s\n",tab[VHD_loconDFN]);
        printf ("-> user        : %s\n",tab[VHD_userDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_befigDFN):

	/* ###------------------------------------------------------### */
	/*			befig					*/
	/* ###------------------------------------------------------### */

        befig_pnt = (struct befig *)(cur_pnt.data);

        if (befig_pnt->BEREG != NULL)
          {
          tab[VHD_beregDFN] = avail;
          nxt[VHD_beregDFN] = (void *)befig_pnt->BEREG;
          typ[VHD_beregDFN] = VHD_beregDFN;
          }
        if (befig_pnt->BEMSG != NULL)
          {
          tab[VHD_bemsgDFN] = avail;
          nxt[VHD_bemsgDFN] = (void *)befig_pnt->BEMSG;
          typ[VHD_bemsgDFN] = VHD_bemsgDFN;
          }
        if (befig_pnt->BERIN != NULL)
          {
          tab[VHD_berinDFN] = avail;
          nxt[VHD_berinDFN] = (void *)befig_pnt->BERIN;
          typ[VHD_berinDFN] = VHD_berinDFN;
          }
        if (befig_pnt->BEOUT != NULL)
          {
          tab[VHD_beoutDFN] = avail;
          nxt[VHD_beoutDFN] = (void *)befig_pnt->BEOUT;
          typ[VHD_beoutDFN] = VHD_beoutDFN;
          }
        if (befig_pnt->BEBUS != NULL)
          {
          tab[VHD_bebusDFN] = avail;
          nxt[VHD_bebusDFN] = (void *)befig_pnt->BEBUS;
          typ[VHD_bebusDFN] = VHD_bebusDFN;
          }
        if (befig_pnt->BEBUX != NULL)
          {
          tab[VHD_bebuxDFN] = avail;
          nxt[VHD_bebuxDFN] = (void *)befig_pnt->BEBUX;
          typ[VHD_bebuxDFN] = VHD_bebuxDFN;
          }
        if (befig_pnt->BEAUX != NULL)
          {
          tab[VHD_beauxDFN] = avail;
          nxt[VHD_beauxDFN] = (void *)befig_pnt->BEAUX;
          typ[VHD_beauxDFN] = VHD_beauxDFN;
          }
        if (befig_pnt->BEDLY != NULL)
          {
          tab[VHD_bedlyDFN] = avail;
          nxt[VHD_bedlyDFN] = (void *)befig_pnt->BEDLY;
          typ[VHD_bedlyDFN] = VHD_beauxDFN;
          }
        if (befig_pnt->BEPOR != NULL)
          {
          tab[VHD_beporDFN] = avail;
          nxt[VHD_beporDFN] = (void *)befig_pnt->BEPOR;
          typ[VHD_beporDFN] = VHD_beporDFN;
          }
        if (befig_pnt->BEGEN != NULL)
          {
          tab[VHD_begenDFN] = avail;
          nxt[VHD_begenDFN] = (void *)befig_pnt->BEGEN;
          typ[VHD_begenDFN] = VHD_begenDFN;
          }
        if (befig_pnt->USER != NULL)
          {
          tab[VHD_userDFN] = avail;
          nxt[VHD_userDFN] = (void *)befig_pnt->USER;
          typ[VHD_userDFN] = VHD_ptypeDFN;
          }
        if (befig_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)befig_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_befigDFN;
          }

        circuit_pnt = befig_pnt->CIRCUI;

        printf ("   name        : %s\n",befig_pnt->NAME);
        printf ("   errflg      : %d\n",befig_pnt->ERRFLG);
        printf ("   type        : %d\n",befig_pnt->TYPE);
        printf ("-> bereg       : %s\n",tab[VHD_beregDFN]);
        printf ("-> bemsg       : %s\n",tab[VHD_bemsgDFN]);
        printf ("-> berin       : %s\n",tab[VHD_berinDFN]);
        printf ("-> beout       : %s\n",tab[VHD_beoutDFN]);
        printf ("-> bebus       : %s\n",tab[VHD_bebusDFN]);
        printf ("-> beaux       : %s\n",tab[VHD_beauxDFN]);
        printf ("-> bedly       : %s\n",tab[VHD_bedlyDFN]);
        printf ("-> bebux       : %s\n",tab[VHD_bebuxDFN]);
        printf ("-> bepor       : %s\n",tab[VHD_beporDFN]);
        printf ("-> begen       : %s\n",tab[VHD_begenDFN]);
        printf ("-> user        : %s\n",tab[VHD_userDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_beregDFN):

	/* ###------------------------------------------------------### */
	/*			bereg					*/
	/* ###------------------------------------------------------### */

        bereg_pnt = (struct bereg *)(cur_pnt.data);

        if (bereg_pnt->BIABL != NULL)
          {
          tab[VHD_biablDFN] = avail;
          nxt[VHD_biablDFN] = (void *)bereg_pnt->BIABL;
          typ[VHD_biablDFN] = VHD_biablDFN;
          }
        if (bereg_pnt->BINODE != NULL)
          {
          tab[VHD_binodeDFN] = avail;
          nxt[VHD_binodeDFN] = (void *)bereg_pnt->BINODE;
          typ[VHD_binodeDFN] = VHD_binodeDFN;
          }
        if (bereg_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)bereg_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_beregDFN;
          }

        printf ("   name        : %s\n",bereg_pnt->NAME);
        printf ("-> biabl       : %s\n",tab[VHD_biablDFN]);
        printf ("-> binode      : %s\n",tab[VHD_binodeDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_bemsgDFN):

	/* ###------------------------------------------------------### */
	/*			bemsg					*/
	/* ###------------------------------------------------------### */

        bemsg_pnt = (struct bemsg *)(cur_pnt.data);

        if (bemsg_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)bemsg_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_bemsgDFN;
          }

        printf ("   message     : %s\n",bemsg_pnt->MESSAGE);
        printf ("   label       : %s\n",bemsg_pnt->LABEL);
        printf ("   level       : %c\n",bemsg_pnt->LEVEL);
        if (bemsg_pnt->ABL != NULL)
          {
          buffer=exprToCharInt (bemsg_pnt->ABL,1,buffer,&buff_size);
          printf ("   abl         : %s\n",buffer);
          }
        else
          printf ("   abl         :\n");
        buffer[0] = '\0';

        if (bemsg_pnt->NODE != NULL)
          {
          ptr_abl = bddToAbl (bemsg_pnt->NODE, circuit_pnt->pNameI);
          buffer=exprToCharInt (ptr_abl,1,buffer,&buff_size);
          printf ("   node        : %s\n",buffer);
          }
        else
          printf ("   node        :\n");
        buffer[0] = '\0';
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_berinDFN):

	/* ###------------------------------------------------------### */
	/*			berin					*/
	/* ###------------------------------------------------------### */

        berin_pnt = (struct berin *)(cur_pnt.data);

        if (berin_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)berin_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_berinDFN;
          }

        printf ("   name        : %s\n",berin_pnt->NAME);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_beoutDFN):

	/* ###------------------------------------------------------### */
	/*			beout					*/
	/* ###------------------------------------------------------### */

        beout_pnt = (struct beout *)(cur_pnt.data);

        if (beout_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)beout_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_beoutDFN;
          }

        printf ("   name        : %s\n",beout_pnt->NAME);
        if (beout_pnt->ABL != NULL)
          {
          buffer=exprToCharInt (beout_pnt->ABL,1,buffer,&buff_size);
          printf ("   abl         : %s\n",buffer);
          }
        else
          printf ("   abl         :\n");
        buffer[0] = '\0';

        if (beout_pnt->NODE != NULL)
          {
          ptr_abl= bddToAbl (beout_pnt->NODE, circuit_pnt->pNameI);
          buffer=exprToCharInt (ptr_abl,1,buffer,&buff_size);
          printf ("   node        : %s\n",buffer);
          }
        else
          printf ("   node        :\n");
        buffer[0] = '\0';
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_bebusDFN):

	/* ###------------------------------------------------------### */
	/*			bebus					*/
	/* ###------------------------------------------------------### */

        bebus_pnt = (struct bebus *)(cur_pnt.data);

        if (bebus_pnt->BINODE != NULL)
          {
          tab[VHD_binodeDFN] = avail;
          nxt[VHD_binodeDFN] = (void *)bebus_pnt->BINODE;
          typ[VHD_binodeDFN] = VHD_binodeDFN;
          }
        if (bebus_pnt->BIABL != NULL)
          {
          tab[VHD_biablDFN] = avail;
          nxt[VHD_biablDFN] = (void *)bebus_pnt->BIABL;
          typ[VHD_biablDFN] = VHD_biablDFN;
          }
        if (bebus_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)bebus_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_bebusDFN;
          }

        printf ("   name        : %s\n",bebus_pnt->NAME);
        printf ("   type        : %c\n",bebus_pnt->TYPE);
        printf ("-> biabl       : %s\n",tab[VHD_biablDFN]);
        printf ("-> binode      : %s\n",tab[VHD_binodeDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_bebuxDFN):

	/* ###------------------------------------------------------### */
	/*			bebux					*/
	/* ###------------------------------------------------------### */

        bebux_pnt = (struct bebux *)(cur_pnt.data);

        if (bebux_pnt->BINODE != NULL)
          {
          tab[VHD_binodeDFN] = avail;
          nxt[VHD_binodeDFN] = (void *)bebux_pnt->BINODE;
          typ[VHD_binodeDFN] = VHD_binodeDFN;
          }
        if (bebux_pnt->BIABL != NULL)
          {
          tab[VHD_biablDFN] = avail;
          nxt[VHD_biablDFN] = (void *)bebux_pnt->BIABL;
          typ[VHD_biablDFN] = VHD_biablDFN;
          }
        if (bebux_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)bebux_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_bebuxDFN;
          }

        printf ("   name        : %s\n",bebux_pnt->NAME);
        printf ("   type        : %c\n",bebux_pnt->TYPE);
        printf ("-> biabl       : %s\n",tab[VHD_biablDFN]);
        printf ("-> binode      : %s\n",tab[VHD_binodeDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_beauxDFN):

	/* ###------------------------------------------------------### */
	/*			beaux					*/
	/* ###------------------------------------------------------### */

        beaux_pnt = (struct beaux *)(cur_pnt.data);

        if (beaux_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)beaux_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_beauxDFN;
          }

        printf ("   name        : %s\n",beaux_pnt->NAME);
        if (beaux_pnt->ABL != NULL)
          {
          buffer=exprToCharInt (beaux_pnt->ABL,1,buffer,&buff_size);
          printf ("   abl         : %s\n",buffer);
          }
        else
          printf ("   abl         :\n");
        buffer[0] = '\0';

        if (beaux_pnt->NODE != NULL)
          {
          ptr_abl= bddToAbl (beaux_pnt->NODE, circuit_pnt->pNameI);
          buffer=exprToCharInt (ptr_abl,1,buffer,&buff_size);
          printf ("   node        : %s\n",buffer);
          }
        else
          printf ("   node        :\n");
        buffer[0] = '\0';
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_beporDFN):

	/* ###------------------------------------------------------### */
	/*			bepor					*/
	/* ###------------------------------------------------------### */

        bepor_pnt = (struct bepor *)(cur_pnt.data);

        if (bepor_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)bepor_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_beporDFN;
          }

        printf ("   name        : %s\n",bepor_pnt->NAME);
        printf ("   direction   : %c\n",bepor_pnt->DIRECTION);
        printf ("   type        : %c\n",bepor_pnt->TYPE);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_biablDFN):

	/* ###------------------------------------------------------### */
	/*			biabl					*/
	/* ###------------------------------------------------------### */

        biabl_pnt = (struct biabl *)(cur_pnt.data);

        if (biabl_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)biabl_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_biablDFN;
          }
        if (biabl_pnt->USER != NULL)
          {
          tab[VHD_userDFN] = avail;
          nxt[VHD_userDFN] = (void *)biabl_pnt->USER;
          typ[VHD_userDFN] = VHD_ptypeDFN;
          }

        if (biabl_pnt->VALABL != NULL)
          {
          buffer=exprToCharInt (biabl_pnt->VALABL,1,buffer,&buff_size);
          printf ("   valabl      : %s\n",buffer);
          }
        else
          printf ("   valabl      :\n");
        buffer[0] = '\0';

        if (biabl_pnt->CNDABL != NULL)
          {
          buffer=exprToCharInt (biabl_pnt->CNDABL,1,buffer,&buff_size);
          printf ("   cndabl      : %s\n",buffer);
          }
        else
          printf ("   cndabl      :\n");
        buffer[0] = '\0';

        printf ("   label       : %s\n",biabl_pnt->LABEL);
        printf ("-> user        : %s\n",tab[VHD_ptypeDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_binodeDFN):

	/* ###------------------------------------------------------### */
	/*			binode					*/
	/* ###------------------------------------------------------### */

        binode_pnt = (struct binode *)(cur_pnt.data);

        if (binode_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)binode_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_binodeDFN;
          }

        if (binode_pnt->CNDNODE != NULL)
          {
          ptr_abl= bddToAbl (binode_pnt->CNDNODE, circuit_pnt->pNameI);
          buffer=exprToCharInt (ptr_abl,1,buffer,&buff_size);
          printf ("   cndnode     : %s\n",buffer);
          }
        else
          printf ("   cndnode     :\n");
        buffer[0] = '\0';

        if (binode_pnt->VALNODE != NULL)
          {
          ptr_abl= bddToAbl (binode_pnt->VALNODE, circuit_pnt->pNameI);
          buffer=exprToCharInt (ptr_abl,1,buffer,&buff_size);
          printf ("   valnode     : %s\n",buffer);
          }
        else
          printf ("   valnode     :\n");
        buffer[0] = '\0';

        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_lkdfigDFN):

	/* ###------------------------------------------------------### */
	/*			lkdfig					*/
	/* ###------------------------------------------------------### */

        lkdfig_pnt = (struct lkdfig *)(cur_pnt.data);

        if (lkdfig_pnt->LKDINS != NULL)
          {
          tab[VHD_lkdinsDFN] = avail;
          nxt[VHD_lkdinsDFN] = (void *)lkdfig_pnt->LKDINS;
          typ[VHD_lkdinsDFN] = VHD_lkdinsDFN;
          }
        if (lkdfig_pnt->SIMSIG != NULL)
          {
          tab[VHD_simsigDFN] = avail;
          nxt[VHD_simsigDFN] = (void *)lkdfig_pnt->SIMSIG;
          typ[VHD_simsigDFN] = VHD_simsigDFN;
          }
        if (lkdfig_pnt->BUSSIG != NULL)
          {
          tab[VHD_bussigDFN] = avail;
          nxt[VHD_bussigDFN] = (void *)lkdfig_pnt->BUSSIG;
          typ[VHD_bussigDFN] = VHD_bussigDFN;
          }
        if (lkdfig_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)lkdfig_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_lkdfigDFN;
          }

        printf ("   name        : %s\n",lkdfig_pnt->NAME);
        printf ("-> lkdins      : %s\n",tab[VHD_lkdinsDFN]);
        printf ("-> simsig      : %s\n",tab[VHD_simsigDFN]);
        printf ("-> bussig      : %s\n",tab[VHD_bussigDFN]);
        printf ("   valsiz      : %u\n",lkdfig_pnt->VALSIZ);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_lkdinsDFN):

	/* ###------------------------------------------------------### */
	/*			lkdins					*/
	/* ###------------------------------------------------------### */

        lkdins_pnt = (struct lkdins *)(cur_pnt.data);

        if (lkdins_pnt->WRSSIG != NULL)
          {
          tab[VHD_wrssigDFN] = avail;
          nxt[VHD_wrssigDFN] = (void *)lkdins_pnt->WRSSIG;
          typ[VHD_wrssigDFN] = VHD_wrssigDFN;
          }
        if (lkdins_pnt->WRBSIG != NULL)
          {
          tab[VHD_wrbsigDFN] = avail;
          nxt[VHD_wrbsigDFN] = (void *)lkdins_pnt->WRBSIG;
          typ[VHD_wrbsigDFN] = VHD_wrbsigDFN;
          }
        if (lkdins_pnt->WRIREG != NULL)
          {
          tab[VHD_wriregDFN] = avail;
          nxt[VHD_wriregDFN] = (void *)lkdins_pnt->WRIREG;
          typ[VHD_wriregDFN] = VHD_wriregDFN;
          }
        if (lkdins_pnt->WRIAUX != NULL)
          {
          tab[VHD_wriauxDFN] = avail;
          nxt[VHD_wriauxDFN] = (void *)lkdins_pnt->WRIAUX;
          typ[VHD_wriauxDFN] = VHD_wriauxDFN;
          }
        if (lkdins_pnt->WRIBUX != NULL)
          {
          tab[VHD_wribuxDFN] = avail;
          nxt[VHD_wribuxDFN] = (void *)lkdins_pnt->WRIBUX;
          typ[VHD_wribuxDFN] = VHD_wribuxDFN;
          }
        if (lkdins_pnt->REDLST != NULL)
          {
          tab[VHD_redlstDFN] = avail;
          nxt[VHD_redlstDFN] = (void *)lkdins_pnt->REDLST;
          typ[VHD_redlstDFN] = VHD_redlstDFN;
          }
        if (lkdins_pnt->BEFIG != NULL)
          {
          tab[VHD_befigDFN] = avail;
          nxt[VHD_befigDFN] = (void *)lkdins_pnt->BEFIG;
          typ[VHD_befigDFN] = VHD_befigDFN;
          }
        if (lkdins_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)lkdins_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_lkdinsDFN;
          }

        circuit_pnt = lkdins_pnt->CIRCUI;

        printf ("   insname     : %s\n",lkdins_pnt->INSNAME);
        printf ("   eval        : %d\n",lkdins_pnt->EVAL);
        printf ("-> wrssig      : %s\n",tab[VHD_wrssigDFN]);
        printf ("-> wrbsig      : %s\n",tab[VHD_wrbsigDFN]);
        printf ("-> wrireg      : %s\n",tab[VHD_wriregDFN]);
        printf ("-> wriaux      : %s\n",tab[VHD_wriauxDFN]);
        printf ("-> wribux      : %s\n",tab[VHD_wribuxDFN]);
        printf ("-> redlst      : %s\n",tab[VHD_redlstDFN]);
        printf ("-> befig       : %s\n",tab[VHD_befigDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_simsigDFN):

	/* ###------------------------------------------------------### */
	/*			simsig					*/
	/* ###------------------------------------------------------### */

        simsig_pnt = (struct simsig *)(cur_pnt.data);

        if (simsig_pnt->REDINS != NULL)
          {
          tab[VHD_redinsDFN] = avail;
          nxt[VHD_redinsDFN] = (void *)simsig_pnt->REDINS;
          typ[VHD_redinsDFN] = VHD_redinsDFN;
          }
        if (simsig_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)simsig_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_simsigDFN;
          }

        nam_lst = simsig_pnt->NAMECHAIN;

        printf ("   namechain   :\n");
        while (nam_lst != NULL)
          {
          printf ("                 %s\n",(char *)nam_lst->DATA);
          nam_lst = nam_lst->NEXT;
          }
        printf ("   curval      : %c\n",*(simsig_pnt->CURVAL));
        printf ("   prjval      : %c\n",simsig_pnt->PRJVAL);
        printf ("-> redins      : %s\n",tab[VHD_redinsDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_bussigDFN):

	/* ###------------------------------------------------------### */
	/*			bussig					*/
	/* ###------------------------------------------------------### */

        bussig_pnt = (struct bussig *)(cur_pnt.data);

        if (bussig_pnt->REDINS != NULL)
          {
          tab[VHD_redinsDFN] = avail;
          nxt[VHD_redinsDFN] = (void *)bussig_pnt->REDINS;
          typ[VHD_redinsDFN] = VHD_redinsDFN;
          }
        if (bussig_pnt->PRJBVL != NULL)
          {
          tab[VHD_prjbvlDFN] = avail;
          nxt[VHD_prjbvlDFN] = (void *)bussig_pnt->PRJBVL;
          typ[VHD_prjbvlDFN] = VHD_prjbvlDFN;
          }
        if (bussig_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)bussig_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_bussigDFN;
          }

        nam_lst = bussig_pnt->NAMECHAIN;

        printf ("   namechain   :\n");
        while (nam_lst != NULL)
          {
          printf ("                 %s\n",(char *)nam_lst->DATA);
          nam_lst = nam_lst->NEXT;
          }
        printf ("   type        : %c\n",bussig_pnt->TYPE);
        printf ("   curval      : %c\n",*(bussig_pnt->CURVAL));
        printf ("-> prjbvl      : %s\n",tab[VHD_prjbvlDFN]);
        printf ("-> redins      : %s\n",tab[VHD_redinsDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_wrbsigDFN):

	/* ###------------------------------------------------------### */
	/*			wrbsig					*/
	/* ###------------------------------------------------------### */

        wrbsig_pnt = (struct wrbsig *)(cur_pnt.data);

        if (wrbsig_pnt->BEBUS != NULL)
          {
          tab[VHD_bebusDFN] = avail;
          nxt[VHD_bebusDFN] = (void *)wrbsig_pnt->BEBUS;
          typ[VHD_bebusDFN] = VHD_bebusDFN;
          }
        if (wrbsig_pnt->BUSSIG != NULL)
          {
          tab[VHD_bussigDFN] = avail;
          nxt[VHD_bussigDFN] = (void *)wrbsig_pnt->BUSSIG;
          typ[VHD_bussigDFN] = VHD_bussigDFN;
          }
        if (wrbsig_pnt->PRJBVL != NULL)
          {
          tab[VHD_prjbvlDFN] = avail;
          nxt[VHD_prjbvlDFN] = (void *)wrbsig_pnt->PRJBVL;
          typ[VHD_prjbvlDFN] = VHD_prjbvlDFN;
          }
        if (wrbsig_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)wrbsig_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_wrbsigDFN;
          }

        printf ("-> bussig      : %s\n",tab[VHD_bussigDFN]);
        printf ("-> bebus       : %s\n",tab[VHD_bebusDFN]);
        printf ("-> prjbvl      : %s\n",tab[VHD_prjbvlDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_wriregDFN):

	/* ###------------------------------------------------------### */
	/*			wrireg					*/
	/* ###------------------------------------------------------### */

        wrireg_pnt = (struct wrireg *)(cur_pnt.data);

        if (wrireg_pnt->BEREG != NULL)
          {
          tab[VHD_beregDFN] = avail;
          nxt[VHD_beregDFN] = (void *)wrireg_pnt->BEREG;
          typ[VHD_beregDFN] = VHD_beregDFN;
          }
        if (wrireg_pnt->LKDINS != NULL)
          {
          tab[VHD_lkdinsDFN] = avail;
          nxt[VHD_lkdinsDFN] = (void *)wrireg_pnt->LKDINS;
          typ[VHD_lkdinsDFN] = VHD_lkdinsDFN;
          }
        if (wrireg_pnt->PRJRVL != NULL)
          {
          tab[VHD_prjrvlDFN] = avail;
          nxt[VHD_prjrvlDFN] = (void *)wrireg_pnt->PRJRVL;
          typ[VHD_prjrvlDFN] = VHD_prjrvlDFN;
          }
        if (wrireg_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)wrireg_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_wriregDFN;
          }

        printf ("-> lkdins      : %s\n",tab[VHD_lkdinsDFN]);
        printf ("-> bereg       : %s\n",tab[VHD_beregDFN]);
        printf ("-> prjrvl      : %s\n",tab[VHD_prjrvlDFN]);
        printf ("   curval      : %c\n",*(wrireg_pnt->CURVAL));
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_wriauxDFN):

	/* ###------------------------------------------------------### */
	/*			wriaux					*/
	/* ###------------------------------------------------------### */

        wriaux_pnt = (struct wriaux *)(cur_pnt.data);

        if (wriaux_pnt->BEAUX != NULL)
          {
          tab[VHD_beauxDFN] = avail;
          nxt[VHD_beauxDFN] = (void *)wriaux_pnt->BEAUX;
          typ[VHD_beauxDFN] = VHD_beauxDFN;
          }
        if (wriaux_pnt->LKDINS != NULL)
          {
          tab[VHD_lkdinsDFN] = avail;
          nxt[VHD_lkdinsDFN] = (void *)wriaux_pnt->LKDINS;
          typ[VHD_lkdinsDFN] = VHD_lkdinsDFN;
          }
        if (wriaux_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)wriaux_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_wriauxDFN;
          }

        printf ("   curval      : %c\n",*(wriaux_pnt->CURVAL));
        printf ("   prjval      : %c\n",  wriaux_pnt->PRJVAL);
        printf ("-> beaux       : %s\n",tab[VHD_beauxDFN]);
        printf ("-> lkdins      : %s\n",tab[VHD_lkdinsDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_wribuxDFN):

	/* ###------------------------------------------------------### */
	/*			wribux					*/
	/* ###------------------------------------------------------### */

        wribux_pnt = (struct wribux *)(cur_pnt.data);

        if (wribux_pnt->BEBUX != NULL)
          {
          tab[VHD_bebuxDFN] = avail;
          nxt[VHD_bebuxDFN] = (void *)wribux_pnt->BEBUX;
          typ[VHD_bebuxDFN] = VHD_bebuxDFN;
          }
        if (wribux_pnt->LKDINS != NULL)
          {
          tab[VHD_lkdinsDFN] = avail;
          nxt[VHD_lkdinsDFN] = (void *)wribux_pnt->LKDINS;
          typ[VHD_lkdinsDFN] = VHD_lkdinsDFN;
          }
        if (wribux_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)wribux_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_wribuxDFN;
          }
        if (wribux_pnt->PRJBVL != NULL)
          {
          tab[VHD_prjbvlDFN] = avail;
          nxt[VHD_prjbvlDFN] = (void *)wribux_pnt->PRJBVL;
          typ[VHD_prjbvlDFN] = VHD_prjbvlDFN;
          }

        printf ("   curval      : %c\n",*(wribux_pnt->CURVAL));
        printf ("-> prjbvl      : %s\n",tab[VHD_prjbvlDFN]);
        printf ("-> bebux       : %s\n",tab[VHD_bebuxDFN]);
        printf ("-> lkdins      : %s\n",tab[VHD_lkdinsDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_prjbvlDFN):

	/* ###------------------------------------------------------### */
	/*			prjbvl					*/
	/* ###------------------------------------------------------### */

        prjbvl_pnt = (struct prjbvl *)(cur_pnt.data);

        if (prjbvl_pnt->GLNEXT != NULL)
          {
          tab[VHD_glnextDFN] = avail;
          nxt[VHD_glnextDFN] = (void *)prjbvl_pnt->GLNEXT;
          typ[VHD_glnextDFN] = VHD_prjbvlDFN;
          }
        if (prjbvl_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)prjbvl_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_prjbvlDFN;
          }

        printf ("   cndval      : %c\n",prjbvl_pnt->CNDVAL);
        printf ("   drvval      : %c\n",prjbvl_pnt->DRVVAL);
        printf ("-> glnext      : %s\n",tab[VHD_glnextDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_prjrvlDFN):

	/* ###------------------------------------------------------### */
	/*			prjrvl					*/
	/* ###------------------------------------------------------### */

        prjrvl_pnt = (struct prjrvl *)(cur_pnt.data);

        if (prjrvl_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)prjrvl_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_prjrvlDFN;
          }

        printf ("   cndval      : %c\n",prjrvl_pnt->CNDVAL);
        printf ("   drvval      : %c\n",prjrvl_pnt->DRVVAL);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_wrssigDFN):

	/* ###------------------------------------------------------### */
	/*			wrssig					*/
	/* ###------------------------------------------------------### */

        wrssig_pnt = (struct wrssig *)(cur_pnt.data);

        if (wrssig_pnt->BEOUT != NULL)
          {
          tab[VHD_beoutDFN] = avail;
          nxt[VHD_beoutDFN] = (void *)wrssig_pnt->BEOUT;
          typ[VHD_beoutDFN] = VHD_beoutDFN;
          }
        if (wrssig_pnt->SIMSIG != NULL)
          {
          tab[VHD_simsigDFN] = avail;
          nxt[VHD_simsigDFN] = (void *)wrssig_pnt->SIMSIG;
          typ[VHD_simsigDFN] = VHD_simsigDFN;
          }
        if (wrssig_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)wrssig_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_wrssigDFN;
          }

        printf ("-> beout       : %s\n",tab[VHD_beoutDFN]);
        printf ("-> simsig      : %s\n",tab[VHD_simsigDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_redlstDFN):

	/* ###------------------------------------------------------### */
	/*			redlst					*/
	/* ###------------------------------------------------------### */

        redlst_pnt = (struct redlst *)(cur_pnt.data);

        if (redlst_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)redlst_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_redlstDFN;
          }

        printf ("   valu        : %c\n",*((char *)redlst_pnt->VALU));
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_redinsDFN):

	/* ###------------------------------------------------------### */
	/*			redins					*/
	/* ###------------------------------------------------------### */

        chain_pnt = (struct chain *)(cur_pnt.data);

        if (chain_pnt->DATA != NULL)
          {
          tab[VHD_lkdinsDFN] = avail;
          nxt[VHD_lkdinsDFN] = (void *)chain_pnt->DATA;
          typ[VHD_lkdinsDFN] = VHD_lkdinsDFN;
          }
        if (chain_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)chain_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_redinsDFN;
          }

        printf ("-> lkdins      : %s\n",tab[VHD_lkdinsDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_begenDFN):

	/* ###------------------------------------------------------### */
	/*			begen					*/
	/* ###------------------------------------------------------### */

        begen_pnt = (struct begen *)(cur_pnt.data);

        if (begen_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)begen_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_begenDFN;
          }

        printf ("   name        : %s\n",begen_pnt->NAME);
        printf ("   value       : %ld\n",*((long *)begen_pnt->VALUE));
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;

      case (VHD_paseqDFN):

	/* ###------------------------------------------------------### */
	/*			paseq					*/
	/* ###------------------------------------------------------### */

        paseq_pnt = (struct paseq *)(cur_pnt.data);

        if (paseq_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)paseq_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_paseqDFN;
          }
        if (paseq_pnt->PAGRP != NULL)
          {
          tab[VHD_pagrpDFN] = avail;
          nxt[VHD_pagrpDFN] = (void *)paseq_pnt->PAGRP;
          typ[VHD_pagrpDFN] = VHD_pagrpDFN;
          }
        if (paseq_pnt->PAIOL != NULL)
          {
          tab[VHD_paiolDFN] = avail;
          nxt[VHD_paiolDFN] = (void *)paseq_pnt->PAIOL;
          typ[VHD_paiolDFN] = VHD_paiolDFN;
          }
        if (paseq_pnt->OLDPAT != NULL)
          {
          tab[VHD_oldpatDFN] = avail;
          nxt[VHD_oldpatDFN] = (void *)paseq_pnt->OLDPAT;
          typ[VHD_oldpatDFN] = VHD_papatDFN;
          }
        if (paseq_pnt->CURPAT != NULL)
          {
          tab[VHD_curpatDFN] = avail;
          nxt[VHD_curpatDFN] = (void *)paseq_pnt->CURPAT;
          typ[VHD_curpatDFN] = VHD_papatDFN;
          }
        if (paseq_pnt->NXTPAT != NULL)
          {
          tab[VHD_nxtpatDFN] = avail;
          nxt[VHD_nxtpatDFN] = (void *)paseq_pnt->NXTPAT;
          typ[VHD_nxtpatDFN] = VHD_papatDFN;
          }
        if (paseq_pnt->DECCOM != NULL)
          {
          tab[VHD_deccomDFN] = avail;
          nxt[VHD_deccomDFN] = (void *)paseq_pnt->DECCOM;
          typ[VHD_deccomDFN] = VHD_pacomDFN;
          }
        if (paseq_pnt->OLDCOM != NULL)
          {
          tab[VHD_oldcomDFN] = avail;
          nxt[VHD_oldcomDFN] = (void *)paseq_pnt->OLDCOM;
          typ[VHD_oldcomDFN] = VHD_pacomDFN;
          }
        if (paseq_pnt->CURCOM != NULL)
          {
          tab[VHD_curcomDFN] = avail;
          nxt[VHD_curcomDFN] = (void *)paseq_pnt->CURCOM;
          typ[VHD_curcomDFN] = VHD_pacomDFN;
          }

        printf ("-> next         : %s\n",tab[VHD_nextDFN]);
        printf ("-> pagrp        : %s\n",tab[VHD_pagrpDFN]);
        printf ("-> paiol        : %s\n",tab[VHD_paiolDFN]);
        printf ("-> deccom       : %s\n",tab[VHD_deccomDFN]);
        printf ("-> oldpat       : %s\n",tab[VHD_oldpatDFN]);
        printf ("-> odlcom       : %s\n",tab[VHD_oldcomDFN]);
        printf ("-> curpat       : %s\n",tab[VHD_curpatDFN]);
        printf ("-> curcom       : %s\n",tab[VHD_curcomDFN]);
        printf ("-> nxtpat       : %s\n",tab[VHD_nxtpatDFN]);
        printf ("   name         : %s\n",paseq_pnt->NAME);
        printf ("   patnbr       : %u\n",paseq_pnt->PATNBR);
        printf ("   iolnbr       : %u\n",paseq_pnt->IOLNBR);
        printf ("   lineno       : %u\n",paseq_pnt->LINENO);
        printf ("   subseq       : %u\n",paseq_pnt->SUBSEQ);
        printf ("   savflg       : %c\n",paseq_pnt->SAVFLG);
        printf ("   endflg       : %c\n",paseq_pnt->ENDFLG);
        printf ("   drvseq       : %u\n",paseq_pnt->DRVSEQ);
        printf ("   errflg       : %d\n",paseq_pnt->ERRFLG);

        break;

      case (VHD_pagrpDFN):

	/* ###------------------------------------------------------### */
	/*			pagrp					*/
	/* ###------------------------------------------------------### */

        pagrp_pnt = (struct pagrp *)(cur_pnt.data);

        if (pagrp_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)pagrp_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_pagrpDFN;
          }
        printf ("-> next         : %s\n",tab[VHD_nextDFN]);
        printf ("   name         : %s\n",pagrp_pnt->NAME);
        printf ("   length       : %u\n",pagrp_pnt->LENGTH);
        printf ("   findex       : %u\n",pagrp_pnt->FINDEX);
        printf ("   flag         : %d\n",pagrp_pnt->FLAG);

        break;

      case (VHD_paiolDFN):

	/* ###------------------------------------------------------### */
	/*			paiol					*/
	/* ###------------------------------------------------------### */

        paiol_pnt = (struct paiol *)(cur_pnt.data);

        if (paiol_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)paiol_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_paiolDFN;
          }
        printf ("-> next         : %s\n",tab[VHD_nextDFN]);
        printf ("   name         : %s\n",paiol_pnt->NAME);
        printf ("   format       : %c\n",paiol_pnt->FORMAT);
        printf ("   mode         : %c\n",paiol_pnt->MODE);
        printf ("   blank        : %u\n",paiol_pnt->BLANK);
        printf ("   value        : %c\n",paiol_pnt->VALUE);

        if (paiol_pnt->SIG != NULL)
          {
          tab[VHD_sigDFN] = avail;
          nxt[VHD_sigDFN] = (void *)paiol_pnt->SIG;
          switch (paiol_pnt->MODE)
            {
            case 'I':
            case 'B':
            case 'O':
            case 'W':
              typ[VHD_sigDFN] = VHD_simsigDFN;
              break;
            case 'T':
            case 'Z':
            case 'X':
              typ[VHD_sigDFN] = VHD_bussigDFN;
              break;
            case 'S':
              typ[VHD_sigDFN] = VHD_wriauxDFN;
              break;
            case 'U':
              typ[VHD_sigDFN] = VHD_wribuxDFN;
              break;
            case 'R':
              typ[VHD_sigDFN] = VHD_wriregDFN;
              break;
            }
          }
        printf ("-> sig          : %s\n",tab[VHD_sigDFN]);

        break;

      case (VHD_papatDFN):

	/* ###------------------------------------------------------### */
	/*			papat					*/
	/* ###------------------------------------------------------### */

        papat_pnt = (struct papat *)(cur_pnt.data);

        if (papat_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)papat_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_papatDFN;
          }
        printf ("-> next         : %s\n",tab[VHD_nextDFN]);
        printf ("   label        : %s\n",papat_pnt->LABEL);
        if (papat_pnt->PAINI != NULL)
          {
          tab[VHD_painiDFN] = avail;
          nxt[VHD_painiDFN] = (void *)papat_pnt->PAINI;
          typ[VHD_painiDFN] = VHD_painiDFN;
          }
        printf ("-> paini        : %s\n",tab[VHD_painiDFN]);
        if (papat_pnt->PAEVT != NULL)
          {
          tab[VHD_paevtDFN] = avail;
          nxt[VHD_paevtDFN] = (void *)papat_pnt->PAEVT;
          typ[VHD_paevtDFN] = VHD_paevtDFN;
          }
        printf ("-> paevt        : %s\n",tab[VHD_paevtDFN]);
        printf ("   line         : %u\n",papat_pnt->LINE);
        printf ("   blank        : %u\n",papat_pnt->BLANK);
        printf ("   actflag      : %c\n",papat_pnt->ACTFLAG);
        printf ("   simflag      : %c\n",papat_pnt->SIMFLAG);

        break;

      case (VHD_painiDFN):

	/* ###------------------------------------------------------### */
	/*			paini					*/
	/* ###------------------------------------------------------### */

        paini_pnt = (struct paini *)(cur_pnt.data);

        if (paini_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)paini_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_painiDFN;
          }
        printf ("-> next         : %s\n",tab[VHD_nextDFN]);
        printf ("   name         : %s\n",paini_pnt->NAME);
        printf ("   value        : %c\n",paini_pnt->VALUE);

        break;

      case (VHD_paevtDFN):

	/* ###------------------------------------------------------### */
	/*			paevt					*/
	/* ###------------------------------------------------------### */

        paevt_pnt = (struct paevt *)(cur_pnt.data);

        if (paevt_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)paevt_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_paevtDFN;
          }
        printf ("-> next         : %s\n",tab[VHD_nextDFN]);
        printf ("   index        : %u\n",paevt_pnt->INDEX);
        printf ("   usrval       : %c\n",paevt_pnt->USRVAL);
        printf ("   simval       : %c\n",paevt_pnt->SIMVAL);

        break;

      case (VHD_pacomDFN):

	/* ###------------------------------------------------------### */
	/*			pacom					*/
	/* ###------------------------------------------------------### */

        pacom_pnt = (struct pacom *)(cur_pnt.data);

        if (pacom_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)pacom_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_pacomDFN;
          }
        printf ("-> next         : %s\n"  , tab[VHD_nextDFN]);
        printf ("   text         : %s\n"  , pacom_pnt->TEXT);
        printf ("   position     : %u\n"  , pacom_pnt->POSITION);

        break;

      case (VHD_ptypeDFN):

	/* ###------------------------------------------------------### */
	/*			ptype					*/
	/* ###------------------------------------------------------### */

        ptype_pnt = (struct ptype *)(cur_pnt.data);

        if (ptype_pnt->DATA != NULL)
          {
          tab[VHD_dataDFN] = avail;
          nxt[VHD_dataDFN] = (void *)ptype_pnt->DATA;
          switch (ptype_pnt->TYPE)
            {
            case BEH_GENERIC :
              typ[VHD_dataDFN] = VHD_begenDFN ;
              break;
            }
          }

        if (ptype_pnt->NEXT != NULL)
          {
          tab[VHD_nextDFN] = avail;
          nxt[VHD_nextDFN] = (void *)ptype_pnt->NEXT;
          typ[VHD_nextDFN] = VHD_ptypeDFN;
          }

        printf ("   type        : %ld\n",ptype_pnt->TYPE);
        printf ("-> data        : %s\n",tab[VHD_dataDFN]);
        printf ("-> next        : %s\n",tab[VHD_nextDFN]);

        break;
      }

	/* ###------------------------------------------------------### */
	/*    Reading new command					*/
	/* ###------------------------------------------------------### */

    readcmd = vhd_getcmd (readtab);

    for (i=0 ; i<VHD_MAXDFN ; i++)
      {
      if (!strcmp (readcmd, key[i]))
        break;
      }
    if ((i != VHD_MAXDFN+1) && (tab[i] == avail))
      newsta0 = i;
    else
      newsta0 = VHD__errorDFN;

    if (newsta0 == VHD__setDFN)
      {
      for (i=0 ; i<VHD_MAXDFN ; i++)
        {
        if (!strcmp (readtab[1], key[i]))
          break;
        }
      if (i != VHD_MAXDFN+1)
        newsta1 = i;
      else
        newsta1 = VHD__errorDFN;
      }

	/* ###------------------------------------------------------### */
	/*    Analysing new command					*/
	/* ###------------------------------------------------------### */

    switch (newsta0)
      {
      case (VHD__setDFN):
        switch (state)
          {
          case (VHD_bemsgDFN):
            switch (newsta1)
              {
              case (VHD_levelDFN):
                bemsg_pnt->LEVEL = readtab[2][0];
                break;
              }
            break;
          case (VHD_simsigDFN):
            switch (newsta1)
              {
              case (VHD_curvalDFN):
                *(simsig_pnt->CURVAL) = readtab[2][0];
                break;
              case (VHD_prjvalDFN):
                simsig_pnt->PRJVAL    = readtab[2][0];
                break;
              }
            break;
          case (VHD_bussigDFN):
            switch (newsta1)
              {
              case (VHD_curvalDFN):
                *(bussig_pnt->CURVAL) = readtab[2][0];
                break;
              case (VHD_typeDFN):
                bussig_pnt->TYPE = readtab[2][0];
                break;
              }
            break;
          case (VHD_wriregDFN):
            switch (newsta1)
              {
              case (VHD_curvalDFN):
                *(wrireg_pnt->CURVAL) = readtab[2][0];
                break;
              }
            break;
          case (VHD_prjbvlDFN):
            switch (newsta1)
              {
              case (VHD_cndvalDFN):
                prjbvl_pnt->CNDVAL = readtab[2][0];
                break;
              case (VHD_drvvalDFN):
                prjbvl_pnt->DRVVAL = readtab[2][0];
                break;
              }
          case (VHD_prjrvlDFN):
            switch (newsta1)
              {
              case (VHD_cndvalDFN):
                prjrvl_pnt->CNDVAL = readtab[2][0];
                break;
              case (VHD_drvvalDFN):
                prjrvl_pnt->DRVVAL = readtab[2][0];
                break;
              }
          case (VHD_redlstDFN):
            switch (newsta1)
              {
              case (VHD_valuDFN):
                *((char *)redlst_pnt->VALU) = readtab[2][0];
                break;
              }
            break;
          }
        break;

      case (VHD__upDFN):
        cur_pnt        = stk[--stk_pnt] ;
        break;

      case (VHD__backDFN):
        while ((--stk_pnt != 0) && (stk[stk_pnt].mark != 1));
        cur_pnt        = stk[stk_pnt] ;
        break;

      case (VHD__stopDFN):
        cur_pnt.mark   = 1;
        break;

      case (VHD__topDFN):
        cur_pnt        = stk[0] ;
        stk_pnt        = 0 ;
        break;

      case (VHD__exitDFN):
        cur_pnt.data   = NULL;
        cur_pnt.type   = VHD__exitDFN;
        cur_pnt.mark   = 0;
        break;

      case (VHD__errorDFN):
        break;

      default:
        if (stk_pnt < VHD_STKSIZ)
          {
          stk[stk_pnt++] = cur_pnt;
          cur_pnt.type   = typ[newsta0];
          cur_pnt.mark   = 0;
          cur_pnt.data   = nxt[newsta0];
          }
        else
          printf ("==> STACK OVERFLOW -- STACK OVERFLOW <==\n");
        break;

      }

    state  = cur_pnt.type;
    }

  free (buffer);
  }
