/* Inclusion des fichiers header 						    */

# include<genlib.h>
# include<stdio.h>
# include<ctype.h>
# include<string.h>
# include<math.h>

extern void laypack  ();
extern void datapack ();
extern void iconpack ();
extern void vhdlpack ();
extern void patpack  ();



/* definition des macros                                                            */
 
#define x_max(a,b)      ((a)>(b)?(a):(b))       /* rend le max de  a et b           */
#define x_min(a,b)      ((a)>(b)?(b):(a))       /* rend le min de  a et b           */
#define round(a)        (2*((a+1)/2))           /* rend a si il est pair,a+1 sinon  */


/* definition des constantes     						    */

#define TRUE  		(1)		/* valeur booleenne VRAI		    */
#define FALSE 		(0)		/* valeur booleenne FAUX		    */


/* definition des variables externes globales                                       */

extern int      op1,op2;	/* Taille temporaire des operandes		    */
extern int 	layout,vhdl;	/* vues generes				  	    */
extern int 	data,icon;	/* vues generes				    	    */
extern int 	patterns ;	/* vues generes				   	    */
extern int	virtual,msb0;	/* parametres pour les connecteurs		    */
extern char	*name;		/* nom du bloc genere				    */
extern int 	t0,t1,n;	/* Parametres pour l'emplacement du pipeline	    */




long      N,M;	        	/* Taille  des operandes			    */
int 	  step,step1,step2;	/* Pas de pipelinage		       		    */


/************************************************************************************/
/*				DISPATCH					    */
/************************************************************************************/
char *amg ()
{
testpack ();
initpack ();

if  (layout)   laypack  ();
if  (icon)     iconpack ();
if  (vhdl)     vhdlpack ();
if  (data)     datapack ();
if  (patterns) patpack  ();

mespack ();

return (name);
}
/************************************************************************************/




/************************************************************************************************/
/*		   			TESTE LES ENTREES			   		*/	
/************************************************************************************************/
int testpack ()
{
if ((op1%2)+(op2%2)) {fprintf (stderr,"[ERR] Operand size must be odd number\n");exit (1);}
if ((op1>64)+(op2>64)) {fprintf (stderr,"[ERR] 5 < operand size < 65 \n");exit (1);}
if ((op1<6) +(op2<6) ) {fprintf (stderr,"[ERR] 5 < operand size < 65 \n");exit (1);}
if (layout+icon+vhdl+data+patterns == 0) {fprintf (stderr,"[ERR] One view must be specified\n");exit (1);}
return 0;
}
/*______________________________________________________________________________________________*/




/************************************************************************************************/
/* 				INITIALISATION DES VARIABLES STRUCTURELLE		 	*/
/************************************************************************************************/
int initpack ()
{
M= x_max(op1,op2);              /* M est la taille du multiplicande,la plus grande des deux     */
N= x_min(op1,op2); 	        /* N est la taille du multiplicateur, la plus petite            */

/****************************** calcul du pas de pipelinage *************************************/
/*      Le pas du pipeline est calculer pour egaliser le plus possible les temps de propagation */
/* entre deux registres. Pour cela on utilise deux pas de pipline:step1 et step2.               */
/*                                                                                              */
/*      -> si n=0 : On ne pipeline pas. Dans ce cas step1=step2=N/2-1                           */
/*      -> sinon on cherche a couper l'ARRAY en n+1 parties plus ou moins egales pour           */
/*      y inserer les n registres demandes. Pour ce faire on effectue la division               */
/*      Euclidiene de N/2-1 par n+1.                                                            */
/*              -> Si le reste r est nul : C'est le cas ideal. L'ARRAY se decoupe en            */
/*              n+1 parties rigoureusement egales. step1=step2=(N/2-1)/(n+1)                    */
/*              -> Sinon : On repartie l'exedent r parmis les r premieres parts                 */
/*              et on a alors step1=(N/2-1)/(n+1) + 1 et step2=step1-1                          */
/*              Apres avoir placer les r premiers registres avect step=step1                    */
/*              on place les n-r registres restant avec step=step2                              */
/************************************************************************************************/
if (n==0)
        {
        step1 = N/2-1;          /* si n=0 on prend un pas de la largeur de l'ARRAY              */
        step2 = step1;
        }
 
else if (n > (N/2-1)) {printf ("-n=%d is out of range\n",n);exit (2);}
else if ((N/2-1) % (n+1) ==0)   /* sinon on teste le modulo de N/2-1 par n+1                    */
        /* Si N/2-1 est un multiple de n+1 c'est ideal                                          */
        {
        /* printf ("%d mod %d = %d\n",N/2-1,n+1,(N/2-1)%(n+1)); */
        step1=(N/2-1)/(n+1);
        step2=step1;
        }
else
        {
        step1 = (N/2-1)/(n+1) + 1;
        step2 = step1-1;
        }
/* printf ("le pas de pipelinage vaut %d\n",step1); */
return 0;
}
/*_______________________________________________________________________________________________*/



/************************************************************************/
/* 				MESSAGES			        */
/************************************************************************/
mespack ()
{
if (layout)  printf ("[MES] FILE %s.ap		HAS BEEN GENERATED   \n",name);
if (icon)    printf ("[MES] FILE %s.icn		HAS BEEN GENERATED   \n",name);
if (vhdl)    printf ("[MES] FILE %s.vbe		HAS BEEN GENERATED   \n",name);
if (patterns) printf ("[MES] FILE %s.pat		HAS BEEN GENERATED   \n",name);
}
/*______________________________________________________________________*/




/*******************************************************************/
/*******************************************************************/
/*  			THE END 				   */
/*      							   */
/*		THAT' S   ALL    FOLKS				   */
/*      							   */
/*******************************************************************/
/*******************************************************************/
