/* PATTERNS FOR THE AMD2901 */
/* procedures */
/**/
/*****************************************************/
/*procedure performing a clock cycle     (3 patterns)*/
/*****************************************************/
/* The procedural nature of the clock cycle shows that */ 
/* there should be no change in the Data inputs during a cycle */
/* They only are changed on the clock's low state */ 
void clock(cur_vect) int cur_vect;
{
AFFECT (CONV(cur_vect),"ck","0b0",0);
cur_vect = cur_vect + 1;
AFFECT (CONV(cur_vect),"ck","0b1",0);
cur_vect = cur_vect + 1;
AFFECT (CONV(cur_vect),"ck","0b0",0);
}  
/**********************************************************************/
/*  procedure performing the to-the-right shifting test (51 patterns) */
/**********************************************************************/
void shift_right(cur_vect) int cur_vect;
{
int i;
int hi;
int lo;
hi = 1;
lo = 0;
/* writing  of 0101 in the register */
AFFECT (CONV(cur_vect),"i","0o007",0);
AFFECT (CONV(cur_vect),"d","0b0101",0);
AFFECT (CONV(cur_vect),"y","0b0101",0);
clock (cur_vect);
cur_vect = cur_vect+3;
/* writing of the shifted value (register and ram) */
AFFECT (CONV(cur_vect),"i","0o462",0);
AFFECT (CONV(cur_vect),"b","0b0000",0);
AFFECT (CONV(cur_vect),"r0",CONVCMP(hi),0);
AFFECT (CONV(cur_vect),"q0",CONVCMP(hi),0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect-1),"r0",CONVCMP(lo),0);
AFFECT (CONV(cur_vect-1),"q0",CONVCMP(lo),0);
AFFECT (CONV(cur_vect-1),"y","0b1010",0);
AFFECT (CONV(cur_vect-1),"signe","0b1",0);
AFFECT (CONV(cur_vect),"b","0b0001",0);
AFFECT (CONV(cur_vect),"r3",CONV(lo),0);
AFFECT (CONV(cur_vect),"q3",CONV(lo),0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect-1),"r0",CONVCMP(hi),0);
AFFECT (CONV(cur_vect-1),"q0",CONVCMP(hi),0);
AFFECT (CONV(cur_vect-1),"y","0b0101",0);
AFFECT (CONV(cur_vect-1),"signe","0b0",0);
AFFECT (CONV(cur_vect),"i","0o432",0);
AFFECT (CONV(cur_vect),"b","0b0010",0);
AFFECT (CONV(cur_vect),"r3",CONV(hi),0);
AFFECT (CONV(cur_vect),"q3",CONV(hi),0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect-1),"r0",CONVCMP(lo),0);
AFFECT (CONV(cur_vect-1),"q0",CONVCMP(lo),0);
AFFECT (CONV(cur_vect-1),"y","0b1010",0);
AFFECT (CONV(cur_vect-1),"signe","0b1",0);
AFFECT (CONV(cur_vect),"b","0b0011",0);
AFFECT (CONV(cur_vect),"r3",CONV(lo),0);
AFFECT (CONV(cur_vect),"q3",CONV(lo),0);
clock (cur_vect);
cur_vect = cur_vect+3;
/* writing of the shifted value (ram) */
AFFECT (CONV(cur_vect-1),"r0",CONVCMP(hi),0);
AFFECT (CONV(cur_vect-1),"q0",CONVCMP(hi),0);
AFFECT (CONV(cur_vect-1),"y","0b0101",0);
AFFECT (CONV(cur_vect-1),"signe","0b0",0);
AFFECT (CONV(cur_vect),"i","0o564",0);
AFFECT (CONV(cur_vect),"a","0b0001",0);
AFFECT (CONV(cur_vect),"b","0b0100",0);
AFFECT (CONV(cur_vect),"r3",CONV(hi),0);
AFFECT (CONV(cur_vect),"q3",CONV(hi),0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"a","0b0010",0);
AFFECT (CONV(cur_vect),"b","0b0101",0);
AFFECT (CONV(cur_vect),"r0",CONVCMP(lo),0);
AFFECT (CONV(cur_vect),"r3",CONV(lo),0);
AFFECT (CONV(cur_vect),"q3",CONV(lo),0);
AFFECT (CONV(cur_vect),"y","0b1010",0);
AFFECT (CONV(cur_vect),"signe","0b1",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"i","0o534",0);
AFFECT (CONV(cur_vect),"a","0b0011",0);
AFFECT (CONV(cur_vect),"b","0b0110",0);
AFFECT (CONV(cur_vect),"r0",CONVCMP(hi),0);
AFFECT (CONV(cur_vect),"r3",CONV(hi),0);
AFFECT (CONV(cur_vect),"q3",CONV(hi),0);
AFFECT (CONV(cur_vect),"y","0b0101",0);
AFFECT (CONV(cur_vect),"signe","0b0",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"a","0b0100",0);
AFFECT (CONV(cur_vect),"b","0b0111",0);
AFFECT (CONV(cur_vect),"r0",CONVCMP(lo),0);
AFFECT (CONV(cur_vect),"r3",CONV(lo),0);
AFFECT (CONV(cur_vect),"q3",CONV(lo),0);
AFFECT (CONV(cur_vect),"y","0b1010",0);
AFFECT (CONV(cur_vect),"signe","0b1",0);
clock (cur_vect);
cur_vect = cur_vect+3;
/* checking of the ram's content */
AFFECT (CONV(cur_vect),"i","0o163",0);
AFFECT (CONV(cur_vect),"r0",CONV(hi),0);
AFFECT (CONV(cur_vect),"q0",CONV(hi),0);
AFFECT (CONV(cur_vect),"r3",CONV(hi),0);
AFFECT (CONV(cur_vect),"q3",CONV(hi),0);
for (i=0;i<8;i=i+2)
  {
AFFECT (CONV(cur_vect),"b",CONV(i),0);
AFFECT (CONV(cur_vect),"y","0b1010",0);
AFFECT (CONV(cur_vect),"signe","0b1",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"b",CONV(i+1),0);
AFFECT (CONV(cur_vect),"y","0b0101",0);
AFFECT (CONV(cur_vect),"signe","0b0",0);
clock (cur_vect);
cur_vect = cur_vect+3;
  }
}
/**********************************************************************/
/*  procedure performing the to-the-left shifting test  (51 patterns) */
/**********************************************************************/
void shift_left(cur_vect) int cur_vect;
{
int i;
int hi;
int lo;
hi = 1;
lo = 0;
/* writing  of 1010 in the register */
AFFECT (CONV(cur_vect),"i","0o034",0);
AFFECT (CONV(cur_vect),"a","0b0000",0);
AFFECT (CONV(cur_vect),"r0",CONV(hi),0);
AFFECT (CONV(cur_vect),"q0",CONV(hi),0);
AFFECT (CONV(cur_vect),"y","0b1010",0);
AFFECT (CONV(cur_vect),"signe","0b1",0);
clock (cur_vect);
cur_vect = cur_vect+3;
/* writing of the shifted value (register and ram) */
AFFECT (CONV(cur_vect),"i","0o662",0);
AFFECT (CONV(cur_vect),"b","0b0000",0);
AFFECT (CONV(cur_vect),"r3",CONVCMP(hi),0);
AFFECT (CONV(cur_vect),"q3",CONVCMP(hi),0);
AFFECT (CONV(cur_vect),"y","0b1010",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect-1),"r3",CONVCMP(lo),0);
AFFECT (CONV(cur_vect-1),"q3",CONVCMP(lo),0);
AFFECT (CONV(cur_vect-1),"y","0b0101",0);
AFFECT (CONV(cur_vect-1),"signe","0b0",0);
AFFECT (CONV(cur_vect),"b","0b0001",0);
AFFECT (CONV(cur_vect),"r0",CONV(lo),0);
AFFECT (CONV(cur_vect),"q0",CONV(lo),0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect-1),"r3",CONVCMP(hi),0);
AFFECT (CONV(cur_vect-1),"q3",CONVCMP(hi),0);
AFFECT (CONV(cur_vect-1),"y","0b1010",0);
AFFECT (CONV(cur_vect-1),"signe","0b1",0);
AFFECT (CONV(cur_vect),"i","0o632",0);
AFFECT (CONV(cur_vect),"b","0b0010",0);
AFFECT (CONV(cur_vect),"r0",CONV(hi),0);
AFFECT (CONV(cur_vect),"q0",CONV(hi),0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect-1),"r3",CONVCMP(lo),0);
AFFECT (CONV(cur_vect-1),"q3",CONVCMP(lo),0);
AFFECT (CONV(cur_vect-1),"y","0b0101",0);
AFFECT (CONV(cur_vect-1),"signe","0b0",0);
AFFECT (CONV(cur_vect),"b","0b0011",0);
AFFECT (CONV(cur_vect),"r0",CONV(lo),0);
AFFECT (CONV(cur_vect),"q0",CONV(lo),0);
clock (cur_vect);
cur_vect = cur_vect+3;
/* writing of the shifted value (ram) */
AFFECT (CONV(cur_vect-1),"r3",CONVCMP(hi),0);
AFFECT (CONV(cur_vect-1),"q3",CONVCMP(hi),0);
AFFECT (CONV(cur_vect-1),"y","0b1010",0);
AFFECT (CONV(cur_vect-1),"signe","0b1",0);
AFFECT (CONV(cur_vect),"i","0o764",0);
AFFECT (CONV(cur_vect),"a","0b0001",0);
AFFECT (CONV(cur_vect),"b","0b0100",0);
AFFECT (CONV(cur_vect),"r0",CONV(hi),0);
AFFECT (CONV(cur_vect),"q0",CONV(hi),0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"a","0b0010",0);
AFFECT (CONV(cur_vect),"b","0b0101",0);
AFFECT (CONV(cur_vect),"r0",CONV(lo),0);
AFFECT (CONV(cur_vect),"q0",CONV(lo),0);
AFFECT (CONV(cur_vect),"r3",CONVCMP(lo),0);
AFFECT (CONV(cur_vect),"y","0b0101",0);
AFFECT (CONV(cur_vect),"signe","0b0",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"i","0o734",0);
AFFECT (CONV(cur_vect),"a","0b0011",0);
AFFECT (CONV(cur_vect),"b","0b0110",0);
AFFECT (CONV(cur_vect),"r0",CONV(hi),0);
AFFECT (CONV(cur_vect),"q0",CONV(hi),0);
AFFECT (CONV(cur_vect),"r3",CONVCMP(hi),0);
AFFECT (CONV(cur_vect),"y","0b1010",0);
AFFECT (CONV(cur_vect),"signe","0b1",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"a","0b0100",0);
AFFECT (CONV(cur_vect),"b","0b0111",0);
AFFECT (CONV(cur_vect),"r0",CONV(lo),0);
AFFECT (CONV(cur_vect),"q0",CONV(lo),0);
AFFECT (CONV(cur_vect),"r3",CONVCMP(lo),0);
AFFECT (CONV(cur_vect),"y","0b0101",0);
AFFECT (CONV(cur_vect),"signe","0b0",0);
clock (cur_vect);
cur_vect = cur_vect+3;
/* checking of the ram's content */
AFFECT (CONV(cur_vect),"i","0o163",0);
AFFECT (CONV(cur_vect),"r0",CONV(hi),0);
AFFECT (CONV(cur_vect),"q0",CONV(hi),0);
AFFECT (CONV(cur_vect),"r3",CONV(hi),0);
AFFECT (CONV(cur_vect),"q3",CONV(hi),0);
for (i=0;i<8;i=i+2)
  {
AFFECT (CONV(cur_vect),"b",CONV(i),0);
AFFECT (CONV(cur_vect),"y","0b0101",0);
AFFECT (CONV(cur_vect),"signe","0b0",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"b",CONV(i+1),0);
AFFECT (CONV(cur_vect),"y","0b1010",0);
AFFECT (CONV(cur_vect),"signe","0b1",0);
clock (cur_vect);
cur_vect = cur_vect+3;
  }
}
/**********************************************************/
/*  procedure performing the RAM test      (150 patterns) */
/**********************************************************/
void ram(cur_vect) int cur_vect;
{
int i;
int j;
int k;
int l;
int z;
/* filling of the ram : values (f->0) -> addresses (0->f)     */
/* and checking of the a-addressed word during the next cycle */
AFFECT (CONV(cur_vect),"i","0o367",0);
AFFECT (CONV(cur_vect),"b","0b0000",0);
AFFECT (CONV(cur_vect),"d","0b1111",0);
AFFECT (CONV(cur_vect),"y","0b1111",0);
AFFECT (CONV(cur_vect),"zero","0b0",0);
AFFECT (CONV(cur_vect),"signe","0b1",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"i","0o267",0);
for (i=1;i<16;i=i+1)
  {
AFFECT (CONV(cur_vect),"a",CONV(i-1),0);
AFFECT (CONV(cur_vect),"b",CONV(i),0);
AFFECT (CONV(cur_vect),"d",CONV(15-i),0);
AFFECT (CONV(cur_vect),"y",CONV(16-i),0);
z = ~((((15-i)/8)|((15-i)/4)|((15-i)/2)|(15-i))&1);
AFFECT (CONV(cur_vect),"zero",CONV(z),0);
AFFECT (CONV(cur_vect),"signe",CONV((((15-i)/8)&1)),0);
clock (cur_vect);
cur_vect = cur_vect+3;
  }
AFFECT (CONV(cur_vect),"a","0b1111",0);
AFFECT (CONV(cur_vect),"y","0b0000",0);
AFFECT (CONV(cur_vect),"signe","0b0",0);
AFFECT (CONV(cur_vect),"zero","0b1",0);
clock (cur_vect);
cur_vect = cur_vect+3;
/* checking of the b-addressed word */
/* (the first 8 words have been checked during the shifters' test) */
AFFECT (CONV(cur_vect),"i","0o163",0);
for (j=8;j<16;j=j+1)
  {
AFFECT (CONV(cur_vect),"b",CONV(j),0);
AFFECT (CONV(cur_vect),"y",CONV(15-j),0);
z = ~((((15-j)/8)|((15-j)/4)|((15-j)/2)|(15-j))&1);
AFFECT (CONV(cur_vect),"zero",CONV(z),0);
AFFECT (CONV(cur_vect),"signe",CONV((((15-j)/8)&1)),0);
clock (cur_vect);
cur_vect = cur_vect+3;
  }
/* filling of the ram : values (0->f) -> addresses (0->f)     */
/* and checking of the a-addressed word during the next cycle */
AFFECT (CONV(cur_vect),"i","0o337",0);
AFFECT (CONV(cur_vect),"b","0b0000",0);
AFFECT (CONV(cur_vect),"d","0b0000",0);
AFFECT (CONV(cur_vect),"y","0b0000",0);
AFFECT (CONV(cur_vect),"signe","0b0",0);
AFFECT (CONV(cur_vect),"zero","0b1",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"i","0o237",0);
for (k=1;k<16;k=k+1)
  {
AFFECT (CONV(cur_vect),"a",CONV(k-1),0);
AFFECT (CONV(cur_vect),"b",CONV(k),0);
AFFECT (CONV(cur_vect),"d",CONV(k),0);
AFFECT (CONV(cur_vect),"y",CONV(k-1),0);
z = ~((k/8)|(k/4)|(k/2)|(k)&1);
AFFECT (CONV(cur_vect),"zero",CONV(z),0);
AFFECT (CONV(cur_vect),"signe",CONV(((k/8)&1)),0);
clock (cur_vect);
cur_vect = cur_vect+3;
  }
/* checking of the b-addressed word */
/* (the first 8 words have been checked during the shifters' test) */
AFFECT (CONV(cur_vect),"i","0o267",0);
AFFECT (CONV(cur_vect),"a","0b1111",0);
AFFECT (CONV(cur_vect),"y","0b1111",0);
AFFECT (CONV(cur_vect),"signe","0b1",0);
AFFECT (CONV(cur_vect),"zero","0b0",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"i","0o133",0);
for (l=8;l<16;l=l+1)
  {
AFFECT (CONV(cur_vect),"b",CONV(l),0);
AFFECT (CONV(cur_vect),"y",CONV(l),0);
z = ~(((l/8)|(l/4)|(l/2)|l)&1);
AFFECT (CONV(cur_vect),"zero",CONV(z),0);
AFFECT (CONV(cur_vect),"signe",CONV(((l/8)&1)),0);
clock (cur_vect);
cur_vect = cur_vect+3;
  }
}
/***************************************************************/
/*  procedure performing all logical operations  (30 patterns) */
/***************************************************************/
/* v0, d1, d2 help to define the selected operation */
/* op1, op2 are the two selected operands           */
/* cad ="0" if the operands are A and D, "1" else   */
/* cdq ="0" if the operands are D and Q, "1" else   */
/* The values of all above mentioned parameters must be decimal ones */
void logic(cur_vect,v0,d1,d2,op1,op2,cad,cdq) 
int cur_vect,v0,d1,d2,op1,op2,cad,cdq;
{
int j;
int x;
int z;
AFFECT (CONV(cur_vect),"i",CONV(v0),0);
x = op1|op2;
z = ~((x/8)|(x/4)|(x/2)|(x)&1);
AFFECT (CONV(cur_vect+3*cad),"y",CONV(x),0);
AFFECT (CONV(cur_vect+3*cad),"zero",CONV(z),0);
AFFECT (CONV(cur_vect+3*cad),"signe",CONV(((x/8)&1)),0);
clock (cur_vect);
cur_vect = cur_vect + 3;
for (j=0;j<2;j=j+1)
  {
v0 = v0+d1;
AFFECT (CONV(cur_vect),"i",CONV(v0),0);
x = op1*(1-j) + op1*cdq*j;
z = ~((x/8)|(x/4)|(x/2)|(x)&1);
AFFECT (CONV(cur_vect-3*cad),"y",CONV(x),0);
AFFECT (CONV(cur_vect-3*cad),"zero",CONV(z),0);
AFFECT (CONV(cur_vect-3*cad),"signe",CONV(((x/8)&1)),0);
clock (cur_vect);
cur_vect = cur_vect + 3;
v0 = v0+d2;
AFFECT (CONV(cur_vect),"i",CONV(v0),0);
x = (op1&op2)*(1-j) + (op1^op2)*j;
z = ~((x/8)|(x/4)|(x/2)|(x)&1);
AFFECT (CONV(cur_vect+3*cad),"y",CONV(x),0);
AFFECT (CONV(cur_vect+3*cad),"zero",CONV(z),0);
AFFECT (CONV(cur_vect+3*cad),"signe",CONV(((x/8)&1)),0);
clock (cur_vect);
cur_vect = cur_vect + 3;
v0 = v0+d1;
AFFECT (CONV(cur_vect),"i",CONV(v0),0);
x = op1*j;
z = ~((x/8)|(x/4)|(x/2)|(x)&1);
AFFECT (CONV(cur_vect-3*cad),"y",CONV(x),0);
AFFECT (CONV(cur_vect-3*cad),"zero",CONV(z),0);
AFFECT (CONV(cur_vect-3*cad),"signe",CONV(((x/8)&1)),0);
clock (cur_vect);
cur_vect = cur_vect + 3;
v0 = v0+d2;
AFFECT (CONV(cur_vect),"i",CONV(v0),0);
x = (((~op2)&op1)*cdq + ((~op1)&op2)*(1-cdq))*(1-j) + (~(op1^op2))*j;
z = ~((x/8)|(x/4)|(x/2)|(x)&1);
AFFECT (CONV(cur_vect+3*cad),"y",CONV(x),0);
AFFECT (CONV(cur_vect+3*cad),"zero",CONV(z),0);
AFFECT (CONV(cur_vect+3*cad),"signe",CONV(((x/8)&1)),0);
clock (cur_vect);
cur_vect = cur_vect + 3;
  }
v0 = v0+d1;
AFFECT (CONV(cur_vect),"i",CONV(v0),0);
x = ~op1;
z = ~((x/8)|(x/4)|(x/2)|(x)&1);
AFFECT (CONV(cur_vect-3*cad),"y",CONV(x),0);
AFFECT (CONV(cur_vect-3*cad),"zero",CONV(z),0);
AFFECT (CONV(cur_vect-3*cad),"signe",CONV(((x/8)&1)),0);
clock (cur_vect);
}  
/*****************************************************************/
/*  procedure performing all arithmetic operations (18 patterns) */
/*****************************************************************/
/* v0, d1, d2 help to define the selected operation                  */
/* op1, op2 are the two selected operands                            */
/* cad ="0" if the operands are A and D, "1" else                    */
/* cdq ="-1" if the operands are D and Q, "1" else                   */
/* cin is the carry input of the AMD2901                             */
/* The following parameters are used for the flags                   */
/* cqa ="1" if the operands are Q and A, "0" else (used for ovr)     */
/* np, ng enable to foretell the values of the np, ng and cout flags */
/* The values of all above mentioned parameters must be decimal ones */
void arithmetic(cur_vect,v0,d1,d2,op1,op2,cad,cdq,cin,cqa,np,ng) 
int cur_vect,v0,d1,d2,op1,op2,cad,cdq,cin,cqa,np,ng;
{
int i;
int x;
int z;
int p;
int g;
AFFECT (CONV(cur_vect),"i",CONV(v0),0);
x = op1+op2+cin;
z = ~((x/8)|(x/4)|(x/2)|(x)&1);
p = ((np/32)&1);
g = ((ng/32)&1);
AFFECT (CONV(cur_vect+3*cad),"y",CONV(x),0);
AFFECT (CONV(cur_vect+3*cad),"zero",CONV(z),0);
AFFECT (CONV(cur_vect+3*cad),"signe",CONV(((x/8)&1)),0);
AFFECT (CONV(cur_vect+3*cad),"ovr","0b0",0);
AFFECT (CONV(cur_vect+3*cad),"np",CONV(p),0);
AFFECT (CONV(cur_vect+3*cad),"ng",CONV(g),0);
AFFECT (CONV(cur_vect+3*cad),"cout",CONV(((~p)&cin)|(~g)),0);
clock (cur_vect);
cur_vect = cur_vect + 3;
for (i=0;i<2;i=i+1)
  {
v0 = v0+d1;
AFFECT (CONV(cur_vect),"i",CONV(v0),0);
x = op1-op1*2*(((cdq-i)*cdq)/2)+cin-(i+1)/2;
z = ~((x/8)|(x/4)|(x/2)|(x)&1);
p = ((np/(16-i*12))&1);
g = ((ng/(16-i*12))&1);
AFFECT (CONV(cur_vect-3*cad),"y",CONV(x),0);
AFFECT (CONV(cur_vect-3*cad),"zero",CONV(z),0);
AFFECT (CONV(cur_vect-3*cad),"signe",CONV(((x/8)&1)),0);
AFFECT (CONV(cur_vect-3*cad),"ovr","0b0",0);
AFFECT (CONV(cur_vect-3*cad),"np",CONV(p),0);
AFFECT (CONV(cur_vect-3*cad),"ng",CONV(g),0);
AFFECT (CONV(cur_vect-3*cad),"cout",CONV(((~p)&cin)|(~g)),0);
clock (cur_vect);
cur_vect = cur_vect + 3;
v0 = v0+d2;
AFFECT (CONV(cur_vect),"i",CONV(v0),0);
x = (1-2*i)*cdq*(op1-op2)-1+cin;
z = ~((x/8)|(x/4)|(x/2)|(x)&1);
p = ((np/(8-i*6))&1);
g = ((ng/(8-i*6))&1);
AFFECT (CONV(cur_vect+3*cad),"y",CONV(x),0);
AFFECT (CONV(cur_vect+3*cad),"zero",CONV(z),0);
AFFECT (CONV(cur_vect+3*cad),"signe",CONV(((x/8)&1)),0);
AFFECT (CONV(cur_vect+3*cad),"ovr",CONV(cqa),0);
AFFECT (CONV(cur_vect+3*cad),"np",CONV(p),0);
AFFECT (CONV(cur_vect+3*cad),"ng",CONV(g),0);
AFFECT (CONV(cur_vect+3*cad),"cout",CONV(((~p)&cin)|(~g)),0);
clock  (cur_vect);
cur_vect = cur_vect + 3;
  }
v0 = v0+d1;
AFFECT (CONV(cur_vect),"i",CONV(v0),0);
x = (-op1)*cdq-1+cin;
z = ~((x/8)|(x/4)|(x/2)|(x)&1);
p = (np&1);
g = (ng&1);
AFFECT (CONV(cur_vect-3*cad),"y",CONV(x),0);
AFFECT (CONV(cur_vect-3*cad),"zero",CONV(z),0);
AFFECT (CONV(cur_vect-3*cad),"signe",CONV(((x/8)&1)),0);
AFFECT (CONV(cur_vect-3*cad),"ovr","0b0",0);
AFFECT (CONV(cur_vect-3*cad),"np",CONV(p),0);
AFFECT (CONV(cur_vect-3*cad),"ng",CONV(g),0);
AFFECT (CONV(cur_vect-3*cad),"cout",CONV(((~p)&cin)|(~g)),0);
clock  (cur_vect);
}  
/****************************************/
/* test mode : scanning of the register */
/****************************************/ 
void test_mode(cur_vect) int cur_vect;
{
int i;
int x;
int z;
AFFECT (CONV(cur_vect),"i","0o067",0);
AFFECT (CONV(cur_vect),"d","0b1110",0);
AFFECT (CONV(cur_vect),"y","0b1110",0);
AFFECT (CONV(cur_vect),"zero","0b0",0);
AFFECT (CONV(cur_vect),"signe","0b1",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"i","0o162",0);
AFFECT (CONV(cur_vect),"y","0b1110",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect),"i","0o162",0);
AFFECT (CONV(cur_vect),"fonc","0b0",0);
AFFECT (CONV(cur_vect),"test","0b1",0);
AFFECT (CONV(cur_vect),"y","0b1110",0);
AFFECT (CONV(cur_vect),"scout","0b1",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect-1),"y","0b1100",0);
AFFECT (CONV(cur_vect),"scin","0b1",0);
clock (cur_vect);
cur_vect = cur_vect+3;
AFFECT (CONV(cur_vect-1),"y","0b1001",0);
AFFECT (CONV(cur_vect),"scin","0b0",0);
x = 9;
for(i=0;i<5;i=i+1)
  {
clock (cur_vect);
cur_vect = cur_vect+3;
x = x*2;
z = ~((x/8)|(x/4)|(x/2)|(x)&1);
AFFECT (CONV(cur_vect-1),"y",CONV(x),0);
AFFECT (CONV(cur_vect-1),"zero",CONV(z),0);
AFFECT (CONV(cur_vect-1),"signe",CONV(((x/8)&1)),0);
AFFECT (CONV(cur_vect-1),"scout",CONV(((x/8)&1)),0);
  }
}
/************************************/
/*           main program           */
/************************************/
void main()
{
int cv;
DEF_GENPAT ("pattern");
PORT ("a","b","d",":1","x","i","3 DOWNTO 0",0);
PORT ("i",":1","o","i","8 DOWNTO 0",0);
PORT ("fonc","test","scin","noe","ck","cin",":1","b","i",0);
PORT ("r0","r3","q0","q3",":1","b","t",0);
PORT ("y",":1","x","o","3 DOWNTO 0",0);
PORT ("zero","signe","scout","ovr","np","ng","cout",":1","b","o",0);
PORT ("vdd","vss",":1","b","i",0);
PORT ("vddp","vssp",":1","b","i",0);
LABEL ("accu");
AFFECT ("0","a","0b0000",0);
AFFECT ("0","b","0b0000",0);
AFFECT ("0","fonc","0b1",0);
AFFECT ("0","test","0b0",0);
AFFECT ("0","scin","0b0",0);
AFFECT ("0","noe","0b0",0);
AFFECT ("0","cin","0b0",0);
AFFECT ("0","vdd","0b1",0);
AFFECT ("0","vss","0b0",0);
AFFECT ("0","vddp","0b1",0);
AFFECT ("0","vssp","0b0",0);
AFFECT ("0","r0","0b1",0);
AFFECT ("0","r3","0b1",0);
AFFECT ("0","q0","0b1",0);
AFFECT ("0","q3","0b1",0);
AFFECT ("0","zero","0b0",0);
AFFECT ("0","signe","0b0",0);
AFFECT ("0","scout","0b*",0);
AFFECT ("0","ovr","0b0",0);
AFFECT ("0","np","0b1",0);
AFFECT ("0","ng","0b1",0);
AFFECT ("0","cout","0b0",0);
cv = 0;
shift_right(cv);
cv = cv +51;
shift_left(cv);
cv = cv +51;
AFFECT (CONV(cv),"r0","0b1",0);
AFFECT (CONV(cv),"q0","0b1",0);
AFFECT (CONV(cv),"r3","0b1",0);
AFFECT (CONV(cv),"q3","0b1",0);
LABEL ("ram");
ram(cv);
cv = cv + 150;
/* After running this procedure, the RAM is filled as follows :  */
/* values (0->f)  ->  addresses (0->f), which will be used later */  
AFFECT (CONV(cv),"i","0o164",0);
AFFECT (CONV(cv),"a","0b0101",0);
AFFECT (CONV(cv),"y","0b0101",0);
AFFECT (CONV(cv),"zero","0b0",0);
AFFECT (CONV(cv),"signe","0b0",0);
clock (cv);
cv = cv+3;
/* ALU TEST :  A->0101 and D->1111 */ 
LABEL ("alu");
logic (cv,92,1,7,5,15,1,1);
cv = cv + 30;
arithmetic (cv,68,1,7,5,15,1,1,0,0,25,25);
cv = cv + 18;
/* ALU TEST : Q->0011 and A->1010 */
AFFECT (CONV(cv),"i","0o037",0);
AFFECT (CONV(cv),"a","0b1010",0);
AFFECT (CONV(cv),"d","0b0011",0);
AFFECT (CONV(cv),"y","0b0011",0);
AFFECT (CONV(cv),"zero","0b0",0);
AFFECT (CONV(cv),"signe","0b0",0);
AFFECT (CONV(cv),"ovr","0b0",0);
AFFECT (CONV(cv),"np","0b1",0);
AFFECT (CONV(cv),"ng","0b1",0);
AFFECT (CONV(cv),"cout","0b0",0);
clock (cv);
cv = cv+3;
arithmetic (cv,64,2,6,3,10,0,1,0,1,59,57);
cv = cv + 18;
AFFECT (CONV(cv),"ovr","0b0",0);
AFFECT (CONV(cv),"np","0b1",0);
AFFECT (CONV(cv),"ng","0b1",0);
AFFECT (CONV(cv),"cout","0b0",0);
logic (cv,88,2,6,3,10,0,1);
cv = cv + 30;
/* ALU TEST : D->0000 and Q->1100 */
AFFECT (CONV(cv),"i","0o037",0);
AFFECT (CONV(cv),"d","0b1100",0);
AFFECT (CONV(cv),"y","0b1100",0);
AFFECT (CONV(cv),"zero","0b0",0);
AFFECT (CONV(cv),"signe","0b1",0);
clock (cv);
cv = cv+3;
AFFECT (CONV(cv),"d","0b0000",0);
logic (cv,94,1,7,0,12,0,0);
cv = cv + 30;
arithmetic (cv,70,1,7,0,12,0,-1,0,0,50,55);
cv = cv + 18;
/* ALU TEST : B->1111 and A->1111 */
AFFECT (CONV(cv),"b","0b1111",0);
AFFECT (CONV(cv),"a","0b1111",0);
arithmetic (cv,65,2,6,15,15,0,1,0,0,1,27);
cv = cv + 18;
AFFECT (CONV(cv),"cin","0b1",0);
arithmetic (cv,65,2,6,15,15,0,1,1,0,1,27);
cv = cv + 18;
AFFECT (CONV(cv),"ovr","0b0",0);
AFFECT (CONV(cv),"np","0b1",0);
AFFECT (CONV(cv),"ng","0b1",0);
AFFECT (CONV(cv),"cout","0b0",0);
logic (cv,89,2,6,15,15,0,1);
cv = cv + 30;
/* TEST MODE */ 
LABEL ("scan");
test_mode(cv);
cv = cv + 27;
/* noe=1 : high-impedance output */
LABEL ("high_Z");
AFFECT (CONV(cv),"y","0b****",0);
AFFECT (CONV(cv),"noe","0b1",0);
clock (cv);
SAV_GENPAT();
}  
