
/************************************************************************/
/*                    MBK   ----------->  CIF                           */
/* -  layers are discribed with boxes (B)                               */
/* -  figure names was in comment                      ex : (na2_y)     */
/*    now they are precceded by the dialect command 9  ex : 9 na2_y;    */
/* -  somes references (a2l, a2r, a2rl)  are traduced as vias           */
/* -  regenerate tie layers                                             */
/************************************************************************/

#include "symb2cif.tec"
 
#include MUT_H 
#include MPH_H 

chain_list   *MODEL_CHAIN = NULL ;

/************************************************************************/
/* building of complete hierarchical instance model list                */
/************************************************************************/

/*-----------------------------------------------------------------------*/
/* return the list of model figure at first                              */
/*-----------------------------------------------------------------------*/

chain_list *make_model_list( pt_phfig )

phfig_list  *pt_phfig ;

{
  phins_list   * pt_ins ;
  chain_list   * pt_chain ;

  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- make_model_list \n" ) ;

  for ( pt_ins = pt_phfig->PHINS ; pt_ins != NULL ; pt_ins = pt_ins->NEXT ) {
    for ( pt_chain = MODEL_CHAIN ; pt_chain != NULL ; pt_chain = pt_chain->NEXT ) {
      if ( ( ( phfig_list * )pt_chain->DATA )->NAME == pt_ins->FIGNAME ) {
        break ;
      }
    }
    if ( pt_chain == NULL ) {
      /* if not already in model list , add a new model to it */
      phfig_list   * pt_model ;
      pt_model = getphfig( pt_ins->FIGNAME , 'A' ) ;
      make_model_list( pt_model ) ;
    } else {
      /* already in model list */
    }
  }

  /* add the mother figure */
  MODEL_CHAIN = addchain( MODEL_CHAIN , ( char *)pt_phfig ) ;

  return( MODEL_CHAIN ) ;
}


/*****************************************************************************/
/***** *  Automatic generation of NTIE & PTIE Layers            ********/
/*****************************************************************************/

polar( phfig )
phfig_list  *phfig ;
{
 phseg_list  *phseg ;
 phvia_list  *phvia ;

/*
 *  First we transform all NTIE and PTIE in NDIF and PDIF, to eliminate design errors :
 *  Put an PTIE in place of PDIF.
 */
  for( phseg = phfig->PHSEG ; phseg != NULL ; phseg = phseg->NEXT )  {
    if( phseg->LAYER == NTIE )  phseg->LAYER = NDIF ;
    if( phseg->LAYER == PTIE )  phseg->LAYER = PDIF ;
  }
  for( phvia = phfig->PHVIA ; phvia != NULL ; phvia = phvia->NEXT )  {
    if( phvia->TYPE == CONT_BODY_N )  phvia->TYPE = CONT_DIF_N ;
    if( phvia->TYPE == CONT_BODY_P )  phvia->TYPE = CONT_DIF_P ;
  }
/*
 *    Now we generate the layers NTIE & PTIE.
 */
  for( phseg = phfig->PHSEG ; phseg != NULL ; phseg = phseg->NEXT )
    if( phseg->LAYER == NDIF  ||  phseg->LAYER == PDIF )
      if( innwell( phseg->X1, phseg->Y1, phfig ) )  {
        if( phseg->LAYER == NDIF )  phseg->LAYER = NTIE ;
      }
      else  if( phseg->LAYER == PDIF )  phseg->LAYER = PTIE ;
  for( phvia = phfig->PHVIA ; phvia != NULL ; phvia = phvia->NEXT )
    if( phvia->TYPE == CONT_DIF_N  ||  phvia->TYPE == CONT_DIF_P )
      if( innwell( phvia->XVIA, phvia->YVIA, phfig ) )  {
        if( phvia->TYPE == CONT_DIF_N )  phvia->TYPE = CONT_BODY_N ;
      }
      else  if( phvia->TYPE == CONT_DIF_P )  phvia->TYPE = CONT_BODY_P ;
}


int innwell( x, y, phfig )
long  x, y ;
phfig_list  *phfig ;
{
int  inwell ;
phseg_list  *nseg ;

   inwell = 0 ;

  for( nseg = phfig->PHSEG ; nseg != NULL ; nseg = nseg->NEXT )  {
    if( nseg->LAYER == NWELL )
      if( nseg->TYPE == HOR )
        inwell = (  x >= nseg->X1
          &&  x <= nseg->X2
          &&  y >= (nseg->Y1 - nseg->WIDTH/2)
          &&  y <= (nseg->Y2 + nseg->WIDTH/2) ) ;
      else
        inwell = (  x >= nseg->X1 - nseg->WIDTH/2
          &&  x <= nseg->X2 + nseg->WIDTH/2
          &&  y >= nseg->Y1
          &&  y <= nseg->Y2 ) ;
    if( inwell )  break ;
    }
  return  inwell ;
}

/****************************************************************************/
/*****   macros                                                         *****/
/****************************************************************************/

#define CIF     4306
#define CIF_UNIT  100 

/****************************************************************************/
/*****   global variables                                               *****/
/****************************************************************************/

FILE            *pt_file ;

/****************************************************************************/
/*****   writing mother figure                                          *****/
/****************************************************************************/

wr_figure( model_num )

int  model_num ;

{
  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- wr_figure \n" ) ;

  fprintf( pt_file , "C%ld;\n" , model_num ) ;
}



/****************************************************************************/
/**** writing instance                                                   ****/
/****************************************************************************/

wr_ins( model_name , ins_name , model_num , x , y , mbk_transf )

char  *model_name ;
char  *ins_name ;
int  model_num ;
int  x ;
int  y ;
int  mbk_transf ;

{
  char  cif_transf[100] ;
  int  cif_x ;
  int  cif_y ;

  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- wr_ins \n" ) ;

  cif_x = (x * CIF_UNIT) / SCALE ;
  cif_y = (y * CIF_UNIT) / SCALE ;

  switch ( mbk_transf ) {
  case NOSYM :
    {
      sprintf( cif_transf , "T%ld,%ld" , cif_x , cif_y ) ;
      break ;
    }
  case SYM_X :
    {
      sprintf( cif_transf , "MX T%ld,%ld" , cif_x , cif_y ) ;
      break ;
    }
  case SYM_Y :
    {
      sprintf( cif_transf , "MY T%ld,%ld" , cif_x , cif_y ) ;
      break ;
    }
  case SYMXY :
    {
      sprintf( cif_transf , "R-1,0 T%ld,%ld" , cif_x , cif_y ) ;
      break ;
    }
  case ROT_P :
    {
      sprintf( cif_transf , "R0,1 T%ld,%ld" , cif_x , cif_y ) ;
      break ;
    }
  case ROT_M :
    {
      sprintf( cif_transf , "R0,-1 T%ld,%ld" , cif_x , cif_y ) ;
      break ;
    }
  case SY_RP :
    {
      sprintf( cif_transf , "MX R0,-1 T%ld,%ld" , cif_x , cif_y ) ;
      break ;
    }
  case SY_RM :
    {
      sprintf( cif_transf , "MX R0,1 T%ld,%ld" , cif_x , cif_y ) ;
      break ;
    }
  default :
    {
      printf( "*** mbk *** wr_ins : unknown transformation \n" ) ;
      exit( -1 ) ;
    }
  }
  fprintf( pt_file , "C%ld %s;" , model_num , cif_transf ) ;
  fprintf( pt_file , "4I %s;\n" , ins_name ) ;  /* 24/9/90 */

}


/****************************************************************************/
/**** writing segments                                                   ****/
/****************************************************************************/

wr_rect( x1 , y1 , x2 , y2 , phys_layer )

int  x1 ;
int  y1 ;
int  x2 ;
int  y2 ;
char  phys_layer ;

{
  int  cif_x1 ;
  int  cif_y1 ;
  int  cif_x2 ;
  int  cif_y2 ;

  cif_x1 = ( x1 * CIF_UNIT ) / SCALE ;
  cif_y1 = ( y1 * CIF_UNIT ) / SCALE ;
  cif_x2 = ( x2 * CIF_UNIT ) / SCALE ;
  cif_y2 = ( y2 * CIF_UNIT ) / SCALE ;

  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- wr_rect : %5g %5g %5g %5g %5d \n"  , 
      x1 , y1 , x2 , y2 , phys_layer ) ;

  fprintf( pt_file , "L%s;", Cif_Layer[ phys_layer ] ) ;

  fprintf( pt_file , "B%ld %ld %ld,%ld;\n" , 
    cif_x2 - cif_x1 , cif_y2 - cif_y1, 
    cif_x1 + (cif_x2 - cif_x1) / 2 , 
    cif_y1 + (cif_y2 -  cif_y1) / 2);

}


/****************************************************************************/
/* writing figure header                                                    */
/****************************************************************************/

wr_header( figname )

char  *figname ;

{
  int  counter = 0 ;

  time( &counter ) ;
  fprintf( pt_file , "(MBK-CIF\n" );
  fprintf( pt_file , "%s" , ctime( &counter ) );
  fprintf( pt_file , "%s\n" , figname );
  fprintf( pt_file , "%s);\n\n" , getenv( "USER" ) );

}


/****************************************************************************/
/* writing figure tail                                                      */
/****************************************************************************/

wr_tail( xab1 , yab1 , xab2 , yab2 )

int  xab1 ;
int  yab1 ;
int  xab2 ;
int  yab2 ;

{
  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- wr_tail \n" ) ;

  fprintf( pt_file , "(AB : %ld,%ld %ld,%ld in lambda); \n" , xab1 , yab1 , xab2 , yab2 ) ;
  fprintf( pt_file , "E \n" ) ;
}


/****************************************************************************/
/* writing of model header                                                  */
/****************************************************************************/

wr_model_header( pt_model )

phfig_list  *pt_model ;

{
  static int  model_num = 0 ;

  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- wr_model_header : cif \n" ) ;

  model_num ++;
  fprintf( pt_file , "DS%ld;\n" , model_num ) ;
  fprintf( pt_file , "9 %s;\n" , pt_model->NAME ) ; /* 24/9/90 */
  fprintf( pt_file , "(AB : %ld,%ld %ld,%ld in lambda); \n" , pt_model->XAB1 , pt_model->YAB1 , 
      pt_model->XAB2 , pt_model-> YAB2 ) ;

  pt_model->USER = addptype( pt_model->USER , CIF , ( char * )model_num ) ;

}


/****************************************************************************/
/* writing of model tail                                                    */
/****************************************************************************/

wr_model_tail( pt_model )

phfig_list  *pt_model ;

{

  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- wr_model_tail : cif \n" ) ;

  fprintf( pt_file , "DF;\n\n" ) ;

}


/****************************************************************************/
/* opening CIF output file                                                  */
/****************************************************************************/

open_outfile( figname )

char  *figname ;

{
  char  filename[120] ;

  strcpy( filename , WORK_LIB ) ;
  strcat( filename , "/" ) ;
  strcat( filename , figname ) ;
  strcat( filename , ".cif" ) ;
  if ( ( pt_file = fopen( filename , "w" ) ) == NULL ) {
    printf( "\n*** cif *** savecif : can't open file : %s \n" , filename ) ;
    perror( "" )  ;
    exit( -1 ) ;
  }
  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- savecif : file : %s \n" , filename ) ;
}


void usage(argc, argv)
int  argc;
char  *argv[];
{
  printf("usage : %s file \n", argv[0]);
  printf("        file to be traducted \n");
  exit(1);
}


/****************************************************************************/
/**** macro definitions                                                  ****/
/****************************************************************************/

#define Next(pt)                        ((pt)->NEXT)


#define Min_Symb_Width(mbk_layer)       Symb_to_Phys[ mbk_layer ][ 0 ]

#define Phys_Layer(num_layer,mbk_layer) ( (char )Symb_to_Phys[ mbk_layer ][ 1 + num_layer * 3])

#define Long_Ext(num_layer,mbk_layer)   Symb_to_Phys[ mbk_layer ][ 2 + num_layer * 3]

#define Width_Ext(num_layer,mbk_layer)  Symb_to_Phys[ mbk_layer ][ 3 + num_layer * 3]


#define Min_Phys_Width(phys_layer)      techno[ phys_layer ][ 0 ]

#define Segment_Ext(phys_layer)         techno[ phys_layer ][ 1 ]

#define Connector_Ext(phys_layer)       techno[ phys_layer ][ 2 ]


#define Side(num_layer, type)           via[ type ][ 1 + num_layer * 2 ]

#define VIALayer(num_layer,type)         ( ( char )via[ type ][ num_layer * 2 ] )

#define REFLayer(num_layer,type)         ( ( char )ref[ type ][ num_layer * 2 ] )

#define roundNE(exp)   ( ((exp)>=0) \
      ?((((exp) + PHYS_GRID/2) / PHYS_GRID ) * PHYS_GRID)\
      :(((exp) / PHYS_GRID ) * PHYS_GRID) )

#define roundSW(exp)   ( (exp>=0) \
      ?(((exp) / PHYS_GRID ) * PHYS_GRID) \
      :((((exp) - PHYS_GRID/2) / PHYS_GRID ) * PHYS_GRID) )

/****************************************************************************/
/* main translating function from symbolic MBK to physical layout           */
/****************************************************************************/

void     savephys (pt_phfig)

phfig_list      *pt_phfig;

{
  chain_list     * model_list    = NULL ;


  /*****  opening output file   *****/
  open_outfile( pt_phfig->NAME ) ;

  /***** printing lambda value *****/
  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- lambda : %g \n" , LAMBDA ) ;

  /*****  building instance model list ****/
  model_list = make_model_list( pt_phfig ) ;


  /****  translating figure header  ****/
  trad_header( pt_phfig ) ;


#ifdef MAKEFILE
  /****  buliting of the hierarchical makefile ****/
  {
    chain_list   * pt_chain = NULL, * pt_model = NULL ;
    FILE     * makefile;

    makefile = fopen( "make_versatil", "w");

    fprintf(makefile, "# -------------------------------------------\n");
    fprintf(makefile, "# makefile just used by Hierarchical Versatil\n");
    fprintf(makefile, "# -------------------------------------------\n");
    fprintf(makefile, ".SILENT:\n");
    
    for ( pt_chain = model_list ; pt_chain != NULL ; pt_chain = pt_chain->NEXT ) {
      if (in_catalog(((( phfig_list * )pt_chain->DATA)->NAME ))) {
        fprintf( makefile, "%s.RNG: %s/%s.%s", 
          ((( phfig_list * )pt_chain->DATA)->NAME ),
          ( char * )CATA_LIB,
          ((( phfig_list * )pt_chain->DATA)->NAME ), IN_PH);
      } else {
        fprintf( makefile, "%s.RNG: %s.%s", 
          ((( phfig_list * )pt_chain->DATA)->NAME ),
          ((( phfig_list * )pt_chain->DATA)->NAME ), IN_PH);
      }
      for (   pt_model = (( phfig_list * )pt_chain->DATA)->MODELCHAIN;
        pt_model != NULL ; pt_model = pt_model->NEXT ) {
        if (in_catalog(( char * )pt_model->DATA)) {
          fprintf(makefile,"\\\n  %s/%s.%s %s.RNG",
            ( char * )CATA_LIB,
            ( char * )pt_model->DATA, IN_PH, ( char * )pt_model->DATA);
        } else {
          fprintf(makefile,"\\\n  %s.%s %s.RNG",
            ( char * )pt_model->DATA, IN_PH, ( char * )pt_model->DATA);
        }
      }
      fprintf( makefile, "\n\t-echo \"  updating %s.RNG\"", (( phfig_list * )pt_chain->DATA)->NAME );
      fprintf( makefile, "\n\t-rm -f %s.RNG\n\n", (( phfig_list * )pt_chain->DATA)->NAME );
    }
    fprintf(makefile, "\n\n");
    
    fclose( makefile);
  }
#endif

  /**** ordering list and translating instance models ****/
  model_list = reverse( model_list ) ;

  {
    chain_list   * pt_chain = NULL ;

    for ( pt_chain = model_list ; pt_chain != NULL ; pt_chain = pt_chain->NEXT ) {
      if ( TRACE_MODE == 'Y' )
        printf( "--- mbk --- translating model : %s \n" , 
        (( phfig_list * )pt_chain->DATA )->NAME);
      polar( ( phfig_list * )pt_chain->DATA ) ;
      trad_model( ( phfig_list * )pt_chain->DATA ) ;
    }
  }

  /**** translating main figure contents ****/
  {
    trad_figure( pt_phfig ) ;
  }

  /**** translating figure tail ****/
  {
    trad_tail( pt_phfig ) ;
  }

}


/****************************************************************************/
/**** translating main figure contents                                   ****/
/****************************************************************************/

trad_figure( pt_phfig )

phfig_list  *pt_phfig ;

{
  int  model_num ;

  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- trad_figure \n" ) ;

  model_num = ( int )getptype( pt_phfig->USER , CIF )->DATA ;

  wr_figure( model_num ) ;

}


/****************************************************************************/
/**** translating one instance model                                     ****/
/****************************************************************************/

trad_model( pt_model )

phfig_list  *pt_model ;

{
  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- trad_model \n" ) ;

  /***** writing the model's header *****/
  wr_model_header( pt_model ) ;

  /***** translating the model's content *****/
  trad_content( pt_model ) ;

  /***** writing the model's tail *****/
  wr_model_tail( pt_model ) ;
}


/****************************************************************************/
/**** translating  figure's contents                                     ****/
/****************************************************************************/

trad_content( pt_phfig )

phfig_list  *pt_phfig ;

{
  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- trad_content \n" ) ;


  /**** translating connectors ****/
  {
    phcon_list   * pt_con = NULL ;

    for ( pt_con = pt_phfig->PHCON ; pt_con != NULL ; pt_con = Next(pt_con) ) {
      trad_con( ( int ) pt_con->XCON , 
          ( int ) pt_con->YCON  , 
          ( int ) pt_con->WIDTH  , 
          ( char )pt_con->LAYER , ( char )pt_con->ORIENT ) ;
    }
  }

  /**** translating segments ****/
  {
    phseg_list   * pt_seg = NULL ;

    for ( pt_seg = pt_phfig->PHSEG ; pt_seg != NULL ; pt_seg = Next(pt_seg) ) {
      trad_seg( ( int ) pt_seg->X1  , 
          ( int ) pt_seg->Y1  , 
          ( int ) pt_seg->X2  , 
          ( int ) pt_seg->Y2  , 
          ( int ) pt_seg->WIDTH ,
          ( char )pt_seg->LAYER , ( char )pt_seg->TYPE ) ;
    }
  }

  /**** traduction des vias ****/
  {
    phvia_list   * pt_via = NULL ;

    for ( pt_via = pt_phfig->PHVIA ; pt_via != NULL ; pt_via = Next(pt_via) ) {
      trad_via( ( int ) pt_via->XVIA  , ( int ) pt_via->YVIA  , pt_via->TYPE) ;
    }
  }

        /**** traduction des references ****/
        {
                phref_list       * pt_ref = NULL ;
    char     * name_a2r, * name_a2l, * name_a2rl;
 
    name_a2r  = namealloc ("ref_a2r");
    name_a2l  = namealloc ("ref_a2l");
    name_a2rl = namealloc ("ref_a2rl");

                for ( pt_ref = pt_phfig->PHREF ; pt_ref != NULL ; pt_ref = Next(pt_ref) ) {

      if (pt_ref->FIGNAME == name_a2r)
                          trad_ref( ( int ) pt_ref->XREF , ( int ) pt_ref->YREF, REF_A2R ) ;
    else  if (pt_ref->FIGNAME == name_a2l)
                          trad_ref( ( int ) pt_ref->XREF , ( int ) pt_ref->YREF, REF_A2L ) ;
    else  if (pt_ref->FIGNAME == name_a2rl)
                          trad_ref( ( int ) pt_ref->XREF , ( int ) pt_ref->YREF, REF_A2RL ) ;

                }
        }
 
  /**** traduction des instances ****/
  {
    phins_list   * pt_ins = NULL ;

    for ( pt_ins = pt_phfig->PHINS ; pt_ins != NULL ; pt_ins = Next(pt_ins) ) {
      trad_ins( ( int )pt_ins->XINS , 
          ( int )pt_ins->YINS , pt_ins->FIGNAME ,
          pt_ins->INSNAME , pt_ins->TRANSF ) ;
    }
  }

}


/****************************************************************************/
/**** traduction des connecteurs                                         ****/
/****************************************************************************/

trad_con( mbk_x , mbk_y , mbk_width , mbk_layer , orient )

int  mbk_x ;
int  mbk_y ;
int  mbk_width ;
char  mbk_layer ;
char  orient ;

{
  int  x1 ;
  int  y1 ;
  int  x2 ;
  int  y2 ;
  char  phys_layer  ;
  int  num_layer;

  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- trad_con \n" ) ;
  for ( num_layer = 0 ; num_layer < N_TRANS_LAYER ; num_layer++) {

    phys_layer = Phys_Layer( num_layer, mbk_layer );
    if ( phys_layer == PHYS_NOP )  
      continue;

    switch ( orient ) {
    case NORTH :
    case SOUTH :

      /* calcul de x1 */
      x1 = 0;
      x1 -= mbk_width + Width_Ext( num_layer, mbk_layer ) - Min_Symb_Width( mbk_layer );
      x1 *= LAMBDA  ;
      x1 -= Min_Phys_Width( phys_layer ) ;
      x1 /= 2 ;
      x1 += LAMBDA * mbk_x ;
      x1 = roundSW (x1);

      /* calcul de x2 */
      x2 = mbk_width + Width_Ext( num_layer, mbk_layer ) - Min_Symb_Width( mbk_layer );
      x2 *= LAMBDA;
      x2 += Min_Phys_Width( phys_layer );
      x2 /= 2 ;
      x2 += LAMBDA * mbk_x;
      x2 = roundNE (x2);

      /* calcul de y1 */
      y1 = mbk_y - Long_Ext( num_layer, mbk_layer );
      y1 *= LAMBDA;
      y1 -= Connector_Ext( phys_layer ) ;
      y1 = roundSW (y1);

      /* calcul de y2 */
      y2 = mbk_y + Long_Ext( num_layer, mbk_layer );
      y2 *= LAMBDA;
      y2 += Connector_Ext( phys_layer ) ;
      y2 = roundNE (y2);

      wr_rect( x1 , y1 , x2 , y2 , phys_layer ) ;
      break ;

    case EAST :
    case WEST :

      /* calcul de x1 */
      x1 = mbk_x - Long_Ext( num_layer,  mbk_layer );
      x1 *= LAMBDA;
      x1 -= Connector_Ext( phys_layer ) ;
      x1 = roundSW (x1);

      /* calcul de x2 */
      x2 = mbk_x + Long_Ext( num_layer ,  mbk_layer );
      x2 *= LAMBDA;
      x2 += Connector_Ext( phys_layer ) ;
      x2 = roundNE (x2);

      /* calcul de y1 */
      y1 = 0;
      y1 -= mbk_width + Width_Ext( num_layer ,  mbk_layer ) - Min_Symb_Width( mbk_layer );
      y1 *= LAMBDA  ;
      y1 -=  Min_Phys_Width( phys_layer ) ;
      y1 /= 2 ;
      y1 += LAMBDA * mbk_y ;
      y1 = roundSW (y1);

      /* calcul de y2 */
      y2 = mbk_width + Width_Ext( num_layer ,  mbk_layer ) - Min_Symb_Width( mbk_layer );
      y2 *= LAMBDA;
      y2 += Min_Phys_Width( phys_layer );
      y2 /= 2 ;
      y2 += LAMBDA * mbk_y;
      y2 = roundNE (y2);

      wr_rect( x1 , y1 , x2 , y2 , phys_layer ) ;
      break ;

    default :
      printf( "*** mbk *** trad_con : unknown orientation of connector \n" ) ;
      exit( -1 ) ;
    }
  }
}


/****************************************************************************/
/**** traduction des segments                                            ****/
/****************************************************************************/

trad_seg( mbk_x1 , mbk_y1 , mbk_x2 , mbk_y2 , mbk_width , mbk_layer , mbk_type )

int  mbk_x1 ;
int  mbk_y1 ;
int  mbk_x2 ;
int  mbk_y2 ;
int  mbk_width ;
char  mbk_layer ;
char  mbk_type ;

{
  int  x1  ;
  int  y1  ;
  int  x2  ;
  int  y2  ;
  char  phys_layer ;
  int  num_layer;

  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- trad_seg \n" ) ;

  for ( num_layer = 0 ; num_layer < N_TRANS_LAYER ; num_layer++) {

    phys_layer = Phys_Layer( num_layer , mbk_layer );
    if ( phys_layer == PHYS_NOP )  
      continue;

    switch ( mbk_type ) {
    case VER :

      /*========== dubious ( - Min_Symb_Width ) ==========*/
      /**** calcul de x1 ****/
      x1 = 0;
      x1 -= mbk_width + Width_Ext( num_layer , mbk_layer ) - Min_Symb_Width( mbk_layer );
      x1 *= LAMBDA;
      x1 -= Min_Phys_Width( phys_layer );
      x1 /= 2 ;
      x1 += ( LAMBDA * mbk_x1 );
      x1 = roundSW (x1);

      /**** calcul de x2 ****/
      x2 = mbk_width + Width_Ext( num_layer , mbk_layer ) - Min_Symb_Width( mbk_layer );
      x2 *= LAMBDA;
      x2 += Min_Phys_Width( phys_layer );
      x2 /= 2 ;
      x2 += ( LAMBDA * mbk_x1 );
      x2 = roundNE (x2);
      /*============================*/

      /**** calcul de y1 ****/
      y1 = mbk_y1 - Long_Ext( num_layer , mbk_layer );
      y1 *= LAMBDA;
      y1 -= Segment_Ext( phys_layer ) ;
      y1 = roundSW (y1);

      /* calcul de y2 */
      y2 = mbk_y2 + Long_Ext( num_layer , mbk_layer );
      y2 *= LAMBDA;
      y2 += Segment_Ext( phys_layer ) ;
      y2 = roundNE (y2);

      wr_rect( x1 , y1 , x2 , y2 , phys_layer ) ;
      break ;

    case HOR :

      /***** calcul de x1 *****/
      x1 = mbk_x1 - Long_Ext( num_layer , mbk_layer ) ;
      x1 *= LAMBDA ;
      x1 -= Segment_Ext( phys_layer ) ;
      x1 = roundSW(x1);

      /***** calcul de x2 *****/
      x2 = mbk_x2 + Long_Ext( num_layer , mbk_layer ) ;
      x2 *= LAMBDA ;
      x2 += Segment_Ext( phys_layer ) ;
      x2 = roundNE (x2);

      /*========== dubious ( - Min_Symb_Width ) ==========*/
      /***** calcul de y1 *****/
      y1 = 0;
      y1 -= mbk_width + Width_Ext( num_layer , mbk_layer ) - Min_Symb_Width( mbk_layer );
      y1 *= LAMBDA;
      y1 -= Min_Phys_Width( phys_layer );
      y1 /= 2 ;
      y1 += ( LAMBDA * mbk_y1 );
      y1 = roundSW (y1);

      /***** calcul de y2 *****/
      y2 = mbk_width + Width_Ext( num_layer , mbk_layer ) - Min_Symb_Width( mbk_layer );
      y2 *= LAMBDA ;
      y2 += Min_Phys_Width( phys_layer ) ;
      y2 /= 2 ;
      y2 += ( LAMBDA * mbk_y1 ) ;
      y2 = roundNE (y2);
      /*============================*/

      wr_rect( x1 , y1 , x2 , y2 , phys_layer ) ;
      break ;

    default :

      printf( "*** mbk *** trad_seg : unknown type of segment \n" ) ;
      exit( -1 ) ;
    }
  }
}

 
/****************************************************************************/
/**** traduction des vias                                                ****/
/****************************************************************************/
 
trad_ref( x , y , type )
 
int     x ;
int     y ;
int     type ;
 
{
        int     num_layer;
 
        if ( TRACE_MODE == 'Y' )
                printf( "--- mbk --- trad_via \n" ) ;
 
        for ( num_layer = 0 ; num_layer < N_REF_LAYER ; num_layer++)
                if ( REFLayer( num_layer , type ) != PHYS_NOP )
                        wr_rect(( int )( ( x * LAMBDA ) - ( Side( num_layer , type ) / 2 ) ) ,
                                ( int )( ( y * LAMBDA ) - ( Side( num_layer , type ) / 2 ) ) ,
                                ( int )( ( x * LAMBDA ) + ( Side( num_layer , type ) / 2 ) ) ,
                                ( int )( ( y * LAMBDA ) + ( Side( num_layer , type ) / 2 ) ) ,
                                REFLayer( num_layer , type ) ) ;
 
}
 
/****************************************************************************/
/**** traduction des vias                                                ****/
/****************************************************************************/

trad_via( x , y , type )

int  x ;
int  y ;
int  type ;

{
  int  num_layer;

  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- trad_via \n" ) ;

  for ( num_layer = 0 ; num_layer < N_VIA_LAYER ; num_layer++)
    if ( VIALayer( num_layer , type ) != PHYS_NOP )
      wr_rect(( int )( ( x * LAMBDA ) - ( Side( num_layer , type ) / 2 ) ) , 
        ( int )( ( y * LAMBDA ) - ( Side( num_layer , type ) / 2 ) ) , 
        ( int )( ( x * LAMBDA ) + ( Side( num_layer , type ) / 2 ) ) , 
        ( int )( ( y * LAMBDA ) + ( Side( num_layer , type ) / 2 ) ) , 
        VIALayer( num_layer , type ) ) ;

}


/****************************************************************************/
/**** instance translation                                               ****/
/****************************************************************************/

trad_ins( xins , yins , model_name , ins_name , mbk_transf )

int  xins ;
int  yins ;
char  *model_name ;
char  *ins_name ;
int  mbk_transf ;

{
  int  model_num = 0 ;
  phfig_list   * pt_model = NULL ;
  int  x ;
  int  y ;

  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- trad_ins \n" ) ;

  /***** get model ******/
  pt_model = getphfig( model_name , 'A' ) ;

  /***** get model number *****/
  model_num = ( int )getptype( pt_model->USER , CIF )->DATA ;

  switch ( mbk_transf ) {
  case NOSYM :
    {
      x = xins - pt_model->XAB1 / SCALE_X ;
      y = yins - pt_model->YAB1 / SCALE_X ;
      break ;
    }
  case SYM_X :
    {
      x = xins + pt_model->XAB2 / SCALE_X ;
      y = yins - pt_model->YAB1 / SCALE_X ;
      break ;
    }
  case SYM_Y :
    {
      x = xins - pt_model->XAB1 / SCALE_X ;
      y = yins + pt_model->YAB2 / SCALE_X ;
      break ;
    }
  case SYMXY :
    {
      x = xins + pt_model->XAB2 / SCALE_X ;
      y = yins + pt_model->YAB2 / SCALE_X ;
      break ;
    }
  case ROT_P :
    {
      x = xins + pt_model->YAB2 / SCALE_X ;
      y = yins - pt_model->XAB1 / SCALE_X ;
      break ;
    }
  case ROT_M :
    {
      x = xins - pt_model->YAB1 / SCALE_X ;
      y = yins + pt_model->XAB2 / SCALE_X ;
      break ;
    }
  case SY_RP :
    {
      x = xins - pt_model->YAB1 / SCALE_X ;
      y = yins - pt_model->XAB1 / SCALE_X ;
      break ;
    }
  case SY_RM :
    {
      x = xins + pt_model->YAB2 / SCALE_X ;
      y = yins + pt_model->XAB2 / SCALE_X ;
      break ;
    }
  default :
    {
      printf( "*** mbk *** trad_ins : unknown transformation \n" ) ;
      exit( -1 ) ;
    }
  }

  x *= LAMBDA ;
  y *= LAMBDA ;
  wr_ins( model_name , ins_name , model_num , x , y , mbk_transf ) ;

}


/****************************************************************************/
/* translate figure's header                                                */
/****************************************************************************/

trad_header( pt_phfig )

phfig_list  *pt_phfig ;

{
  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- trad_header \n" );

  wr_header( pt_phfig->NAME ) ;
}


/****************************************************************************/
/* translate figure's tail                                                  */
/****************************************************************************/

trad_tail( pt_phfig )

phfig_list  *pt_phfig ;

{
  if ( TRACE_MODE == 'Y' ) 
    printf( "--- mbk --- trad_tail \n" ) ;

  wr_tail( pt_phfig->XAB1 , pt_phfig->YAB1 , pt_phfig->XAB2 , pt_phfig->YAB2 ) ;
}


/****************************************************************************/
/* Read the argument in line command set environnement                      */
/****************************************************************************/


get_arg (argc, argv, filename_in, filename_out)
int  argc;
char  *argv[];
char  **filename_in;
char  **filename_out;

{
  /**** test command line **** reading arguments ****/

  mbkenv();

  if (argc != 2) 
    usage (argc, argv);

  *filename_in = mbkalloc (100);
  strcpy( *filename_in, argv[1]);

  *filename_out = mbkalloc (100);
  strcpy( *filename_out, argv[1]);

  SCALE_X = 1; /* all coordonnates are truncated */

}


main( argc, argv)

int  argc;
char  *argv[];

{
  char  *filename_in;
  char  *filename_out;
  phfig_list  * phfig;

  get_arg( argc, argv, &filename_in, &filename_out);
  phfig = getphfig( filename_in, 'A');
  phfig->NAME = filename_out;
  savephys( phfig);
  return 0;
}
