
/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  Synthetiseur Logique                                       */
/*    Fichier :  sl_system.c                                                */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  L. Burgun                            le : 16/07/1991     */
/*                                                                          */
/*    Modifie par :                                     le : 25/10/1991     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "mut309.h"
#include "log120.h"
#include "beh104.h"
#include "ctype.h"
#include "../menu/sl_corps.h"
#include "../ablorder/sl_order.h"
#include "../param/sl_param.h"
#include "../mapping/types.h"
#include "../mapping/compile.h"
#include "../mapping/util.h"
#include "../mbk/sl_mbk.h"
#include "../cccc/c4_debug.h"
#include "../cccc/c4.h"
#include "sl_type.h"
#include "../compil/sl_util.h"

char *getenv();

/*----------------------------------------------------------------------------
verifArgs	: verifie les arguments de la ligne de commande.
------------------------------------------------------------------------------
retour		: un entier a 1 si OK, 1 sinon.
------------------------------------------------------------------------------*/

int verifArgs(sl,argc,argv)
sl_system *sl;
int argc;
char *argv[];
{
FILE *fic;
FILE *fopen();

	/* cas de l'appel par relax */

if (argc == 3 && !strcmp(argv[2],"relax"))
   {
   argv[1] = (char *) genNAME("%s.vbe",argv[1]);
   return(1);
   }

if (argc == 2)
   {
   argv[1] = (char *) genNAME("%s.vbe",argv[1]);
   return(1);
   }

		/* avec un fichier de parametres */

if (argc == 3 && strcmp(argv[1],"-d") &&  strcmp(argv[1],"-o") && 
    strcmp(argv[1],"-m") && strcmp(argv[1],"-n") && strcmp(argv[1],"-c"))
   {
   argv[1] = (char *) genNAME("%s.vbe",argv[1]);
   argv[2] = (char *) genNAME("%s.par",argv[2]);

	/* on verifie l'existence du fichier de parametres */

   if (!strcmp(sl->par_lib,"."))
      {
      if(!(fic = fopen(argv[2],"r")))
      	{
	printf("\nlogic 2.17      : unable to open '%s'\n\n",argv[2]) ;
	return(0) ;
	}
      else
        fclose(fic);
      }
   else
      if(!(fic = fopen(genNAME("%s/%s",sl->par_lib,argv[2]),"r")))
      	{
	printf("\nlogic 2.17      : unable to open ") ;
        printf(" '%s'\n\n",genNAME("%s/%s",sl->par_lib,argv[2])) ;
	return(0) ;
	}
      else
        fclose(fic);
   return(1);
   }			/* fin appel version interactive */

if (argc < 3 || argc > 4)
   {
   printf("\nlogic 2.17      : usage   logic -option <file_entity> <file_par>\n");
   printf("option : -d   behavioral optimization & decompiler\n");
   printf("         -o   behavioral optimization & mapping standard cells\n"); 
   printf("         -m   mapping standard cells only\n"); 
   printf("         -n   behavioral optimization & mapping with C4\n"); 
   printf("         -c   mapping with C4 only\n"); 
   return(0) ;
   }

if (strcmp(argv[1],"-d") && strcmp(argv[1],"-o") && 
    strcmp(argv[1],"-m") && strcmp(argv[1],"-n") && strcmp(argv[1],"-c"))
   	{
	printf("\nlogic 2.17      : bad option '%s'\n\n",argv[1]) ;
	return(0) ;
	}

argv[2] = (char *) genNAME("%s.vbe",argv[2]);
if (!strcmp(sl->beh_lib,"."))
   {
   if(!(fic = fopen(argv[2],"r")))
	{
	printf("\nlogic 2.17      : unable to open '%s'\n\n",argv[2]) ;
	return(0) ;
	}
   else
        fclose(fic);
   }
else
   {
   if(!(fic = fopen(genNAME("%s/%s",sl->beh_lib,argv[2]),"r")))
	{
	printf("\nlogic 2.17      : unable to open ");
        printf(" '%s'\n\n",genNAME("%s/%s",sl->beh_lib,argv[2])) ;
	return(0) ;
	}
   else
        fclose(fic);
   }

if (argc == 4)
   {
   argv[3] = (char *) genNAME("%s.par",argv[3]);
   if (!strcmp(sl->par_lib,"."))
      {
      if(!(fic = fopen(argv[3],"r")))
      	{
	printf("\nlogic 2.17      : unable to open '%s'\n\n",argv[3]) ;
	return(0) ;
	}
      else
        fclose(fic);
      }
   else
      if(!(fic = fopen(genNAME("%s/%s",sl->par_lib,argv[3]),"r")))
      	{
	printf("\nlogic 2.17      : unable to open ") ;
        printf(" '%s'\n\n",genNAME("%s/%s",sl->par_lib,argv[3])) ;
	return(0) ;
	}
      else
        fclose(fic);
   }

return(1);
}


/*----------------------------------------------------------------------------
initializeParam : initialise les parametres de la synthese.
------------------------------------------------------------------------------
retour		: un pointeur sur une structure param.
------------------------------------------------------------------------------*/

sl_param *initializeParam(optim,aux,auxOF,level,delayPI,guardedAux,optimPO,numTransN,numTransP,numCanN,numCanP)
int optim;
int aux;
int auxOF;
int level;
ptype_list *delayPI;
chain_list *guardedAux;
chain_list *optimPO;
int numTransN,numTransP,numCanN,numCanP;
{
sl_param *par;

par = (sl_param *) malloc (sizeof(sl_param));
par->optim = optim;
par->aux = aux;
par->auxOF = auxOF;
par->level = level;
par->delayPI = delayPI;
par->guardedAux = guardedAux;
par->optimPO = optimPO;
par->numTransN = numTransN;
par->numTransP = numTransP;
par->numCanN = numCanN;
par->numCanP = numCanP;
return(par);
}

/*----------------------------------------------------------------------------
initializeSystem:  alloue sys et initialise ses parametres d'environnement
------------------------------------------------------------------------------
retour		: un pointeur sur une structure systeme. 
------------------------------------------------------------------------------*/

sl_system *initializeSystem()
{
sl_system *sl;

sl = (sl_system *) malloc (sizeof(sl_system));

sl->orderPI = NULL;
sl->order = 1;
sl->version = (char *) malloc (100);
sl->fileVhdl  = (char *) malloc (100);
sl->file      = (char *) malloc (100);
sl->fileParam = (char *) malloc (100);
sl->filePar   = (char *) malloc (100);

sl->beh_lib   = (char *) malloc (100);
sl->log_lib   = (char *) malloc (100);
sl->par_lib   = (char *) malloc (100);
sl->cata_lib   = (char *) malloc (100);
sl->c4_lib   = (char *) malloc (100);
sl->in_lo   = (char *) malloc (20);
sl->out_lo   = (char *) malloc (20);
sl->out_ph   = (char *) malloc (20);

if (!getenv("MBK_WORK_LIB"))
   strcpy(sl->beh_lib,".");
else
   strcpy(sl->beh_lib,getenv("MBK_WORK_LIB"));

if (!existDirectory(sl->beh_lib))
   {
   printf("\nlogic 2.17      : the directory '%s' doesn't exist\n",sl->beh_lib);
   exit(-1);
   }

if (!getenv("MBK_WORK_LIB"))
   strcpy(sl->log_lib,".");
else
   strcpy(sl->log_lib,getenv("MBK_WORK_LIB"));

if (!existDirectory(sl->log_lib))
   {
   printf("\nlogic 2.17      : the directory '%s' doesn't exist\n",sl->log_lib);
   exit(-1);
   }

if (!getenv("SL_PAR_LIB"))
   strcpy(sl->par_lib,".");
else
   strcpy(sl->par_lib,getenv("SL_PAR_LIB"));

if (!existDirectory(sl->par_lib))
   {
   printf("\nlogic 2.17      : the directory '%s' doesn't exist\n",sl->par_lib);
   exit(-1);
   }

if (!getenv("SL_CATA_LIB"))
   strcpy(sl->cata_lib,".");
else
   strcpy(sl->cata_lib,getenv("SL_CATA_LIB"));

if (!existDirectory(sl->cata_lib))
   {
   printf("\nlogic 2.17      : the directory '%s' doesn't exist\n",sl->cata_lib);
   exit(-1);
   }

if (!getenv("SL_C4_LIB"))
   strcpy(sl->c4_lib,".");
else
   strcpy(sl->c4_lib,getenv("SL_C4_LIB"));

if (!existDirectory(sl->c4_lib))
   {
   printf("\nlogic 2.17      : the directory '%s' doesn't exist\n",sl->c4_lib);
   exit(-1);
   }

if (!getenv("MBK_IN_LO"))
   strcpy(sl->in_lo,"al");
else
   strcpy(sl->in_lo,getenv("MBK_IN_LO"));

if (!getenv("MBK_OUT_LO"))
   strcpy(sl->out_lo,"al");
else
   strcpy(sl->out_lo,getenv("MBK_OUT_LO"));

if (!getenv("MBK_OUT_PH"))
   strcpy(sl->out_ph,"ap");
else
   strcpy(sl->out_ph,getenv("MBK_OUT_PH"));

if (getenv("SL_TRACE") == NULL || !strcmp(getenv("SL_TRACE"),"0"))
   sl->trace = 0; 
else
   if (!strcmp(getenv("SL_TRACE"),"1"))
      sl->trace = 1;
   else
      if (!strcmp(getenv("SL_TRACE"),"2"))
         sl->trace = 2;
      else
         sl->trace = 0;

if (getenv("SL_LATCHE") == NULL || !strcmp(getenv("SL_LATCHE"),"0"))
   sl->latches = 0;
else
   sl->latches = 1;		

		/* on fige le chapeau des latches */

if (!getenv("SL_NAME_LOG"))
   sl->name_log = 0;		/* on genere une lofig du nom  + optim */
else
   sl->name_log = 1;		/* on genere une lofig du meme nom */

return( sl );
}

/*----------------------------------------------------------------------------
addInfoSystem	: ajoute les infos de process et de fichiers a traiter
------------------------------------------------------------------------------
retour		: rien. 
------------------------------------------------------------------------------*/

void addInfoSystem(sl,mode,argc,argv,version)
sl_system *sl;
int mode;
int argc;
char *argv[];
char *version;
{
strcpy(sl->version,version);
sl->mode = mode;
if (sl->mode == 1)
   {
   strcpy(sl->file,argv[2]) ;
   if (!strcmp(sl->beh_lib,"."))
      strcpy(sl->fileVhdl,argv[2]) ;
   else
      strcpy(sl->fileVhdl,genNAME("%s/%s",sl->beh_lib,argv[2]));
   sl->par = initializeParam(2,0,1,2,NULL,NULL,NULL,4,4,2,2);
   if (argc == 4)
      {
      strcpy(sl->filePar,argv[3]) ;
      if (!strcmp(sl->par_lib,"."))
         strcpy(sl->fileParam,argv[3]) ;
      else
         strcpy(sl->fileParam,genNAME("%s/%s",sl->par_lib,argv[3])) ;
      if ( loadParam(sl,sl->fileParam) != 0 ) 
		{ 
		printf("loadParam : error: bad parameters file \n");
		exit( -1 );
		}
      }
   else
      {
      if (!strcmp(sl->par_lib,"."))
         strcpy(sl->fileParam,"default.par");
      else
         strcpy(sl->fileParam,genNAME("%s/default.par",sl->par_lib));
      }
   sl->option = *(argv[1]+1);
   }
else		/* mode 0 ou 2 */
   {
   strcpy(sl->file,argv[1]) ;
   if (!strcmp(sl->beh_lib,"."))
      strcpy(sl->fileVhdl,argv[1]) ;
   else
      strcpy(sl->fileVhdl,genNAME("%s/%s",sl->beh_lib,argv[1]));
   sl->par = initializeParam(2,0,1,2,NULL,NULL,NULL,4,4,2,2);

   if (sl->mode == 0)
      {
      strcpy(sl->filePar,"default.par");
      if (!strcmp(sl->par_lib,"."))
         strcpy(sl->fileParam,"default.par");
      else
         strcpy(sl->fileParam,genNAME("%s/default.par",sl->par_lib));
      }
   else		/* mode 2 */
      {
      strcpy(sl->filePar,argv[2]) ;
      if (!strcmp(sl->par_lib,"."))
         strcpy(sl->fileParam,argv[2]) ;
      else
         strcpy(sl->fileParam,genNAME("%s/%s",sl->par_lib,argv[2])) ;
      if ( loadParam(sl,sl->fileParam) != 0 ) 
		{ 
		printf("loadParam : error: bad parameters file \n");
		exit( -1 );
		}
      }
   sl->option = '\0';
   }
		/* mise a jour des variables de MBK */

putenv(genNAME("MBK_IN_LO=%s",MBK_IN_LO));
putenv(genNAME("MBK_OUT_LO=%s",MBK_OUT_LO));
putenv(genNAME("MBK_OUT_PH=%s",MBK_OUT_PH));
putenv(genNAME("MBK_WORK_LIB=%s",MBK_WORK_LIB));
putenv(genNAME("MBK_CATA_LIB=%s:%s",SL_CATA_LIB,SL_CCCC_LIB));

mbkenv();
}

/*----------------------------------------------------------------------------
displaySystem   : affiche les arguments de la synthese 
------------------------------------------------------------------------------
retour		: void 
------------------------------------------------------------------------------*/

void displaySystem(sys)
sl_system *sys;
{
printf("\n\n");
printf("         @@         @@@@@      @@@@@    @@@@@@    @@@@@\n");
printf("         @@        @@@@@@@    @@@@@@@   @@@@@@   @@@@@ \n");
printf("         @@        @@   @@    @@          @@     @@    \n");
printf("         @@        @@   @@    @@          @@     @@    \n");
printf("         @@        @@   @@    @@   @@     @@     @@    \n");
printf("         @@@@@@@   @@@@@@@    @@@@@@    @@@@@@   @@@@@ \n");
printf("         @@@@@@@    @@@@@      @@@@@    @@@@@@    @@@@@\n");
printf("\n\n");
printf("                Chaine de CAO & VLSI   Alliance\n"); 
printf("===================================================================\n");
printf("    (c) copyright 1992 Laboratoire MASI equipe CAO & VLSI\n");
printf("    All rigths reserved\n");
printf("    Support : e-mail cao-vlsi@masi.ibp.fr\n");
printf("===================================================================\n");
printf("%s\n",SL_VERSION);
printf("\n");

if (SL_MODE == 1)		/* mode batch */
   {
   printf("==========================  Environnement  ========================\n");
   printf("MBK_WORK_LIB         = %s\n",MBK_WORK_LIB);
   printf("SL_PAR_LIB         = %s\n",SL_PAR_LIB);
   if (SL_OPTION != 'd')
      {
      printf("MBK_WORK_LIB         = %s\n",MBK_WORK_LIB);
      printf("SL_NAME_LOG        = %d\n",SL_NAME_LOG);
      if (SL_OPTION == 'm' || SL_OPTION == 'o')
         {
         printf("SL_CATA_LIB        = %s\n",SL_CATA_LIB);
         printf("MBK_IN_LO           = %s\n",MBK_IN_LO);
         }
      else
         {
         printf("SL_C4_LIB          = %s\n",SL_CCCC_LIB);
         printf("MBK_OUT_PH          = %s\n",MBK_OUT_PH);
         } 
      printf("MBK_OUT_LO          = %s\n",MBK_OUT_LO);
      }
   printf("SL_TRACE           = %d\n",SL_TRACE);
   printf("SL_LATCHE          = %d\n",SL_LATCHES);
   printf("=================  Files, Options and Parameters  =================\n");
   printf("VHDL file          = %s\n",SL_VHDL);
   printf("Parameters file    = %s\n",SL_PARAM);
   printf("Mode               = ");
   switch (SL_OPTION)
       {
       case 'd' : printf("Behavioral optimization and decompiler\n"); break;
       case 'o' : printf("Behavioral optimization and Mapping standard cell\n");
                  break;
       case 'm' : printf("Mapping standard cell only\n"); break;
       case 'n' : printf("Behavioral optimization and Mapping with C4\n");
                  break;
       case 'c' : printf("Mapping with C4 only\n"); break;
       }
   printf("Optimization mode  = %d\n",SL_OPTIM);
   printf("Optimization level = %d\n",SL_LEVEL);
   if (SL_OPTION != 'd')
      {
      if (SL_OPTION == 'm' || SL_OPTION == 'o')
         {
         printf("Mapping Standard Cell\n");
         }
      else
         {
         printf("Mapping free (compiler cells C4 actived)\n");
         printf("Number of serial transistors on graph P = %d\n",SL_NUMTRANSP);
         printf("Number of serial transistors on graph N = %d\n",SL_NUMTRANSN);
         }
      }
   if (SL_AUX == 1)
      printf("Auxiliary signals are saved\n");
   else
      printf("Auxiliary signals may be erased\n");
   printf("===================================================================\n");
   printf("\n");
   }
}

void mappingSC()
{
   chain_list *fileLib;

		/* compilation de la bibliotheque */

   VHB_HEDFIG = NULL;

   printf("Running Mapping Standard Cell...\n");

   if (SL_TRACE)
      printf("Removing the auxiliary signals...\n");

   if (SL_AUX == 0)
      compactExprBeh(SL_BEH,0,SL_DELAYPI,SL_OPTIMPO,1);
   else
      mapCarExprBeh(SL_BEH,simplif10Expr);

   fileLib = getFile(SL_CATA_LIB,"vbe");
   if (!fileLib)
      {
      printf("Mapping SC : Error - there's no cell in '%s'\n",SL_CATA_LIB);
      exit(-1);
      }
   while (fileLib)		
      {
      if (SL_TRACE)
         {
         printf("%s\n",fileLib->DATA);
         }
      if (compileVHDL(fileLib->DATA,NULL,0,NULL,1,0,1,1,0,renameSig,0) != NULL)
         {
         removeAuxBeh(VHB_HEDFIG,NULL);
         bddToAblBeh(VHB_HEDFIG,0);
         }
      fileLib = fileLib->NEXT;
      }
   if (SL_TRACE)
      {
      printf("\n");
      }
   mappSys = initMapping();
   compileLibrary();
   mapper();
   genMBKBeh(SL_BEH,1);
   changeAblBeh(SL_BEH);
   endMapping();

   if (SL_TRACE)
      {
      printf("End of mappingSC\n");
      }
   else
      printf("\n");
}

void mappingC4()
{
   if (SL_BEH->TYPE & BEH_STABLE)
      {
      printf("Mapping C4 : error - attribut stable is not supported with C4\n");
      exit(-1);
      }
   printf("Running Mapping with C4 ...");
   printf(".");
   fflush(stdout);
   devXorBeh(SL_BEH,SL_OPTIM,SL_DELAYPI,SL_OPTIMPO);

   printf(".");
   fflush(stdout);

   if (SL_TRACE)
      printf("\nRemoving the auxiliary signals...\n");

		/* si l'on peut eliminer les aux., on compacte un peu
                   plus pour C4 */

   if (SL_AUX == 0)
      compactExprBeh(SL_BEH,SL_OPTIM,SL_DELAYPI,SL_OPTIMPO,0);
   else
      mapCarExprBeh(SL_BEH,simplif10Expr);

   if (SL_TRACE && SL_AUX == 0)
      {
      printf("apres decompactage\n");
      displayBeh(SL_BEH,1);
      }

   printf(".");
   fflush(stdout);
   flatPolarityBeh(SL_BEH);

   printf(".");
   fflush(stdout);
   decompBoolBeh(SL_BEH,SL_OPTIM,SL_DELAYPI,SL_OPTIMPO,SL_NUMTRANSP,SL_NUMTRANSN);

		/* on appelle une deuxieme fois (les temps ont change) */
   printf(".");
   fflush(stdout);
   decompBoolBeh(SL_BEH,SL_OPTIM,SL_DELAYPI,SL_OPTIMPO,SL_NUMTRANSP,SL_NUMTRANSN);

   printf(".");
   fflush(stdout);
   mapBeh(SL_BEH,SL_OPTIM,SL_DELAYPI,SL_OPTIMPO,SL_NUMTRANSP,SL_NUMTRANSN);

   printf(".");
   fflush(stdout);
   postBeh(SL_BEH,SL_AUX);

   printf(".");
   fflush(stdout);

		/* appel a C4 */

   printf("\n");
   putenv(genNAME("MBK_WORK_LIB=%s",SL_CCCC_LIB));
   mbkenv();
   c4MappBeh(SL_BEH,SL_TRACE,SL_DELAYPI);

   putenv(genNAME("MBK_WORK_LIB=%s",MBK_WORK_LIB));
   mbkenv();
   genMBKBeh(SL_BEH,0);
   changeAblBeh(SL_BEH);
}
