/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : synthetiseur logique                                        */
/*    Fichier : types.h                                                     */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :   ALLEGRE P.                          le : 01/08/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#define ARITE(exp) (int)CDR(CAR(exp))

typedef struct AChain
{
	struct AChain	*NEXT;
	char		*name;
	chain_list	*ptChain;
} Alist;

typedef struct tabNum
{
	struct tabNum	*NEXT;
	char		*name;
	num_list	*ptNum;
} tabNumList;

typedef struct cellule
{
	struct cellule	*NEXT;
	char		type;
	Alist		*interface,*entrees;
	chain_list	*sorties;
	num_list	*delais;
	long		surface;
	char		*nomlog,*nom;
	tabNumList	*delais_tech,*capa_tech;
	ptype_list	*surface_tech,*resistance_tech;
	ptype_list	*generic;
	struct biabl	*val_abl;
	chain_list	*envel;
	short		util;
	pCircuit  	circuit;
	pNode		BDD;
} cellList;

typedef struct regle
{
	struct regle	*NEXT;
	char 		*nom;
	chain_list	*premisse,*conclusion;
	short		condition,prof_premi;
	int		util;
} regle_list;

typedef struct declencheur
{
	struct declencheur	*NEXT;
	char			*name;
	regle_list		*regles;
} declenList;

typedef struct sig
{
	short		type;
	char 		*name;
	long		delais_in,delais,capa;
	int		cout;
	chain_list 	*ablList,*util;
} sig;

typedef struct virtuel
{
	chain_list	*solutions;
	long		delais,surface_cone,capa,del_rc;
	chain_list	*fanout;
	cellList	*op_log;
	char		*cellule;
} virtuelList;

typedef struct mapping
{
	cellList	*ptcell;
	declenList	*ptdecl;
	ptype_list	*ref;
	short		delta,coef,coutSig;
	pTH		sig_hash,cell_hash,virt_hash,abl_hash;
} mapping;

mapping	*mappSys;

