/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : Synthetiseur logique                                        */
/*    Fichier : oper.c                                                      */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :   DICTUS N.                           le : 21/08/1991     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "mut309.h"
#include "mlo402.h"
#include "log120.h"
#include "beh104.h"
#include "types.h"
#include "../compil/sl_util.h"
#include "oper.h"

void createTabOper()
{
sysOper = (struct typeOper *)mbkalloc(sizeof(struct typeOper));
sysOper->numOper = 10;
sysOper->ptOper = createTH(100);
sysOper->identOper = (char **)mbkalloc(sizeof(char *)*100);
}

void addOper(name)
char *name;

{
char **ppName;

if (searchNumOper(name) != EMPTYTH)
	{
	printf("addOper : Error operator already exists -> %s\n",name);
	}
addTH(sysOper->ptOper,name,sysOper->numOper);
ppName = sysOper->identOper + sysOper->numOper - 10;
*ppName = name;
sysOper->numOper++;
}

int searchNumOper(name)
char *name;

{
int oper =charToOper(name);

if (oper != -1)
	return oper;
oper = searchTH(sysOper->ptOper,name); 
return oper;
}

char *searchCharOper(num)
int num;

{
if (num < 10) return operToChar(num);
if (num > 1000) 
	{
	printf("searchCharOper : Error unknown operator = %d\n",num);
	exit(-1);
	}
if (num >= sysOper->numOper) return (char *)NULL;
return *(sysOper->identOper + num - 10);
}

void destroyTabOper()
{
mbkfree((void *)sysOper->identOper);
destroyTH(sysOper->ptOper);
mbkfree((void *)sysOper);
}

void displayTabOper()

{
char **ppName = sysOper->identOper;
int i;

if (sysOper->numOper == 10)
	{
	printf("the table is EMPTY !\n");
/*
	return ;
*/
	}
printf("Displaying the operator table : %d elems\n",sysOper->numOper-10);
displayTH(sysOper->ptOper);
for(i = 0; i < sysOper->numOper - 10; i++)
	{

	printf("%d : %s\n",i+10,*ppName);
	ppName++;
	}
}

/*------------------------------------------------------------------
  IDENT : displayOperExpr
  ------------------------------------------------------------------
  FUNCTION : affiche l'expression a la sauce LISP --> (oper list_arg) 
  ------------------------------------------------------------------ */

void displayOperExpr(expr)
chain_list *expr;
{

if (ATOM(expr))
   printf(" %s",VALUE_ATOM(expr));
else
   {
   printf(" (%s",searchCharOper(OPER(expr)));
   mapExpr(displayOperExpr,expr);
   printf(")");
   }
}

/*------------------------------------------------------------------
  IDENT : operToCell
  ------------------------------------------------------------------
  FUNCTION : cherche une cellule a partir d'un operateur 
  ------------------------------------------------------------------ */

cellList *operToCell(expr)
chain_list *expr;
{
char *oper;
cellList *cell;

   if (ATOM(expr)) return NULL;
   if (OPER(expr) < 10)
   {
      switch (OPER(expr))
      {
         case NOT  : oper = gensym("not",ARITE(expr));break;
         case AND  : oper = gensym("and",ARITE(expr));break;
         case OR   : oper = gensym("or",ARITE(expr));break;
         case NAND : oper = gensym("nand",ARITE(expr));break;
         case NOR  : oper = gensym("nor",ARITE(expr));break;
         case XOR  : oper = gensym("xor",ARITE(expr));break;
         case NXOR : oper = gensym("nxor",ARITE(expr));break;
      }
   }  
   else
      oper = searchCharOper(OPER(expr));
   if (cell = (struct cellule *)testObj(oper,'c'))
      return cell;
   return NULL;
}

chain_list *invExpr(abl)
chain_list *abl;
{
   abl = notExpr(abl);
   addArite(abl);
   return abl;
}
