
/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  Compilateur de cellules CMOS  & Synthetiseur Logique       */
/*    Fichier :  c4_lofig.c                                                 */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  L. Burgun                            le : 28/04/1992     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "genlib.h"


void lofigNot(name,lc_io,out,in)
char *name;
chain_list *lc_io;
char *out;
char *in;
{
	DEF_LOFIG(name);
        while (lc_io)
           {
	   LOCON(lc_io->DATA, UNKNOWN,lc_io->DATA);
           lc_io = lc_io->NEXT;
           }
	LOTRS(TRANSP, 12, 1, in, "vdd", out);
	LOTRS(TRANSN, 6, 1, in, "vss", out);
	SAVE_LOFIG();
}




void lofigHigh(name,lc_io)
char *name;
chain_list *lc_io;
{
	DEF_LOFIG(name);
        while (lc_io)
           {
	   LOCON(lc_io->DATA, UNKNOWN,lc_io->DATA);
           lc_io = lc_io->NEXT;
           }
	SAVE_LOFIG();
}




void lofigLow(name,lc_io)
char *name;
chain_list *lc_io;
{
	DEF_LOFIG(name);
        while (lc_io)
           {
	   LOCON(lc_io->DATA, UNKNOWN,lc_io->DATA);
           lc_io = lc_io->NEXT;
           }
	SAVE_LOFIG();
}


	/* BUS : i1 = data  (i2,i3) double commande */

void lofigBus(name,lc_io,out,i1,i2,i3)	
char *name;
chain_list *lc_io;
char * out;
char *i1, *i2, *i3;
{
	DEF_LOFIG(name);
        while (lc_io)
           {
	   LOCON(lc_io->DATA, UNKNOWN,lc_io->DATA);
           lc_io = lc_io->NEXT;
           }
	LOTRS(TRANSP, 23, 1, i3, "mbksig[8]", out);
	LOTRS(TRANSN, 12, 1, i2, "mbksig[9]", out);
	LOTRS(TRANSP, 23, 1, i1, "vdd", "mbksig[8]");
	LOTRS(TRANSN, 12, 1, i1, "vss", "mbksig[9]");
	SAVE_LOFIG();
}




void lofigTie(name,lc_io)
char *name;
chain_list *lc_io;
{
	DEF_LOFIG(name);
        while (lc_io)
           {
	   LOCON(lc_io->DATA, UNKNOWN,lc_io->DATA);
           lc_io = lc_io->NEXT;
           }
	SAVE_LOFIG();
}

	/* LATCH1 & LATCH1N : i1 = data   i2 = commande
                              i3 = point memorisant       */

void lofigLatch1(name,lc_io,out,i1,i2,i3)
char *name;
chain_list *lc_io;
char *out;
char *i1, *i2, *i3;
{
	DEF_LOFIG(name);
        while (lc_io)
           {
	   LOCON(lc_io->DATA, UNKNOWN,lc_io->DATA);
           lc_io = lc_io->NEXT;
           }
	LOTRS(TRANSN, 3, 7, "mbksig[8]", "vss", i3);
	LOTRS(TRANSN, 12, 1, "mbksig[8]", "vss", out);
	LOTRS(TRANSP, 2, 4, "mbksig[8]", "vdd", i3);
	LOTRS(TRANSP, 23, 1, "mbksig[8]", "vdd", out);
	LOTRS(TRANSN, 5, 1, i3, "vss", "mbksig[8]");
	LOTRS(TRANSN, 6, 1, i2, i1,i3);
	LOTRS(TRANSP, 5, 1, i3, "vdd", "mbksig[8]");
	SAVE_LOFIG();
}

void lofigLatch1N(name,lc_io,out,i1,i2,i3)
char *name;
chain_list *lc_io;
char *out;
char *i1, *i2, *i3;
{
	DEF_LOFIG(name);
        while (lc_io)
           {
	   LOCON(lc_io->DATA, UNKNOWN,lc_io->DATA);
           lc_io = lc_io->NEXT;
           }
	LOTRS(TRANSP, 12, 1, i3, "vdd", out);
	LOTRS(TRANSN, 6, 1, i2, i1, i3);
	LOTRS(TRANSP, 3, 1, i3, "vdd", "mbksig[8]");
	LOTRS(TRANSP, 2, 4, "mbksig[8]", "vdd", i3);
	LOTRS(TRANSN, 3, 1, i3, "vss", "mbksig[8]");
	LOTRS(TRANSN, 2, 7, "mbksig[8]", "vss", i3);
	LOTRS(TRANSN, 11, 1, i3, "vss", "f");
	SAVE_LOFIG();
}

	/* LATCH2 & LATCH2N : i1 = data   i2 = commande
                              i3 = data   i4 = commande
                              i5 = point memorisant    */

void lofigLatch2(name,lc_io,out,i1,i2,i3,i4,i5)
char *name;
chain_list *lc_io;
char *out;
char *i1, *i2, *i3, *i4, *i5;
{
	DEF_LOFIG(name);
        while (lc_io)
           {
	   LOCON(lc_io->DATA, UNKNOWN,lc_io->DATA);
           lc_io = lc_io->NEXT;
           }
	LOTRS(TRANSP, 2, 3, "mbksig[10]", "vdd", i5);
	LOTRS(TRANSP, 23, 1, "mbksig[10]", "vdd", out);
	LOTRS(TRANSP, 5, 1, i5, "vdd", "mbksig[10]");
	LOTRS(TRANSN, 5, 1, i5, "vss", "mbksig[10]");
	LOTRS(TRANSN, 12, 1, "mbksig[10]", "vss", out);
	LOTRS(TRANSN, 2, 7, "mbksig[10]", "vss", i5);
	LOTRS(TRANSN, 6, 1, i2, i1, i5);
	LOTRS(TRANSN, 6, 1, i4, i5, i3);
	SAVE_LOFIG();
}

void lofigLatch2N(name,lc_io,out,i1,i2,i3,i4,i5)
char *name;
chain_list *lc_io;
char *out;
char *i1, *i2, *i3, *i4, *i5;
{
	DEF_LOFIG(name);
        while (lc_io)
           {
	   LOCON(lc_io->DATA, UNKNOWN,lc_io->DATA);
           lc_io = lc_io->NEXT;
           }
	LOTRS(TRANSN, 6, 1, i4, i5 , i3);
	LOTRS(TRANSN, 6, 1, i2, i1, i5);
	LOTRS(TRANSP, 3, 1, i5 , "vdd", "mbksig[10]");
	LOTRS(TRANSP, 2, 4, "mbksig[10]", "vdd", i5);
	LOTRS(TRANSN, 3, 1, i5 , "vss", "mbksig[10]");
	LOTRS(TRANSN, 2, 7, "mbksig[10]", "vss", i5 );
	LOTRS(TRANSN, 23, 1, i5 , "vss", out);
	LOTRS(TRANSP, 23, 1, i5 , "vdd", out);
	SAVE_LOFIG();
}

	/* BD  i1 = data   i2 = commande
               i3 = 1er point memorisant  (master)
               i4 = 2eme point memorisant (slave)      */


void lofigBD(name,lc_io,out,i1,i2,i3,i4)
char *name;
chain_list *lc_io;
char *out;
char *i1, *i2, *i3, *i4;
{
        DEF_LOFIG(name);
        while (lc_io)
           {
	   LOCON(lc_io->DATA, UNKNOWN,lc_io->DATA);
           lc_io = lc_io->NEXT;
           }
        LOTRS(TRANSN, 9, 1, "l", "vss", "mbksig[11]");
        LOTRS(TRANSP, 18, 1, "l", "vdd", "mbksig[11]");
        LOTRS(TRANSP, 2, 4, "mbksig[10]", "mmpx_s", "vdd");
        LOTRS(TRANSP, 23, 1, "mbksig[7]", "vdd", "t");
        LOTRS(TRANSP, 2, 4, "mbksig[7]", "smpx_s", "vdd");
        LOTRS(TRANSN, 12, 1, "mbksig[7]", "vss", "t");
        LOTRS(TRANSP, 12, 1, "mbksig[10]", "vdd", "mbksig[12]");
        LOTRS(TRANSN, 5, 1, "mmpx_s", "vss", "mbksig[10]");
        LOTRS(TRANSN, 6, 1, "l", "mmpx_s", "i");
        LOTRS(TRANSP, 5, 1, "mmpx_s", "vdd", "mbksig[10]");
        LOTRS(TRANSN, 3, 7, "mbksig[10]", "mmpx_s", "vss");
        LOTRS(TRANSP, 5, 1, "smpx_s", "vdd", "mbksig[7]");
        LOTRS(TRANSN, 3, 7, "mbksig[7]", "smpx_s", "vss");
        LOTRS(TRANSN, 5, 1, "smpx_s", "vss", "mbksig[7]");
        LOTRS(TRANSN, 6, 1, "mbksig[10]", "vss", "mbksig[12]");
        LOTRS(TRANSN, 6, 1, "mbksig[11]", "smpx_s", "mbksig[12]");
        SAVE_LOFIG();
}
