/******************************************************************************/
/*                                                                            */
/*                    CAO & VLSI's cad tools chain Alliance                   */
/*                                                                            */
/*     Product  : Standard Cell Placer                                        */
/*     File     : scp_mc.c                                                    */
/*     Contents : this function chooses randomly a modification of the        */
/*                current configuration                                       */
/*                                                                            */
/*     (c) Copyright 1992 Laboratoire MASI equipe CAO & VLSI                  */
/*     All rights reserved                                                    */
/*     Hot line  : cao-vlsi@masi.ibp.fr (e-mail)                              */
/*                                                                            */
/*     Author(s)   : Pierre Fedrichkine                 Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*                                                                            */
/******************************************************************************/
#include "scp_types.h"

/*** fonction qui donne une modification elementaire de la configuration ******/

/************* donne un echange de position de deux cellules ******************/
/**** cette fonction choisit deux cellules et inverse leurs positions  ********/

void modification_configuration()
{
      MODIF.cell1 = rand() % NBCELL;
      MODIF.cell2 = rand() % NBCELL;
      while (MODIF.cell2 == MODIF.cell1) 
            MODIF.cell2 = rand() % NBCELL;

      MODIF.deltawidth[MODIF.cell1] = 
			CELL[MODIF.cell2].width - CELL[MODIF.cell1].width; 
      MODIF.deltawidth[MODIF.cell2] = 
			CELL[MODIF.cell1].width - CELL[MODIF.cell2].width; 

      MODIF.nextpos[MODIF.cell1] = CELL[MODIF.cell2].pos 
		           	 - CELL[MODIF.cell2].width / 2
                           	 + CELL[MODIF.cell1].width / 2;

      MODIF.nextpos[MODIF.cell2] = CELL[MODIF.cell1].pos 
				 - CELL[MODIF.cell1].width / 2
                           	 + CELL[MODIF.cell2].width / 2;

      DELTA_C = calcul_difference_cout(MODIF.cell1,MODIF.cell2)
              + calcul_difference_cout(MODIF.cell2,MODIF.cell1);
}
