/******************************************************************************/
/*                                                                            */
/*                    CAO & VLSI's cad tools chain Alliance                   */
/*                                                                            */
/*     Product  : Standard Cell Placer                                        */
/*     File     : scp_mbk2scp.c                                               */
/*     Contents : function wich loads the netlist in the internal data 	      *//* 		  structure through MBK data base 			      */
/*                                                                            */
/*     (c) Copyright 1992 Laboratoire MASI equipe CAO & VLSI                  */
/*     All rights reserved                                                    */
/*     Hot line  : cao-vlsi@masi.ibp.fr (e-mail)                              */
/*                                                                            */
/*     Author(s)   : Pierre Fedrichkine                 Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*                                                                            */
/******************************************************************************/
#include "scp_types.h"

void add_connect_cell();
void add_cell_net();

/** lecture de la figure logique et implementation dans la structure interne **/

void chargement_figure(ptlofig)
lofig_list *ptlofig;
{
    static phfig_list *ptphfig=NULL;
    static phfig_list *ptphfig2=NULL;
    static locon_list *ptlocon=NULL;
    static phcon_list *ptphcon=NULL;
    static phins_list *ptphins=NULL;
    static loins_list *ptloins=NULL;
    static losig_list *ptlosig=NULL;
    static chain_list *connect=NULL;
    int ind_length=0, ind_length2=0;
    int decalx, decaly;
    int ind_sig;
    int ind_card;
    int ind_cell = 0;
    int ind_net = 0;
    int inter_net[NBNETMAX];
    extern long SCALE_X;

    /************************ initialisation *********************************/

    for (ind_card=0;ind_card<4;NB_CON[ind_card++]=0);

    /*********** ouverture de la figure physique (preplacement) ***************/

    PRE_PLACE = NULL;
    if (mbkfopen(ptlofig->NAME,IN_PH,READ_TEXT) != NULL)
    {
/*
           printf("preplacement pris en compte\n");
           ptphfig = getphfig(ptlofig->NAME,'A');
	   PRE_PLACE = 1;
*/
    }
    
    /********************** lecture des signaux (nets) ************************/

    lofigchain(ptlofig);/* fct permetant l'acces aux connecteurs par les nets */

    for (ptlosig=ptlofig->LOSIG;ptlosig;ptlosig=ptlosig->NEXT) /* boucle sigs */
    {
	inter_net[ptlosig->INDEX] = ind_net;
	ind_card = 0;
	connect=(chain_list *)(getptype(ptlosig->USER,(long)LOFIGCHAIN)->DATA);
	if (strncmp("vdd",((locon_list *)(connect->DATA))->NAME,3) != 0 
		&& strncmp(((locon_list *)(connect->DATA))->NAME,"vss",3) !=0) 
		for (;connect;connect=connect->NEXT) 
			ind_card++;
	NET[ind_net].coeff = man2dp(ind_card);
	ind_net++;
    }
    NBNET = ind_net;
    HEIGHT = 42;

    /******************** lecture des instances (cellules) ********************/
    /************************ cellules preplacees *****************************/

    NB_FIX_CELL = 0;
    if (PRE_PLACE)
    {
	PRE_PLACE_LENGTH=0;
	PRE_PLACE_ROW=0;
	decalx = ptphfig -> XAB1;
	decaly = ptphfig -> YAB1;
	for (ptphins=ptphfig->PHINS;ptphins;ptphins=ptphins->NEXT)
	{
	     ptloins = getloins(ptlofig,ptphins->INSNAME);
	     ptloins->USER = (ptype_list *)(1);
	     ptphfig2 = getphfig(ptloins->FIGNAME,'P');
	     CELL[ind_cell].width = (ptphfig2->XAB2 - ptphfig2->XAB1) / SCALE_X;
	     if (((ptphins->YINS-decaly)/ SCALE_X)%HEIGHT != 0)
     	     {
/*
		printf("la cellule %s n'est pas sur une bande !!\n"
			,ptphins->INSNAME);
*/
                exit(-1);
             }			
	     CELL[ind_cell].row = (ptphins->YINS - decaly) / (SCALE_X*HEIGHT); 
	     if (CELL[ind_cell].row >  PRE_PLACE_ROW)
		 PRE_PLACE_ROW = CELL[ind_cell].row; 
	     CELL[ind_cell].pos = (ptphins->XINS - decalx) / SCALE_X; 
	     if (CELL[ind_cell].pos + CELL[ind_cell].width > PRE_PLACE_LENGTH) 
		PRE_PLACE_LENGTH = CELL[ind_cell].pos + CELL[ind_cell].width;
	     ind_length = ind_length + CELL[ind_cell].width;
             CELL_REF[ind_cell].figname = ptphins->FIGNAME;
             CELL_REF[ind_cell].insname = ptphins->INSNAME;

             for(ptlocon=ptloins->LOCON;ptlocon;ptlocon=ptlocon->NEXT)
             {            
             	if (strncmp("vdd",ptlocon->NAME,3) != 0
                        && strncmp(ptlocon->NAME,"vss",3) !=0)
             	{
                    ind_sig = ptlocon->SIG->INDEX;
                    add_connect_cell(ind_cell,inter_net[ind_sig]);
                    add_cell_net(inter_net[ind_sig],ind_cell);
                }
             }
             ind_cell++;
    	}
    	NB_FIX_CELL = ind_cell;
	PRE_PLACE_ROW++;
    }
 
    /********************** cellules non preplacees ***************************/

    for (ptloins=ptlofig->LOINS;ptloins;ptloins=ptloins->NEXT) 
    {
	if (ptloins->USER) 		
		continue;
	ptphfig2 = getphfig(ptloins->FIGNAME,'P');
	CELL[ind_cell].width = (ptphfig2->XAB2 - ptphfig2->XAB1) / SCALE_X;
	ind_length = ind_length + CELL[ind_cell].width;
	ind_length2 = ind_length2 + CELL[ind_cell].width;
	CELL_REF[ind_cell].figname = ptloins->FIGNAME;
	CELL_REF[ind_cell].insname = ptloins->INSNAME;

	for(ptlocon=ptloins->LOCON;ptlocon;ptlocon=ptlocon->NEXT)  
	{	     
	     if (strncmp("vdd",ptlocon->NAME,3) != 0 
			&& strncmp(ptlocon->NAME,"vss",3) !=0) 
	     {
	        ind_sig = ptlocon->SIG->INDEX;
		add_connect_cell(ind_cell,inter_net[ind_sig]);
		add_cell_net(inter_net[ind_sig],ind_cell);
	     }
	}
	ind_cell++;
    }
    NBCELL = ind_cell;
    NB_FREE_CELL = NBCELL - NB_FIX_CELL;
    TOTAL_LENGTH = ind_length;
    FREE_CELL_LENGTH = ind_length2;

    /************** connecteurs preplaces (cellules fantomes) *****************/ 

    if (PRE_PLACE)
    {	
    	for (ptphcon = ptphfig->PHCON;ptphcon;ptphcon=ptphcon->NEXT)
    	{
            ptlocon = getlocon(ptlofig,ptphcon->NAME);
	    /* on utilise la var CELL[].last pour stocker la face */
	    /* on utilise la var CELL[].width pour stocker la position */
	    switch(ptphcon->ORIENT)
	    {
		case 'E' : CELL[ind_cell].last = 0;
			   CELL[ind_cell].width = ptphcon->YCON; 
			   break;

		case 'W' : CELL[ind_cell].last = 1;
			   CELL[ind_cell].width = ptphcon->YCON; 
			   break;

		case 'S' : CELL[ind_cell].last = 2;
			   CELL[ind_cell].width = ptphcon->XCON; 
			   break;

		case 'N' : CELL[ind_cell].last = 3;
			   CELL[ind_cell].width = ptphcon->XCON; 
	    }
	    NB_CON[CELL[ind_cell].last]++; /* comptage du nb de con. par face */
	    ind_sig = ptlocon->SIG->INDEX;
	    CELL_REF[ind_cell].figname = ptphcon->NAME;
            add_connect_cell(ind_cell,inter_net[ind_sig]);
            ind_cell++;
        }
    	NB_PREP_CON = ind_cell - NBCELL;
/*
	printf("nombre de connecteurs preplaces : %d\n",NB_PREP_CON);
*/
     }
}

/********** fonction qui cree ou ajoute un connecteur a une cellule ***********/

void add_connect_cell(ind_cell,net_number)
int ind_cell;
int net_number;
{
      struct connect_list_struct *connect;
      struct connect_list_struct *connect2;

      connect2 = (struct connect_list_struct *)
                        malloc(sizeof(struct connect_list_struct));
      connect2->next = NULL; 
      connect2->net_number = net_number;
      
      if (CELL[ind_cell].first == NULL)      /* liste inexistante : creation */
	    CELL[ind_cell].first = connect2;
      else					/* liste existante : ajout */
      {
	    for (connect=CELL[ind_cell].first;connect->next;connect=connect->next);
	    connect->next = connect2;
      }
}

/*************** fonction qui cree ou ajoute une cellule a un net *************/

void add_cell_net(ind_net,cell_number)
int ind_net;
int cell_number;
{
	struct cell_list_struct *cell;
	struct cell_list_struct *cell2;

	cell2 = (struct cell_list_struct *)
			malloc(sizeof(struct cell_list_struct));
	cell2->cell_number = cell_number;
	cell2->next = NULL;

      if (NET[ind_net].first == NULL)
	    NET[ind_net].first = cell2;
      else
      {
	    for (cell=NET[ind_net].first;cell->next;cell=cell->next);
	    cell->next = cell2;
      }
}
