/******************************************************************************/
/*                                                                            */
/*                    CAO & VLSI's cad tools chain Alliance                   */
/*                                                                            */
/*     Product  : Standard Cell Placer                                        */
/*     File     : scp_initpp.c                                                */
/*     Contents : initialisation des variables pour le preplacement           */
/*                                                                            */
/*     (c) Copyright 1992 Laboratoire MASI equipe CAO & VLSI                  */
/*     All rights reserved                                                    */
/*     Hot line  : cao-vlsi@masi.ibp.fr (e-mail)                              */
/*                                                                            */
/*     Author(s)   : Pierre Fedrichkine                 Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*                                                                            */
/******************************************************************************/
#include "scp_types.h"

/**************************** initialisation des donnees **********************/

void initialisation_preplacement(nbrow,fill)
int nbrow; 
int fill; 
{
	int ind_row;

        if (NB_FREE_CELL == 0)
    	{
        	fprintf(stdout,"All cells are already placed !!\n");
        	exit(-1);
    	}

	/******** choix des valeurs en fonction du preplacement ***************/

	FILL = fill;

	if (FILL)    		/* preplacement a completer */
	{
		if (NBROW == nbrow)	/* nbrow passe en argument */ 
                { 
			if (PRE_PLACE_ROW > NBROW)
			{
                       		printf("nombre de bandes trop faible \n"); 
                       		exit(-1); 
                	} 
		}
		else			/* nbrow pas passe en argument */
		{
			if (PRE_PLACE_ROW > NBROW)
				NBROW = PRE_PLACE_ROW;

			while ((PRE_PLACE_LENGTH > IDEAL_ROW_LENGTH) 
				&& (NBROW > PRE_PLACE_ROW)) 
				NBROW--;
		}
    		IDEAL_ROW_LENGTH = TOTAL_LENGTH / NBROW;
	}
	else			/* preplacement par bandes entieres */	
	{
		if (NBROW == nbrow)	/* nbrow passe en argument */ 
                { 
			if (PRE_PLACE_ROW > NBROW)
			{
                       		fprintf(stdout,"number of rows is very low \n"); 
                       		exit(-1); 
			}
		}
		else
		{
			ind_row = FREE_CELL_LENGTH / PRE_PLACE_LENGTH;
			if (FREE_CELL_LENGTH % PRE_PLACE_LENGTH != 0)
				ind_row++ ;
			NBROW = ind_row + PRE_PLACE_ROW;
		}
    		IDEAL_ROW_LENGTH = FREE_CELL_LENGTH / (NBROW - PRE_PLACE_ROW);
	}
}
