/******************************************************************************/
/*                                                                            */
/*                    CAO & VLSI's cad tools chain Alliance                   */
/*                                                                            */
/*     Product  : Standard Cell Placer                                        */
/*     File     :                                                             */
/*     Contents :                                                             */
/*                                                                            */
/*     (c) Copyright 1992 Laboratoire MASI equipe CAO & VLSI                  */
/*     All rights reserved                                                    */
/*     Hot line  : cao-vlsi@masi.ibp.fr (e-mail)                              */
/*                                                                            */
/*     Author(s)   : Pierre Fedrichkine                 Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*                                                                            */
/******************************************************************************/
#include "scp_types.h"
#include "scp_gcaph.h"

/************ fonction realisant le placement initial aleatoire ***************/

void generation_configuration_initiale(ptlofig)
lofig_list *ptlofig;
{
	int ind_cell;                                  /* indice de cellule */
	int ind_row;	                             /* indice de collonne */
	int ind_col; 			              /* indice de colonne */
	float ind_pos; 			             /* indice de position */
	int up =1;

	/*********************** initialisations ******************************/

	NBCELL_ROW = NBCELL / NBROW;  /* nb de cells par rangee (div entiere) */
	for (ind_row = 0;ind_row < NBROW;tabrow[ind_row++]=0);
	for (ind_row = 0;ind_row < NBROW;ind_row++)
		for (ind_cell = 0; ind_cell < NBCELLMAX;
			tab_row_col[ind_row][ind_cell++] = NONE);
	for (ind_row = 0;ind_row < NBROW;ROW[ind_row++].free = 1);

	/***************** prise en compte du preplacement ********************/

	if (PRE_PLACE)
		chargement_preplacement(ptlofig);

	/************ repartition des cellules dans les rangees ***************/

	for (ind_cell = NB_FIX_CELL;ind_cell < NBCELL;ind_cell++)
	{
		CELL[ind_cell].row = rand()%NBROW;
		while(tabrow[CELL[ind_cell].row] > NBCELL_ROW 
			| ROW[CELL[ind_cell].row].free == 0)
			CELL[ind_cell].row = rand()%NBROW;
		tabrow[CELL[ind_cell].row]++;
	}

	for (ind_row = 0;ind_row < NBROW;ind_row++)
		if (tabrow[ind_row] == 0)
		{
			fprintf(stdout,"Number of rows is very high !!\n");
			exit(-1); 
		}
				
	/************* repartition des cellules  par colonnes *****************/

	for (ind_cell= NB_FIX_CELL ;ind_cell<NBCELL;ind_cell++)
	{
		ind_col = rand()%tabrow[CELL[ind_cell].row];
		while(tab_row_col[CELL[ind_cell].row][ind_col] != NONE)
			if (up)
				if(ind_col == tabrow[CELL[ind_cell].row]-1)
					ind_col =0;
				else
					ind_col++;
			else
				if(ind_col == 0)
					ind_col = tabrow[CELL[ind_cell].row]-1;
				else
					ind_col--;
		tab_row_col[CELL[ind_cell].row][ind_col] = ind_cell;
		up = 1 - up;
	}

	/******** affectation du placement dans la structure CELL  ************/

	for (ind_row=0;ind_row < NBROW;ind_row++)
	{
		ROW[ind_row].number_cell = tabrow[ind_row];
                ind_cell = tab_row_col[ind_row][0];
		ROW[ind_row].first = ind_cell;	
		CELL[ind_cell].last = NONE;
                CELL[ind_cell].pos = CELL[ind_cell].width / 2;
                ind_pos = CELL[ind_cell].width;

		CELL[tab_row_col[ind_row][tabrow[ind_row]-1]].next = NONE;
		ROW[ind_row].last = tab_row_col[ind_row][tabrow[ind_row]-1];

		for (ind_col=1;ind_col < tabrow[ind_row] ;ind_col++)
		{
                        ind_cell = tab_row_col[ind_row][ind_col];
                        CELL[ind_cell].pos = ind_pos+CELL[ind_cell].width/2;
                        ind_pos = ind_pos + CELL[ind_cell].width;

			CELL[ind_cell].last = tab_row_col[ind_row][ind_col-1];
			CELL[tab_row_col[ind_row][ind_col-1]].next = ind_cell;
		}
		ROW[ind_row].length = ind_pos;
	}
}
