/******************************************************************************/
/*                                                                            */
/*                    CAO & VLSI's cad tools chain Alliance                   */
/*                                                                            */
/*     Product  : Standard Cell Placer                                        */
/*     File     : scp_dist.c                                                  */
/*     Contents : function man2dp. from mannathan evaluation of net lengths   */
/*                this function gives the semi-perimeter evaluation           */
/*                                                                            */
/*     (c) Copyright 1992 Laboratoire MASI equipe CAO & VLSI                  */
/*     All rights reserved                                                    */
/*     Hot line  : cao-vlsi@masi.ibp.fr (e-mail)                              */
/*                                                                            */
/*     Author(s)   : Pierre Fedrichkine                 Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*     Modified by :                                    Date : ../../....     */
/*                                                                            */
/******************************************************************************/
#include "scp_types.h"

/*** calcul du rapport entre distance de mannathan et demi-perimetre **********/

float man2dp(card)
int card;
{
	switch(card)
	{
		case 0 : return(0);
			break;

		case 1 : return(0);
			break;

		case 2 : return(1);
			break;

		case 3 : return(0.5);	 
			break;

		case 4 : return(0.333);	 
			break;

		case 5 : return(0.222);	 
			break;

		case 6 : return(0.15);	 
			break;

		case 7 : return(0.11);	 
			break;

		case 8 : return(0.087);	 
			break;

		case 9 : return(0.0689);	 
			break;

		case 10 : return(0.0563);	 
			break;

		default : return(6. / (card*(card+1.)));
	}
}

