/******************************************************************************/
/*                                                                            */
/*                      Chaine de CAO & VLSI   Alliance                       */
/*                                                                            */
/*    Produit : STANDAD CELLS ROUTER                                          */
/*    Fichier : SCR_Type.h                                                    */
/*                                                                            */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                   */
/*    Tous droits reserves                                                    */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                   */
/*                                                                            */
/*    Auteur(s) : El housseine REJOUAN                  le : 26/10/1991       */
/*                                                                            */
/*    Modifie par :                                     le : ../../....       */
/*    Modifie par :                                     le : ../../....       */
/*    Modifie par :                                     le : ../../....       */
/*                                                                            */
/******************************************************************************/

# define TRICE		((char *) "_")
# define SIGNAME        ((char *) "Sig_")
# define NOTNET		((long 0) 0)

# define MIN(a,b) 	((a<b) ? a:b)
# define INF(x,y,z)	(((x - y) <= (z - x)) ? y : z)
# define LABS(x,y)	((x > y) ? (x - y) : (y - x))
# define PATH		'P'
# define CELL		'C'
# define DOWN		'D'
# define UP		'U'
# define BOOLEAN	int
# define FALSE		((int ) 0)
# define TRUE		((int ) 1)
# define VDDOFFSET	((long ) 2 * SCALE_X)
# define VSSOFFSET	((long ) 2 * SCALE_X)
# define VDDWIDTH	((long ) 8 * SCALE_X)
# define VSSWIDTH	((long ) 8 * SCALE_X)
# define RIGHTSUPPLY	(PITCH_X / 2)
# define LEFTSUPPLY	(PITCH_X / 2)
# define MIDDLESUPPLY	((long ) 2 * SCALE_X)

typedef struct SCR_Figure 
	{
	 struct SCR_Line	*LINE;	
	 struct SCR_Signal	*SIG;	
	 struct SCR_Connector	*CON;
         struct SCR_Segment	*ALLOW;
        } Figure;

typedef struct SCR_Line 
	{
	 struct SCR_Line	*NEXT;
         char		 	*NAME;	        
         char		 	TYPE;	        
         long		 	X,Y;          
         long		 	WIDTH;       
         long     	 	HEIGTH;     
	 long			INDEX;
         struct SCR_Instance 	*INS;     
         struct chain		*SIG;       	
         struct chain 		*CON;      
         struct SCR_Segment	*ALLOWUSED;   
         struct chain 		*ALLOW;      
         struct SCR_Channel	*CHANNEL;	
        } Line;

typedef struct SCR_Signal 
	{
	 struct SCR_Signal	*NEXT;
         char			*NAME;
         long			INDEX;     
         char			TYPE;     
         struct chain		*CON;	
         struct chain		*LINE;
         long 		 	MAXCON;        
        } Signal;	

typedef struct SCR_Instance 
	{
	 struct SCR_Instance	*NEXT;
         char			*NAME;
         char			*FIGNAME;
         long		 	X,Y;
         long		 	WIDTH;	
         long		 	HEIGTH; 
	 char		 	TRANSF; 
         struct SCR_Connector 	*CON;	
         struct SCR_Segment 	*ALLOW; 
        } Instance;

typedef struct SCR_Connector 
	{
	 struct SCR_Connector	*NEXT;
         char			*NAME;
         char		 	TYPE;     	
         char             	DIRECTION;     
         char             	ORIENT;    
	 long            	X,Y; 
	 long             	WIDTH;	   
	 long             	ORDER;	   
	 char             	LAYER;	
	 struct SCR_Signal	*SIG;
	 struct SCR_Line	*LINE;     
	 struct SCR_Instance	*INST;	
        } Connector;

typedef struct SCR_Segment 
	{
	 struct SCR_Segment	*NEXT;
	 char            	*NAME;
	 long             	X1,Y1,X2,Y2;
	 long             	WIDTH;	    
	 char             	TYPE;	
	 char             	LAYER;
        } Segment;


typedef struct SCR_Channel
        {
         struct SCR_ConnectorList	*NORTH_LIST;
         struct SCR_ConnectorList	*SOUTH_LIST;
         struct SCR_ConnectorList	*WEST_LIST;
         struct SCR_ConnectorList	*EAST_LIST;
	 struct SCR_SegmentList		*H_SEGMENT;
	 struct SCR_SegmentList		*V_SEGMENT;
	 struct SCR_ViasList		*VIA;
	 long				WIDTH;
	 long				HEIGTH;
        } Channel ; 


