/****************************************************************************/
/*                                                                          */
/*                      ALLIANCE CAO & VLSI CAD                             */
/*                                                                          */
/*    Product : (S)ymbolic (2)to (R)eal translater                          */
/*    File    : statistics.c                                                */
/*                                                                          */
/*    (c) copyright 1992 MASI laboratory CAO & VLSI team                    */
/*    All Right Reserved                                                    */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/****************************************************************************/ 
/*                                                                          */
/*                           Statistics functions                           */
/*                                                                          */
/****************************************************************************/

#include "statistics.h"

long STAT_RECT_REQRD = 0;   /* number of rectangles required to be allocated */
long STAT_RECT_ALLOC = 0;   /* number of rectangles really allocated in memory*/
long STAT_SCTCH_RQRD = 0;   /* number of scotchs needed */
long STAT_SCTCH_CRTD = 0;   /* number of scotchs created */
extern long mbkalloc_stat;  /* memory allocated by mbk */

/*******************************************************************************
 * print_statistics: prints statistics 
 ******************************************************************************/

void print_statistics(scotch_on_flag)
int scotch_on_flag;
{
	printf("\to memory allocation informations\n");
    	printf("\t--> required rectangles = %ld ", STAT_RECT_REQRD);
    	printf(" really allocated = %ld\n", STAT_RECT_ALLOC);
	if (scotch_on_flag) {
    		printf("\t--> required scotchs = %ld ", STAT_SCTCH_RQRD);
    		printf(" really created = %ld\n", STAT_SCTCH_CRTD);
	}
	printf("\t--> Number of allocated bytes: %ld\n", mbkalloc_stat);
}
   

