/******************************************************************************
 *                                                                            *
 *    Rectangle Data Base : Structures and Access functions                   *
 *                                                                            *
 *****************************************************************************/

#include "maxima.h"

/******************************************************************************
 * definitions of flags
 *****************************************************************************/

#define	REC_INIT	0  	/* rectangle: default */
#define	REMOVE		1  	/* rectangle: to be removed */
#define	FLATTENRES	2	/* rectangle: resulted from a flatten */ 	
#define	USED		4	/* rectangle: used in merge */ 	
#define	SCOTCH		8	/* rectangle: a scotch */ 	
#define	OLD_SCOTCH	16	/* rectangle: an old scotch */ 	

#define	EMPTY		1	/* model(specific for a layer): 
                         		it contains nothing in this layer*/

#define	POST		1	/* model->flag: the model is postrated*/
#define	READ		2	/* model->flag: model already read from disk */
				/* when a cell contains a model which has been */
				/* already read in another cell, this flag */
				/* prevents from reading it twice from disk */
/* Rectangles */

typedef rds_rec *rds_rectanglep_typ;


/*****************************************************************************
 * Instances :
 * The coordinates and symetry semantics are the gds & cif 's one, that's 
 * completly different from mbk's 
 *****************************************************************************/

/* Models */

typedef rds_fig *rds_figurep_typ;

/************************************************************************
* types and definitions of rectangle data base access
*************************************************************************/

/************************************************************************
 * free list of rectangles removed to be 
 * allocated when a creation of a rectangle is requested 
 ************************************************************************/
extern rds_rec *Free_List; 

/************************************************************************
 * declaration of the functions defined in rds_access.c
 ************************************************************************/

extern rds_rec *rds_rectangle_in();
extern rds_ins *rds_instance_in();
extern void rds_remove_model();
extern rds_fig *rds_create_model();
extern rds_fig *rds_model_out();
extern rds_ins *rds_instance_out();
extern void rds_mbk_kill();
extern void mark_remove();
extern void mark_flattenres();
extern void mark_used();
extern void mark_scotch();
extern void mark_old_scotch();
extern void mark_empty();
extern void mark_post();
extern void demark_flattenres();
extern void demark_scotch();
extern void demark_used();
extern void push_free_list();
extern rds_rec *pull_free_list();
extern void rds_remove_rectangle();
extern void rds_clean_layer();
extern side_intersec();
extern rect_intersec();

/*******************************************************************************
 * macro definitions to test the flags fields of rectangles and models
 ******************************************************************************/

/******************************************************************************
 * rectangles
 *****************************************************************************/

#define is_remove(rectangle)  		( (rectangle)->flags & REMOVE)
#define is_flattenres(rectangle)  	( (rectangle)->flags & FLATTENRES)
#define is_used(rectangle)  		( (rectangle)->flags & USED)
#define is_scotch(rectangle)  		( (rectangle)->flags & SCOTCH)
#define is_old_scotch(rectangle)  	( (rectangle)->flags & OLD_SCOTCH)
         
/*****************************************************************************
 * are_rect_intersec: tests if the 2 given rectangles ( given by their 
 *                    coordinates) intersect or not.
 ******************************************************************************/

#define are_rect_intersec(x1,y1,dx1,dy1,x2,y2,dx2,dy2)     (\
                 (( ((x2) >= (x1)) && ((x2) <= ((x1)+(dx1))))\
            ||\
                 (( (x2) <= (x1)) && ( ((x2)+(dx2)) >= (x1))))\
        &&\
                 (( ((y2) >= (y1)) && ((y2) <= ((y1)+(dy1))))\
            ||\
                 (( (y2) <= (y1)) && ( ((y2)+(dy2)) >= (y1))))\
                                                           )
                      
/****************************************************************************
 * models
 ****************************************************************************/

#define is_empty(model,layer_num)  	( (model)->flagtab[layer_num] & EMPTY)
#define is_post(model)  		( (model)->flag & POST)
#define is_read(model)  		( (model)->flag & READ)

