            /************************************************************
             *                                                          *
             *                       GDS_TYPE.H                         *
             *                                                          *
             *  Pierre VITTET - Aout 1991                               *
             *                                                          *
             ************************************************************/



#ifndef _GDS_TYPE_
#define _GDS_TYPE_

#ifndef ushort
#define ushort unsigned short
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#define	type_i	unsigned short
#define	type_l	unsigned short
#define	type_c	unsigned short

typedef struct {                 /* enregistrement de la date et de l'heure */
  short   year;                           /*  annee                 */
  short   month;                         /*   mois                 */
  short   day;                          /*    jour                */
  short   hour;                        /*     heure              */
  short   min;                        /*      minutes           */
  short   sec;                       /*       secondes         */
} date_t;

typedef struct {                   /*   paire de coordonnees       */
        long x;                   /*        abcisse               */
        long y;                  /*         ordonnee             */
} coord_t;

typedef struct {                        /* en-tete de l'enregistrement contient les infos :  */
        short size;                    /*       longueur de l'enregistrement                */
        short gdscode;                /*        record type & data type                    */
} hinfo_t;

typedef double unit_t;          /* database unit type */
typedef double angle_t;         /* angular rotation factor type */
typedef double mag_t;           /* magnification factor type */

/*********
*
*           STRUCT VAR
*
* Cette structure est utilisee pour contenir certaines variables du programme.
*
***/

struct var {
        short v_error;          /* code d'erreur			*/
        char *v_textp;          /* pointeur vers un texte quelconque.	*/
                                /* Peut, par exemple, etre utilise pour completer un message d'erreur   */
};

extern struct var pv_error;

/* erreurs generales */

#define ENOMEM       1          /* No enough core. */
#define EIO          2          /* IO error. */
#define EFTRUNC      3          /* The file is teuncated somewhere. */
#define ENOFILE      4          /* Cannot open file. */
#define ENOSPACE     5          /* No more space on disk. */
#define ECLOCK       6          /* Cannot read internal clock well. */
#define EOVERFL      7          /* Overflow or underflow. */
#define ENOMODEL     8          /* Unknown model in Rds. */

#define ENODONE      99
/* Programme en cours de finition... Cela permet de definir par exemple l'en-tete d'une */
/* fonction et de ne pas faire son corps. C'est utile si on doit fabriquer une librai-  */
/* rie et que l'on est en retard : n'importe qui peut quand meme inclure cette fonction */
/* dans un executable, il ne se passera rien lors de son appel. Il suffit simplement de */
/* recompiler lorsque la librairie est terminee.                                        */

/* erreurs specifiques aux parser/driver */

#define ENOCODE      101        /* Le code rencontre n'est pas reconnu.                                                 */
#define ENORELE      102        /* Le code existe bien mais correspond a une version trop recente du format de stockage */
                                /* (GDS2, CIF...), dans la version avec laquelle on travaille, ce code etait envisage   */
                                /* mais pas encore implemente.                                                          */
#define ENOTHER      255        /* Any other (wierd !) error. */

#endif
