/*
*	PARSE_CIF.H
*/

#define SZ_NAME_MAX 256
/*		types pour le portage sur DOS				*/
typedef unsigned char bool;
typedef int lnat;			/* entier sur 4 octets sous DOS	*/
typedef short cnat;			/* entier sur 2 octets sous DOS */
typedef unsigned char uchar; 		/* octet non signe 		*/

/* prototypes :
	obtain for proper compilation by the use of ctags.
   I made some type modification on most of them, perhaps bad ones!
   Fred : 06/08/92
   */

/*		codes de operations geometriques			*/
#define  GNOP    0x02   		/* pas d'operation  		*/
#define  GRPLUS  0x03   		/* rotation plus 		*/
#define  GRMOINS 0x04   		/* rotation moins 		*/
#define  GSYMX   0x05   		/* symetrie X  			*/
#define  GSYMY   0x06   		/* symetrie Y  			*/
#define  GSYMO   0x07   		/* symetrie par rapport a 0 	*/
#define  GRPSY   0x08   		/* rotation + suivie de sym/y 	*/
#define  GRMSY   0x09   		/* rotation - suivie de sym/y 	*/

#define ABS(x)              ((x)>=0) ? (x): -(x)
 
typedef struct node {
	struct	node	*next;
	char	*name;
	int	xcoord;
	int	ycoord;
	int	layer;
}NODE, *PTNODE;

#define		RAM		1
#define		OLD		2
#define		NEW		3
#define		DEJAVU		4
#define		BLOCK		5
#define 	MASK		6

#define		MAXSHAB		1000
#define		MAXRAMB 	3000
#define 	MAXFLAT		1000

#ifndef		MAXMOTIF
#define 	MAXMOTIF	1
#endif

#define TRUE 1
#define FALSE 0
#define POS 1
#define NEG 0

#define MAXDESCR	40000
#define MAXDSYM	3000
#define MAXSYSNAME	80

#define D_POLYGON	1
#define D_BOX		2
#define D_ABBOX		3
#define D_XCTOR		4
#define N_ABBOX		5

#define LAR_CNCTOR	0		/* valait 2 avant pour la largeur par defaut */
#define FMULT		100

#define MRTXFLWEC	32
#define MAXDESCOVER	33
#define SYMBEXIST	40
#define OVERMAXDSYM	41
#define NODSNAME	43

/* command definitions */
#define COM_NULL	0
#define COM_POLYGON	1
#define COM_BOX		2
#define COM_ROUNDFLASH	3
#define COM_WIRE	4
#define COM_LAYER	5
#define COM_DEFSTART	6
#define COM_DEFFINISH	7
#define COM_DEFDELETE	8
#define COM_CALL	9
#define COM_COMMENT	10
#define COM_END		11
#define COM_EOF		12
#define COM_USR9	13
#define COM_USR91	14
#define COM_USR92	15
#define COM_USR93	16
#define COM_USRLABEL	17
#define COM_USER	18
#define COM_U9SYMBN	19
#define COM_U4INSTN	20
#define COM_U4NODE	21
#define COM_U4ABBOX	22
#define COM_U4XCTOR	23



/* structure for a point */
typedef struct apoint {
	int p_xcoord;	/* x-coordinate */
	int p_ycoord;	/* y-coordinate */
} POINT;


/* structure for transformation */
typedef struct transform {
	int t_type;
	union {
		POINT t_pt;	/* if t_type == TRANSLATION or ROTATION */
		unsigned int t_dir;	/* if t_type == MIRROR */
	} u;
	struct transform *t_next; /* next elt in transform list */
} TRANSFORM;

typedef struct inst_geo {
   char     *name_isym;
   char     *ad_csym_cur;
   TRANSFORM   *pt_trans;
   struct inst_geo   *next;
}INST_GEO, *PT_INST_GEO;

/* defines for TRANSFORM.t_type */
#define TRANSLATE	1	
#define MIRROR		2
#define ROTATE		3

/* defines for TRANSFORM.u.t_dir */
#define NODIRECTION	0
#define ONLYMIRROR  0
#define XDIRECTION	1
#define YDIRECTION	2

/* structure for call */
typedef struct call {
	unsigned int c_symnum;	/* symbol number */
	TRANSFORM *c_xformlst;	/* list of transforms */
	struct call *c_next;	/* next elt in call list */
} CALL;


typedef struct {
	char *ad_symbname;
	int nro,elmtnbr,callnbr;
	lnat x_env,y_env,dx_env,dy_env;
}TYP_DSYM;

typedef struct {
	uchar block_id;
	char block_name[SZ_NAME_MAX+1];
}TYP_BLOCID;
	

/* error numbers */
#define NOLAYERNAME 	1
#define NESTDEF		2
#define NODEFSTART	3
#define NESTDD		4
#define BADCOMMENT	5
#define NESTEND		6
#define NOSPACE		7
#define BADUSER		8
#define BADCOMMAND	9
#define BADDEF		10
#define NOSEMI		11
#define BADTRANS	12
#define BADMIRRORTYPE	13
#define NONAME		14
#define NOUNSIGNED	15
#define NOSIGNED	16
#define NUMTOOBIG	17
#define NOPATH		18
#define RLABEL_ERR	19
#define REDEFINE_LL	20
#define REDEFINE_UR	21
#define SYMNUMERR	22
#define BADDIRECTION	23
#define BASELENGTH	24
#define OPENFILE	25
#define INTERNAL	30
#define NOFILEIN	31
#define MRTXTFLWEC	32
#define MAXDESOVER	33
#define NOMEMORY	34
#define NON_MANHATTAN	35
#define STOCKHR		36
#define NON_NIV		37
#define XCTOR		38
#define NOABBOX		39
#define SYMBEXIST	40
#define OVERMAXDSYM	41
#define NAMEALLOC	42
#define NODSNAME	43
#define BADNODE		44
#define COORDBIG	45
#define POLREC		46
#define ENDOFILE	47
#define NOLAYERINRDS 	48

#define NOTALIGNED 49

extern rds_fig *loadcif();
static void init_emi();

/*
*	Variables et fonctions internes a PARSE_CIF.c
*/
#ifdef PARSECIF_C

cnat represen; 		/* represen du fichier.                 	*/
lnat root_flatnbdesc; /* ?? */

char nextchar=' ', curname[SZ_NAME_MAX];
char *ad_lyrn_cur,*ad_dsym_cur,*ad_csym_cur,*ad_isym,*ad_node,*ad_cntno,*ad_cntly,*ad_cntna,*ad_cntty,*ad_cntly,*cntno;
char *ad_root_sym;

POINT boxcenter,curpoint,*curpath,boxdirection,boxdim;

lnat descrcount,elmt_nbr_cur_dsym,call_nbr_in_cur_dsym;

int cenvx_min,cenvx_max,cenvy_min,cenvy_max,x_abbox,y_abbox,dx_abbox,dy_abbox,x_cnctor,y_cnctor,nro_dsym_cur,INITENV,DSNAMEXIST;

int distscale;

TYP_DSYM TAB_DSYM[MAXDSYM];

#define NBMAXBLOC 1
TYP_BLOCID TAB_BLOCID[NBMAXBLOC];

int cnctorid,cnctorwi;

char ciffilename[MAXSYSNAME+1];

int mirror_direction;
int curpathl=0;
int cpt_dsym=0;
unsigned int linecount = 0;

FILE *infile;

static int corresp();
static void calcul_coord();
static void fill_rect_with_node();
static void build_figure_rds();
static rds_rec *MyGetRectangleByPoint();
static void write_mask();
static void write_bloc();
static void get_dsym_env();
static void get_i_pos_geop();
static cnat comp_geop();
static void write_emi();
static uchar get_id_isym();
static char *get_inst_ad();
static void put_inst_id_ad();
static void error();
static void warning();
static unsigned int parsecommand();
static void gettransform();
static void appendtrans();
static char getch();
static void blank();
static void sep();
static bool semi();
static bool sp();
static void utext();
static void name();
static void getname();
static unsigned int cardinal();
static int vers_signed();
static void getpoint();
static void getpath();

#undef PARSECIF_C
#endif

