/***************************************************************************
 * maxima definitions
 ***************************************************************************/

#define BUFFER_SIZE 		255
#define MAX_STRING_SIZE 	30
#define MAX_FILE_NAME   	30

/**************************************************************************
 * special chars
 **************************************************************************/
 
#define SEPARATORS_STRING " \t\n"
#define COMMENT_CAR '#'
 
/***************************************************************************
 * tec language keywords
 ***************************************************************************/

#define	DEFINE			"DEFINE"
#define	TABLE			"TABLE"
#define	END_RECORD		 NULL
#define	END_TABLE		"END"

/**************************************************************************
 * program variables
 *************************************************************************/

#define LAMBDA			"LAMBDA"
#define PHYS_GRID		"PHYSICAL_GRID"

/*************************************************************************
 * tables 
 *************************************************************************/

#define	POST			"S2R_POST_TREAT"
#define RFM_SEG			"MBK_TO_RDS_SEGMENT" 		
#define RFM_VIA			"MBK_TO_RDS_VIA" 		
#define RFM_CON			"MBK_TO_RDS_CONNECTOR" 		
#define CIF_LAYER   		"CIF_LAYER"
#define GDS_LAYER   		"GDS_LAYER"
#define OVERSIZE		"OVERSIZE_DENOTCH"
#define RINGWIDTH		"BLOC_RING_WIDTH"
#define LAYERWIDTH		"MINIMUM_LAYER_WIDTH"

/**************************************************************************
 * program variables
 *************************************************************************/

#define LAMBDA_DEFINED        	1
#define PHYS_GRID_DEFINED    	2
#define ALL_VAR_DEFINED 	3

#define is_lambda_defined 	(var_defined & LAMBDA_DEFINED)
#define is_phys_grid_defined 	(var_defined & PHYS_GRID_DEFINED)
#define is_all_var_defined	(!(var_defined ^ ALL_VAR_DEFINED))
#define mark_lambda		var_defined = (is_lambda_defined)\
                                    ? (var_defined)\
			 	    : (var_defined + LAMBDA_DEFINED)
#define mark_phys_grid		var_defined = (is_phys_grid_defined)\
                                    ? (var_defined)\
				    : (var_defined + PHYS_GRID_DEFINED)

/************************************************************************
 * tables
 ************************************************************************/

#define	POST_DEFINED		1
#define RFM_SEG_DEFINED		2
#define RFM_VIA_DEFINED		4
#define RFM_CON_DEFINED		8
#define CIF_LAYER_DEFINED   	16
#define GDS_LAYER_DEFINED   	32
#define OVERSIZE_DEFINED	64
#define RINGWIDTH_DEFINED	128
#define LAYERWIDTH_DEFINED	256
#define ALL_TABLE_DEFINED 	511

#define is_post_defined 	(table_defined & POST_DEFINED)
#define is_rfm_seg_defined 	(table_defined & RFM_SEG_DEFINED)
#define is_rfm_via_defined 	(table_defined & RFM_VIA_DEFINED)
#define is_rfm_con_defined 	(table_defined & RFM_CON_DEFINED)
#define is_cif_layer_defined   	(table_defined & CIF_LAYER_DEFINED)
#define is_gds_layer_defined 	(table_defined & GDS_LAYER_DEFINED)
#define is_oversize_defined 	(table_defined & OVERSIZE_DEFINED)
#define is_ringwidth_defined 	(table_defined & RINGWIDTH_DEFINED)
#define is_layerwidth_defined 	(table_defined & LAYERWIDTH_DEFINED)
#define is_all_table_defined	(!(table_defined ^ ALL_TABLE_DEFINED))
#define mark_post		table_defined = (is_post_defined)\
                              	    ? (table_defined)\
				    : (table_defined + POST_DEFINED)
#define mark_rfm_seg		table_defined = (is_rfm_seg_defined)\
                              	    ? (table_defined)\
				    : (table_defined + RFM_SEG_DEFINED)
#define mark_rfm_via		table_defined = (is_rfm_via_defined)\
                              	    ? (table_defined)\
				    : (table_defined + RFM_VIA_DEFINED)
#define mark_rfm_con		table_defined = (is_rfm_con_defined)\
                              	    ? (table_defined)\
				    : (table_defined + RFM_CON_DEFINED)
#define mark_cif_layer		table_defined = (is_cif_layer_defined)\
                              	    ? (table_defined)\
				    : (table_defined + CIF_LAYER_DEFINED)
#define mark_gds_layer		table_defined = (is_gds_layer_defined)\
                              	    ? (table_defined)\
				    : (table_defined + GDS_LAYER_DEFINED)
#define mark_oversize		table_defined = (is_oversize_defined)\
                                    ? (table_defined)\
				    : (table_defined + OVERSIZE_DEFINED)
#define mark_ringwidth		table_defined = (is_ringwidth_defined)\
                              	    ? (table_defined)\
				    : (table_defined + RINGWIDTH_DEFINED)
#define mark_layerwidth		table_defined = (is_layerwidth_defined)\
                              	    ? (table_defined)\
				    : (table_defined + LAYERWIDTH_DEFINED)
