/*------------------------------------------------------\
|                                                       |
|  Title   :      Translator MBK -> RDS                 |
|                                                       |
|  Date    :            21/09/92                        |
|                                                       |
|  Author  :         Jacomme Ludovic                    |
|                                                       |
\------------------------------------------------------*/

/*------------------------------------------------------\
|               Les fichiers a inclure                  |
\------------------------------------------------------*/

#include MUT_H
#include MPH_H
#include RPR_H
#include RDS_H
#include RFM_H

#include "rfm.h"

/*------------------------------------------------------\
|                                                       |
|        Les fonctions de passage Mbk -> Rds            |
|                                                       |
\------------------------------------------------------*/
/*------------------------------------------------------\
|     Transformation d'un Segment d'une Figure Mbk      |
\------------------------------------------------------*/

/*------------------------------------------------------\
| The values given by the macros are no more to be      |
| interpreted the same way than previously              |
| but rather : see documentation for more               |
\------------------------------------------------------*/

/*------------------------------------------------------\
| It is to be noticed that here is done the explicit    |
| part of the mbk to rds segment translation.           |
| The layers are coming directly from the rpr file      |
\------------------------------------------------------*/

  rds_rec *SegmentMbkRds( FigureRds, Segment )

           rds_fig    *FigureRds;
           phseg_list *Segment;
  {
    long          X1;
    long          X2;
    long          Y1;
    long          Y2;

    char          LayerMbk;
    char          LayerRds;

    rds_rec      *Rectangle;
    rds_rec      *Inter;
    rds_rec      *First;

    char          Index;
    LineSeg      *LineS;

    LayerMbk  = Segment->LAYER;
    LineS     = GetSegParam( LayerMbk ); 
    Rectangle = (rds_rec *)NULL;
    Inter     = (rds_rec *)NULL;
    First     = (rds_rec *)NULL;
    
    for ( Index = 0; 
          Index < MAX_N_SEG_LAYER;
          Index++ )
    {
      if ( (LayerRds = GET_SEG_LAYER( LineS, Index )) == RDS_NOP ) continue;

/*------------------------------------------------------\
| Here, we suppose that PHYS_GRID_PARAM is always even, |
| if not, dividing by 2 will truncate arbitrary         |
| the value and therefore imply loosing precision.      |
\------------------------------------------------------*/

      if ( Segment->TYPE == HOR )
      {
         X1 = ( Segment->X1 * LAMBDA_PARAM /  SCALE_X      ) - 
              ( GET_SEG_DLR( LineS, Index )                );

         X2 = ( Segment->X2 * LAMBDA_PARAM /  SCALE_X      ) + 
              ( GET_SEG_DLR( LineS, Index )                );

         Y1 = ( Segment->Y1 * LAMBDA_PARAM / SCALE_X       ) -
              ((( GET_SEG_DWR( LineS, Index )              ) +
                ( Segment->WIDTH * LAMBDA_PARAM / SCALE_X  )) >> 1 ); 

         Y2 = ( Segment->Y1 * LAMBDA_PARAM / SCALE_X       ) +
              ((( GET_SEG_DWR( LineS, Index )              ) +
                ( Segment->WIDTH * LAMBDA_PARAM / SCALE_X  )) >> 1 ); 

      }
      else
      {
         Y1 = ( Segment->Y1 * LAMBDA_PARAM /  SCALE_X      ) - 
              ( GET_SEG_DLR( LineS, Index )                );

         Y2 = ( Segment->Y2 * LAMBDA_PARAM /  SCALE_X      ) + 
              ( GET_SEG_DLR( LineS, Index )                );

         X1 = ( Segment->X1 * LAMBDA_PARAM / SCALE_X       ) -
              ((( GET_SEG_DWR( LineS, Index )              ) +
                ( Segment->WIDTH * LAMBDA_PARAM / SCALE_X  )) >> 1 ); 

         X2 = ( Segment->X1 * LAMBDA_PARAM / SCALE_X       ) +
              ((( GET_SEG_DWR( LineS, Index )              ) +
                ( Segment->WIDTH * LAMBDA_PARAM / SCALE_X  )) >> 1 ); 

      }

      X1 = RoundInf( X1 ); 
      Y1 = RoundInf( Y1 );
      X2 = RoundSup( X2 );
      Y2 = RoundSup( Y2 ); 

/*------------------------------------------------------\
| By default, all segments are supposed to be linked    |
| with some other one                                   |
\------------------------------------------------------*/

      Rectangle = AddRectangleFigRds
      (
        FigureRds, 
        NULL,
        X1,
        Y1,
        X2 - X1, 
        Y2 - Y1,
        LayerRds, 
        MBK_SEGMENT, 
        (( LayerMbk == NTRANS || LayerMbk == PTRANS ) ? RDS_SEG_TRANS 
                                                      : RDS_RECTANGLE_LINK ),
        Segment
      );
        
      if ( First == (rds_rec *)NULL ) First = Rectangle;

      Rectangle->u_rec.link = Inter;
      Inter                 = Rectangle;
    }

    if ( First != Inter )
    {
      First->u_rec.link = Rectangle;
    }
    else
    {

/*------------------------------------------------------\
| Whee the segment is in fact not linked, since only is |
| to be generated, the name and extract_type fields     |
| are changed to there expected value.                  |
\------------------------------------------------------*/

      First->u_rec.name   = Segment->NAME;
      First->extract_type = RDS_NONE;
    }
    
    return( Rectangle );
  }

/*-----------------------------------------------------\
|     Transformation d'un Segment d'une Figure Mbk     |
\-----------------------------------------------------*/
/*-----------------------------------------------------\
| This function ensures the implicit part              |
| of the translation                                   |
\-----------------------------------------------------*/

  rds_rec *SegmentTransMbkRds( FigureRds, Segment )

           rds_fig    *FigureRds;
           phseg_list *Segment;

  {
    rds_rec *Gate  = NULL;
    rds_rec *Activ = NULL;
    rds_rec *Index;
    rds_rec *Rectangle;
    rds_rec *First;
    
    First = Index = Rectangle = SegmentMbkRds( FigureRds, Segment );
    if (( Segment->LAYER == NTRANS ) ||
        ( Segment->LAYER == PTRANS ))
    {
      do 
      {
        if ( Index->layer == RDS_GATE ) 

           Gate  = Index;          /* we suppose there is only one gate  */

        if ( Index->layer == RDS_ACTIV ) 

           Activ = Index;          /* we suppose there is only one activ */

        Index  = Index->u_rec.link;
      } 
      while ( Index != Rectangle );

      if ( Activ == NULL || Gate == NULL ) return ( Rectangle );

      if ( Segment->TYPE == HOR )
      {
        Rectangle = AddRectangleFigRds
        (
          FigureRds,
          NULL,
          Activ->x,
          Activ->y,
          Activ->dx,
          Gate->y - Activ->y,
          Segment->LAYER == NTRANS ? RDS_NDIF : RDS_PDIF,
          MBK_SEGMENT,
          RDS_SEG_TRANS,
          Segment
        );

        Index = AddRectangleFigRds
        (
          FigureRds,
          NULL,
          Activ->x,
          Gate->y + Gate->dy,
          Activ->dx,
          Activ->y + Activ->dy - Gate->y - Gate->dy,
          Segment->LAYER == NTRANS ? RDS_NDIF : RDS_PDIF,
          MBK_SEGMENT,
          RDS_SEG_TRANS,
          Segment
        );
        Index->u_rec.link = Rectangle;
      }
      else
      {
        Rectangle = AddRectangleFigRds
        (
          FigureRds,
          NULL,
          Activ->x,
          Activ->y,
          Gate->x - Activ->x,
          Activ->dy,
          Segment->LAYER == NTRANS ? RDS_NDIF : RDS_PDIF,
          MBK_SEGMENT,
          RDS_SEG_TRANS,
          Segment
        );

        Index = AddRectangleFigRds
        (
          FigureRds,
          NULL,
          Gate->x + Gate->dx,
          Activ->y,
          Activ->x + Activ->dx - Gate->x - Gate->dx,
          Activ->dy,
          Segment->LAYER == NTRANS ? RDS_NDIF : RDS_PDIF,
          MBK_SEGMENT,
          RDS_SEG_TRANS,
          Segment
        );
        Index->u_rec.link = Rectangle;
      }
      Rectangle->u_rec.link = First->u_rec.link;
      First->u_rec.link = Index;
    }
    else if (( Segment->LAYER == NDIF ) ||
             ( Segment->LAYER == PDIF ) ||
             ( Segment->LAYER == NTIE ) ||
             ( Segment->LAYER == PTIE ))
    {
      do 
      {
        if ( Index->layer == RDS_ACTIV )
        {
          Activ = Index; /* we suppose there is only one activ */
          break;
        }

        Index  = Index->u_rec.link;
      } 
      while ( Index != Rectangle );

      if ( Activ == NULL ) return Rectangle;

      Rectangle = AddRectangleFigRds
      (
        FigureRds,
        NULL,
        Activ->x,
        Activ->y,
        Activ->dx,
        Activ->dy,
        Segment->LAYER == NDIF ? RDS_NDIF :
              Segment->LAYER == PDIF ? RDS_PDIF :
              Segment->LAYER == NTIE ? RDS_NTIE : RDS_PTIE,
        MBK_SEGMENT,
        RDS_RECTANGLE_LINK,
        Segment
      );

      Rectangle->u_rec.link = First->u_rec.link;
      First->u_rec.link = Rectangle;
    }

    return ( Rectangle );
  }

/*------------------------------------------------------\
|             Transformation d'un Via Mbk               |
\------------------------------------------------------*/

  rds_rec *ViaMbkRds( FigureRds, Via )

           rds_fig    *FigureRds;
           phvia_list *Via;
  {
    long X1;
    long Y1;
    long X2;
    long Y2;

    char          LayerRds;

    rds_rec      *Rectangle;
    rds_rec      *First;
    rds_rec      *Inter;
    rds_rec      *Activ;

    char          Index;
    LineVia      *LineV;

    LineV     = GetViaParam( Via->TYPE ); 
    Rectangle = (rds_rec *)NULL;
    First     = (rds_rec *)NULL;
    Inter     = (rds_rec *)NULL;
    Activ     = (rds_rec *)NULL;
    
    for ( Index = 0; 
          Index < MAX_N_VIA_LAYER;
          Index++ )
    {
      if ( (LayerRds = GET_VIA_LAYER( LineV, Index )) == RDS_NOP ) 

        continue;

      X1 = ( Via->XVIA * LAMBDA_PARAM /  SCALE_X ) - 
           ( GET_VIA_SIZE( LineV, Index ) >> 1   );

      X2 = ( Via->XVIA * LAMBDA_PARAM /  SCALE_X ) + 
           ( GET_VIA_SIZE( LineV, Index ) >> 1   );

      Y1 = ( Via->YVIA * LAMBDA_PARAM /  SCALE_X ) - 
           ( GET_VIA_SIZE( LineV, Index ) >> 1   );

      Y2 = ( Via->YVIA * LAMBDA_PARAM /  SCALE_X ) + 
           ( GET_VIA_SIZE( LineV, Index ) >> 1   );

      X1 = RoundInf( X1 );
      Y1 = RoundInf( Y1 );
      X2 = RoundSup( X2 );
      Y2 = RoundSup( Y2 );

      Rectangle = AddRectangleFigRds
      (
        FigureRds, 
        NULL,
        X1,
        Y1,
        X2 - X1,
        Y2 - Y1,
        LayerRds, 
        MBK_VIA, 
        RDS_RECTANGLE_LINK,
        Via
      ); 

      if ( First == (rds_rec *)NULL )  First = Rectangle;
 
      Rectangle->u_rec.link = Inter;
      Inter                 = Rectangle;
    }
 
    First->u_rec.link = Rectangle;

    if ( Via->TYPE == CONT_DIF_N   ||
         Via->TYPE == CONT_DIF_P   ||
         Via->TYPE == CONT_BODY_N  ||
         Via->TYPE == CONT_BODY_P  ||
         Via->TYPE == C_X_N  ||
         Via->TYPE == C_X_P )
    {
      Inter = Rectangle;
      do 
      {
        if ( Inter->layer == RDS_ACTIV )
        {
          Activ = Inter; /* we suppose there is only one activ */
          break;
        }

        Inter  = Inter->u_rec.link;
      } 
      while ( Inter != Rectangle );

    if ( Via->TYPE == CONT_DIF_N || Via->TYPE == C_X_N ) Index = RDS_NDIF;
    else if ( Via->TYPE == CONT_DIF_P || Via->TYPE == C_X_P ) Index = RDS_PDIF;
    else if ( Via->TYPE == CONT_BODY_P ) Index = RDS_PTIE;
    else Index = RDS_NTIE;

      Rectangle = AddRectangleFigRds
      (
        FigureRds, 
        NULL,
        Activ->x,
        Activ->y,
        Activ->dx,
        Activ->dy,
        Index,
        MBK_VIA, 
        RDS_RECTANGLE_LINK,
        Via
      );

      Rectangle->u_rec.link = First->u_rec.link;
      First->u_rec.link     = Rectangle;
    }

    return( Rectangle );
  }

/*------------------------------------------------------\
|          Transformation d'un Connecteur Mbk           |
\------------------------------------------------------*/

  rds_rec *ConnectorMbkRds( FigureRds, Connector )

           rds_fig    *FigureRds;
           phcon_list *Connector;
  {
    long X1;
    long Y1;
    long X2;
    long Y2;

    char          LayerRds;
    rds_rec      *Rectangle;

    LineCon      *LineC;

    LineC     = GetConParam( Connector->LAYER ); 
    Rectangle = (rds_rec *)NULL;
    
/*------------------------------------------------------\
| Since a connector MUST have a name, there is no way   |
| to have several rectangle linked                      |
\------------------------------------------------------*/

    if ( (LayerRds = GET_CON_LAYER( LineC )) == RDS_NOP ) 

       return NULL;

    if ( Connector->ORIENT == EAST || Connector->ORIENT == WEST )
    {
       X1 = ( Connector->XCON * LAMBDA_PARAM /  SCALE_X        ) - 
            ( GET_CON_DER( LineC )                             );

       X2 = ( Connector->XCON * LAMBDA_PARAM /  SCALE_X        ) + 
            ( GET_CON_DER( LineC )                             );

       Y1 = ( Connector->YCON * LAMBDA_PARAM / SCALE_X         ) -
            ((( GET_CON_DWR( LineC )                           ) +
              ( Connector->WIDTH * LAMBDA_PARAM / SCALE_X      )) >> 1 ); 

       Y2 = ( Connector->YCON * LAMBDA_PARAM / SCALE_X         ) +
            ((( GET_CON_DWR( LineC )                           ) +
              ( Connector->WIDTH * LAMBDA_PARAM / SCALE_X      )) >> 1 ); 

    }
    else
    {
       Y1 = ( Connector->YCON * LAMBDA_PARAM /  SCALE_X        ) - 
            ( GET_CON_DER( LineC )                             );

       Y2 = ( Connector->YCON * LAMBDA_PARAM /  SCALE_X        ) + 
            ( GET_CON_DER( LineC )                             );

       X1 = ( Connector->XCON * LAMBDA_PARAM / SCALE_X         ) -
            ((( GET_CON_DWR( LineC )                           ) +
              ( Connector->WIDTH * LAMBDA_PARAM / SCALE_X      )) >> 1 ); 

       X2 = ( Connector->XCON * LAMBDA_PARAM / SCALE_X         ) +
            ((( GET_CON_DWR( LineC )                           ) +
              ( Connector->WIDTH * LAMBDA_PARAM / SCALE_X      )) >> 1 ); 

    }

    X1 = RoundInf( X1 );
    Y1 = RoundInf( Y1 );
    X2 = RoundSup( X2 );
    Y2 = RoundSup( Y2 ); 

    Rectangle = AddRectangleFigRds
    (
      FigureRds,
      Connector->NAME,
      X1,
      Y1,
      X2 - X1,
      Y2 - Y1,
      LayerRds, 
      MBK_CONNECTOR, 
      RDS_CON_EXTER,
      Connector
    );

    return Rectangle;
  }

/*------------------------------------------------------\
|          Transformation d'une Reference Mbk           |
\------------------------------------------------------*/

  rds_rec *ReferenceMbkRds( FigureRds, Reference )

           rds_fig    *FigureRds;
           phref_list *Reference;

  { 
    return( AddRectangleFigRds
    (
      FigureRds, 
      Reference->NAME,
      ( Reference->XREF - SCALE_X ) * LAMBDA_PARAM / SCALE_X, 
      ( Reference->YREF - SCALE_X ) * LAMBDA_PARAM / SCALE_X, 
      LAMBDA_PARAM << 1,
      LAMBDA_PARAM << 1,
      RDS_REF, 
      MBK_REFERENCE,
      (strcmp( Reference->FIGNAME, "ref_con" )) ? RDS_REF_REF 
                                                : RDS_REF_CON,
      Reference
    )) ; 
  }

/*------------------------------------------------------\
|    Transformation d'un Connecteur d'une instance Mbk  |
\------------------------------------------------------*/

  void ConnectorInsMbkRds( InstanceRds, FigureMbk, InstanceMbk )

       rds_ins    *InstanceRds;
       phfig_list *FigureMbk;
       phins_list *InstanceMbk;

  {
    static char NEW_ORIENT_NORTH_SOUTH[ RDS_MAX_TRANSF ] =
                {
                  1,  /* NOSYM */
                  0,  /* ROT_P */
                  1,  /* SYMXY */
                  0,  /* ROT_M */
                  1,  /* SYM_X */
                  0,  /* SY_RM */
                  1,  /* SYM_Y */
                  0   /* SY_RP */
                };

    phcon_list *Connector;

    long XCON;
    long YCON;
    long X1;
    long Y1;
    long X2;
    long Y2;

    char Orient;
    char LayerRds;

    LineCon *LineC;

    for ( Connector = FigureMbk->PHCON; 
          Connector ;
          Connector = Connector->NEXT
        )
    {
      LineC     = GetConParam( Connector->LAYER ); 

      xyflat
      ( &XCON, &YCON,
        Connector->XCON,
        Connector->YCON,
        InstanceMbk->XINS ,
        InstanceMbk->YINS,
        FigureMbk->XAB1,
        FigureMbk->YAB1,
        FigureMbk->XAB2,
        FigureMbk->YAB2,
        InstanceMbk->TRANSF
      );

      Orient = NEW_ORIENT_NORTH_SOUTH[ InstanceMbk->TRANSF ];

      if (( Connector->ORIENT == 'E' ) ||
          ( Connector->ORIENT == 'W' ))
      {
        Orient =  ! Orient;
      }

      if ( (LayerRds = GET_CON_LAYER( LineC )) == RDS_NOP ) continue;

      if ( Orient != 1 )  /* EAST AND WEST */
      {
         X1 = ( XCON * LAMBDA_PARAM /  SCALE_X ) - 
              ( GET_CON_DER( LineC )           );

         X2 = ( XCON * LAMBDA_PARAM /  SCALE_X ) + 
              ( GET_CON_DER( LineC )           );

         Y1 = ( YCON * LAMBDA_PARAM / SCALE_X          ) -
            ((( GET_CON_DWR( LineC )                           ) +
              ( Connector->WIDTH * LAMBDA_PARAM / SCALE_X      )) >> 1 ); 
    
         Y2 = ( YCON * LAMBDA_PARAM / SCALE_X          ) +
            ((( GET_CON_DWR( LineC )                           ) +
              ( Connector->WIDTH * LAMBDA_PARAM / SCALE_X      )) >> 1 ); 
    
      }
      else
      {
         Y1 = ( YCON * LAMBDA_PARAM /  SCALE_X ) - 
              ( GET_CON_DER( LineC )           );

         Y2 = ( YCON * LAMBDA_PARAM /  SCALE_X ) + 
              ( GET_CON_DER( LineC )           );

         X1 = ( XCON * LAMBDA_PARAM / SCALE_X          ) -
            ((( GET_CON_DWR( LineC )                           ) +
              ( Connector->WIDTH * LAMBDA_PARAM / SCALE_X      )) >> 1 ); 

         X2 = ( XCON * LAMBDA_PARAM / SCALE_X          ) +
            ((( GET_CON_DWR( LineC )                           ) +
              ( Connector->WIDTH * LAMBDA_PARAM / SCALE_X      )) >> 1 ); 
      }

      X1 = RoundInf( X1 );
      Y1 = RoundInf( Y1 );
      X2 = RoundSup( X2 );
      Y2 = RoundSup( Y2 ); 

      AddRectangleInsRds
      (
        InstanceRds, 
        Connector->NAME,
        X1,
        Y1,
        X2 - X1,
        Y2 - Y1,
        LayerRds, 
        MBK_CONNECTOR, 
        RDS_CON_INTER,
        Connector
      );
    }
  }

/*------------------------------------------------------\
|    Transformation d'une reference d'une instance Mbk  |
\------------------------------------------------------*/

  void ReferenceInsMbkRds( InstanceRds, FigureMbk, InstanceMbk )

       rds_ins    *InstanceRds;
       phfig_list *FigureMbk;
       phins_list *InstanceMbk;

  {
    phref_list *Reference;

    long        X;
    long        Y;

    long        X1;
    long        Y1;
    long        X2;
    long        Y2;

    for ( Reference = FigureMbk->PHREF; 
          Reference ;
          Reference = Reference->NEXT
        )
    {
      X = Reference->XREF;
      Y = Reference->YREF;

      xyflat
      ( &X1, &Y1,
        X - SCALE_X,
        Y - SCALE_X,
        InstanceMbk->XINS,
        InstanceMbk->YINS,
        FigureMbk->XAB1,
        FigureMbk->YAB1,
        FigureMbk->XAB2,
        FigureMbk->YAB2,
        InstanceMbk->TRANSF
      );

      xyflat
      ( &X2, &Y2,
        X + SCALE_X,
        Y + SCALE_X,
        InstanceMbk->XINS,
        InstanceMbk->YINS,
        FigureMbk->XAB1,
        FigureMbk->YAB1,
        FigureMbk->XAB2,
        FigureMbk->YAB2,
        InstanceMbk->TRANSF
      );

      if ( X1 > X2 ) { X = X1; X1 = X2; X2 = X; }

      if ( Y1 > Y2 ) { Y = Y1; Y1 = Y2; Y2 = Y; }

      AddRectangleInsRds
      (
        InstanceRds,
        Reference->NAME,
        X1 * LAMBDA_PARAM / SCALE_X,
        Y1 * LAMBDA_PARAM / SCALE_X,
        ( X2 - X1 )* LAMBDA_PARAM / SCALE_X, 
        ( Y2 - Y1 )* LAMBDA_PARAM / SCALE_X,
        RDS_REF,
        MBK_REFERENCE,
        (strcmp( Reference->FIGNAME, "ref_con" )) ? RDS_REF_REF 
                                                  : RDS_REF_CON,
        Reference
      );
    }
  }

/*------------------------------------------------------\
|    Transformation d'un segment d'une instance Mbk     |
\------------------------------------------------------*/

  void SegmentInsMbkRds( InstanceRds, FigureMbk, InstanceMbk )

       rds_ins    *InstanceRds;
       phfig_list *FigureMbk;
       phins_list *InstanceMbk;

  {
    long          X1;
    long          X2;
    long          Y1;
    long          Y2;

    long          SegX1;
    long          SegX2;
    long          SegY1;
    long          SegY2;

    char          LayerMbk;
    char          LayerRds;

    char          Index;
    LineSeg      *LineS;
    phseg_list   *Segment;

    
    for ( Segment = FigureMbk->PHSEG; 
          Segment ;
          Segment = Segment->NEXT
        )
    {
      LayerMbk = Segment->LAYER;

      if (( LayerMbk != TPOLY ) &&
          ( LayerMbk != TALU1 ) &&
          ( LayerMbk != TALU2 ) &&
          ( LayerMbk != TALU3 ))  

        continue;

      LineS    = GetSegParam( LayerMbk ); 

      xyflat
      ( &SegX1, 
        &SegY1,
        Segment->X1,
        Segment->Y1,
        InstanceMbk->XINS,
        InstanceMbk->YINS,
        FigureMbk->XAB1,
        FigureMbk->YAB1,
        FigureMbk->XAB2,
        FigureMbk->YAB2,
        InstanceMbk->TRANSF
      );

      xyflat
      ( &SegX2, 
        &SegY2,
        Segment->X2,
        Segment->Y2,
        InstanceMbk->XINS,
        InstanceMbk->YINS,
        FigureMbk->XAB1,
        FigureMbk->YAB1,
        FigureMbk->XAB2,
        FigureMbk->YAB2,
        InstanceMbk->TRANSF
      );

      if ( SegX1 > SegX2 ) { X1 = SegX1; SegX1 = SegX2; SegX2 = X1; }
      if ( SegY1 > SegY2 ) { Y1 = SegY1; SegY1 = SegY2; SegY2 = Y1; }

      for ( Index = 0; 
            Index < MAX_N_SEG_LAYER;
            Index++ )
      {
        if ( (LayerRds = GET_SEG_LAYER( LineS, Index )) == RDS_NOP ) continue;

        if ( SegY1 == SegY2 )      /* resulting segment must be horizontal */
        {
           X1 = ( SegX1 * LAMBDA_PARAM /  SCALE_X ) - 
                ( GET_SEG_DLR( LineS, Index )     );

           X2 = ( SegX2 * LAMBDA_PARAM /  SCALE_X ) + 
                ( GET_SEG_DLR( LineS, Index )     );

           Y1 = ( SegY1 * LAMBDA_PARAM / SCALE_X                     ) -
                ((( GET_SEG_DWR( LineS, Index )                      ) +
                  ( Segment->WIDTH * LAMBDA_PARAM / SCALE_X  )) >> 1 ); 

           Y2 = ( SegY1 * LAMBDA_PARAM / SCALE_X                     ) +
                ((( GET_SEG_DWR( LineS, Index )                      ) +
                  ( Segment->WIDTH * LAMBDA_PARAM / SCALE_X  )) >> 1 ); 
        }
        else
        {
           Y1 = ( SegY1 * LAMBDA_PARAM /  SCALE_X ) - 
                ( GET_SEG_DLR( LineS, Index )     );

           Y2 = ( SegY2 * LAMBDA_PARAM /  SCALE_X ) + 
                ( GET_SEG_DLR( LineS, Index )     );

           X1 = ( SegX1 * LAMBDA_PARAM / SCALE_X                     ) -
                ((( GET_SEG_DWR( LineS, Index )                      ) +
                  ( Segment->WIDTH * LAMBDA_PARAM / SCALE_X  )) >> 1 ); 

           X2 = ( SegX1 * LAMBDA_PARAM / SCALE_X                     ) +
                ((( GET_SEG_DWR( LineS, Index )                      ) +
                  ( Segment->WIDTH * LAMBDA_PARAM / SCALE_X  )) >> 1 ); 

        }
    
        X1 = RoundInf( X1 );
        Y1 = RoundInf( Y1 );
        X2 = RoundSup( X2 );
        Y2 = RoundSup( Y2 );  

        AddRectangleInsRds
        (
          InstanceRds, 
          Segment->NAME,
          X1,
          Y1,
          X2 - X1, 
          Y2 - Y1,
          LayerRds, 
          MBK_SEGMENT, 
          RDS_NONE,
          Segment
        );
      }
    }
  }

/*------------------------------------------------------\
|           Transformation d'une Instance Mbk           |
\------------------------------------------------------*/

  rds_ins *InstanceMbkRds( FigureRds, InstanceMbk )

           rds_fig    *FigureRds;
           phins_list *InstanceMbk;

  {
    phfig_list *FigureMbk;
    rds_ins    *InstanceRds;
 
    long        X;
    long        Y;
    long        Dx;
    long        Dy;
    long        Inter;

    FigureMbk = getphfig( InstanceMbk->FIGNAME, 'A' );

    xyflat
    ( &X, &Y,
      0,
      0,
      InstanceMbk->XINS,
      InstanceMbk->YINS,
      FigureMbk->XAB1,
      FigureMbk->YAB1,
      FigureMbk->XAB2,
      FigureMbk->YAB2,
      InstanceMbk->TRANSF
    );

    InstanceRds = AddInstanceRds
    (
      FigureRds, 
      InstanceMbk->FIGNAME, 
      InstanceMbk->INSNAME,
      X * LAMBDA_PARAM / SCALE_X,
      Y * LAMBDA_PARAM / SCALE_X,
      InstanceMbk->TRANSF,
      InstanceMbk
    );
   
    Dx = RoundSup(( FigureMbk->XAB2 - FigureMbk->XAB1 )*LAMBDA_PARAM / SCALE_X);
    Dy = RoundSup(( FigureMbk->YAB2 - FigureMbk->YAB1 )*LAMBDA_PARAM / SCALE_X);

    if (( InstanceMbk->TRANSF == RDS_ROT_P ) ||
        ( InstanceMbk->TRANSF == RDS_ROT_M ) ||
        ( InstanceMbk->TRANSF == RDS_SY_RM ) ||
        ( InstanceMbk->TRANSF == RDS_SY_RP ))

    {
      Inter = Dx; Dx = Dy; Dy = Inter;
    }

    AddRectangleInsRds
    ( 
      InstanceRds,
      InstanceMbk->INSNAME,
      RoundInf(InstanceMbk->XINS * LAMBDA_PARAM / SCALE_X),
      RoundInf(InstanceMbk->YINS * LAMBDA_PARAM / SCALE_X),
      Dx,
      Dy,
      RDS_ABOX, 
      MBK_INSTANCE, 
      RDS_NONE, 
      (void *)InstanceMbk
    );

    SegmentInsMbkRds   ( InstanceRds, FigureMbk, InstanceMbk );
    ConnectorInsMbkRds ( InstanceRds, FigureMbk, InstanceMbk );
    ReferenceInsMbkRds ( InstanceRds, FigureMbk, InstanceMbk );

    return( InstanceRds );
  }

/*------------------------------------------------------\
|     Transforms a figure from Mbk -> Rds               |
| Mbk objects are linked in both way through the use    |
| of the user pointer.
\------------------------------------------------------*/
#define PREVIOUS USER

  rds_fig *TransFigMbkRds( FigureMbk, Flags )

       phfig_list *FigureMbk;
       char Flags;

  {
    void    *Pointer;
    void    **OldPointer;
    rds_fig *FigureRds;

    FigureRds = AddFigureRds
    (
      FigureMbk->NAME,
      FigureMbk,
      Flags
    );

    if ( ( FigureMbk->XAB1 != 0 ) || 
         ( FigureMbk->XAB2 != 0 ) ||
         ( FigureMbk->YAB1 != 0 ) ||
         ( FigureMbk->YAB2 != 0 ) )
    {
      AddRectangleFigRds
      ( 
        FigureRds,
        FigureMbk->NAME,
        RoundInf(FigureMbk->XAB1 * LAMBDA_PARAM / SCALE_X),
        RoundInf(FigureMbk->YAB1 * LAMBDA_PARAM / SCALE_X),
        RoundSup((FigureMbk->XAB2 - FigureMbk->XAB1) * LAMBDA_PARAM / SCALE_X),
        RoundSup((FigureMbk->YAB2 - FigureMbk->YAB1) * LAMBDA_PARAM / SCALE_X),
        RDS_ABOX, 
        MBK_FIGURE, 
        RDS_NONE, 
        (void *)FigureMbk
      );
    }

    if ( Flags & RDS_MODE_ALL )
    {
      OldPointer = (void **)&(FigureMbk->PHVIA);
      for ( Pointer = (void *)(FigureMbk->PHVIA); 
            Pointer;
            Pointer = (void *)(((phvia_list *)Pointer)->NEXT))
      {
        ((phvia_list *)Pointer)->PREVIOUS = (ptype_list *)OldPointer;
        OldPointer = (void **)&((phvia_list *)Pointer)->NEXT;
        ViaMbkRds( FigureRds, (phvia_list *)Pointer);
      }

      OldPointer = (void **)&(FigureMbk->PHINS);
      for ( Pointer = (void *)(FigureMbk->PHINS); 
            Pointer;
            Pointer = (void *)(((phins_list *)Pointer)->NEXT))
      {
        ((phins_list *)Pointer)->PREVIOUS = (ptype_list *)OldPointer;
        OldPointer = (void **)&((phins_list *)Pointer)->NEXT;
        (void)InstanceMbkRds( FigureRds, (phins_list *)Pointer);
      }

      OldPointer = (void **)&(FigureMbk->PHSEG);
      for ( Pointer = (void *)(FigureMbk->PHSEG); 
            Pointer;
            Pointer = (void *)(((phseg_list *)Pointer)->NEXT))
      {
        ((phseg_list *)Pointer)->PREVIOUS = (ptype_list *)OldPointer;
        OldPointer = (void **)&((phseg_list *)Pointer)->NEXT;
        SegmentTransMbkRds( FigureRds, (phseg_list *)Pointer);
      }

      OldPointer = (void **)&(FigureMbk->PHCON);
      for ( Pointer = (void *)(FigureMbk->PHCON); 
            Pointer;
            Pointer = (void *)(((phcon_list *)Pointer)->NEXT))
      {
        ((phcon_list *)Pointer)->PREVIOUS = (ptype_list *)OldPointer;
        OldPointer = (void **)&((phcon_list *)Pointer)->NEXT;
        ConnectorMbkRds( FigureRds, (phcon_list *)Pointer);
      }

      OldPointer = (void **)&(FigureMbk->PHREF);
      for ( Pointer = (void *)(FigureMbk->PHREF); 
            Pointer;
            Pointer = (void *)(((phref_list *)Pointer)->NEXT))
      {
        ((phref_list *)Pointer)->PREVIOUS = (ptype_list *)OldPointer;
        OldPointer = (void **)&((phref_list *)Pointer)->NEXT;
        ReferenceMbkRds( FigureRds, (phref_list *)Pointer);
      }
    }
    else
    {
      OldPointer = (void **)&(FigureMbk->PHSEG);
      for ( Pointer = (void *)(FigureMbk->PHSEG); 
            Pointer;
            Pointer = (void *)(((phseg_list *)Pointer)->NEXT))
      {
        ((phseg_list *)Pointer)->PREVIOUS = (ptype_list *)OldPointer;
        (void *)((phseg_list *)Pointer)->NEXT;
        switch ( ((phseg_list *)Pointer)->LAYER )
        {
            case TALU1:
            case TALU2:
            case TALU3:
            case TPOLY:

               SegmentTransMbkRds( FigureRds, (phseg_list *)Pointer);
        }
      }

      OldPointer = (void **)&(FigureMbk->PHCON);
      for ( Pointer = (void *)(FigureMbk->PHCON); 
            Pointer;
            Pointer = (void *)(((phcon_list *)Pointer)->NEXT))
      {
        ((phcon_list *)Pointer)->PREVIOUS = (ptype_list *)OldPointer;
        OldPointer = (void **)&((phcon_list *)Pointer)->NEXT;
        ConnectorMbkRds( FigureRds, (phcon_list *)Pointer);
      }

      OldPointer = (void **)&(FigureMbk->PHREF);
      for ( Pointer = (void *)(FigureMbk->PHREF); 
            Pointer;
            Pointer = (void *)(((phref_list *)Pointer)->NEXT))
      {
        ((phref_list *)Pointer)->PREVIOUS = (ptype_list *)OldPointer;
        OldPointer = (void **)&((phref_list *)Pointer)->NEXT;
        ReferenceMbkRds( FigureRds, (phref_list *)Pointer);
      }
    }

    return FigureRds ;
  }
#undef PREVIOUS


/*------------------------------------------------------\
| must be included in mpu as soon as possible           |
\------------------------------------------------------*/

/******************************************************************************
 *    Coordinates alignement to 0,0 (left down corner)
 ******************************************************************************/

  void zero( phfig )

       phfig_list *phfig ;
  {
    long  x, y ;
    phins_list  *phins ;
    phcon_list  *phcon ;
    phseg_list  *phseg ;
    phvia_list  *phvia ;
    phref_list  *phref ;

    x = phfig->XAB1;
    y = phfig->YAB1;

    phfig->XAB1 = phfig->YAB1 = 0;
    phfig->XAB2 -= x; phfig->YAB2 -= y;

    for( phins = phfig->PHINS; phins != NULL ; phins = phins->NEXT) 
    {
      phins->XINS -= x;
      phins->YINS -= y;
    }

    for( phcon = phfig->PHCON; phcon != NULL ; phcon = phcon->NEXT) 
    {
      phcon->XCON -= x;
      phcon->YCON -= y;
    }

    for( phseg = phfig->PHSEG; phseg != NULL ; phseg = phseg->NEXT) 
    {
      phseg->X1 -= x;
      phseg->Y1 -= y;
      phseg->X2 -= x;
      phseg->Y2 -= y;
    }
    
    for( phvia = phfig->PHVIA; phvia != NULL ; phvia = phvia->NEXT) 
    {
      phvia->XVIA -= x;
      phvia->YVIA -= y;
    }
    
    for( phref = phfig->PHREF; phref != NULL ; phref = phref->NEXT) 
    {
      phref->XREF -= x;
      phref->YREF -= y;
    }
  }


static chain_list *MODEL_CHAIN;

static chain_list *rmake_model_list( pt_phfig )

  phfig_list  *pt_phfig ;

  {

    phins_list   * pt_ins ;
    chain_list   * pt_chain ;

    for ( pt_ins = pt_phfig->PHINS ; pt_ins != NULL ; pt_ins = pt_ins->NEXT){
      for ( pt_chain = MODEL_CHAIN ;
            pt_chain != NULL ;
            pt_chain = pt_chain->NEXT ) {
        if ( ( ( phfig_list * )pt_chain->DATA )->NAME == pt_ins->FIGNAME ) {
          break ;
        }
      }  
      if ( pt_chain == NULL ) {
        /* if not already in model list , add a new model to it */
        phfig_list   * pt_model ;
        pt_model = getphfig( pt_ins->FIGNAME , 'A' ) ;
        /* cells whose have got gds equivalent must have been shifted to zero */
	if( incataloggds(pt_model->NAME))
          zero(pt_model);
        (void)rmake_model_list( pt_model ) ;
      }
    }  

    MODEL_CHAIN = addchain( MODEL_CHAIN , ( char *)pt_phfig ) ;

    return( MODEL_CHAIN ) ;
  }

static chain_list *make_model_list( fig )
phfig_list *fig;
{
	if (MODEL_CHAIN != NULL)
		freechain(MODEL_CHAIN);
	MODEL_CHAIN = NULL;
	return rmake_model_list(fig);
}

/*------------------------------------------------------\
|       Transform a hierarchy Mbk -> Rds                |
\------------------------------------------------------*/

  rds_fig *TransMbkRds( FigureMbk, Flags )

       phfig_list *FigureMbk;
       char Flags;

  {
    rds_fig *FigureRds;
    chain_list *Pt;

    if ( Flags & RDS_MODE_ALL )
    {
       Pt = make_model_list( FigureMbk ) ;

       FigureRds = TransFigMbkRds( (phfig_list *)Pt->DATA, Flags ) ;
       for ( Pt = Pt->NEXT; Pt != NULL; Pt = Pt->NEXT)
          TransFigMbkRds( (phfig_list *)Pt->DATA, Flags ) ;
    }
    else
    {
       FigureRds = TransFigMbkRds( FigureMbk, Flags | RDS_MODE_ALL ) ;
       for ( Pt = FigureMbk->MODELCHAIN; Pt != NULL; Pt = Pt->NEXT)
          TransFigMbkRds( getphfig((char *)Pt->DATA, 'P'), Flags ) ;
    }
    return FigureRds;
  }


#define PREVIOUS USER
void
	DeleteMbkInRds(Rectangle)
rds_rec *Rectangle;
{
	switch (Rectangle->mbk_type) {
		case MBK_INSTANCE:
			*((phins_list **)((phins_list *)Rectangle->mbk)->PREVIOUS) =
				((phins_list *)Rectangle->mbk)->NEXT;

			if (((phins_list *)Rectangle->mbk)->NEXT != NULL)
				((phins_list *)Rectangle->mbk)->NEXT->PREVIOUS =
										((phins_list *)Rectangle->mbk)->PREVIOUS;
			break;
		case MBK_CONNECTOR:
			*((phcon_list **)((phcon_list *)Rectangle->mbk)->PREVIOUS) =
				((phcon_list *)Rectangle->mbk)->NEXT;

			if (((phcon_list *)Rectangle->mbk)->NEXT != NULL)
				((phcon_list *)Rectangle->mbk)->NEXT->PREVIOUS =
										((phcon_list *)Rectangle->mbk)->PREVIOUS;
			break;
		case MBK_SEGMENT:
			*((phseg_list **)((phseg_list *)Rectangle->mbk)->PREVIOUS) =
				((phseg_list *)Rectangle->mbk)->NEXT;

			if (((phseg_list *)Rectangle->mbk)->NEXT != NULL)
				((phseg_list *)Rectangle->mbk)->NEXT->PREVIOUS =
										((phseg_list *)Rectangle->mbk)->PREVIOUS;
			break;
		case MBK_VIA:
			*((phvia_list **)((phvia_list *)Rectangle->mbk)->PREVIOUS) =
				((phvia_list *)Rectangle->mbk)->NEXT;

			if (((phvia_list *)Rectangle->mbk)->NEXT != NULL)
				((phvia_list *)Rectangle->mbk)->NEXT->PREVIOUS =
										((phvia_list *)Rectangle->mbk)->PREVIOUS;
			break;
		case MBK_REFERENCE:
			*((phref_list **)((phref_list *)Rectangle->mbk)->PREVIOUS) =
				((phref_list *)Rectangle->mbk)->NEXT;

			if (((phref_list *)Rectangle->mbk)->NEXT != NULL)
				((phref_list *)Rectangle->mbk)->NEXT->PREVIOUS =
										((phref_list *)Rectangle->mbk)->PREVIOUS;
			break;
		default :
			fprintf(stderr,
						"*** rds error ***\n Unknown Mbk type for DeleteMbkInRds\n");
			EXIT(1);
	}
	mbkfree(Rectangle->mbk);
}
#undef PREVIOUS
